/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.ExponentialMap;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.RotationDerivatives;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.docking.scoring.AbstractScoringEngine;
import com.actelion.research.chem.optimization.Evaluable;
import com.actelion.research.chem.optimization.MCHelper;
import com.actelion.research.chem.potentialenergy.PositionConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class LigandPose
implements Evaluable {
    private static double MOVE_AMPLITUDE = 2.0;
    private BondRotationHelper torsionHelper;
    private double[] state;
    private Conformer ligConf;
    private Coordinates[] origCoords;
    private Coordinates[] cachedCoords;
    private double[][] dRdvi1;
    private double[][] dRdvi2;
    private double[][] dRdvi3;
    private StereoMolecule mol;
    private AbstractScoringEngine engine;
    public static long SEED = 12345L;
    private Coordinates origCOM;
    private MCHelper mcHelper;

    public LigandPose(Conformer conformer, AbstractScoringEngine abstractScoringEngine, double d) {
        this.engine = abstractScoringEngine;
        this.ligConf = conformer;
        this.init(d);
    }

    public void setMCSBondConstraints(List<Integer> list) {
        int n;
        int[] nArray = this.torsionHelper.getRotatableBonds();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (list.contains(n)) continue;
            arrayList.add(i);
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        this.mcHelper.setMcsRotBondIndeces(nArray2);
    }

    private void init(double d) {
        this.mol = this.ligConf.getMolecule();
        this.torsionHelper = new BondRotationHelper(this.mol, true);
        this.engine.init(this, d);
        this.setInitialState();
        this.origCoords = new Coordinates[this.ligConf.getMolecule().getAllAtoms()];
        this.cachedCoords = new Coordinates[this.ligConf.getMolecule().getAllAtoms()];
        this.origCOM = new Coordinates();
        for (int i = 0; i < this.ligConf.getMolecule().getAllAtoms(); ++i) {
            this.origCoords[i] = new Coordinates(this.ligConf.getCoordinates(i));
            this.cachedCoords[i] = new Coordinates(this.ligConf.getCoordinates(i));
            this.origCOM.add(this.cachedCoords[i]);
        }
        this.origCOM.scale(1.0 / (double)this.cachedCoords.length);
        this.dRdvi1 = new double[3][3];
        this.dRdvi2 = new double[3][3];
        this.dRdvi3 = new double[3][3];
        this.mcHelper = new MCHelper(this.torsionHelper, null, new Random(SEED));
    }

    private void resetLigCoordinates() {
        for (int i = 0; i < this.ligConf.getMolecule().getAllAtoms(); ++i) {
            this.ligConf.setX(i, this.origCoords[i].x);
            this.ligConf.setY(i, this.origCoords[i].y);
            this.ligConf.setZ(i, this.origCoords[i].z);
        }
    }

    @Override
    public double getFGValue(double[] dArray) {
        Object object;
        int n;
        double[] dArray2 = new double[this.ligConf.getMolecule().getAllAtoms() * 3];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        double d = this.engine.getFGValue(dArray2);
        for (int i = 0; i < this.ligConf.getMolecule().getAllAtoms(); ++i) {
            dArray[0] = dArray[0] + dArray2[3 * i];
            dArray[1] = dArray[1] + dArray2[3 * i + 1];
            dArray[2] = dArray[2] + dArray2[3 * i + 2];
        }
        double[] dArray3 = new double[]{this.state[3], this.state[4], this.state[5]};
        RotationDerivatives rotationDerivatives = new RotationDerivatives(dArray3);
        rotationDerivatives.dRdv(0, this.dRdvi1);
        rotationDerivatives.dRdv(1, this.dRdvi2);
        rotationDerivatives.dRdv(2, this.dRdvi3);
        for (n = 0; n < this.ligConf.getMolecule().getAllAtoms(); ++n) {
            object = this.cachedCoords[n];
            Coordinates coordinates = ((Coordinates)object).rotateC(this.dRdvi1);
            dArray[3] = dArray[3] + (dArray2[3 * n] * coordinates.x + dArray2[3 * n + 1] * coordinates.y + dArray2[3 * n + 2] * coordinates.z);
            coordinates = ((Coordinates)object).rotateC(this.dRdvi2);
            dArray[4] = dArray[4] + (dArray2[3 * n] * coordinates.x + dArray2[3 * n + 1] * coordinates.y + dArray2[3 * n + 2] * coordinates.z);
            coordinates = ((Coordinates)object).rotateC(this.dRdvi3);
            dArray[5] = dArray[5] + (dArray2[3 * n] * coordinates.x + dArray2[3 * n + 1] * coordinates.y + dArray2[3 * n + 2] * coordinates.z);
        }
        for (n = 0; n < this.torsionHelper.getRotatableBonds().length; ++n) {
            object = this.torsionHelper.getSmallerSideAtomLists()[n];
            int n2 = this.torsionHelper.getRotationCenters()[n];
            int n3 = this.torsionHelper.getTorsionAtoms()[n][1] == n2 ? this.torsionHelper.getTorsionAtoms()[n][2] : this.torsionHelper.getTorsionAtoms()[n][1];
            Coordinates coordinates = this.ligConf.getCoordinates(n3).subC(this.ligConf.getCoordinates(n2));
            for (Object object2 : object) {
                Coordinates coordinates2 = this.ligConf.getCoordinates((int)object2).subC(this.ligConf.getCoordinates(n2));
                Coordinates coordinates3 = coordinates.cross(coordinates2);
                int n4 = 6 + n;
                dArray[n4] = dArray[n4] + (coordinates3.x * dArray2[3 * object2] + coordinates3.y * dArray2[3 * object2 + 1] + coordinates3.z * dArray2[3 * object2 + 2]);
            }
        }
        return d;
    }

    public Map<String, Double> getContributions() {
        return this.engine.getContributions();
    }

    public void setInitialState() {
        int n = 6 + this.torsionHelper.getRotatableBonds().length;
        this.state = new double[n];
        this.state[0] = 0.0;
        this.state[1] = 0.0;
        this.state[2] = 0.0;
        Quaternion quaternion = new Quaternion(1.0, 0.0, 0.0, 0.0);
        ExponentialMap exponentialMap = new ExponentialMap(quaternion);
        this.state[3] = exponentialMap.getP().x;
        this.state[4] = exponentialMap.getP().y;
        this.state[5] = exponentialMap.getP().z;
        for (int i = 0; i < this.torsionHelper.getRotatableBonds().length; ++i) {
            int[] nArray = this.torsionHelper.getTorsionAtoms()[i];
            this.state[6 + i] = TorsionDB.calculateTorsionExtended(this.ligConf, nArray);
        }
    }

    public void updateLigandCoordinates() {
        this.resetLigCoordinates();
        this.updateDihedralAngles();
        for (int i = 0; i < this.ligConf.getMolecule().getAllAtoms(); ++i) {
            this.cachedCoords[i] = new Coordinates(this.ligConf.getCoordinates(i));
        }
        ExponentialMap exponentialMap = new ExponentialMap(this.state[3], this.state[4], this.state[5]);
        Quaternion quaternion = exponentialMap.toQuaternion();
        Translation translation = new Translation(this.origCOM.scaleC(-1.0));
        Translation translation2 = new Translation(this.origCOM);
        Rotation rotation = new Rotation(quaternion.getRotMatrix().getArray());
        Translation translation3 = new Translation(this.state[0], this.state[1], this.state[2]);
        TransformationSequence transformationSequence = new TransformationSequence();
        transformationSequence.addTransformation(translation);
        transformationSequence.addTransformation(rotation);
        transformationSequence.addTransformation(translation2);
        transformationSequence.addTransformation(translation3);
        transformationSequence.apply(this.ligConf);
    }

    private void updateDihedralAngles() {
        for (int i = 0; i < this.torsionHelper.getRotatableBonds().length; ++i) {
            double d = this.state[6 + i];
            int[] nArray = this.torsionHelper.getTorsionAtoms()[i];
            double d2 = TorsionDB.calculateTorsionExtended(this.ligConf, nArray);
            double d3 = d - d2;
            this.torsionHelper.rotateAroundBond(i, d3, this.ligConf, false);
        }
    }

    @Override
    public void setState(double[] dArray) {
        assert (this.state.length == dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 5 && dArray[i] > Math.PI) {
                int n = i;
                dArray[n] = dArray[n] - Math.PI * 2;
            }
            this.state[i] = dArray[i];
        }
        this.updateLigandCoordinates();
    }

    public double[] getState(double[] dArray) {
        for (int i = 0; i < this.state.length; ++i) {
            dArray[i] = this.state[i];
        }
        return dArray;
    }

    public double[] getCartState() {
        double[] dArray = new double[3 * this.ligConf.getMolecule().getAllAtoms()];
        for (int i = 0; i < this.ligConf.getMolecule().getAllAtoms(); ++i) {
            dArray[3 * i] = this.ligConf.getCoordinates((int)i).x;
            dArray[3 * i + 1] = this.ligConf.getCoordinates((int)i).y;
            dArray[3 * i + 2] = this.ligConf.getCoordinates((int)i).z;
        }
        return dArray;
    }

    @Override
    public double[] getState() {
        return this.getState(new double[this.state.length]);
    }

    public void randomPerturbation() {
        this.mcHelper.randomPerturbation(this.ligConf, this.state);
        this.updateLigandCoordinates();
    }

    public void addPositionalConstraints(double d) {
        for (int i = 0; i < this.ligConf.getMolecule().getAtoms(); ++i) {
            PositionConstraint positionConstraint = new PositionConstraint(this.ligConf, i, 50.0, d);
            this.engine.addConstraint(positionConstraint);
        }
    }

    public void addConstraint(PositionConstraint positionConstraint) {
        this.engine.addConstraint(positionConstraint);
    }

    public void removeConstraints() {
        this.engine.removeConstraints();
    }

    public Conformer getLigConf() {
        return this.ligConf;
    }
}

