/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.IDCodeParserWithoutCoordinateInvention;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.KabschAlignment;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.ConformerSet;
import com.actelion.research.chem.conf.ConformerSetGenerator;
import com.actelion.research.chem.docking.DockingFailedException;
import com.actelion.research.chem.docking.LigandPose;
import com.actelion.research.chem.docking.receptorpharmacophore.NegativeReceptorImageCreator;
import com.actelion.research.chem.docking.scoring.AbstractScoringEngine;
import com.actelion.research.chem.docking.scoring.ChemPLP;
import com.actelion.research.chem.docking.scoring.IdoScore;
import com.actelion.research.chem.docking.shape.ShapeDocking;
import com.actelion.research.chem.forcefield.AbstractForceField;
import com.actelion.research.chem.forcefield.mmff.EnergyTerm;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import com.actelion.research.chem.forcefield.mmff.MMFFPositionConstraint;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.chem.mcs.MCS;
import com.actelion.research.chem.optimization.OptimizerLBFGS;
import com.actelion.research.chem.phesa.EncodeFunctions;
import com.actelion.research.chem.phesa.MolecularVolume;
import com.actelion.research.chem.phesa.PheSAAlignment;
import com.actelion.research.chem.phesa.ShapeVolume;
import com.actelion.research.chem.potentialenergy.PositionConstraint;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public class DockingEngine {
    private static final int DEFAULT_NR_MC_STEPS = 50;
    private static final int DEFAULT_START_POSITIONS = 10;
    private static final double BOLTZMANN_FACTOR = 1.2;
    public static final double GRID_DIMENSION = 6.0;
    public static final double GRID_RESOLUTION = 0.5;
    public static final double MINI_CUTOFF = 100.0;
    public static final int MCS_EXHAUSTIVENESS = 3;
    private Rotation rotation;
    private Coordinates origCOM;
    private int mcSteps;
    private Random random;
    private AbstractScoringEngine engine;
    private int startPositions;
    private StereoMolecule nativeLigand;
    private ShapeDocking shapeDocking;
    private ThreadMaster threadMaster;
    private StereoMolecule mcsRef;
    private List<Integer> mcsConstrainedBonds;
    private List<Integer> mcsConstrainedAtoms;

    public DockingEngine(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n, int n2, ScoringFunction scoringFunction) throws DockingFailedException {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getImplicitHydrogens(i) <= 0) continue;
            throw new DockingFailedException("please add hydrogen atoms to receptor structure!");
        }
        this.nativeLigand = new Molecule3D(stereoMolecule2);
        this.nativeLigand.ensureHelperArrays(31);
        Molecule3D molecule3D = new Molecule3D(stereoMolecule);
        molecule3D.ensureHelperArrays(31);
        MolecularVolume molecularVolume = new MolecularVolume(this.nativeLigand);
        this.origCOM = new Coordinates(molecularVolume.getCOM());
        Conformer conformer = new Conformer(this.nativeLigand);
        this.rotation = molecularVolume.preProcess(conformer);
        this.startPositions = n2;
        this.preprocess(molecule3D, this.nativeLigand);
        TransformationSequence transformationSequence = new TransformationSequence();
        ShapeVolume shapeVolume = NegativeReceptorImageCreator.create(this.nativeLigand, molecule3D, transformationSequence);
        this.shapeDocking = new ShapeDocking(shapeVolume, transformationSequence);
        MoleculeGrid moleculeGrid = new MoleculeGrid(this.nativeLigand, 0.5, new Coordinates(6.0, 6.0, 6.0));
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (scoringFunction == ScoringFunction.CHEMPLP) {
            DockingEngine.getBindingSiteAtoms(molecule3D, hashSet, moleculeGrid, true);
            this.engine = new ChemPLP(molecule3D, hashSet, moleculeGrid);
        } else if (scoringFunction == ScoringFunction.IDOSCORE) {
            DockingEngine.getBindingSiteAtoms(molecule3D, hashSet, moleculeGrid, false);
            this.engine = new IdoScore(molecule3D, hashSet, DockingEngine.getReceptorAtomTypes(molecule3D), moleculeGrid);
        }
        this.mcSteps = n;
        this.random = new Random(LigandPose.SEED);
    }

    public DockingEngine(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) throws DockingFailedException {
        this(stereoMolecule, stereoMolecule2, 50, 10, ScoringFunction.CHEMPLP);
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.threadMaster = threadMaster;
    }

    private double getStartingPositions(StereoMolecule stereoMolecule2, List<Conformer> list) throws DockingFailedException {
        double d = Double.MAX_VALUE;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dielectric constant", 80.0);
        ConformerSet conformerSet = new ConformerSet();
        List<StereoMolecule> list2 = this.shapeDocking.dock(stereoMolecule2);
        list2.stream().forEach(stereoMolecule -> conformerSet.add(new Conformer((StereoMolecule)stereoMolecule)));
        for (Conformer conformer : conformerSet) {
            ForceFieldMMFF94 forceFieldMMFF94;
            if (conformer == null) continue;
            StereoMolecule stereoMolecule3 = conformer.toMolecule();
            stereoMolecule3.ensureHelperArrays(15);
            try {
                forceFieldMMFF94 = new ForceFieldMMFF94(stereoMolecule3, "MMFF94s+", hashMap);
            }
            catch (Exception exception) {
                throw new DockingFailedException("could not assess atom types");
            }
            MMFFPositionConstraint mMFFPositionConstraint = new MMFFPositionConstraint(stereoMolecule3, 50.0, 0.2);
            forceFieldMMFF94.addEnergyTerm(mMFFPositionConstraint);
            forceFieldMMFF94.minimise();
            Conformer conformer2 = new Conformer(stereoMolecule3);
            list.add(conformer2);
            if (list.size() >= this.startPositions) break;
            double d2 = forceFieldMMFF94.getTotalEnergy();
            if (d2 < d) {
                d = d2;
            }
            if (this.threadMaster == null || !this.threadMaster.threadMustDie()) continue;
            break;
        }
        return d;
    }

    private double getStartingPositionsMCS(StereoMolecule stereoMolecule, List<Conformer> list) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Object object62;
        boolean bl;
        double d3 = Double.MAX_VALUE;
        int n2 = stereoMolecule.getRotatableBondCount();
        int n3 = this.nativeLigand.getRotatableBondCount();
        MCS mCS = new MCS();
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        if (n2 > n3) {
            mCS.set(stereoMolecule, this.nativeLigand);
            blArray = new boolean[stereoMolecule.getAllBonds()];
            blArray2 = new boolean[this.nativeLigand.getAllBonds()];
            bl = true;
        } else {
            mCS.set(stereoMolecule, this.nativeLigand);
            blArray = new boolean[stereoMolecule.getAllBonds()];
            blArray2 = new boolean[this.nativeLigand.getAllBonds()];
            bl = false;
        }
        StereoMolecule stereoMolecule2 = mCS.getMCS();
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setFragment(stereoMolecule2);
        sSSearcher.setMolecule(this.nativeLigand);
        sSSearcher.findFragmentInMolecule(4, 4);
        int[] nArray = sSSearcher.getMatchList().get(0);
        sSSearcher.setMolecule(stereoMolecule);
        sSSearcher.findFragmentInMolecule(4, 4);
        int[] nArray2 = sSSearcher.getMatchList().get(0);
        this.mcsConstrainedAtoms = new ArrayList<Integer>();
        for (int n4 : nArray2) {
            this.mcsConstrainedAtoms.add(n4);
        }
        Object object7 = new HashMap();
        for (int i = 0; i < nArray.length; ++i) {
            object7.put(nArray[i], nArray2[i]);
        }
        mCS.getMCSBondArray(blArray, blArray2);
        this.mcsConstrainedBonds = new ArrayList<Integer>();
        boolean[] blArray3 = null;
        blArray3 = bl ? blArray : blArray2;
        for (int i = 0; i < blArray3.length; ++i) {
            if (!blArray3[i]) continue;
            this.mcsConstrainedBonds.add(i);
        }
        ForceFieldMMFF94.initialize("MMFF94s+");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dielectric constant", 80.0);
        ConformerSetGenerator conformerSetGenerator = new ConformerSetGenerator();
        ConformerSet conformerSet = conformerSetGenerator.generateConformerSet(stereoMolecule);
        HashMap<Object, Double> hashMap2 = new HashMap<Object, Double>();
        for (Object object62 : conformerSet) {
            Object object82;
            Coordinates[] coordinatesArray = new Coordinates[nArray.length];
            object5 = new Coordinates[nArray.length];
            n = 0;
            object4 = object7.keySet().iterator();
            while (object4.hasNext()) {
                int n5 = (Integer)object4.next();
                coordinatesArray[n] = new Coordinates(this.nativeLigand.getCoordinates(n5));
                object5[n] = new Coordinates(((Conformer)object62).getCoordinates((Integer)object7.get(n5)));
                ++n;
            }
            object4 = new int[coordinatesArray.length][2];
            n = 0;
            for (Object object82 : object4) {
                object82[0] = n;
                object82[1] = n;
                ++n;
            }
            object3 = new Coordinates();
            object2 = new Matrix(3, 3);
            object = new Coordinates();
            object82 = new KabschAlignment(coordinatesArray, (Coordinates[])object5, (int[][])object4);
            ((KabschAlignment)object82).align((Coordinates)object3, (Matrix)object2, (Coordinates)object);
            double d4 = DockingEngine.getCoreRMSD(coordinatesArray, (Coordinates[])object5);
            for (Coordinates coordinates : ((Conformer)object62).getCoordinates()) {
                coordinates.add((Coordinates)object3);
                coordinates.rotate(((Matrix)object2).getArray());
                coordinates.add((Coordinates)object);
            }
            hashMap2.put(object62, d4);
        }
        LinkedHashMap linkedHashMap = hashMap2.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (d, d2) -> d, LinkedHashMap::new));
        object62 = linkedHashMap.entrySet().iterator();
        boolean bl2 = false;
        n = 0;
        while (!bl2 && n < this.startPositions * 3) {
            ++n;
            try {
                object5 = (Map.Entry)object62.next();
            }
            catch (Exception exception) {
                bl2 = true;
                continue;
            }
            object4 = (Conformer)object5.getKey();
            object3 = new StereoMolecule();
            object3 = ((Conformer)object4).toMolecule(null);
            ((StereoMolecule)object3).ensureHelperArrays(15);
            object = new MMFFPositionConstraint((StereoMolecule)object3, 50.0, 0.2);
            object2 = new ForceFieldMMFF94((StereoMolecule)object3, "MMFF94s+", hashMap);
            ((ForceFieldMMFF94)object2).addEnergyTerm((EnergyTerm)object);
            ((AbstractForceField)object2).minimise();
            double d5 = ((ForceFieldMMFF94)object2).getTotalEnergy();
            for (int i = 0; i < ((Molecule)object3).getAllAtoms(); ++i) {
                ((Conformer)object4).setCoordinates(i, new Coordinates(((Molecule)object3).getCoordinates(i)));
            }
            list.add((Conformer)object4);
            if (!(d5 < d3)) continue;
            d3 = d5;
        }
        return d3;
    }

    public DockingResult dockMolecule(StereoMolecule stereoMolecule) throws DockingFailedException {
        Object object;
        Conformer conformer = null;
        double d = Double.MAX_VALUE;
        if (ForceFieldMMFF94.table("MMFF94s+") == null) {
            ForceFieldMMFF94.initialize("MMFF94s+");
        }
        ArrayList<Conformer> arrayList = new ArrayList<Conformer>();
        double d2 = 0.0;
        int n = this.mcSteps;
        if (this.mcsRef != null) {
            d2 = this.getStartingPositionsMCS(stereoMolecule, arrayList);
            n /= 3;
        } else {
            d2 = this.getStartingPositions(stereoMolecule, arrayList);
        }
        Map<String, Double> map = null;
        for (Conformer object2 : arrayList) {
            double d3;
            object = new Conformer(object2);
            LigandPose ligandPose = this.initiate((Conformer)object, d2);
            if (this.mcsRef != null) {
                ligandPose.setMCSBondConstraints(this.mcsConstrainedBonds);
                for (int n2 : this.mcsConstrainedAtoms) {
                    PositionConstraint positionConstraint = new PositionConstraint((Conformer)object, n2, 50.0, 1.0);
                    ligandPose.addConstraint(positionConstraint);
                }
            }
            if ((d3 = this.mcSearch(ligandPose, n)) < d) {
                d = d3;
                conformer = ligandPose.getLigConf();
                map = ligandPose.getContributions();
            }
            if (this.threadMaster == null || !this.threadMaster.threadMustDie()) continue;
            break;
        }
        if (conformer != null) {
            StereoMolecule stereoMolecule2 = conformer.toMolecule();
            Rotation rotation = this.rotation.getInvert();
            object = new Translation(new double[]{this.origCOM.x, this.origCOM.y, this.origCOM.z});
            rotation.apply(stereoMolecule2);
            object.apply(stereoMolecule2);
            return new DockingResult(stereoMolecule, stereoMolecule2, d, map);
        }
        throw new DockingFailedException("docking failed");
    }

    private double mcSearch(LigandPose ligandPose, int n) {
        double[] dArray = new double[ligandPose.getState().length];
        double[] dArray2 = new double[ligandPose.getState().length];
        double[] dArray3 = new double[ligandPose.getState().length];
        double d = -3.4028234663852886E38;
        double d2 = -3.4028234663852886E38;
        double d3 = -3.4028234663852886E38;
        OptimizerLBFGS optimizerLBFGS = new OptimizerLBFGS(200, 0.001);
        dArray2 = optimizerLBFGS.optimize(ligandPose);
        dArray = dArray2;
        d = d2 = ligandPose.getFGValue(new double[dArray.length]);
        for (int i = 0; i < n; ++i) {
            double d4;
            ligandPose.randomPerturbation();
            double d5 = ligandPose.getFGValue(new double[dArray.length]);
            if (d5 < 100.0) {
                dArray3 = optimizerLBFGS.optimize(ligandPose);
                d3 = ligandPose.getFGValue(new double[dArray.length]);
            } else {
                dArray3 = ligandPose.getState();
                d3 = d5;
            }
            if (d3 < d2) {
                d2 = d3;
                dArray2 = dArray3;
                if (!(d3 < d)) continue;
                d = d3;
                dArray = dArray3;
                continue;
            }
            double d6 = d3 - d2;
            double d7 = this.random.nextDouble();
            if (d7 < (d4 = Math.exp(-d6 / 1.2))) {
                d2 = d3;
                dArray2 = dArray3;
                continue;
            }
            ligandPose.setState(dArray2);
        }
        ligandPose.setState(dArray);
        ligandPose.removeConstraints();
        d = ligandPose.getFGValue(new double[dArray.length]);
        return d;
    }

    private LigandPose initiate(Conformer conformer, double d) {
        LigandPose ligandPose = new LigandPose(conformer, this.engine, d);
        return ligandPose;
    }

    public void setMCSReference(StereoMolecule stereoMolecule) {
        this.mcsRef = stereoMolecule;
    }

    public static void getBindingSiteAtoms(StereoMolecule stereoMolecule, Set<Integer> set, MoleculeGrid moleculeGrid, boolean bl) {
        int[] nArray = moleculeGrid.getGridSize();
        int n = stereoMolecule.getAtoms();
        if (bl) {
            n = stereoMolecule.getAllAtoms();
        }
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = moleculeGrid.getGridCoordinates(stereoMolecule.getCoordinates(i));
            int n2 = nArray2[0];
            int n3 = nArray2[1];
            int n4 = nArray2[2];
            if (n2 <= 0 || n2 >= nArray[0] || n3 <= 0 || n3 >= nArray[1] || n4 <= 0 || n4 >= nArray[2]) continue;
            set.add(i);
        }
    }

    public static int[] getReceptorAtomTypes(StereoMolecule stereoMolecule) {
        int[] nArray = new int[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            nArray[i] = InteractionAtomTypeCalculator.getAtomType(stereoMolecule, i);
        }
        return nArray;
    }

    private void preprocess(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        Translation translation = new Translation(new double[]{-this.origCOM.x, -this.origCOM.y, -this.origCOM.z});
        translation.apply(stereoMolecule2);
        this.rotation.apply(stereoMolecule2);
        translation.apply(stereoMolecule);
        this.rotation.apply(stereoMolecule);
    }

    public double refineNativePose(double d, double[] dArray) {
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dielectric constant", 80.0);
        if (ForceFieldMMFF94.table("MMFF94s+") == null) {
            ForceFieldMMFF94.initialize("MMFF94s+");
        }
        Molecule3D molecule3D = new Molecule3D(this.nativeLigand);
        new Canonizer(molecule3D);
        ForceFieldMMFF94 forceFieldMMFF94 = new ForceFieldMMFF94(molecule3D, "MMFF94s+", hashMap);
        MMFFPositionConstraint mMFFPositionConstraint = new MMFFPositionConstraint(molecule3D, 50.0, 0.2);
        forceFieldMMFF94.addEnergyTerm(mMFFPositionConstraint);
        forceFieldMMFF94.minimise();
        ConformerSetGenerator conformerSetGenerator = new ConformerSetGenerator(100, 3, false, LigandPose.SEED);
        ConformerSet conformerSet = conformerSetGenerator.generateConformerSet(molecule3D);
        double d2 = Double.MAX_VALUE;
        ConformerSet conformerSet2 = new ConformerSet();
        for (Object object2 : conformerSet) {
            if (object2 == null) continue;
            StereoMolecule stereoMolecule = ((Conformer)object2).toMolecule();
            stereoMolecule.ensureHelperArrays(15);
            forceFieldMMFF94 = new ForceFieldMMFF94(stereoMolecule, "MMFF94s+", hashMap);
            mMFFPositionConstraint = new MMFFPositionConstraint(stereoMolecule, 50.0, 0.2);
            forceFieldMMFF94.addEnergyTerm(mMFFPositionConstraint);
            forceFieldMMFF94.minimise();
            Conformer conformer = new Conformer(stereoMolecule);
            conformerSet2.add(conformer);
            if (conformerSet2.size() >= this.startPositions) break;
            double d3 = forceFieldMMFF94.getTotalEnergy();
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        LigandPose ligandPose = new LigandPose(new Conformer(molecule3D), this.engine, d2);
        ligandPose.addPositionalConstraints(d);
        object2 = new OptimizerLBFGS(200, 0.001);
        ((OptimizerLBFGS)object2).optimize(ligandPose);
        double d4 = ligandPose.getFGValue(new double[ligandPose.getState().length]);
        StereoMolecule stereoMolecule = ligandPose.getLigConf().toMolecule();
        double[][] dArray2 = this.rotation.getInvert().getRotation();
        PheSAAlignment.rotateMol(stereoMolecule, dArray2);
        PheSAAlignment.translateMol(stereoMolecule, new double[]{this.origCOM.x, this.origCOM.y, this.origCOM.z});
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            dArray[3 * i] = stereoMolecule.getAtomX(i);
            dArray[3 * i + 1] = stereoMolecule.getAtomY(i);
            dArray[3 * i + 2] = stereoMolecule.getAtomZ(i);
        }
        return d4;
    }

    private static double getCoreRMSD(Coordinates[] coordinatesArray, Coordinates[] coordinatesArray2) {
        double d = 0.0;
        for (int i = 0; i < coordinatesArray.length; ++i) {
            Coordinates coordinates = coordinatesArray[i];
            Coordinates coordinates2 = coordinatesArray2[i];
            d += coordinates.distanceSquared(coordinates2);
        }
        d /= (double)coordinatesArray.length;
        d = Math.sqrt(d);
        return d;
    }

    public static class DockingResult
    implements Comparable<DockingResult> {
        private double score;
        private StereoMolecule input;
        private StereoMolecule pose;
        private Map<String, Double> contributions;
        private static final String DELIMITER = ";";
        private static final String DELIMITER2 = ":";
        private static final String DELIMITER3 = "%";
        private static final String NULL_CONTRIBUTION = "#";

        public DockingResult(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, double d, Map<String, Double> map) {
            this.score = d;
            this.pose = stereoMolecule2;
            this.contributions = map;
            this.input = stereoMolecule;
        }

        public void setInput(StereoMolecule stereoMolecule) {
            this.input = stereoMolecule;
        }

        public StereoMolecule getInput() {
            return this.input;
        }

        public double getScore() {
            return this.score;
        }

        public StereoMolecule getPose() {
            return this.pose;
        }

        public Map<String, Double> getContributions() {
            return this.contributions;
        }

        public String encode() {
            Base64.Encoder encoder = Base64.getEncoder();
            StringBuilder stringBuilder = new StringBuilder();
            Canonizer canonizer = new Canonizer(this.pose, 64);
            String string = canonizer.getEncodedCoordinates(true);
            String string2 = canonizer.getIDCode();
            stringBuilder.append(string2);
            stringBuilder.append(DELIMITER);
            stringBuilder.append(string);
            stringBuilder.append(DELIMITER);
            stringBuilder.append(this.input.getIDCode());
            stringBuilder.append(DELIMITER);
            stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleToByteArray(this.score)));
            stringBuilder.append(DELIMITER);
            if (this.contributions == null || this.contributions.keySet().size() == 0) {
                stringBuilder.append(NULL_CONTRIBUTION);
            } else {
                for (String string3 : this.contributions.keySet()) {
                    stringBuilder.append(string3);
                    stringBuilder.append(DELIMITER3);
                    stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleToByteArray(this.contributions.get(string3))));
                    stringBuilder.append(DELIMITER2);
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }

        public static DockingResult decode(String string) {
            String[] stringArray;
            Base64.Decoder decoder = Base64.getDecoder();
            String[] stringArray2 = string.split(DELIMITER);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            StereoMolecule stereoMolecule = new StereoMolecule();
            IDCodeParserWithoutCoordinateInvention iDCodeParserWithoutCoordinateInvention = new IDCodeParserWithoutCoordinateInvention();
            iDCodeParserWithoutCoordinateInvention.parse(stereoMolecule, string2, string3);
            stereoMolecule.ensureHelperArrays(31);
            String string4 = stringArray2[2];
            StereoMolecule stereoMolecule2 = new StereoMolecule();
            new IDCodeParser().parse(stereoMolecule2, string4);
            double d = EncodeFunctions.byteArrayToDouble(decoder.decode(stringArray2[3].getBytes()));
            HashMap<String, Double> hashMap = null;
            if (!stringArray2[4].equals(NULL_CONTRIBUTION)) {
                hashMap = new HashMap<String, Double>();
                for (String string5 : stringArray = stringArray2[4].split(DELIMITER2)) {
                    String[] stringArray3 = string5.split(DELIMITER3);
                    String string6 = stringArray3[0];
                    double d2 = EncodeFunctions.byteArrayToDouble(decoder.decode(stringArray3[1].getBytes()));
                    hashMap.put(string6, d2);
                }
            }
            stringArray = new DockingResult(stereoMolecule2, stereoMolecule, d, hashMap);
            return stringArray;
        }

        @Override
        public int compareTo(DockingResult dockingResult) {
            if (Double.isNaN(this.score) && Double.isNaN(dockingResult.score)) {
                return 0;
            }
            if (Double.isNaN(this.score)) {
                return -1;
            }
            if (Double.isNaN(dockingResult.score)) {
                return 1;
            }
            return Double.compare(this.score, dockingResult.score);
        }
    }

    public static enum ScoringFunction {
        CHEMPLP,
        IDOSCORE;

    }
}

