/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.descriptor.pharmacophoretree.HungarianAlgorithm;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreNode;
import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreTree;
import com.actelion.research.chem.descriptor.pharmacophoretree.TreeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeMatcher {
    public static final int EXTENSION_MATCHES = 3;
    public static final double ALPHA = 0.8;
    public static final double NULL_MATCH_SCALING = 0.5;
    public static final double SIMILARITY_SCALING_SPLIT_SCORE = 0.6;
    public static final double MATCH_BALANCE = 2.0;
    public static final double MATCH_SIZE_LIMIT = 3.0;
    public static final int MATCH_NODE_NR_LIMIT = 2;
    public static final int EXTENSION_MATCH_NODE_NR_LIMIT = 3;
    public static final int INITIAL_SPLITS = 5;
    public static final double SIZE_RATIO = 2.0;
    private TreeMatching[][] dpMatchMatrix;
    private PharmacophoreTree queryTree;
    private PharmacophoreTree baseTree;
    private List<PharmacophoreNode> queryNodes;
    private List<PharmacophoreNode> baseNodes;

    public TreeMatcher(PharmacophoreTree pharmacophoreTree, PharmacophoreTree pharmacophoreTree2) {
        this.queryTree = pharmacophoreTree;
        this.baseTree = pharmacophoreTree2;
        this.queryNodes = pharmacophoreTree.getNodes();
        this.baseNodes = pharmacophoreTree2.getNodes();
        this.dpMatchMatrix = new TreeMatching[2 * pharmacophoreTree.getEdges().size()][2 * pharmacophoreTree2.getEdges().size()];
    }

    public TreeMatching matchSearch() {
        int[][] nArray;
        double d = 0.0;
        TreeMatching treeMatching = new TreeMatching();
        for (int[] nArray2 : nArray = this.findInitialSplits()) {
            int n = nArray2[0];
            int n2 = -1;
            int n3 = nArray2[1] / 2;
            int n4 = nArray2[1] % 2 == 0 ? -1 : 1;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            int[] nArray3 = this.queryTree.initialCut(n2, n, arrayList, arrayList3, arrayList2, arrayList4);
            ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
            int[] nArray4 = this.baseTree.initialCut(n4, n3, arrayList5, arrayList7, arrayList6, arrayList8);
            TreeMatching treeMatching2 = this.extensionMatch(nArray3[0], nArray4[0], n, n3, n2, n4, arrayList, arrayList5, arrayList3, arrayList7);
            TreeMatching treeMatching3 = this.extensionMatch(nArray3[1], nArray4[1], n, n3, n2 * -1, n4 * -1, arrayList2, arrayList6, arrayList4, arrayList8);
            treeMatching2.addMatching(treeMatching3);
            treeMatching2.calculate();
            if (!(treeMatching2.sim > d)) continue;
            d = treeMatching2.sim;
            treeMatching = treeMatching2;
        }
        treeMatching.calculate();
        return treeMatching;
    }

    public int[][] findInitialSplits() {
        Object object;
        int[] nArray = new int[]{-1, 1};
        double[][] dArray = new double[2 * this.queryTree.getEdges().size()][2 * this.baseTree.getEdges().size()];
        for (int i = 0; i < this.queryTree.getEdges().size(); ++i) {
            object = new ArrayList();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            int[] nArray2 = this.queryTree.initialCut(nArray[0], i, (List<Integer>)object, arrayList2, arrayList, arrayList3);
            for (int j = 0; j < this.baseTree.getEdges().size(); ++j) {
                for (int n : nArray) {
                    ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
                    int[] nArray3 = this.baseTree.initialCut(n, j, arrayList4, arrayList6, arrayList5, arrayList7);
                    Set<Integer> set = this.queryTree.getNodesFromEdges((List<Integer>)object);
                    set.add(nArray2[0]);
                    Set<Integer> set2 = this.queryTree.getNodesFromEdges(arrayList);
                    set2.add(nArray2[1]);
                    Set<Integer> set3 = this.baseTree.getNodesFromEdges(arrayList4);
                    set3.add(nArray3[0]);
                    Set<Integer> set4 = this.baseTree.getNodesFromEdges(arrayList5);
                    set4.add(nArray3[1]);
                    int n2 = i;
                    int n3 = n == -1 ? j * 2 : j * 2 + 1;
                    dArray[n2][n3] = this.getSplitScore(this.queryTree, this.baseTree, set, set3, set2, set4);
                }
            }
        }
        int[][] nArray4 = new int[5][2];
        object = new double[5];
        TreeUtils.retrieveHighestValuesFrom2DArray(dArray, (double[])object, nArray4);
        return nArray4;
    }

    private TreeMatching extensionMatch(int n, int n2, int n3, int n4, int n5, int n6, List<Integer> list, List<Integer> list2, List<Integer> list3, List<Integer> list4) {
        TreeMatching treeMatching;
        int n7 = n5 == -1 ? n3 * 2 : n3 * 2 + 1;
        int n8 = n6 == -1 ? n4 * 2 : n4 * 2 + 1;
        Set<Integer> set = this.queryTree.getNodesFromEdges(list);
        set.add(n);
        Set<Integer> set2 = this.baseTree.getNodesFromEdges(list2);
        set2.add(n2);
        if (this.dpMatchMatrix[n7][n8] != null) {
            treeMatching = this.dpMatchMatrix[n7][n8];
        } else {
            List<FeatureMatch> list5 = this.assessMatch(set, set2);
            if (list5 != null) {
                treeMatching = new TreeMatching();
                for (FeatureMatch featureMatch : list5) {
                    treeMatching.addFeatureMatch(featureMatch);
                }
                treeMatching.calculate();
                this.dpMatchMatrix[n7][n8] = treeMatching;
            } else {
                Object[] objectArray;
                List<int[]> list6 = this.queryTree.getExtensionCuts(list, list3);
                List<int[]> list7 = this.baseTree.getExtensionCuts(list2, list4);
                double[][] dArray = new double[list6.size()][list7.size()];
                for (int i = 0; i < list6.size(); ++i) {
                    objectArray = list6.get(i);
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    HashSet<Integer> hashSet2 = new HashSet<Integer>();
                    this.queryTree.enumerateExtensionCutFast(n, (int[])objectArray, list, (Set<Integer>)hashSet, (Set<Integer>)hashSet2);
                    for (int j = 0; j < list7.size(); ++j) {
                        int[] nArray = list7.get(j);
                        HashSet<Integer> object = new HashSet<Integer>();
                        HashSet<Integer> hashSet3 = new HashSet<Integer>();
                        this.baseTree.enumerateExtensionCutFast(n2, nArray, list2, object, hashSet3);
                        dArray[i][j] = this.scoreExtensionMatch(this.queryTree, this.baseTree, hashSet, object, hashSet2, hashSet3);
                    }
                }
                int[][] nArray = new int[list6.size() * list7.size()][2];
                objectArray = new double[list6.size() * list7.size()];
                TreeUtils.retrieveHighestValuesFrom2DArray(dArray, objectArray, nArray);
                double d = -1.7976931348623157E308;
                TreeMatching treeMatching2 = null;
                int n9 = 0;
                for (int[] nArray2 : nArray) {
                    FeatureMatch featureMatch;
                    int n10;
                    Object object;
                    Object i2;
                    int n11;
                    if (n9 > 3) break;
                    if (nArray2[0] == -1 || nArray2[1] == -1) continue;
                    int[] nArray3 = list6.get(nArray2[0]);
                    int[] nArray4 = list7.get(nArray2[1]);
                    ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
                    ArrayList<List<Integer>> arrayList2 = new ArrayList<List<Integer>>();
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
                    this.queryTree.enumerateExtensionCutFull(n, nArray3, list, list3, arrayList, arrayList2, arrayList3, hashSet, arrayList4, arrayList5);
                    ArrayList<List<Integer>> arrayList6 = new ArrayList<List<Integer>>();
                    ArrayList<List<Integer>> arrayList7 = new ArrayList<List<Integer>>();
                    ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
                    HashSet<Integer> hashSet4 = new HashSet<Integer>();
                    ArrayList<Integer> arrayList9 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList10 = new ArrayList<Integer>();
                    this.baseTree.enumerateExtensionCutFull(n2, nArray4, list2, list4, arrayList6, arrayList7, arrayList8, hashSet4, arrayList9, arrayList10);
                    FeatureMatch featureMatch2 = this.assessExtensionMatch(hashSet, hashSet4);
                    if (featureMatch2 == null) continue;
                    ++n9;
                    TreeMatching[][] treeMatchingArray = new TreeMatching[arrayList3.size()][arrayList8.size()];
                    double[][] dArray2 = new double[arrayList3.size()][arrayList8.size()];
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        for (n11 = 0; n11 < arrayList8.size(); ++n11) {
                            treeMatchingArray[i][n11] = i2 = this.extensionMatch((Integer)arrayList3.get(i), (Integer)arrayList8.get(n11), (Integer)arrayList4.get(i), (Integer)arrayList9.get(n11), (Integer)arrayList5.get(i), (Integer)arrayList10.get(n11), (List)arrayList.get(i), (List)arrayList6.get(n11), (List)arrayList2.get(i), (List)arrayList7.get(n11));
                            dArray2[i][n11] = ((TreeMatching)i2).sim;
                        }
                    }
                    int[][] i = new int[0][0];
                    n11 = 0;
                    if (dArray2.length > 0 && dArray2[0].length > 0) {
                        if (dArray2.length > dArray2[0].length) {
                            dArray2 = HungarianAlgorithm.transpose(dArray2);
                            n11 = 1;
                        }
                        if (dArray2.length <= 0 || dArray2[0].length > 0) {
                            // empty if block
                        }
                        i = HungarianAlgorithm.hgAlgorithm(dArray2, "max");
                        if (n11 != 0) {
                            dArray2 = HungarianAlgorithm.transpose(dArray2);
                            for (int j = 0; j < i.length; ++j) {
                                object = i[j];
                                Object object2 = object[0];
                                object[0] = object[1];
                                object[1] = object2;
                            }
                        }
                    }
                    i2 = new HashSet<Integer>();
                    object = new HashSet<Integer>();
                    TreeMatching object3 = new TreeMatching();
                    object3.addFeatureMatch(featureMatch2);
                    for (n10 = 0; n10 < i.length; ++n10) {
                        i2.add(i[n10][0]);
                        object.add(i[n10][1]);
                        object3.addMatching(treeMatchingArray[i[n10][0]][i[n10][1]]);
                    }
                    for (n10 = 0; n10 < arrayList3.size(); ++n10) {
                        if (i2.contains(n10)) continue;
                        featureMatch = this.getMatch((Integer)arrayList3.get(n10), (List)arrayList.get(n10), -1, new ArrayList<Integer>());
                        object3.addFeatureMatch(featureMatch);
                    }
                    for (n10 = 0; n10 < arrayList8.size(); ++n10) {
                        if (object.contains(n10)) continue;
                        featureMatch = this.getMatch(-1, new ArrayList<Integer>(), (Integer)arrayList8.get(n10), (List)arrayList6.get(n10));
                        object3.addFeatureMatch(featureMatch);
                    }
                    object3.calculate();
                    double n102 = object3.sim;
                    if (!(n102 >= d)) continue;
                    d = n102;
                    treeMatching2 = object3;
                }
                treeMatching = treeMatching2;
            }
        }
        return treeMatching;
    }

    private List<FeatureMatch> assessMatch(Collection<Integer> collection, Collection<Integer> collection2) {
        ArrayList<FeatureMatch> arrayList = null;
        double d = this.getSizeOfNodeCollection(collection, this.queryTree);
        double d2 = this.getSizeOfNodeCollection(collection2, this.baseTree);
        boolean bl = this.isMatchBalanced(d, d2);
        if (d < 3.0 || d2 < 3.0 || collection.size() < 2 || collection2.size() < 2) {
            if (bl) {
                arrayList = new ArrayList<FeatureMatch>();
                arrayList.add(this.getMatch(collection, collection2));
            } else {
                arrayList = new ArrayList();
                arrayList.add(this.getMatch(collection, new ArrayList<Integer>()));
                arrayList.add(this.getMatch(new ArrayList<Integer>(), collection2));
            }
        }
        return arrayList;
    }

    private FeatureMatch assessExtensionMatch(Collection<Integer> collection, Collection<Integer> collection2) {
        FeatureMatch featureMatch = null;
        double d = this.getSizeOfNodeCollection(collection, this.queryTree);
        double d2 = this.getSizeOfNodeCollection(collection2, this.baseTree);
        if (collection.size() != 0 && collection2.size() != 0 && (d < 3.0 || d2 < 3.0 || collection.size() < 2 || collection2.size() < 2)) {
            featureMatch = this.getMatch(collection, collection2);
        }
        return featureMatch;
    }

    private FeatureMatch getMatch(int n2, List<Integer> list, int n3, List<Integer> list2) {
        FeatureMatch featureMatch = null;
        int[][] nArrayArray = new int[2][];
        if (n2 == -1) {
            Set<Integer> set = this.baseTree.getNodesFromEdges(list2);
            set.add(n3);
            nArrayArray[0] = new int[0];
            nArrayArray[1] = set.stream().mapToInt(n -> n).toArray();
            featureMatch = new FeatureMatch(nArrayArray);
            featureMatch.calculate(this.queryNodes, this.baseNodes);
        } else if (n3 == -1) {
            Set<Integer> set = this.queryTree.getNodesFromEdges(list);
            set.add(n2);
            nArrayArray[1] = new int[0];
            nArrayArray[0] = set.stream().mapToInt(n -> n).toArray();
            featureMatch = new FeatureMatch(nArrayArray);
            featureMatch.calculate(this.queryNodes, this.baseNodes);
        } else {
            Set<Integer> set = this.queryTree.getNodesFromEdges(list);
            set.add(n2);
            Set<Integer> set2 = this.baseTree.getNodesFromEdges(list2);
            set2.add(n3);
            nArrayArray[0] = set.stream().mapToInt(n -> n).toArray();
            nArrayArray[1] = set2.stream().mapToInt(n -> n).toArray();
            featureMatch = new FeatureMatch(nArrayArray);
            featureMatch.calculate(this.queryNodes, this.baseNodes);
        }
        return featureMatch;
    }

    private FeatureMatch getMatch(Collection<Integer> collection, Collection<Integer> collection2) {
        FeatureMatch featureMatch = null;
        int[][] nArrayArray = new int[][]{collection.stream().mapToInt(n -> n).toArray(), collection2.stream().mapToInt(n -> n).toArray()};
        featureMatch = new FeatureMatch(nArrayArray);
        featureMatch.calculate(this.queryNodes, this.baseNodes);
        return featureMatch;
    }

    private double scoreExtensionMatch(PharmacophoreTree pharmacophoreTree, PharmacophoreTree pharmacophoreTree2, Set<Integer> set, Set<Integer> set2, Set<Integer> set3, Set<Integer> set4) {
        double d = PharmacophoreNode.getSimilarity(set, set2, this.queryNodes, this.baseNodes);
        double d2 = PharmacophoreNode.getSimilarity(set3, set4, this.queryNodes, this.baseNodes);
        return 0.8 * d + 0.19999999999999996 * d2;
    }

    private boolean isMatchBalanced(double d, double d2) {
        boolean bl = true;
        double d3 = d / d2;
        if (d3 > 2.0 || d3 < 0.5) {
            bl = false;
        }
        return bl;
    }

    private double getSizeOfNodeCollection(Collection<Integer> collection, PharmacophoreTree pharmacophoreTree) {
        double d = 0.0;
        List<PharmacophoreNode> list = pharmacophoreTree.getNodes(collection);
        for (PharmacophoreNode pharmacophoreNode : list) {
            d += pharmacophoreNode.getSize();
        }
        return d;
    }

    private double getCutBalance(Collection<Integer> collection, Collection<Integer> collection2) {
        double d = 1.0;
        int n = Math.abs(collection.size() - collection2.size());
        if (n > 2) {
            d = 1.0 - ((double)n - 2.0) / ((double)(collection.size() + collection2.size()) - 2.0);
        }
        return d;
    }

    private double getSplitScore(PharmacophoreTree pharmacophoreTree, PharmacophoreTree pharmacophoreTree2, Collection<Integer> collection, Collection<Integer> collection2, Collection<Integer> collection3, Collection<Integer> collection4) {
        double d = 0.0;
        int n = collection.size();
        int n2 = collection3.size();
        int n3 = collection2.size();
        int n4 = collection4.size();
        double d2 = 0.0;
        d2 = n + n2 < n3 + n4 ? this.getCutBalance(collection, collection3) : (n + n2 == n3 + n4 ? 0.5 * this.getCutBalance(collection, collection3) + 0.5 * this.getCutBalance(collection2, collection4) : this.getCutBalance(collection2, collection4));
        FeatureMatch featureMatch = this.getMatch(collection, collection2);
        FeatureMatch featureMatch2 = this.getMatch(collection3, collection4);
        TreeMatching treeMatching = new TreeMatching();
        treeMatching.addFeatureMatch(featureMatch);
        treeMatching.addFeatureMatch(featureMatch2);
        treeMatching.calculate();
        d = 0.4 * treeMatching.sim + 0.6 * d2;
        return d;
    }

    public static class FeatureMatch {
        private double sim;
        private double size;
        double[] sizes = new double[2];
        private int[][] match;

        public FeatureMatch(int[][] nArray) {
            this.match = nArray;
        }

        public void calculate(List<PharmacophoreNode> list, List<PharmacophoreNode> list2) {
            Integer n;
            int n2;
            int n3;
            Object object;
            this.sim = 0.0;
            this.sizes[0] = 0.0;
            this.sizes[1] = 0.0;
            this.size = 0.0;
            ArrayList<PharmacophoreNode> arrayList = new ArrayList<PharmacophoreNode>();
            ArrayList<PharmacophoreNode> arrayList2 = new ArrayList<PharmacophoreNode>();
            if (this.match[0].length != 0) {
                object = this.match[0];
                n3 = ((int[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    n = object[n2];
                    arrayList.add(list.get(n));
                }
            }
            if (this.match[1].length != 0) {
                object = this.match[1];
                n3 = ((int[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    n = (int)object[n2];
                    arrayList2.add(list2.get(n));
                }
            }
            this.sim = arrayList.size() == 0 || arrayList2.size() == 0 ? 0.0 : PharmacophoreNode.getSimilarity(arrayList, arrayList2);
            if (arrayList.size() > 0) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    PharmacophoreNode pharmacophoreNode = (PharmacophoreNode)object.next();
                    this.sizes[0] = this.sizes[0] + pharmacophoreNode.getSize();
                }
            }
            if (arrayList2.size() > 0) {
                for (PharmacophoreNode pharmacophoreNode : arrayList2) {
                    this.sizes[1] = this.sizes[1] + pharmacophoreNode.getSize();
                }
            }
            this.size = this.sizes[0] + this.sizes[1];
        }

        public double[] getSizes() {
            return this.sizes;
        }

        public double getSim() {
            return this.sim;
        }

        public int[][] getMatch() {
            return this.match;
        }

        public void setSizes(double[] dArray) {
            this.sizes = dArray;
            this.size = dArray[0] + dArray[1];
        }

        public void setSim(double d) {
            this.sim = d;
        }
    }

    public static class TreeMatching {
        private List<FeatureMatch> matches = new ArrayList<FeatureMatch>();
        private double sim;
        private double size1;
        private double size2;

        public void addFeatureMatch(FeatureMatch featureMatch) {
            this.matches.add(featureMatch);
        }

        public void addMatching(TreeMatching treeMatching) {
            this.matches.addAll(treeMatching.matches);
        }

        public void calculate() {
            this.sim = 0.0;
            this.size1 = 0.0;
            this.size2 = 0.0;
            for (FeatureMatch featureMatch : this.matches) {
                this.sim += featureMatch.size * featureMatch.sim;
                this.size1 += featureMatch.sizes[0];
                this.size2 += featureMatch.sizes[1];
            }
            double d = 0.5 * this.sim;
            double d2 = 0.5 * Math.max(this.size1, this.size2) + 0.5 * Math.min(this.size1, this.size2);
            this.sim = d / d2;
        }

        public List<FeatureMatch> getMatches() {
            return this.matches;
        }

        public double getSim() {
            return this.sim;
        }

        public double getSize1() {
            return this.size1;
        }

        public double getSize2() {
            return this.size2;
        }
    }
}

