/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.descriptor.pharmacophoretree.PharmacophoreNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PharmacophoreTree {
    public static final int CUT_NONE = 0;
    public static final int CUT_RIGHT = 1;
    public static final int CUT_LEFT = -1;
    private List<int[]> edges;
    private List<PharmacophoreNode> nodes;
    private Map<Integer, List<Integer>> adjacencyList;
    private int linkerNodes;

    public PharmacophoreTree(List<PharmacophoreNode> list, List<int[]> list2) {
        this.nodes = list;
        this.edges = list2;
        this.linkerNodes = 0;
        this.update();
    }

    private void update() {
        this.linkerNodes = 0;
        for (PharmacophoreNode pharmacophoreNode : this.nodes) {
            if (!pharmacophoreNode.isLinkNode()) continue;
            ++this.linkerNodes;
        }
        this.adjacencyList = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.adjacencyList.putIfAbsent(i, new ArrayList());
            for (int j = 0; j < this.edges.size(); ++j) {
                int[] nArray = this.edges.get(j);
                if (nArray[0] != i && nArray[1] != i) continue;
                this.adjacencyList.get(i).add(j);
            }
        }
    }

    public int[] initialCut(int n, int n2, List<Integer> list, List<Integer> list2, List<Integer> list3, List<Integer> list4) {
        int n3 = -1;
        int n4 = -1;
        if (n == -1) {
            n3 = this.edges.get(n2)[0];
            n4 = this.edges.get(n2)[1];
        } else if (n == 1) {
            n3 = this.edges.get(n2)[1];
            n4 = this.edges.get(n2)[0];
        } else {
            throw new IllegalArgumentException();
        }
        this.treeWalkBFS(n3, n2, list, list2);
        this.treeWalkBFS(n4, n2, list3, list4);
        return new int[]{n3, n4};
    }

    public void treeWalkBFS(int n, int n2, List<Integer> list, List<Integer> list2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        linkedList.add(n);
        hashMap.put(n, n2);
        hashSet2.add(n2);
        list.add(n2);
        list2.add(-1);
        while (!linkedList.isEmpty()) {
            int n3 = (Integer)linkedList.poll();
            hashSet.add(n3);
            int n4 = (Integer)hashMap.get(n3);
            for (int n5 : this.adjacencyList.get(n3)) {
                int[] nArray = this.edges.get(n5);
                if (hashSet2.contains(n5)) continue;
                hashSet2.add(n5);
                int n6 = -1;
                if (nArray[0] == n3) {
                    n6 = nArray[1];
                } else if (nArray[1] == n3) {
                    n6 = nArray[0];
                }
                linkedList.add(n6);
                hashMap.put(n6, n5);
                list.add(n5);
                list2.add(n4);
            }
        }
    }

    public void enumerateExtensionCutFast(int n, int[] nArray, List<Integer> list, Set<Integer> set, Set<Integer> set2) {
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = this.edges.get(list.get(i));
            if (nArray[i] == 0) {
                set.add(nArray2[0]);
                set.add(nArray2[1]);
                continue;
            }
            if (nArray[i] == 1) {
                if (set.contains(nArray2[0])) {
                    set2.add(nArray2[1]);
                    continue;
                }
                set2.add(nArray2[0]);
                continue;
            }
            if (nArray[i] != -1) continue;
            set2.add(nArray2[0]);
            set2.add(nArray2[1]);
        }
    }

    public void enumerateExtensionCutFull(int n, int[] nArray, List<Integer> list, List<Integer> list2, List<List<Integer>> list3, List<List<Integer>> list4, List<Integer> list5, Set<Integer> set, List<Integer> list6, List<Integer> list7) {
        set.add(n);
        for (int i = 1; i < nArray.length; ++i) {
            int n2 = list.get(i);
            int[] nArray2 = this.edges.get(n2);
            if (nArray[i] == 0) {
                set.add(nArray2[0]);
                set.add(nArray2[1]);
                continue;
            }
            if (nArray[i] == 1) {
                list6.add(n2);
                if (set.contains(nArray2[0])) {
                    list5.add(nArray2[1]);
                    list7.add(1);
                } else {
                    list5.add(nArray2[0]);
                    list7.add(-1);
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                arrayList.add(n2);
                list3.add(arrayList);
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                arrayList2.add(-1);
                list4.add(arrayList2);
                continue;
            }
            if (nArray[i] != -1) continue;
            int n3 = list2.get(i);
            int n4 = list6.indexOf(n3);
            if (n4 < 0) {
                for (int j = 0; j < list3.size(); ++j) {
                    if (!list3.get(j).contains(n3)) continue;
                    n4 = j;
                    break;
                }
            }
            list3.get(n4).add(n2);
            list4.get(n4).add(n3);
        }
    }

    public List<int[]> getExtensionCuts(List<Integer> list, List<Integer> list2) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n = 0;
        int[] nArray = new int[list.size()];
        Arrays.fill(nArray, -1);
        nArray[0] = 1;
        while (n >= 0) {
            int[] nArray2 = (int[])nArray.clone();
            n = this.getNextCut(nArray, nArray2, list, list2);
            nArray = nArray2;
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!Arrays.equals(nArray, (int[])arrayList.get(i))) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(nArray);
        }
        return arrayList;
    }

    public Set<Integer> getNodesFromEdges(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 1; i < list.size(); ++i) {
            int n = list.get(i);
            int[] nArray = this.edges.get(n);
            hashSet.add(nArray[0]);
            hashSet.add(nArray[1]);
        }
        return hashSet;
    }

    private int getNextCut(int[] nArray, int[] nArray2, List<Integer> list, List<Integer> list2) {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            if (i < n2) {
                n2 = i;
            }
            if (i <= n3) continue;
            n3 = i;
        }
        if (n2 < Integer.MAX_VALUE && n3 > Integer.MIN_VALUE) {
            int n4;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n4 = 0; n4 < n2; ++n4) {
                hashSet.add(this.edges.get(list.get(n4))[0]);
                hashSet.add(this.edges.get(list.get(n4))[1]);
            }
            n = hashSet.size();
            if (n > 2) {
                n = -1;
            } else {
                nArray2[n3] = 0;
                for (n4 = n3 + 1; n4 < nArray2.length; ++n4) {
                    int n5 = list2.get(n4);
                    int n6 = list.indexOf(n5);
                    nArray2[n4] = n6 == n3 ? 1 : (nArray2[n6] == 0 ? 1 : -1);
                }
            }
        }
        return n;
    }

    public List<PharmacophoreNode> getNodes(Collection<Integer> collection) {
        ArrayList<PharmacophoreNode> arrayList = new ArrayList<PharmacophoreNode>();
        for (int n : collection) {
            arrayList.add(this.nodes.get(n));
        }
        return arrayList;
    }

    public List<PharmacophoreNode> getNodes() {
        return this.nodes;
    }

    public List<int[]> getEdges() {
        return this.edges;
    }

    public int getLinkNodes() {
        return this.linkerNodes;
    }

    public void removeNode(PharmacophoreNode pharmacophoreNode) {
        int n;
        int n2 = this.nodes.indexOf(pharmacophoreNode);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = this.edges.size() - 1; n >= 0; --n) {
            if (this.edges.get(n)[0] != n2 && this.edges.get(n)[1] != n2) continue;
            arrayList.add(n);
        }
        this.nodes.remove(n2);
        for (n = 0; n < this.edges.size(); ++n) {
            int[] nArray = this.edges.get(n);
            if (nArray[0] > n2) {
                nArray[0] = nArray[0] + -1;
            }
            if (nArray[1] <= n2) continue;
            nArray[1] = nArray[1] + -1;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            this.edges.remove(n3);
        }
        this.update();
    }

    public double getSize() {
        double d3 = this.nodes.stream().mapToDouble(pharmacophoreNode -> pharmacophoreNode.getSize()).reduce((d, d2) -> d + d2).getAsDouble();
        return d3;
    }

    public double getSubTreeSize(List<Integer> list, int n) {
        Set<Integer> set = this.getNodesFromEdges(list);
        List<PharmacophoreNode> list2 = this.getNodes(set);
        list2.add(this.nodes.get(n));
        double d3 = list2.stream().mapToDouble(pharmacophoreNode -> pharmacophoreNode.getSize()).reduce((d, d2) -> d + d2).getAsDouble();
        return d3;
    }

    public double getDirectSim(PharmacophoreTree pharmacophoreTree) {
        return PharmacophoreNode.getSimilarity(this.nodes, pharmacophoreTree.getNodes());
    }

    public List<Set<Integer>> getAllSubtrees() {
        HashSet<HashSet<Integer>> hashSet = new HashSet<HashSet<Integer>>();
        for (int i = 0; i < this.edges.size(); ++i) {
            for (int j = 0; j < 2; ++j) {
                int[] nArray = this.edges.get(i);
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                this.treeWalkBFS(nArray[j], i, arrayList, arrayList2);
                List<int[]> list = this.getExtensionCuts(arrayList, arrayList2);
                for (int[] nArray2 : list) {
                    ArrayList<List<Integer>> arrayList3 = new ArrayList<List<Integer>>();
                    ArrayList<List<Integer>> arrayList4 = new ArrayList<List<Integer>>();
                    ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
                    HashSet<Integer> hashSet2 = new HashSet<Integer>();
                    ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
                    this.enumerateExtensionCutFull(nArray[j], nArray2, arrayList, arrayList2, arrayList3, arrayList4, arrayList5, hashSet2, arrayList6, arrayList7);
                    hashSet.add(hashSet2);
                }
            }
        }
        return new ArrayList<Set<Integer>>(hashSet);
    }

    public void getPathsFromHeadNode(int n, List<Set<Integer>> list, Set<Integer> set) {
        Set<Integer> set2 = list.get(list.size() - 1);
        HashSet<Integer> hashSet = new HashSet<Integer>(set2);
        hashSet.add(n);
        list.add(hashSet);
        List<Integer> list2 = this.adjacencyList.get(n);
        for (Integer n2 : list2) {
            if (set.contains(n2)) continue;
            int[] nArray = this.edges.get(n2);
            int n3 = nArray[0];
            int n4 = nArray[1];
            if (n3 == n) {
                this.getPathsFromHeadNode(n4, list, set);
                continue;
            }
            this.getPathsFromHeadNode(n3, list, set);
        }
    }

    public static class BiGramInt {
        public int[] edge;
        public int order;
        int u;
        int v;

        public BiGramInt(int[] nArray) {
            this(nArray, 1);
        }

        public BiGramInt(int[] nArray, int n) {
            this.edge = nArray;
            this.order = n;
            if (nArray[0] < nArray[1]) {
                this.u = nArray[0];
                this.v = nArray[1];
            } else {
                this.u = nArray[1];
                this.v = nArray[0];
            }
        }

        public BiGramInt(int n, int n2) {
            this(new int[]{n, n2}, 1);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof BiGramInt)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return this.u == ((BiGramInt)object).u && this.v == ((BiGramInt)object).v;
        }

        public int hashCode() {
            return this.u * 31 + this.v;
        }
    }
}

