/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IonizableGroupDetector2D {
    private StereoMolecule mol;
    private List<ArrayList<Integer>> ionizableGroups;
    private Set<Integer> positivelyIonizableAtoms;
    private Set<Integer> negativelyIonizableAtoms;

    public IonizableGroupDetector2D(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
        this.ionizableGroups = new ArrayList<ArrayList<Integer>>();
        this.positivelyIonizableAtoms = new HashSet<Integer>();
        this.negativelyIonizableAtoms = new HashSet<Integer>();
    }

    public void detect() {
        int n;
        int n2;
        int n3;
        RingCollection ringCollection = this.mol.getRingSet();
        for (n3 = 0; n3 < ringCollection.getSize(); ++n3) {
            int[] nArray;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray2 = nArray = ringCollection.getRingAtoms(n3);
            n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                Integer n4 = nArray2[n];
                if (this.alreadyDetected(n4) || this.mol.getAtomicNo(n4) != 7 || !this.mol.isAromaticAtom(n4) || this.mol.getConnAtoms(n4) > 2) continue;
                arrayList.add(n4);
            }
            if (arrayList.size() != 4) continue;
            this.ionizableGroups.add(arrayList);
            this.negativelyIonizableAtoms.add((Integer)arrayList.get(0));
        }
        for (n3 = 0; n3 < this.mol.getAtoms(); ++n3) {
            int n5;
            int n6;
            ArrayList<Integer> arrayList;
            int n7;
            if (this.alreadyDetected(n3)) continue;
            if (this.mol.getAtomicNo(n3) == 8) {
                n7 = this.mol.getConnAtom(n3, 0);
                if (this.alreadyDetected(n7)) continue;
                if (AtomFunctionAnalyzer.isAcidicOxygen(this.mol, n3)) {
                    if (this.mol.getAtomicNo(n7) == 6) {
                        arrayList = new ArrayList<Integer>();
                        arrayList.add(n3);
                        arrayList.add(n7);
                        n6 = this.mol.getConnAtom(n7, 0);
                        n5 = this.mol.getConnAtom(n7, 1);
                        n2 = this.mol.getConnAtom(n7, 2);
                        int n8 = n6 != n3 && this.mol.getAtomicNo(n6) == 8 ? n6 : (n = n5 != n3 && this.mol.getAtomicNo(n5) == 8 ? n5 : n2);
                        if (this.alreadyDetected(n)) continue;
                        arrayList.add(n);
                        this.ionizableGroups.add(arrayList);
                        this.negativelyIonizableAtoms.add(n7);
                        continue;
                    }
                    if (this.mol.getAtomicNo(n7) == 15) {
                        arrayList = new ArrayList();
                        arrayList.add(n3);
                        arrayList.add(n7);
                        for (n6 = 0; n6 < this.mol.getConnAtoms(n7); ++n6) {
                            int n9 = this.mol.getConnAtom(n7, n6);
                            if (this.mol.getAtomicNo(n9) != 8 || n9 == n3 || this.alreadyDetected(n9)) continue;
                            arrayList.add(n9);
                        }
                        this.ionizableGroups.add(arrayList);
                        this.negativelyIonizableAtoms.add(n7);
                        continue;
                    }
                    if (this.mol.getAtomicNo(n7) == 16) {
                        arrayList = new ArrayList();
                        arrayList.add(n3);
                        arrayList.add(n7);
                        for (n6 = 0; n6 < this.mol.getConnAtoms(n7); ++n6) {
                            int n10 = this.mol.getConnAtom(n7, n6);
                            if (this.mol.getAtomicNo(n10) != 8 || n10 == n3 || this.alreadyDetected(n10)) continue;
                            arrayList.add(n10);
                        }
                        this.ionizableGroups.add(arrayList);
                        this.negativelyIonizableAtoms.add(n7);
                        continue;
                    }
                }
            } else if (this.mol.getAtomicNo(n3) == 7) {
                if (this.mol.isAromaticAtom(n3)) continue;
                if (this.mol.getConnAtoms(n3) <= 2) {
                    n7 = 0;
                    n6 = 0;
                    for (n5 = 0; n5 < this.mol.getConnAtoms(n3) && n6 == 0; ++n5) {
                        n2 = this.mol.getConnAtom(n3, n5);
                        if (this.alreadyDetected(n2) || this.mol.getAtomicNo(n2) != 6) continue;
                        if (this.mol.getBondOrder(this.mol.getBond(n3, n2)) == 2) {
                            ++n7;
                        }
                        for (n = 0; n < this.mol.getConnAtoms(n2) && n6 == 0; ++n) {
                            int n11 = this.mol.getConnAtom(n2, n);
                            if (this.mol.isAromaticAtom(n11) || n11 == n3 || this.alreadyDetected(n11) || this.mol.getAtomicNo(n11) != 7 || this.mol.getConnAtoms(n11) > 2) continue;
                            if (this.mol.getBondOrder(this.mol.getBond(n2, n11)) == 2) {
                                ++n7;
                            }
                            if (n7 != 1) continue;
                            arrayList = new ArrayList();
                            arrayList.add(n3);
                            arrayList.add(n2);
                            arrayList.add(n11);
                            this.ionizableGroups.add(arrayList);
                            this.positivelyIonizableAtoms.add(n2);
                            n6 = 1;
                        }
                    }
                }
                if (this.alreadyDetected(n3)) continue;
                if (AtomFunctionAnalyzer.isBasicNitrogen(this.mol, n3)) {
                    arrayList = new ArrayList();
                    arrayList.add(n3);
                    this.ionizableGroups.add(arrayList);
                    this.positivelyIonizableAtoms.add(n3);
                    continue;
                }
            }
            if (this.alreadyDetected(n3) || (n7 = this.mol.getAtomCharge(n3)) == 0 || this.hasCounterChargedNeighbour(n3)) continue;
            if (n7 > 0) {
                this.positivelyIonizableAtoms.add(n3);
                continue;
            }
            this.negativelyIonizableAtoms.add(n3);
        }
    }

    private boolean hasCounterChargedNeighbour(int n) {
        for (int i = 0; i < this.mol.getConnAtoms(n); ++i) {
            if (this.mol.getAtomCharge(n) * this.mol.getAtomCharge(this.mol.getConnAtom(n, i)) >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean alreadyDetected(int n) {
        boolean bl = this.ionizableGroups.stream().flatMap(Collection::stream).collect(Collectors.toList()).contains(n);
        return bl;
    }

    public Set<Integer> getPosIonizableAtoms() {
        return this.positivelyIonizableAtoms;
    }

    public Set<Integer> getNegIonizableAtoms() {
        return this.negativelyIonizableAtoms;
    }
}

