/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.redgraph;

import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.RingHelper;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.flexophore.redgraph.SubGraphIndices;
import com.actelion.research.util.hash.HashSetInt;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class SubGraphExtractor {
    private static final int MAX_NUM_ATOMS = 10000;
    private static final int MAX_RING_SIZE_TO_SUMMARIZE_HETERO_RINGS = 6;
    private static final int MAX_DEPTH_END_STANDING_ALIPHATIC_GROUP = 1;
    private static final int MIN_SIZE_ALIPHATIC_CHAIN_IN_RING = 3;
    private static final int DISTANCE_THRESH_SPLIT_GROUP = 6;
    private static final int GROUP_SIZE_SPLITTED = 3;
    private boolean[] arrAtomInSmallRing;
    private boolean[] arrAtomInLargeRing;
    private boolean[] arrRingAtom = new boolean[10000];
    private HashSet<Integer> hsAtomicNumberExcludeAliphatic = new HashSet();

    public SubGraphExtractor() {
        this.hsAtomicNumberExcludeAliphatic.add(7);
        this.hsAtomicNumberExcludeAliphatic.add(8);
    }

    public List<SubGraphIndices> extract(StereoMolecule stereoMolecule) {
        int n = stereoMolecule.getAtoms();
        for (int i = 0; i < n; ++i) {
            this.arrRingAtom[i] = false;
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(7);
        this.createRingAtomIndexMap(stereoMolecule2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            int n2 = stereoMolecule2.getAllConnAtoms(i);
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                int n4 = stereoMolecule2.getConnAtom(i, j);
                int n5 = stereoMolecule2.getAtomicNo(n4);
                if (n5 <= 1) continue;
                ++n3;
            }
            if (n3 != true) continue;
            arrayList.add(i);
        }
        ArrayList<SubGraphIndices> arrayList2 = new ArrayList<SubGraphIndices>();
        List<SubGraphIndices> list = this.getEndStandingHeteroGroups(stereoMolecule2, arrayList);
        arrayList2.addAll(list);
        HashSetInt hashSetInt = new HashSetInt();
        SubGraphIndices.addAtomIndices(hashSetInt, list);
        List<SubGraphIndices> list2 = this.getSmallRingsWithConnEndStanding(stereoMolecule2);
        arrayList2.addAll(list2);
        HashSetInt hashSetInt2 = new HashSetInt();
        SubGraphIndices.addAtomIndices(hashSetInt2, list2);
        hashSetInt.add(hashSetInt2.getValues());
        List<SubGraphIndices> list3 = this.getRemainingHeteroGroups(stereoMolecule2, hashSetInt);
        arrayList2.addAll(list3);
        SubGraphIndices.addAtomIndices(hashSetInt, list3);
        List<SubGraphIndices> list4 = this.getEndStandingAliphaticGroups(stereoMolecule2, arrayList, hashSetInt);
        arrayList2.addAll(list4);
        HashSetInt hashSetInt3 = new HashSetInt();
        SubGraphIndices.addAtomIndices(hashSetInt3, list4);
        List<SubGraphIndices> list5 = this.getAliphaticGroupsInLargeRings(stereoMolecule2, hashSetInt3);
        arrayList2.addAll(list5);
        SubGraphExtractor.mergeBridgedAliphaticRings(stereoMolecule2, arrayList2);
        this.splitLongHeteroGroups(stereoMolecule2, arrayList2);
        return arrayList2;
    }

    public List<SubGraphIndices> extractAliphaticRingsAndEndStandingAliphaticGroups(StereoMolecule stereoMolecule) {
        int n;
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(7);
        int n2 = stereoMolecule2.getAtoms();
        this.createRingAtomIndexMap(stereoMolecule2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n2; ++i) {
            int n3 = stereoMolecule2.getAllConnAtoms(i);
            n = 0;
            for (int j = 0; j < n3; ++j) {
                int n4 = stereoMolecule2.getConnAtom(i, j);
                int n5 = stereoMolecule2.getAtomicNo(n4);
                if (n5 <= 1) continue;
                ++n;
            }
            if (n != true) continue;
            arrayList.add(i);
        }
        HashSetInt hashSetInt = new HashSetInt();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            if (!ExtendedMoleculeFunctions.isHetero(stereoMolecule2, n)) continue;
            hashSetInt.add(n);
        }
        object = new ArrayList();
        List<SubGraphIndices> list = this.getSmallRingsWithConnEndStanding(stereoMolecule2);
        for (SubGraphIndices subGraphIndices : list) {
            int[] nArray = subGraphIndices.getAtomIndices();
            int n6 = 0;
            for (int n7 : nArray) {
                if (!stereoMolecule2.isAromaticAtom(n7)) continue;
                ++n6;
            }
            if (!((double)(n6 / nArray.length) < 0.5) || !SubGraphExtractor.containsOnlyCarbon(stereoMolecule2, subGraphIndices)) continue;
            object.add(subGraphIndices);
        }
        List<SubGraphIndices> list2 = this.getEndStandingAliphaticGroups(stereoMolecule2, arrayList, hashSetInt);
        object.addAll(list2);
        return object;
    }

    private void splitLongHeteroGroups(StereoMolecule stereoMolecule, List<SubGraphIndices> list) {
        int[][] nArray = ExtendedMoleculeFunctions.getTopologicalDistanceMatrix(stereoMolecule);
        for (int i = list.size() - 1; i >= 0; --i) {
            SubGraphIndices subGraphIndices = list.get(i);
            int[] nArray2 = subGraphIndices.getAtomIndices();
            MaximumTopologicalDist maximumTopologicalDist = SubGraphExtractor.getMaximumDistance(nArray, nArray2);
            if (maximumTopologicalDist.dist < 6) continue;
            list.remove(i);
            int[] nArray3 = new int[maximumTopologicalDist.dist + 1];
            stereoMolecule.getPath(nArray3, maximumTopologicalDist.at1, maximumTopologicalDist.at2, maximumTopologicalDist.dist + 1, null);
            boolean bl = false;
            for (int n2 : nArray3) {
                if (!stereoMolecule.isRingAtom(n2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            HashSetInt hashSetInt = new HashSetInt(nArray3);
            int n = nArray3.length;
            for (int j = 0; j < n; j += 3) {
                int n2;
                n2 = Math.min(3, n - j);
                int[] nArray4 = new int[n2];
                for (int k = 0; k < n2; ++k) {
                    int n3 = j + k;
                    nArray4[k] = nArray3[n3];
                }
                SubGraphIndices subGraphIndices2 = new SubGraphIndices();
                subGraphIndices2.addIndex(nArray4);
                SubGraphExtractor.addConnAtoms(stereoMolecule, subGraphIndices2, subGraphIndices, hashSetInt);
                list.add(subGraphIndices2);
            }
        }
    }

    private static void addConnAtoms(StereoMolecule stereoMolecule, SubGraphIndices subGraphIndices, SubGraphIndices subGraphIndices2, HashSetInt hashSetInt) {
        int[] nArray = subGraphIndices.getAtomIndices();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int n3 : nArray) {
            linkedList.add(n3);
        }
        while (!linkedList.isEmpty()) {
            int n = (Integer)linkedList.poll();
            int n2 = stereoMolecule.getConnAtoms(n);
            for (int i = 0; i < n2; ++i) {
                int n3;
                n3 = stereoMolecule.getConnAtom(n, i);
                if (hashSetInt.contains(n3) || subGraphIndices.contains(n3) || !subGraphIndices2.contains(n3)) continue;
                subGraphIndices.addIndex(n3);
                linkedList.add(n3);
            }
        }
    }

    private static MaximumTopologicalDist getMaximumDistance(int[][] nArray, int[] nArray2) {
        MaximumTopologicalDist maximumTopologicalDist = new MaximumTopologicalDist();
        for (int i = 0; i < nArray2.length; ++i) {
            for (int j = i + 1; j < nArray2.length; ++j) {
                int n = nArray[nArray2[i]][nArray2[j]];
                if (n <= maximumTopologicalDist.dist) continue;
                maximumTopologicalDist.dist = n;
                maximumTopologicalDist.at1 = nArray2[i];
                maximumTopologicalDist.at2 = nArray2[j];
            }
        }
        return maximumTopologicalDist;
    }

    private static void mergeBridgedAliphaticRings(StereoMolecule stereoMolecule, List<SubGraphIndices> list) {
        boolean bl = true;
        RingCollection ringCollection = stereoMolecule.getRingSet();
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < list.size(); ++i) {
                SubGraphIndices subGraphIndices = list.get(i);
                if (!SubGraphExtractor.containsOnlyCarbon(stereoMolecule, subGraphIndices)) continue;
                for (int j = i + 1; j < list.size(); ++j) {
                    int n;
                    SubGraphIndices subGraphIndices2 = list.get(j);
                    if (!SubGraphExtractor.containsOnlyCarbon(stereoMolecule, subGraphIndices2) || (n = SubGraphExtractor.getNumOverlappingRingIndices(stereoMolecule, ringCollection, subGraphIndices, subGraphIndices2)) < 3) continue;
                    subGraphIndices.merge(subGraphIndices2);
                    list.remove(j);
                    bl = true;
                    continue block0;
                }
            }
        }
    }

    private static int getNumOverlappingRingIndices(StereoMolecule stereoMolecule, RingCollection ringCollection, SubGraphIndices subGraphIndices, SubGraphIndices subGraphIndices2) {
        int n = 0;
        int n2 = ringCollection.getSize();
        for (int i = 0; i < n2; ++i) {
            int[] nArray = ringCollection.getRingAtoms(i);
            HashSetInt hashSetInt = new HashSetInt();
            for (int n3 : nArray) {
                if (!subGraphIndices.contains(n3)) continue;
                hashSetInt.add(n3);
            }
            int[] nArray2 = hashSetInt.getValues();
            for (int j = 0; j < n2; ++j) {
                int[] nArray3 = ringCollection.getRingAtoms(j);
                HashSetInt hashSetInt2 = new HashSetInt();
                for (int n4 : nArray3) {
                    if (!subGraphIndices2.contains(n4)) continue;
                    hashSetInt2.add(n4);
                }
                int n5 = 0;
                int[] nArray4 = nArray2;
                int n6 = nArray4.length;
                for (int n4 = 0; n4 < n6; ++n4) {
                    int n7 = nArray4[n4];
                    if (!hashSetInt2.contains(n7)) continue;
                    ++n5;
                }
                if (n5 <= n) continue;
                n = n5;
            }
        }
        return n;
    }

    private static boolean containsOnlyCarbon(StereoMolecule stereoMolecule, SubGraphIndices subGraphIndices) {
        int[] nArray;
        boolean bl = true;
        for (int n : nArray = subGraphIndices.getAtomIndices()) {
            if (stereoMolecule.getAtomicNo(n) == 6) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private List<SubGraphIndices> getRemainingHeteroGroups(StereoMolecule stereoMolecule, HashSetInt hashSetInt) {
        int[] nArray;
        ArrayList<SubGraphIndices> arrayList = new ArrayList<SubGraphIndices>();
        int n = stereoMolecule.getAtoms();
        boolean[] blArray = new boolean[n];
        for (int n2 : nArray = hashSetInt.getValues()) {
            blArray[n2] = true;
        }
        for (int i = 0; i < n; ++i) {
            if (blArray[i] || !ExtendedMoleculeFunctions.isHetero(stereoMolecule, i) || ExtendedMoleculeFunctions.isEtherOxygenAtAromatic(stereoMolecule, i)) continue;
            SubGraphIndices subGraphIndices = new SubGraphIndices();
            subGraphIndices.addIndex(i);
            arrayList.add(subGraphIndices);
        }
        for (SubGraphIndices subGraphIndices : arrayList) {
            int n2;
            int n3 = subGraphIndices.getAtomIndices()[0];
            n2 = stereoMolecule.getConnAtoms(n3);
            for (int i = 0; i < n2; ++i) {
                int n4 = stereoMolecule.getConnAtom(n3, i);
                if (blArray[n4]) continue;
                if (ExtendedMoleculeFunctions.isHetero(stereoMolecule, n4)) {
                    subGraphIndices.addIndex(n4);
                    continue;
                }
                if (stereoMolecule.getConnAtoms(n4) != 1) continue;
                subGraphIndices.addIndex(n4);
            }
        }
        SubGraphIndices.merge(arrayList);
        return arrayList;
    }

    private List<SubGraphIndices> getEndStandingAliphaticGroups(StereoMolecule stereoMolecule, List<Integer> list, HashSetInt hashSetInt) {
        ArrayList<SubGraphIndices> arrayList = new ArrayList<SubGraphIndices>();
        int n = stereoMolecule.getAtoms();
        boolean[] blArray = new boolean[n];
        int[] nArray = hashSetInt.getValues();
        for (int n2 : nArray) {
            blArray[n2] = true;
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            int n2;
            int n3 = (Integer)object.next();
            if (blArray[n3]) continue;
            if (ExtendedMoleculeFunctions.isHetero(stereoMolecule, n3)) {
                throw new RuntimeException("This should not happen.");
            }
            if (SubGraphExtractor.areAtomicNoConnectedInList(stereoMolecule, n3, this.hsAtomicNumberExcludeAliphatic)) continue;
            int n4 = stereoMolecule.getConnAtoms(n3);
            n2 = 1;
            for (int i = 0; i < n4; ++i) {
                int n5 = stereoMolecule.getConnAtom(n3, i);
                if (stereoMolecule.isRingAtom(n5)) {
                    n2 = 0;
                    break;
                }
                if (!SubGraphExtractor.areAtomicNoConnectedInList(stereoMolecule, n5, this.hsAtomicNumberExcludeAliphatic)) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            SubGraphIndices subGraphIndices = new SubGraphIndices();
            subGraphIndices.addIndex(n3);
            arrayList.add(subGraphIndices);
        }
        for (SubGraphIndices subGraphIndices : arrayList) {
            this.broadFirstForNonRingCarbon(stereoMolecule, subGraphIndices, hashSetInt, 1);
        }
        SubGraphIndices.merge(arrayList);
        return arrayList;
    }

    private static boolean areAtomicNoConnectedInList(StereoMolecule stereoMolecule, int n, HashSet<Integer> hashSet) {
        int n2 = stereoMolecule.getConnAtoms(n);
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            int n4 = stereoMolecule.getAtomicNo(n3);
            if (!hashSet.contains(n4)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void broadFirstForNonRingCarbon(StereoMolecule stereoMolecule, SubGraphIndices subGraphIndices, HashSetInt hashSetInt, int n) {
        int[] nArray;
        int n2 = stereoMolecule.getAtoms();
        boolean[] blArray = new boolean[n2];
        int[] nArray2 = hashSetInt.getValues();
        for (int n3 : nArray2) {
            blArray[n3] = true;
        }
        Object object = new LinkedList();
        int[] nArray3 = new int[n2];
        for (int n4 : nArray = subGraphIndices.getAtomIndices()) {
            ((LinkedList)object).add(n4);
            nArray3[n4] = 0;
        }
        while (!((AbstractCollection)object).isEmpty()) {
            int n5 = (Integer)((LinkedList)object).poll();
            if (nArray3[n5] > n) continue;
            subGraphIndices.addIndex(n5);
            int n6 = stereoMolecule.getConnAtoms(n5);
            for (int i = 0; i < n6; ++i) {
                int n4;
                n4 = stereoMolecule.getConnAtom(n5, i);
                if (blArray[n4] || this.arrAtomInSmallRing[n4] || stereoMolecule.getAtomicNo(n4) != 6) continue;
                ((LinkedList)object).add(n4);
                nArray3[n4] = nArray3[n5] + 1;
            }
        }
    }

    private SubGraphIndices largestAliphaticFragment(StereoMolecule stereoMolecule, int[] nArray, int n) {
        int n22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = stereoMolecule.getAtoms();
        boolean[] blArray = new boolean[n3];
        for (int object : nArray) {
            blArray[object] = true;
        }
        boolean[] blArray2 = new boolean[n3];
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n4 = 1;
        while (n4 != 0) {
            n4 = 0;
            linkedList.clear();
            for (int n22 : nArray) {
                if (blArray2[n22] || stereoMolecule.getAtomicNo(n22) != 6) continue;
                linkedList.add(n22);
                n4 = 1;
                break;
            }
            Object i = new SubGraphIndices();
            while (!linkedList.isEmpty()) {
                int n5 = (Integer)linkedList.poll();
                ((SubGraphIndices)i).addIndex(n5);
                blArray2[n5] = true;
                int n6 = stereoMolecule.getConnAtoms(n5);
                for (n22 = 0; n22 < n6; ++n22) {
                    int n7 = stereoMolecule.getConnAtom(n5, n22);
                    if (blArray2[n7] || !blArray[n7] || stereoMolecule.getAtomicNo(n7) != 6) continue;
                    linkedList.add(n7);
                }
            }
            arrayList.add(i);
        }
        for (int subGraphIndices = arrayList.size() - 1; subGraphIndices >= 0; --subGraphIndices) {
            SubGraphIndices subGraphIndices2 = (SubGraphIndices)arrayList.get(subGraphIndices);
            if (subGraphIndices2.getNumIndices() < n) {
                arrayList.remove(subGraphIndices);
                continue;
            }
            int[] nArray2 = subGraphIndices2.getAtomIndices();
            n22 = 0;
            block6: for (int n8 : nArray2) {
                int n9 = stereoMolecule.getConnAtoms(n8);
                for (int i = 0; i < n9; ++i) {
                    int n10 = stereoMolecule.getConnAtom(n8, i);
                    int n11 = stereoMolecule.getAtomicNo(n10);
                    if (n11 != 7 && n11 != 8 && n11 != 9) continue;
                    ++n22;
                    continue block6;
                }
            }
            if (nArray2.length - n22 >= n) continue;
            arrayList.remove(subGraphIndices);
        }
        SubGraphIndices subGraphIndices = null;
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, SubGraphIndices.getComparatorNumIndices());
            subGraphIndices = (SubGraphIndices)arrayList.get(arrayList.size() - 1);
        }
        return subGraphIndices;
    }

    private void createRingAtomIndexMap(StereoMolecule stereoMolecule) {
        RingCollection ringCollection = stereoMolecule.getRingSet();
        int n = ringCollection.getSize();
        this.arrAtomInSmallRing = new boolean[stereoMolecule.getAtoms()];
        this.arrAtomInLargeRing = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < n; ++i) {
            int n2 = ringCollection.getRingSize(i);
            int[] nArray = ringCollection.getRingAtoms(i);
            if (n2 <= 6) {
                for (int n3 : nArray) {
                    this.arrAtomInSmallRing[n3] = true;
                }
                continue;
            }
            for (int n3 : nArray) {
                this.arrAtomInLargeRing[n3] = true;
            }
        }
    }

    private boolean isSmallRingAtom(int n) {
        return this.arrAtomInSmallRing[n];
    }

    private List<SubGraphIndices> getSmallRingsWithConnEndStanding(StereoMolecule stereoMolecule) {
        Object object;
        ArrayList<SubGraphIndices> arrayList = new ArrayList<SubGraphIndices>();
        RingHelper ringHelper = new RingHelper(stereoMolecule);
        RingCollection ringCollection = ringHelper.getRingCollection();
        int n = ringCollection.getSize();
        for (int i = 0; i < n; ++i) {
            int[] object2;
            int n2 = ringCollection.getRingSize(i);
            if (n2 > 6 || ringHelper.isEnclosingRing(object2 = ringCollection.getRingAtoms(i))) continue;
            object = new SubGraphIndices();
            ((SubGraphIndices)object).addIndex(object2);
            arrayList.add((SubGraphIndices)object);
        }
        List<SubGraphIndices> list = SubGraphIndices.mergeOverlapping(arrayList, 3);
        for (SubGraphIndices subGraphIndices : list) {
            object = subGraphIndices.getAtomIndices();
            for (int n2 : object) {
                int n3 = stereoMolecule.getConnAtoms(n2);
                if (n3 < 3) continue;
                for (int i = 0; i < n3; ++i) {
                    int n4 = stereoMolecule.getConnAtom(n2, i);
                    int n5 = stereoMolecule.getConnAtoms(n4);
                    if (n5 != 1) continue;
                    subGraphIndices.addIndex(n4);
                }
            }
        }
        return list;
    }

    private List<SubGraphIndices> getAliphaticGroupsInLargeRings(StereoMolecule stereoMolecule, HashSetInt hashSetInt) {
        int n;
        Object object;
        int n2;
        int n3;
        ArrayList<SubGraphIndices> arrayList = new ArrayList<SubGraphIndices>();
        RingCollection ringCollection = stereoMolecule.getRingSet();
        int n4 = ringCollection.getSize();
        boolean[] blArray = SubGraphExtractor.getMapFromHashSetOfIndices(stereoMolecule, hashSetInt);
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = ringCollection.getRingSize(n3);
            if (n5 <= 6) continue;
            int[] nArray = ringCollection.getRingAtoms(n3);
            n2 = 0;
            object = nArray;
            int n6 = ((int[])object).length;
            for (n = 0; n < n6; ++n) {
                int n7 = object[n];
                if (!blArray[n7]) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0 || (object = (Object)this.largestAliphaticFragment(stereoMolecule, nArray, 3)) == null) continue;
            arrayList.add((SubGraphIndices)object);
        }
        block2: for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
            SubGraphIndices subGraphIndices = (SubGraphIndices)arrayList.get(n3);
            for (int i = 0; i < n4; ++i) {
                n2 = ringCollection.getRingSize(i);
                if (n2 > 6) continue;
                object = SubGraphExtractor.getMapFromArrayOfIndices(stereoMolecule, ringCollection.getRingAtoms(i));
                int[] nArray = subGraphIndices.getAtomIndices();
                n = 0;
                for (int n8 : nArray) {
                    if (object[n8] == 0) continue;
                    ++n;
                }
                if (n <= 2) continue;
                arrayList.remove(n3);
                continue block2;
            }
        }
        return arrayList;
    }

    private static boolean[] getMapFromHashSetOfIndices(StereoMolecule stereoMolecule, HashSetInt hashSetInt) {
        int[] nArray;
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int n : nArray = hashSetInt.getValues()) {
            blArray[n] = true;
        }
        return blArray;
    }

    private static boolean[] getMapFromArrayOfIndices(StereoMolecule stereoMolecule, int[] nArray) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int n : nArray) {
            blArray[n] = true;
        }
        return blArray;
    }

    private List<SubGraphIndices> getEndStandingHeteroGroups(StereoMolecule stereoMolecule, List<Integer> list) {
        int n;
        int n2;
        int n3;
        int n4;
        int n52;
        int n6;
        ArrayList<SubGraphIndices> arrayList = new ArrayList<SubGraphIndices>();
        for (int n7 : list) {
            int n8 = stereoMolecule.getAtomicNo(n7);
            int n9 = stereoMolecule.getConnAtom(n7, 0);
            if (this.isSmallRingAtom(n9) && n8 != 7 && n8 != 8 && n8 != 16 && n8 != 17 && n8 != 35 || !ExtendedMoleculeFunctions.isHetero(stereoMolecule, n7) && !ExtendedMoleculeFunctions.isHetero(stereoMolecule, n9)) continue;
            SubGraphIndices subGraphIndices = new SubGraphIndices();
            subGraphIndices.addIndex(n7);
            subGraphIndices.addIndex(n9);
            arrayList.add(subGraphIndices);
        }
        SubGraphIndices.merge(arrayList);
        for (SubGraphIndices subGraphIndices : arrayList) {
            int[] nArray;
            int[] nArray2 = nArray = subGraphIndices.getAtomIndices();
            int n10 = nArray2.length;
            for (n6 = 0; n6 < n10; ++n6) {
                n52 = nArray2[n6];
                n4 = stereoMolecule.getConnAtoms(n52);
                if (n4 <= 1) continue;
                n3 = ExtendedMoleculeFunctions.isHetero(stereoMolecule, n52);
                for (n2 = 0; n2 < n4; ++n2) {
                    n = stereoMolecule.getConnAtom(n52, n2);
                    if (subGraphIndices.contains(n)) continue;
                    boolean bl = ExtendedMoleculeFunctions.isHetero(stereoMolecule, n);
                    if (this.isSmallRingAtom(n) || n3 == 0 && !bl) continue;
                    subGraphIndices.addIndex(n);
                }
            }
        }
        SubGraphIndices.merge(arrayList);
        for (SubGraphIndices subGraphIndices : arrayList) {
            int[] nArray;
            int[] nArray3 = nArray = subGraphIndices.getAtomIndices();
            int n11 = nArray3.length;
            for (n6 = 0; n6 < n11; ++n6) {
                n52 = nArray3[n6];
                n4 = stereoMolecule.getConnAtoms(n52);
                if (n4 <= 1) continue;
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = stereoMolecule.getConnAtom(n52, n3);
                    if (stereoMolecule.isRingAtom(n2) || subGraphIndices.contains(n2) || !ExtendedMoleculeFunctions.isHetero(stereoMolecule, n2)) continue;
                    subGraphIndices.addIndex(n2);
                }
            }
        }
        SubGraphIndices.merge(arrayList);
        for (SubGraphIndices subGraphIndices : arrayList) {
            int[] nArray;
            for (int n52 : nArray = subGraphIndices.getAtomIndices()) {
                n4 = stereoMolecule.getConnAtoms(n52);
                if (n4 == 1) continue;
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = stereoMolecule.getConnAtom(n52, n3);
                    if (subGraphIndices.contains(n2)) continue;
                    int n12 = n = stereoMolecule.getConnAtoms(n2) == 1 ? 1 : 0;
                    if (n == 0) continue;
                    subGraphIndices.addIndex(n2);
                    if (stereoMolecule.getAtomicNo(n2) == 6) continue;
                    throw new RuntimeException("This should not happen!");
                }
            }
        }
        return arrayList;
    }

    private static class MaximumTopologicalDist {
        int at1;
        int at2;
        int dist;

        private MaximumTopologicalDist() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.at1);
            stringBuilder.append(" ");
            stringBuilder.append(this.at2);
            stringBuilder.append(" ");
            stringBuilder.append(this.dist);
            return stringBuilder.toString();
        }
    }
}

