/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.completegraphmatcher;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.graph.MinimumSpanningTree;
import com.actelion.research.chem.descriptor.flexophore.DistHist;
import com.actelion.research.chem.descriptor.flexophore.IMolDistHist;
import com.actelion.research.chem.descriptor.flexophore.IPPNode;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import com.actelion.research.chem.descriptor.flexophore.SlidingWindowDistHist;
import com.actelion.research.chem.descriptor.flexophore.completegraphmatcher.HistogramMatchCalculator;
import com.actelion.research.chem.descriptor.flexophore.completegraphmatcher.PPNodeSimilarity;
import com.actelion.research.chem.descriptor.flexophore.generator.ConstantsFlexophoreGenerator;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.graph.complete.IObjectiveCompleteGraph;
import com.actelion.research.util.graph.complete.SolutionCompleteGraph;
import java.util.Arrays;
import java.util.List;

public class ObjectiveBlurFlexophoreHardMatchUncovered
implements IObjectiveCompleteGraph<IMolDistHist> {
    public static final String VERSION = "07.09.2022";
    public static final String INFO = "";
    public static final double THRESH_HISTOGRAM_SIMILARITY = 0.15;
    public static final double THRESH_HISTOGRAM_SIMILARITY_OPTIMISTIC = 1.0E-7;
    static final double THRESH_NODE_SIMILARITY_START = 0.5;
    private static final float INIT_VAL = -1.0f;
    private boolean modeQuery;
    private int marginQuery;
    private MolDistHistViz mdhvBase;
    private MolDistHistViz mdhvBaseBlurredHist;
    private MolDistHistViz mdhvQuery;
    private MolDistHistViz mdhvQueryBlurredHist;
    private int nodesBase;
    private int nodesQuery;
    private byte[] arrTmpHist = new byte[80];
    private boolean validHelpersQuery;
    private boolean validHelpersBase;
    private boolean resetSimilarityArrays;
    private double threshNodeMinSimilarityStart;
    private double threshHistogramSimilarity;
    private PPNodeSimilarity nodeSimilarity;
    private boolean optimisticHistogramSimilarity;
    private boolean excludeHistogramSimilarity;
    private boolean fragmentNodesMapping;
    boolean verbose;
    private float[][] arrSimilarityNodes;
    private float[][] arrSimilarityHistograms;
    private double[][] arrRelativeDistanceMatrixQuery;
    private double[][] arrRelativeDistanceMatrixBase;
    private Matrix maHelperAdjacencyQuery;
    private Matrix maHelperAdjacencyBase;
    private double sumDistanceMinSpanTreeQuery;
    private double sumDistanceMinSpanTreeBase;
    private int numInevitablePPPoints;
    private double avrPairwiseMappingScaled;
    private double coverageQuery;
    private double coverageBase;
    private double similarity;
    private long deltaNanoQueryBlur;
    private long deltaNanoBaseBlur;
    private long deltaNanoSimilarity;
    private SlidingWindowDistHist slidingWindowDistHist;

    public ObjectiveBlurFlexophoreHardMatchUncovered() {
        this(-1, 1, 0.9, 0.15);
    }

    public ObjectiveBlurFlexophoreHardMatchUncovered(int n, int n2, double d, double d2) {
        this.nodeSimilarity = new PPNodeSimilarity(n, n2);
        this.nodeSimilarity.setThreshSimilarityHardMatch(d);
        this.threshHistogramSimilarity = d2;
        this.threshNodeMinSimilarityStart = 0.5;
        this.slidingWindowDistHist = new SlidingWindowDistHist(ConstantsFlexophoreGenerator.FILTER);
        this.modeQuery = false;
        this.deltaNanoQueryBlur = 0L;
        this.deltaNanoBaseBlur = 0L;
        this.deltaNanoSimilarity = 0L;
        this.setFragmentNodesMapping(false);
        this.setOptimisticHistogramSimilarity(false);
        this.marginQuery = 0;
        this.excludeHistogramSimilarity = false;
        this.initSimilarityMatrices();
    }

    public void setFragmentNodesMapping(boolean bl) {
        this.fragmentNodesMapping = bl;
    }

    public void setMarginQuery(int n) {
        this.marginQuery = n;
    }

    public void setOptimisticHistogramSimilarity(boolean bl) {
        this.optimisticHistogramSimilarity = bl;
        if (bl) {
            this.threshHistogramSimilarity = 1.0E-7;
        }
    }

    public void setExcludeHistogramSimilarity(boolean bl) {
        this.excludeHistogramSimilarity = bl;
    }

    private void initSimilarityMatrices() {
        int n;
        this.arrSimilarityNodes = new float[64][];
        for (n = 0; n < 64; ++n) {
            this.arrSimilarityNodes[n] = new float[64];
            Arrays.fill(this.arrSimilarityNodes[n], -1.0f);
        }
        n = 2016;
        this.arrSimilarityHistograms = new float[n][];
        for (int i = 0; i < n; ++i) {
            this.arrSimilarityHistograms[i] = new float[n];
            Arrays.fill(this.arrSimilarityHistograms[i], -1.0f);
        }
    }

    public void setModeQuery(boolean bl) {
        this.modeQuery = bl;
    }

    public boolean isModeQuery() {
        return this.modeQuery;
    }

    public String toStringParameter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ObjectiveFlexophoreHardMatchUncovered Thresh histogram similarity ");
        stringBuilder.append(this.threshHistogramSimilarity);
        stringBuilder.append(", thresh node similarity start " + this.threshNodeMinSimilarityStart);
        stringBuilder.append(", ");
        stringBuilder.append(this.nodeSimilarity.toStringParameter());
        return stringBuilder.toString();
    }

    private void resetSimilarityMatrices() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.nodesQuery; ++n2) {
            for (n = 0; n < this.nodesBase; ++n) {
                this.arrSimilarityNodes[n2][n] = -1.0f;
            }
        }
        n2 = (this.nodesQuery * this.nodesQuery - this.nodesQuery) / 2;
        n = (this.nodesBase * this.nodesBase - this.nodesBase) / 2;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.arrSimilarityHistograms[i][j] = -1.0f;
            }
        }
        this.resetSimilarityArrays = false;
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = bl;
        this.nodeSimilarity.setVerbose(bl);
    }

    @Override
    public boolean isValidSolution(SolutionCompleteGraph solutionCompleteGraph) {
        byte by;
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = true;
        if (!this.validHelpersQuery) {
            this.calculateHelpersQuery();
        }
        if (!this.validHelpersBase) {
            this.calculateHelpersBase();
        }
        if (this.resetSimilarityArrays) {
            this.resetSimilarityMatrices();
        }
        int n5 = solutionCompleteGraph.getSizeHeap();
        if (this.numInevitablePPPoints > 0) {
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = solutionCompleteGraph.getIndexQueryFromHeap(n3);
                if (!this.mdhvQueryBlurredHist.isInevitablePharmacophorePoint(n2)) continue;
                ++n4;
            }
            n3 = Math.min(n5, this.numInevitablePPPoints);
            if (n4 < n3) {
                bl = false;
            }
        }
        if (!this.fragmentNodesMapping && bl) {
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                PPNodeViz pPNodeViz;
                n = solutionCompleteGraph.getIndexQueryFromHeap(n2);
                PPNodeViz pPNodeViz2 = this.mdhvQueryBlurredHist.getNode(n);
                if (pPNodeViz2.hasHeteroAtom()) {
                    n4 = 1;
                }
                if ((pPNodeViz = this.mdhvBaseBlurredHist.getNode(by = solutionCompleteGraph.getIndexCorrespondingBaseNode(n))).hasHeteroAtom()) {
                    n3 = 1;
                }
                if (n4 != 0 && n3 != 0) break;
            }
            if (n4 == 0 || n3 == 0) {
                bl = false;
            }
        }
        if (bl) {
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = solutionCompleteGraph.getIndexQueryFromHeap(n4);
                if (this.areNodesMapping(n3, n2 = solutionCompleteGraph.getIndexCorrespondingBaseNode(n3))) continue;
                bl = false;
                break;
            }
        }
        if (bl && !this.excludeHistogramSimilarity) {
            block3: for (n4 = 0; n4 < n5; ++n4) {
                n3 = solutionCompleteGraph.getIndexQueryFromHeap(n4);
                n2 = solutionCompleteGraph.getIndexCorrespondingBaseNode(n3);
                for (n = n4 + 1; n < n5; ++n) {
                    byte by2 = solutionCompleteGraph.getIndexQueryFromHeap(n);
                    if (this.areHistogramsMapping(n3, by2, n2, by = solutionCompleteGraph.getIndexCorrespondingBaseNode(by2))) continue;
                    bl = false;
                    break block3;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean areNodesMapping(int n, int n2) {
        if (!this.validHelpersQuery) {
            this.calculateHelpersQuery();
        }
        if (!this.validHelpersBase) {
            this.calculateHelpersBase();
        }
        if (this.resetSimilarityArrays) {
            this.resetSimilarityMatrices();
        }
        boolean bl = true;
        double d = this.getSimilarityNodes(n, n2);
        PPNodeViz pPNodeViz = this.mdhvBaseBlurredHist.getNode(n2);
        PPNodeViz pPNodeViz2 = this.mdhvQueryBlurredHist.getNode(n);
        int n3 = pPNodeViz.getInteractionTypeCount();
        int n4 = pPNodeViz2.getInteractionTypeCount();
        double d2 = 0.0;
        d2 = n3 > n4 ? Math.pow(this.threshNodeMinSimilarityStart, n3) : Math.pow(this.threshNodeMinSimilarityStart, n4);
        if (d < d2) {
            bl = false;
        }
        return bl;
    }

    private boolean areHistogramsMapping(int n, int n2, int n3, int n4) {
        boolean bl = true;
        double d = this.getSimilarityHistogram(n, n2, n3, n4);
        if (d < this.threshHistogramSimilarity) {
            bl = false;
        }
        return bl;
    }

    @Override
    public float getSimilarity(SolutionCompleteGraph solutionCompleteGraph) {
        double d;
        long l = System.nanoTime();
        if (!this.validHelpersQuery) {
            this.calculateHelpersQuery();
        }
        if (!this.validHelpersBase) {
            this.calculateHelpersBase();
        }
        if (this.resetSimilarityArrays) {
            this.resetSimilarityMatrices();
        }
        int n = solutionCompleteGraph.getSizeHeap();
        if (this.modeQuery && this.nodesQuery != n) {
            this.similarity = 0.0;
            return (float)this.similarity;
        }
        if (this.fragmentNodesMapping && n == 1) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(0);
            byte by2 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by);
            this.similarity = this.getSimilarityNodes(by, by2);
            return (float)this.similarity;
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(i);
            byte by3 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by);
            for (int j = i + 1; j < n; ++j) {
                byte by4 = solutionCompleteGraph.getIndexQueryFromHeap(j);
                byte by5 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by4);
                d = this.getScorePairwiseMapping(by, by4, by3, by5);
                d2 += d;
                if (!this.verbose) continue;
                System.out.println("scorePairwiseMapping " + Formatter.format2(d));
            }
        }
        double d3 = (double)(n * n - n) / 2.0;
        this.avrPairwiseMappingScaled = d2 / d3;
        this.coverageQuery = this.getRatioMinimumSpanningTreeQuery(solutionCompleteGraph);
        this.coverageBase = this.getRatioMinimumSpanningTreeBase(solutionCompleteGraph);
        double d4 = this.coverageQuery * this.coverageBase;
        double d5 = (double)Math.min(this.nodesQuery, n) / (double)Math.max(this.nodesQuery, n);
        d = (double)Math.min(n, this.nodesBase) / (double)Math.max(n, this.nodesBase);
        this.similarity = this.modeQuery ? this.avrPairwiseMappingScaled * this.coverageQuery * this.coverageQuery * d5 * d5 : this.avrPairwiseMappingScaled * d4 * d5 * d;
        if (this.verbose) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ObjectiveFlexophoreHardMatchUncovered");
            stringBuilder.append(" similarity");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(this.similarity));
            stringBuilder.append("\t");
            stringBuilder.append("avrPairwiseMappingScaled");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(this.avrPairwiseMappingScaled));
            stringBuilder.append("\t");
            stringBuilder.append("coverage");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(d4));
            stringBuilder.append("\t");
            stringBuilder.append("ratioNodesMatchQuery");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(d5));
            stringBuilder.append("\t");
            stringBuilder.append("ratioNodesMatchBase");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(d));
            System.out.println(stringBuilder.toString());
        }
        this.deltaNanoSimilarity += System.nanoTime() - l;
        return (float)this.similarity;
    }

    @Override
    public float getSimilarityNodes(SolutionCompleteGraph solutionCompleteGraph) {
        long l = System.nanoTime();
        if (this.resetSimilarityArrays) {
            this.resetSimilarityMatrices();
        }
        int n = solutionCompleteGraph.getSizeHeap();
        if (this.modeQuery && Math.abs(this.nodesQuery - n) > this.marginQuery) {
            this.similarity = 0.0;
            return (float)this.similarity;
        }
        if (this.fragmentNodesMapping && n == 1) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(0);
            byte by2 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by);
            this.similarity = this.getSimilarityNodes(by, by2);
            return (float)this.similarity;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(i);
            byte by3 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by);
            double d2 = this.getSimilarityNodes(by, by3);
            d += d2;
        }
        double d3 = n;
        this.avrPairwiseMappingScaled = d / d3;
        this.coverageQuery = 0.0;
        this.coverageBase = 0.0;
        double d4 = (double)Math.min(this.nodesQuery, n) / (double)Math.max(this.nodesQuery, n);
        double d5 = (double)Math.min(n, this.nodesBase) / (double)Math.max(n, this.nodesBase);
        this.similarity = this.modeQuery ? this.avrPairwiseMappingScaled * d4 * d4 : this.avrPairwiseMappingScaled * d4 * d5;
        if (this.verbose) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ObjectiveFlexophoreHardMatchUncovered");
            stringBuilder.append(" similarity nodes");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(this.similarity));
            stringBuilder.append("\t");
            stringBuilder.append("avrPairwiseMappingScaled");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(this.avrPairwiseMappingScaled));
            stringBuilder.append("\t");
            stringBuilder.append("ratioNodesMatchQuery");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(d4));
            stringBuilder.append("\t");
            stringBuilder.append("ratioNodesMatchBase");
            stringBuilder.append("\t");
            stringBuilder.append(Formatter.format2(d5));
            System.out.println(stringBuilder.toString());
        }
        this.deltaNanoSimilarity += System.nanoTime() - l;
        return (float)this.similarity;
    }

    public float getSimilarityHistogramsForNode(SolutionCompleteGraph solutionCompleteGraph, int n) {
        int n2 = solutionCompleteGraph.getSizeHeap();
        if (this.modeQuery && this.nodesQuery != n2) {
            return 0.0f;
        }
        double d = 0.0;
        byte by = solutionCompleteGraph.getIndexQueryFromHeap(n);
        byte by2 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by);
        for (int i = 0; i < n2; ++i) {
            if (n == i) continue;
            byte by3 = solutionCompleteGraph.getIndexQueryFromHeap(i);
            byte by4 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by3);
            double d2 = this.getSimilarityHistogram(by, by3, by2, by4);
            d += d2;
            if (!this.verbose) continue;
            System.out.println("scorePairwiseMapping " + Formatter.format2(d2));
        }
        double d3 = n2 - 1;
        double d4 = d / d3;
        return (float)d4;
    }

    public long getDeltaNanoQueryBlur() {
        return this.deltaNanoQueryBlur;
    }

    public long getDeltaNanoBaseBlur() {
        return this.deltaNanoBaseBlur;
    }

    public long getDeltaNanoSimilarity() {
        return this.deltaNanoSimilarity;
    }

    @Override
    public void setMatchingInfoInQueryAndBase(SolutionCompleteGraph solutionCompleteGraph) {
        this.mdhvQuery.resetInfoColor();
        this.mdhvBase.resetInfoColor();
        int n = solutionCompleteGraph.getSizeHeap();
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(i);
            byte by2 = solutionCompleteGraph.getIndexCorrespondingBaseNode(by);
            double d = this.getSimilarityNodes(by, by2);
            this.mdhvQuery.setSimilarityMappingNodes(by, (float)d);
            this.mdhvQuery.setMappingIndex(by, i);
            this.mdhvBase.setMappingIndex(by2, i);
            this.mdhvBase.setSimilarityMappingNodes(by2, (float)d);
        }
    }

    @Override
    public boolean isModeFragment() {
        return this.fragmentNodesMapping;
    }

    @Override
    public IMolDistHist getBase() {
        return this.mdhvBase;
    }

    @Override
    public IMolDistHist getQuery() {
        return this.mdhvQuery;
    }

    @Override
    public void setBase(IMolDistHist iMolDistHist) {
        if (iMolDistHist.getNumPPNodes() >= 64) {
            throw new RuntimeException("Number of base pharmacophore nodes (" + iMolDistHist.getNumPPNodes() + ") exceeds limit of " + 64 + ".");
        }
        long l = System.nanoTime();
        if (iMolDistHist instanceof MolDistHistViz) {
            this.mdhvBase = (MolDistHistViz)iMolDistHist;
            this.mdhvBaseBlurredHist = new MolDistHistViz((MolDistHistViz)iMolDistHist);
        } else if (iMolDistHist instanceof MolDistHist) {
            this.mdhvBase = new MolDistHistViz((MolDistHist)iMolDistHist);
            this.mdhvBaseBlurredHist = new MolDistHistViz((MolDistHist)iMolDistHist);
        }
        if (!this.fragmentNodesMapping) {
            this.slidingWindowDistHist.apply(this.mdhvBaseBlurredHist);
        }
        this.nodesBase = iMolDistHist.getNumPPNodes();
        this.validHelpersBase = false;
        this.resetSimilarityArrays = true;
        if (!this.checkAtomTypes(this.mdhvBase)) {
            throw new RuntimeException("Base contains Invalid atom type for similarity calculation " + this.mdhvBase.getMolDistHist().toString() + ".");
        }
        this.deltaNanoBaseBlur += System.nanoTime() - l;
    }

    @Override
    public void setQuery(IMolDistHist iMolDistHist) {
        if (iMolDistHist.getNumPPNodes() >= 64) {
            throw new RuntimeException("Number of query pharmacophore nodes (" + iMolDistHist.getNumPPNodes() + ") exceeds limit of " + 64 + ".");
        }
        long l = System.nanoTime();
        if (iMolDistHist instanceof MolDistHistViz) {
            this.mdhvQuery = (MolDistHistViz)iMolDistHist;
            this.mdhvQueryBlurredHist = new MolDistHistViz((MolDistHistViz)iMolDistHist);
        } else if (iMolDistHist instanceof MolDistHist) {
            this.mdhvQuery = new MolDistHistViz((MolDistHist)iMolDistHist);
            this.mdhvQueryBlurredHist = new MolDistHistViz((MolDistHist)iMolDistHist);
        }
        if (!this.fragmentNodesMapping) {
            this.slidingWindowDistHist.apply(this.mdhvQueryBlurredHist);
        }
        this.nodesQuery = iMolDistHist.getNumPPNodes();
        this.numInevitablePPPoints = iMolDistHist.getNumInevitablePharmacophorePoints();
        this.validHelpersQuery = false;
        this.resetSimilarityArrays = true;
        if (!this.checkAtomTypes(this.mdhvQuery)) {
            throw new RuntimeException("Base contains Invalid atom type for similarity calculation " + this.mdhvQuery.getMolDistHist().toString() + ".");
        }
        this.deltaNanoQueryBlur += System.nanoTime() - l;
    }

    private boolean checkAtomTypes(MolDistHistViz molDistHistViz) {
        boolean bl = true;
        List<PPNodeViz> list = molDistHistViz.getNodes();
        block0: for (PPNodeViz pPNodeViz : list) {
            int n = pPNodeViz.getInteractionTypeCount();
            for (int i = 0; i < n; ++i) {
                int n2 = pPNodeViz.getInteractionType(i);
                if (this.nodeSimilarity.isValidType(n2)) continue;
                bl = false;
                break block0;
            }
        }
        return bl;
    }

    private void calculateHelpersQuery() {
        this.arrRelativeDistanceMatrixQuery = this.calculateRelativeDistanceMatrix(this.mdhvQueryBlurredHist);
        this.maHelperAdjacencyQuery = new Matrix(this.arrRelativeDistanceMatrixQuery);
        MinimumSpanningTree minimumSpanningTree = new MinimumSpanningTree(this.maHelperAdjacencyQuery);
        Matrix matrix = minimumSpanningTree.getMST();
        this.sumDistanceMinSpanTreeQuery = matrix.getSumUpperTriangle();
        this.validHelpersQuery = true;
    }

    private void calculateHelpersBase() {
        this.arrRelativeDistanceMatrixBase = this.calculateRelativeDistanceMatrix(this.mdhvBaseBlurredHist);
        this.maHelperAdjacencyBase = new Matrix(this.arrRelativeDistanceMatrixBase);
        MinimumSpanningTree minimumSpanningTree = new MinimumSpanningTree(this.maHelperAdjacencyBase);
        Matrix matrix = minimumSpanningTree.getMST();
        this.sumDistanceMinSpanTreeBase = matrix.getSumUpperTriangle();
        this.validHelpersBase = true;
    }

    private double getRatioMinimumSpanningTreeQuery(SolutionCompleteGraph solutionCompleteGraph) {
        double d = 0.0;
        int n = solutionCompleteGraph.getSizeHeap();
        this.maHelperAdjacencyQuery.set(Double.NaN);
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(i);
            for (int j = i + 1; j < n; ++j) {
                byte by2 = solutionCompleteGraph.getIndexQueryFromHeap(j);
                this.maHelperAdjacencyQuery.set(by, by2, this.arrRelativeDistanceMatrixQuery[by][by2]);
                this.maHelperAdjacencyQuery.set(by2, by, this.arrRelativeDistanceMatrixQuery[by][by2]);
            }
        }
        MinimumSpanningTree minimumSpanningTree = new MinimumSpanningTree(this.maHelperAdjacencyQuery);
        Matrix matrix = minimumSpanningTree.getMST();
        double d2 = matrix.getSumUpperTriangle();
        double d3 = d2 * d2;
        double d4 = this.sumDistanceMinSpanTreeQuery * this.sumDistanceMinSpanTreeQuery;
        d = Math.min(d3, d4) / Math.max(d3, d4);
        return d;
    }

    private double getRatioMinimumSpanningTreeBase(SolutionCompleteGraph solutionCompleteGraph) {
        double d = 0.0;
        int n = solutionCompleteGraph.getSizeHeap();
        this.maHelperAdjacencyBase.set(Double.NaN);
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexBaseFromHeap(i);
            for (int j = i + 1; j < n; ++j) {
                byte by2 = solutionCompleteGraph.getIndexBaseFromHeap(j);
                this.maHelperAdjacencyBase.set(by, by2, this.arrRelativeDistanceMatrixBase[by][by2]);
                this.maHelperAdjacencyBase.set(by2, by, this.arrRelativeDistanceMatrixBase[by][by2]);
            }
        }
        MinimumSpanningTree minimumSpanningTree = new MinimumSpanningTree(this.maHelperAdjacencyBase);
        Matrix matrix = minimumSpanningTree.getMST();
        double d2 = matrix.getSumUpperTriangle();
        double d3 = d2 * d2;
        double d4 = this.sumDistanceMinSpanTreeBase * this.sumDistanceMinSpanTreeBase;
        d = Math.min(d3, d4) / Math.max(d3, d4);
        return d;
    }

    private double[][] calculateRelativeDistanceMatrix(IMolDistHist iMolDistHist) {
        int n;
        int n2;
        int n3 = iMolDistHist.getNumPPNodes();
        double[][] dArray = new double[n3][n3];
        int n4 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = n2 + 1; n < dArray.length; ++n) {
                int n5 = this.getCenterOfGravityDistanceBin(iMolDistHist, n2, n);
                dArray[n2][n] = n5;
                dArray[n][n2] = n5;
                if (n5 <= n4) continue;
                n4 = n5;
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = n2 + 1; n < dArray.length; ++n) {
                dArray[n2][n] = dArray[n2][n] / (double)n4;
                dArray[n][n2] = dArray[n][n2] / (double)n4;
            }
        }
        return dArray;
    }

    private int getCenterOfGravityDistanceBin(IMolDistHist iMolDistHist, int n, int n2) {
        byte[] byArray = iMolDistHist.getDistHist(n, n2, this.arrTmpHist);
        double d = 0.0;
        for (int i = 0; i < byArray.length; ++i) {
            d += (double)byArray[i];
        }
        double d2 = d / 2.0;
        d = 0.0;
        int n3 = -1;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (!((d += (double)byArray[i]) >= d2)) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private double getScorePairwiseMapping(int n, int n2, int n3, int n4) {
        double d = 0.0;
        double d2 = this.getSimilarityNodes(n, n3);
        double d3 = this.getSimilarityNodes(n2, n4);
        double d4 = this.getSimilarityHistogram(n, n2, n3, n4);
        if (this.optimisticHistogramSimilarity && d4 > 0.0) {
            d4 = 1.0;
        }
        if (this.verbose) {
            System.out.println("simHists " + Formatter.format2(d4));
        }
        d = d2 * d2 * d3 * d3 * d4 * d4;
        return d;
    }

    @Override
    public double getSimilarityNodes(int n, int n2) {
        if (this.arrSimilarityNodes[n][n2] < 0.0f || this.verbose) {
            float f;
            this.arrSimilarityNodes[n][n2] = f = (float)this.nodeSimilarity.getSimilarity(this.mdhvQueryBlurredHist.getNode(n), this.mdhvBaseBlurredHist.getNode(n2));
        }
        return this.arrSimilarityNodes[n][n2];
    }

    @Override
    public float getSimilarityHistogram(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = DistHist.getIndex(n, n2, this.nodesQuery);
        if (this.arrSimilarityHistograms[n6][n5 = DistHist.getIndex(n3, n4, this.nodesBase)] < 0.0f) {
            float f;
            this.arrSimilarityHistograms[n6][n5] = f = (float)HistogramMatchCalculator.getSimilarity(this.mdhvQueryBlurredHist, n, n2, this.mdhvBaseBlurredHist, n3, n4);
        }
        return this.arrSimilarityHistograms[n6][n5];
    }

    @Override
    public double getSimilarityNodes(IPPNode iPPNode, IPPNode iPPNode2) {
        return this.nodeSimilarity.getSimilarity(iPPNode, iPPNode2);
    }

    public String toStringRecentSimilarityResults() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ObjectiveFlexophoreHardMatchUncovered toStringRecentSimilarityResults()");
        stringBuilder.append("avr pairwise mapping " + Formatter.format3(this.avrPairwiseMappingScaled) + "\n");
        stringBuilder.append("coverage query " + Formatter.format3(this.coverageQuery) + "\n");
        stringBuilder.append("coverage base " + Formatter.format3(this.coverageBase) + "\n");
        stringBuilder.append("similarity " + Formatter.format3(this.similarity));
        return stringBuilder.toString();
    }

    public String toString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        Matrix matrix = new Matrix(this.arrSimilarityNodes);
        int n3 = -1;
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            if (!(matrix.get(n2, 0) < 0.0)) continue;
            n3 = n2;
            break;
        }
        n2 = -1;
        for (n = 0; n < matrix.cols(); ++n) {
            if (!(matrix.get(0, n) < 0.0)) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(Formatter.format2(matrix.get(n, i)));
                stringBuilder.append("  ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

