/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore.calculator;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;

public class GeometryCalculator {
    public static final Coordinates getCoordinates(Molecule molecule, int n) {
        return new Coordinates(molecule.getAtomX(n), molecule.getAtomY(n), molecule.getAtomZ(n));
    }

    public static final double getAngle(Molecule3D molecule3D, int n, int n2, int n3) {
        Coordinates coordinates = molecule3D.getCoordinates(n);
        Coordinates coordinates2 = molecule3D.getCoordinates(n2);
        Coordinates coordinates3 = molecule3D.getCoordinates(n3);
        return coordinates.subC(coordinates2).getAngle(coordinates3.subC(coordinates2));
    }

    public static final double getAngle(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3) {
        return coordinates.subC(coordinates2).getAngle(coordinates3.subC(coordinates2));
    }

    public static final double getAngle(Molecule molecule, int n, int n2, int n3) {
        Coordinates coordinates = GeometryCalculator.getCoordinates(molecule, n);
        Coordinates coordinates2 = GeometryCalculator.getCoordinates(molecule, n2);
        Coordinates coordinates3 = GeometryCalculator.getCoordinates(molecule, n3);
        return coordinates.subC(coordinates2).getAngle(coordinates3.subC(coordinates2));
    }

    public static final double getDihedral(Molecule3D molecule3D, int n, int n2, int n3, int n4) {
        Coordinates coordinates = molecule3D.getCoordinates(n);
        Coordinates coordinates2 = molecule3D.getCoordinates(n2);
        Coordinates coordinates3 = molecule3D.getCoordinates(n3);
        Coordinates coordinates4 = molecule3D.getCoordinates(n4);
        return coordinates.getDihedral(coordinates2, coordinates3, coordinates4);
    }

    public static final Coordinates getCenterGravity(Molecule3D molecule3D) {
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            coordinates.x += molecule3D.getAtomX(i);
            coordinates.y += molecule3D.getAtomY(i);
            coordinates.z += molecule3D.getAtomZ(i);
        }
        coordinates.x /= (double)molecule3D.getAllAtoms();
        coordinates.y /= (double)molecule3D.getAllAtoms();
        coordinates.z /= (double)molecule3D.getAllAtoms();
        return coordinates;
    }

    public static final Coordinates[] getBounds(Molecule3D molecule3D) {
        if (molecule3D.getAllAtoms() == 0) {
            return new Coordinates[]{new Coordinates(0.0, 0.0, 0.0), new Coordinates(0.0, 0.0, 0.0)};
        }
        Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38), new Coordinates(-3.4028234663852886E38, -3.4028234663852886E38, -3.4028234663852886E38)};
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            coordinatesArray[0].x = Math.min(coordinatesArray[0].x, molecule3D.getAtomX(i));
            coordinatesArray[0].y = Math.min(coordinatesArray[0].y, molecule3D.getAtomY(i));
            coordinatesArray[0].z = Math.min(coordinatesArray[0].z, molecule3D.getAtomZ(i));
            coordinatesArray[1].x = Math.max(coordinatesArray[1].x, molecule3D.getAtomX(i));
            coordinatesArray[1].y = Math.max(coordinatesArray[1].y, molecule3D.getAtomY(i));
            coordinatesArray[1].z = Math.max(coordinatesArray[1].z, molecule3D.getAtomZ(i));
        }
        return coordinatesArray;
    }

    public static final void translate(Molecule3D molecule3D, Coordinates coordinates) {
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            molecule3D.setAtomX(i, molecule3D.getAtomX(i) + coordinates.x);
            molecule3D.setAtomY(i, molecule3D.getAtomY(i) + coordinates.y);
            molecule3D.setAtomZ(i, molecule3D.getAtomZ(i) + coordinates.z);
        }
    }
}

