/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.ISimilarityCalculator;
import com.actelion.research.chem.descriptor.SimilarityCalculatorInfo;

public class DescriptorHelper
implements DescriptorConstants {
    public static final String TAG_SIMILARITY = "Similarity";

    public static int getDescriptorType(String string) {
        DescriptorInfo descriptorInfo = DescriptorHelper.getDescriptorInfo(DescriptorHelper.unifyShortName(string));
        return descriptorInfo == null ? -1 : descriptorInfo.type;
    }

    public static DescriptorInfo getDescriptorInfo(String string) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName.equals(DescriptorHelper.unifyShortName(string))) continue;
            return DESCRIPTOR_EXTENDED_LIST[i];
        }
        return null;
    }

    public static boolean isBinaryFingerprint(String string) {
        DescriptorInfo descriptorInfo = DescriptorHelper.getDescriptorInfo(DescriptorHelper.unifyShortName(string));
        return descriptorInfo == null ? false : descriptorInfo.isBinary;
    }

    public static boolean isDescriptorShortName(String string) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName.equals(DescriptorHelper.unifyShortName(string))) continue;
            return true;
        }
        return false;
    }

    public static String shortNameToName(String string) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName.equals(string)) continue;
            return DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].name;
        }
        return null;
    }

    public static String nameToShortName(String string) {
        for (int i = 0; i < DESCRIPTOR_EXTENDED_LIST.length; ++i) {
            if (!DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].name.equals(string)) continue;
            return DescriptorHelper.DESCRIPTOR_EXTENDED_LIST[i].shortName;
        }
        return null;
    }

    private static String unifyShortName(String string) {
        return "PP3DMM2".equals(string) ? "Flexophore" : string;
    }

    public static String getTagDescriptorSimilarity(ISimilarityCalculator<?> iSimilarityCalculator) {
        return TAG_SIMILARITY + iSimilarityCalculator.getInfo().shortName;
    }

    public static String getTagDescriptorSimilarity(String string) {
        return TAG_SIMILARITY + string;
    }

    public static String getTagDescriptorSimilarity(SimilarityCalculatorInfo similarityCalculatorInfo) {
        return TAG_SIMILARITY + similarityCalculatorInfo.shortName;
    }

    public static String getTagDescriptorSimilarity(DescriptorInfo descriptorInfo) {
        return TAG_SIMILARITY + descriptorInfo.shortName;
    }

    public static <T> T create(DescriptorHandler<T, StereoMolecule> descriptorHandler, String string) {
        IDCodeParser iDCodeParser = new IDCodeParser();
        StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(string);
        stereoMolecule.ensureHelperArrays(7);
        return descriptorHandler.createDescriptor(stereoMolecule);
    }
}

