/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.BurtleHasher;
import java.util.Arrays;

public class DescriptorHandlerLongCFP
extends AbstractDescriptorHandlerLongFP<StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.6;
    private static DescriptorHandlerLongCFP sDefaultInstance;
    private static final int SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerLongCFP getDefaultInstance() {
        Class<DescriptorHandlerLongCFP> clazz = DescriptorHandlerLongCFP.class;
        synchronized (DescriptorHandlerLongCFP.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerLongCFP();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_HashedCFp;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_HashedCFp.version;
    }

    @Override
    public long[] createDescriptor(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            return null;
        }
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        long[] lArray = new long[16];
        int[] nArray = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (i != 0) {
                Arrays.fill(blArray, false);
            }
            int n = 0;
            int n2 = 0;
            for (int j = 0; j < 5 && n2 < stereoMolecule.getAtoms(); ++j) {
                int n3;
                int n4;
                int n5;
                if (n2 == 0) {
                    nArray[0] = i;
                    blArray[i] = true;
                    n2 = 1;
                } else {
                    int n6 = n2;
                    for (n5 = n; n5 < n2; ++n5) {
                        n4 = nArray[n5];
                        for (n3 = 0; n3 < stereoMolecule.getConnAtoms(n4); ++n3) {
                            int n7 = stereoMolecule.getConnAtom(n4, n3);
                            if (blArray[n7]) continue;
                            blArray[n7] = true;
                            nArray[n6++] = n7;
                        }
                    }
                    n = n2;
                    n2 = n6;
                }
                stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
                String string = new Canonizer(stereoMolecule2).getIDCode();
                n5 = BurtleHasher.hashlittle(string, 13L);
                n4 = 16 - (n5 &= BurtleHasher.hashmask(10)) / 64 - 1;
                n3 = n5 % 32;
                if (n5 % 64 >= 32) {
                    n3 += 32;
                }
                int n8 = n4;
                lArray[n8] = lArray[n8] | 1L << n3;
            }
        }
        return lArray;
    }

    @Override
    public float getSimilarity(long[] lArray, long[] lArray2) {
        return lArray == null || lArray2 == null || lArray.length == 0 || lArray2.length == 0 ? 0.0f : this.normalizeValue(SSSearcherWithIndex.getSimilarityTanimoto(lArray, lArray2));
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.6), 1.6666666666666667)));
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }
}

