/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.util.BurtleHasher;
import com.actelion.research.util.datamodel.IntVec;
import java.util.Arrays;

public class DescriptorHandlerHashedCFp
extends AbstractDescriptorHandlerFP<StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.6;
    private static DescriptorHandlerHashedCFp sDefaultInstance;
    private static final int SPHERE_COUNT = 5;
    private static final int HASH_BITS = 10;
    private static final int HASH_INIT = 13;
    private static final int DESCRIPTOR_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerHashedCFp getDefaultInstance() {
        Class<DescriptorHandlerHashedCFp> clazz = DescriptorHandlerHashedCFp.class;
        synchronized (DescriptorHandlerHashedCFp.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerHashedCFp();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_HashedCFp;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_HashedCFp.version;
    }

    @Override
    public int[] createDescriptor(StereoMolecule stereoMolecule) {
        if (stereoMolecule == null) {
            return null;
        }
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        int n = 32;
        IntVec intVec = new IntVec(n);
        int[] nArray = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (i != 0) {
                Arrays.fill(blArray, false);
            }
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j < 5 && n3 < stereoMolecule.getAtoms(); ++j) {
                int n4;
                if (n3 == 0) {
                    nArray[0] = i;
                    blArray[i] = true;
                    n3 = 1;
                } else {
                    int n5 = n3;
                    for (n4 = n2; n4 < n3; ++n4) {
                        int n6 = nArray[n4];
                        for (int k = 0; k < stereoMolecule.getConnAtoms(n6) + stereoMolecule.getMetalBondedConnAtoms(n6); ++k) {
                            int n7 = stereoMolecule.getConnAtom(n6, k);
                            if (blArray[n7]) continue;
                            blArray[n7] = true;
                            nArray[n5++] = n7;
                        }
                    }
                    n2 = n3;
                    n3 = n5;
                }
                stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
                String string = new Canonizer(stereoMolecule2).getIDCode();
                n4 = BurtleHasher.hashlittle(string, 13L);
                intVec.setBit(n4 &= BurtleHasher.hashmask(10));
            }
        }
        return intVec.get();
    }

    @Override
    public float getSimilarity(int[] nArray, int[] nArray2) {
        return nArray == null || nArray2 == null || nArray.length == 0 || nArray2.length == 0 ? 0.0f : this.normalizeValue(SSSearcherWithIndex.getSimilarityTanimoto(nArray, nArray2));
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.6), 1.6666666666666667)));
    }

    @Override
    public DescriptorHandler<int[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }
}

