/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

public class DescriptorEncoder {
    public static final int MAX_COUNT_VALUE = 63;
    private static final int BITS = 6;
    private static final int PAIR_BITS = 4;
    private static final byte[] sCode = "0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".getBytes();
    private static final byte[] sCodeMultipleMin = "!#$%&()*+,-./".getBytes();
    private static final byte[] sCodeMultipleMax = ":;<=>?[]^{|}~".getBytes();
    private static int[] sDecode;
    private static int[] sDecodeMultiple;
    private byte[] mBytes;
    private int mByteIndex;
    private int mAvailableBits;
    private int mTempData;
    private int mByteMask;
    private int mTempDataLong;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorEncoder() {
        if (sDecode == null) {
            DescriptorEncoder descriptorEncoder = this;
            synchronized (descriptorEncoder) {
                int n;
                int n2 = 64;
                assert (n2 <= sCode.length) : "Error in encoding, not enough characters.";
                sDecode = new int[sCode[sCode.length - 1] + 1];
                for (n = 0; n < sCode.length; ++n) {
                    DescriptorEncoder.sDecode[DescriptorEncoder.sCode[n]] = n;
                }
                sDecodeMultiple = new int[Math.max(sCodeMultipleMin[sCodeMultipleMin.length - 1], sCodeMultipleMax[sCodeMultipleMax.length - 1]) + 1];
                for (n = 0; n < sCodeMultipleMin.length; ++n) {
                    DescriptorEncoder.sDecodeMultiple[DescriptorEncoder.sCodeMultipleMin[n]] = -n - 2;
                }
                for (n = 0; n < sCodeMultipleMax.length; ++n) {
                    DescriptorEncoder.sDecodeMultiple[DescriptorEncoder.sCodeMultipleMax[n]] = n + 2;
                }
            }
        }
    }

    public byte[] encode(int[] nArray) {
        this.encodeStart(32 * nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.encodeBits(nArray[i], 32);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public byte[] encodeIntArray2D(int[][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n3 < nArray[n2].length) {
                n3 = nArray[n2].length;
            }
            for (n = 0; n < nArray[n2].length; ++n) {
                if (n4 >= nArray[n2][n]) continue;
                n4 = nArray[n2][n];
            }
            n5 += nArray[n2].length;
        }
        n2 = this.getNeededBits(n3);
        n = this.getNeededBits(n4);
        this.encodeStart(10 + (1 + nArray.length) * n2 + n5 * n);
        this.encodeBits(n2, 5);
        this.encodeBits(n, 5);
        this.encodeBits(nArray.length, n2);
        for (int i = 0; i < nArray.length; ++i) {
            this.encodeBits(nArray[i].length, n2);
            for (int j = 0; j < nArray[i].length; ++j) {
                this.encodeBits(nArray[i][j], n);
            }
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public int[][] decodeIntArray2D(byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        byArray = this.decodeDuplicateBytes(byArray);
        this.decodeStart(byArray);
        int n = this.decodeBits(5);
        int n2 = this.decodeBits(5);
        int n3 = this.decodeBits(n);
        int[][] nArrayArray = new int[n3][];
        for (int i = 0; i < n3; ++i) {
            int n4 = this.decodeBits(n);
            nArrayArray[i] = new int[n4];
            for (int j = 0; j < n4; ++j) {
                nArrayArray[i][j] = this.decodeBits(n2);
            }
        }
        return nArrayArray;
    }

    public byte[] encodeLong(long[] lArray) {
        this.encodeStart(64 * lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            this.encodeBits(lArray[i], 64);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public int[] decode(String string) {
        return this.decode(string.getBytes());
    }

    public int[] decode(byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        byArray = this.decodeDuplicateBytes(byArray);
        this.decodeStart(byArray);
        int[] nArray = new int[6 * byArray.length / 32];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.decodeBits(32);
        }
        return nArray;
    }

    public long[] decodeLong(String string) {
        return this.decodeLong(string.getBytes());
    }

    public long[] decodeLong(byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        byArray = this.decodeDuplicateBytes(byArray);
        this.decodeStart(byArray);
        long[] lArray = new long[6 * byArray.length / 64];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.decodeBitsLong(64);
        }
        return lArray;
    }

    public byte[] encodeCounts(byte[] byArray) {
        this.encodeStart(6 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.encodeBits(byArray[i], 6);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public byte[] decodeCounts(String string) {
        return this.decodeCounts(string.getBytes());
    }

    public byte[] decodeCounts(byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        byArray = this.decodeDuplicateBytes(byArray);
        this.decodeStart(byArray);
        byte[] byArray2 = new byte[6 * byArray.length / 6];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)this.decodeBits(6);
        }
        return byArray2;
    }

    public byte[] encodeIntArray(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int n3 : nArray) {
            n2 += this.getNeededBits(n3);
            if (n >= n3) continue;
            n = n3;
        }
        int n4 = Math.min(31, this.getNeededBits(nArray.length));
        int n5 = this.getNeededBits(this.getNeededBits(n));
        this.encodeStart(9 + n4 + n2 + n5 * nArray.length);
        this.encodeBits(0, 1);
        this.encodeBits(n4, 5);
        this.encodeBits(nArray.length, n4);
        this.encodeBits(n5, 3);
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            n3 = this.getNeededBits(nArray[i]);
            this.encodeBits(n3, n5);
            this.encodeBits(nArray[i], n3);
        }
        this.encodeBitsEnd();
        this.encodeDuplicateBytes();
        return this.mBytes;
    }

    public int[] decodeIntArray(String string) {
        return string == null ? null : this.decodeIntArray(string.getBytes());
    }

    public int[] decodeIntArray(byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        byArray = this.decodeDuplicateBytes(byArray);
        this.decodeStart(byArray);
        this.decodeBits(1);
        int n = this.decodeBits(5);
        int n2 = this.decodeBits(n);
        int n3 = this.decodeBits(3);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n4 = this.decodeBits(n3);
            nArray[i] = this.decodeBits(n4);
        }
        return nArray;
    }

    public byte[] encodePairs(int[][] nArray) {
        int n = 0;
        int n2 = 0;
        for (int[] object : nArray) {
            n = Math.max(n, object[0]);
            n2 = Math.max(n2, object[1]);
        }
        int n3 = this.getNeededBits(n);
        int n4 = this.getNeededBits(n2);
        int n5 = this.getNeededBits(6) + 8 + nArray.length * (n3 + n4);
        this.encodeStart(n5);
        this.encodeBits(this.mBytes.length * 6 - n5, this.getNeededBits(6));
        this.encodeBits(n3, 4);
        this.encodeBits(n4, 4);
        for (int[] nArray2 : nArray) {
            this.encodeBits(nArray2[0], n3);
            this.encodeBits(nArray2[1], n4);
        }
        this.encodeBitsEnd();
        return this.mBytes;
    }

    public int[][] decodePairs(byte[] byArray) {
        if (byArray.length == 0) {
            return null;
        }
        this.decodeStart(byArray);
        int n = this.decodeBits(this.getNeededBits(6));
        int n2 = this.decodeBits(4);
        int n3 = this.decodeBits(4);
        if (n2 + n3 == 0) {
            return new int[0][2];
        }
        int n4 = (6 * byArray.length - this.getNeededBits(6) - 8 - n) / (n2 + n3);
        int[][] nArray = new int[n4][2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i][0] = this.decodeBits(n2);
            nArray[i][1] = this.decodeBits(n3);
        }
        return nArray;
    }

    public int[][] decodePairs(String string) {
        return this.decodePairs(string.getBytes());
    }

    private int getNeededBits(int n) {
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    private void encodeStart(int n) {
        this.mBytes = new byte[(n + 6 - 1) / 6];
        this.mAvailableBits = 6;
        this.mByteIndex = 0;
    }

    private void encodeBits(int n, int n2) {
        int n3;
        int n4 = n3 = n2 == 0 ? 0 : 1 << n2 - 1;
        while (n3 != 0) {
            if (this.mAvailableBits == 0) {
                this.mBytes[this.mByteIndex] = sCode[this.mBytes[this.mByteIndex]];
                this.mAvailableBits = 6;
            }
            int n5 = ++this.mByteIndex;
            this.mBytes[n5] = (byte)(this.mBytes[n5] << 1);
            if ((n & n3) != 0) {
                int n6 = this.mByteIndex;
                this.mBytes[n6] = (byte)(this.mBytes[n6] | 1);
            }
            n3 >>>= 1;
            --this.mAvailableBits;
        }
    }

    private void encodeBits(long l, int n) {
        long l2;
        long l3 = l2 = n == 0 ? 0L : 1L << n - 1;
        while (l2 != 0L) {
            if (this.mAvailableBits == 0) {
                this.mBytes[this.mByteIndex] = sCode[this.mBytes[this.mByteIndex]];
                this.mAvailableBits = 6;
            }
            int n2 = ++this.mByteIndex;
            this.mBytes[n2] = (byte)(this.mBytes[n2] << 1);
            if ((l & l2) != 0L) {
                int n3 = this.mByteIndex;
                this.mBytes[n3] = (byte)(this.mBytes[n3] | 1);
            }
            l2 >>>= 1;
            --this.mAvailableBits;
        }
    }

    private void encodeBitsEnd() {
        int n = this.mByteIndex;
        this.mBytes[n] = (byte)(this.mBytes[n] << this.mAvailableBits);
        this.mBytes[this.mByteIndex] = sCode[this.mBytes[this.mByteIndex]];
    }

    private void decodeStart(byte[] byArray) {
        this.mBytes = byArray;
        this.mByteIndex = 0;
        this.mTempData = sDecode[this.mBytes[0]];
        this.mTempDataLong = sDecode[this.mBytes[0]];
        this.mByteMask = 32;
    }

    private int decodeBits(int n) {
        int n2 = 0;
        while (n != 0) {
            if (this.mByteMask == 0) {
                ++this.mByteIndex;
                this.mTempData = sDecode[this.mBytes[this.mByteIndex]];
                this.mByteMask = 32;
            }
            n2 <<= 1;
            if ((this.mTempData & this.mByteMask) != 0) {
                n2 |= 1;
            }
            this.mByteMask >>>= 1;
            --n;
        }
        return n2;
    }

    private long decodeBitsLong(int n) {
        long l = 0L;
        while (n != 0) {
            if (this.mByteMask == 0) {
                ++this.mByteIndex;
                this.mTempDataLong = sDecode[this.mBytes[this.mByteIndex]];
                this.mByteMask = 32;
            }
            l <<= 1;
            if (((long)this.mTempDataLong & (long)this.mByteMask) != 0L) {
                l |= 1L;
            }
            this.mByteMask >>>= 1;
            --n;
        }
        return l;
    }

    private byte[] decodeDuplicateBytes(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (sDecodeMultiple[byArray[i]] == 0) continue;
            n += Math.abs(sDecodeMultiple[byArray[i]]) - 1;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            if (sDecodeMultiple[byArray[n2]] != 0) {
                int n4 = Math.abs(sDecodeMultiple[byArray[n2]]);
                byte by = sDecodeMultiple[byArray[n2]] < 0 ? sCode[0] : sCode[sCode.length - 1];
                for (int i = 0; i < n4; ++i) {
                    byArray2[n3++] = by;
                }
                ++n2;
                continue;
            }
            byArray2[n3++] = byArray[n2++];
        }
        return byArray2;
    }

    private void encodeDuplicateBytes() {
        int n = this.encodeDuplicateBytes(sCode[0], sCodeMultipleMin, this.mBytes.length);
        n = this.encodeDuplicateBytes(sCode[sCode.length - 1], sCodeMultipleMax, n);
        byte[] byArray = this.mBytes;
        this.mBytes = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.mBytes[i] = byArray[i];
        }
    }

    private int encodeDuplicateBytes(byte by, byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (this.mBytes[n2] == by) {
                int n4 = 1;
                for (int i = n2 + 1; i < n && this.mBytes[i] == by; ++i) {
                    ++n4;
                }
                while (n4 > byArray.length + 1) {
                    this.mBytes[n3++] = byArray[byArray.length - 1];
                    n2 += byArray.length + 1;
                    n4 -= byArray.length + 1;
                }
                if (n4 > 1) {
                    this.mBytes[n3++] = byArray[n4 - 2];
                    n2 += n4;
                    continue;
                }
            }
            this.mBytes[n3++] = this.mBytes[n2++];
        }
        return n3;
    }
}

