/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.coords;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.CanonizerBaseValue;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.FragmentAssociation;
import com.actelion.research.chem.coords.InventorAngle;
import com.actelion.research.chem.coords.InventorChain;
import com.actelion.research.chem.coords.InventorCharge;
import com.actelion.research.chem.coords.InventorDefaultTemplateList;
import com.actelion.research.chem.coords.InventorFragment;
import com.actelion.research.chem.coords.InventorTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class CoordinateInventor {
    public static final int MODE_SKIP_DEFAULT_TEMPLATES = 1;
    public static final int MODE_REMOVE_HYDROGEN = 2;
    public static final int MODE_KEEP_MARKED_ATOM_COORDS = 4;
    public static final int MODE_PREFER_MARKED_ATOM_COORDS = 8;
    protected static final int MODE_CONSIDER_MARKED_ATOMS = 12;
    public static final int MODE_DEFAULT = 2;
    private static final byte FLIP_AS_LAST_RESORT = 1;
    private static final byte FLIP_POSSIBLE = 2;
    private static final byte FLIP_PREFERRED = 3;
    private static final int PREFERRED_FLIPS = 32;
    private static final int POSSIBLE_FLIPS = 64;
    private static final int LAST_RESORT_FLIPS = 128;
    private static final int TOTAL_FLIPS = 224;
    private static volatile List<InventorTemplate> sDefaultTemplateList;
    private StereoMolecule mMol;
    private long[] mFFP;
    private Random mRandom;
    private boolean[] mAtomHandled;
    private boolean[] mBondHandled;
    private boolean[] mAtomIsPartOfCustomTemplate;
    private boolean mAbsoluteOrientationTemplateFound;
    private int[] mUnPairedCharge;
    private int mMode;
    private List<InventorFragment> mFragmentList;
    private List<InventorTemplate> mCustomTemplateList;

    private static synchronized void buildDefaultTemplateList() {
        if (sDefaultTemplateList == null) {
            sDefaultTemplateList = new InventorDefaultTemplateList();
        }
    }

    public CoordinateInventor() {
        this(2);
    }

    public CoordinateInventor(int n) {
        this.mMode = n;
        if ((n & 1) == 0 && sDefaultTemplateList == null) {
            CoordinateInventor.buildDefaultTemplateList();
        }
    }

    public void setRandomSeed(long l) {
        this.mRandom = new Random(l);
    }

    public void setCustomTemplateList(List<InventorTemplate> list) {
        this.mCustomTemplateList = list;
        for (InventorTemplate inventorTemplate : list) {
            inventorTemplate.normalizeCoordinates();
        }
    }

    public void invent(StereoMolecule stereoMolecule) {
        this.invent(stereoMolecule, null);
    }

    public void invent(StereoMolecule stereoMolecule, long[] lArray) {
        boolean bl = (stereoMolecule.getHelperArrayStatus() & 0xF) != 0;
        int n = stereoMolecule.getHelperArrayStatus() & 0xF8;
        if (this.mRandom == null) {
            this.mRandom = new Random();
        }
        if ((this.mMode & 2) != 0) {
            stereoMolecule.removeExplicitHydrogens(false, false);
        }
        this.mMol = stereoMolecule;
        this.mMol.ensureHelperArrays(7);
        this.mFFP = lArray;
        this.mFragmentList = new ArrayList<InventorFragment>(){

            @Override
            public boolean add(InventorFragment inventorFragment) {
                for (InventorFragment inventorFragment2 : this) {
                    if (!inventorFragment2.equals(inventorFragment)) continue;
                    return false;
                }
                return super.add(inventorFragment);
            }
        };
        this.mAtomHandled = new boolean[this.mMol.getAllAtoms()];
        this.mBondHandled = new boolean[this.mMol.getAllBonds()];
        this.mUnPairedCharge = new int[this.mMol.getAllAtoms()];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            this.mUnPairedCharge[i] = this.mMol.getAtomCharge(i);
        }
        if ((this.mMode & 0xC) != 0) {
            this.locateMarkedFragments();
        }
        if (this.mCustomTemplateList != null) {
            this.mAtomIsPartOfCustomTemplate = this.locateTemplateFragments(this.mCustomTemplateList, 512);
        }
        if ((this.mMode & 1) == 0 && sDefaultTemplateList != null) {
            this.locateTemplateFragments(sDefaultTemplateList, 256);
        }
        this.locateInitialFragments();
        this.joinOverlappingFragments();
        this.locateChainFragments();
        this.joinOverlappingFragments();
        for (InventorFragment inventorFragment : this.mFragmentList) {
            inventorFragment.locateBonds();
        }
        this.correctChainEZParities();
        this.optimizeFragments();
        this.locateSingleAtoms();
        this.joinMetalBondedFragments();
        this.joinChargedFragments();
        this.joinRemainingFragments();
        for (int i = 0; i < this.mFragmentList.size(); ++i) {
            InventorFragment inventorFragment;
            inventorFragment = this.mFragmentList.get(i);
            for (int j = 0; j < inventorFragment.size(); ++j) {
                this.mMol.setAtomX(inventorFragment.mGlobalAtom[j], inventorFragment.mAtomX[j]);
                this.mMol.setAtomY(inventorFragment.mGlobalAtom[j], inventorFragment.mAtomY[j]);
                this.mMol.setAtomZ(inventorFragment.mGlobalAtom[j], 0.0);
            }
        }
        if (bl) {
            this.mMol.setParitiesValid(n);
            this.mMol.setStereoBondsFromParity();
        }
        if (this.mAbsoluteOrientationTemplateFound) {
            this.mMol.removeAtomMarkers();
        }
    }

    public boolean[] getCustomTemplateAtomMask() {
        return this.mAtomIsPartOfCustomTemplate;
    }

    private boolean[] locateTemplateFragments(List<InventorTemplate> list, int n) {
        boolean bl = this.mFFP != null && list.size() != 0 && list.get(0).getFFP() != null;
        SSSearcher sSSearcher = null;
        SSSearcherWithIndex sSSearcherWithIndex = null;
        if (bl) {
            sSSearcherWithIndex = new SSSearcherWithIndex();
            sSSearcherWithIndex.setMolecule(this.mMol, this.mFFP);
        } else {
            sSSearcher = new SSSearcher();
            sSSearcher.setMolecule(this.mMol);
        }
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        for (InventorTemplate inventorTemplate : list) {
            ArrayList<int[]> arrayList = null;
            StereoMolecule stereoMolecule = inventorTemplate.getFragment();
            if (bl) {
                sSSearcherWithIndex.setFragment(stereoMolecule, inventorTemplate.getFFP());
                if (sSSearcherWithIndex.findFragmentInMolecule(4, 8) != 0) {
                    arrayList = sSSearcherWithIndex.getGraphMatcher().getMatchList();
                }
            } else {
                sSSearcher.setFragment(stereoMolecule);
                if (sSSearcher.findFragmentInMolecule(4, 8) != 0) {
                    arrayList = sSSearcher.getMatchList();
                }
            }
            if (arrayList == null) continue;
            for (int[] nArray : arrayList) {
                int n2;
                int n3;
                int n4 = 0;
                int[] nArray2 = nArray;
                int n5 = nArray2.length;
                for (n3 = 0; n3 < n5; ++n3) {
                    n2 = nArray2[n3];
                    if (!blArray[n2]) continue;
                    ++n4;
                }
                if (n4 > true) continue;
                boolean bl2 = inventorTemplate.keepAbsoluteOrientation();
                if (this.mAbsoluteOrientationTemplateFound) {
                    bl2 = false;
                } else {
                    this.mAbsoluteOrientationTemplateFound = true;
                }
                InventorFragment inventorFragment = new InventorFragment(this.mMol, nArray.length, bl2);
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    if (bl2) {
                        this.mMol.setAtomMarker(n2, true);
                    }
                    inventorFragment.mPriority[n3] = n;
                    inventorFragment.mGlobalAtom[n3] = n2;
                    inventorFragment.mAtomX[n3] = inventorTemplate.getNormalizedAtomX(n3);
                    inventorFragment.mAtomY[n3] = inventorTemplate.getNormalizedAtomY(n3);
                    blArray[n2] = true;
                    this.mAtomHandled[n2] = true;
                }
                for (n3 = 0; n3 < stereoMolecule.getBonds(); ++n3) {
                    this.mBondHandled[this.mMol.getBond((int)nArray[stereoMolecule.getBondAtom((int)0, (int)n3)], (int)nArray[stereoMolecule.getBondAtom((int)1, (int)n3)])] = true;
                }
                this.mFragmentList.add(inventorFragment);
            }
        }
        return blArray;
    }

    private void locateMarkedFragments() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        for (n6 = 0; n6 < this.mMol.getAllAtoms(); ++n6) {
            if (!this.mMol.isMarkedAtom(n6)) continue;
            ++n7;
        }
        if (n7 < 2) {
            return;
        }
        n6 = 0;
        double d = 0.0;
        for (n5 = 0; n5 < this.mMol.getAllBonds(); ++n5) {
            n4 = this.mMol.getBondAtom(0, n5);
            int n8 = this.mMol.getBondAtom(1, n5);
            if (!this.mMol.isMarkedAtom(n4) || !this.mMol.isMarkedAtom(n8)) continue;
            this.mBondHandled[n5] = true;
            this.mAtomHandled[n4] = true;
            this.mAtomHandled[n8] = true;
            d += this.mMol.getBondLength(n5);
            ++n6;
        }
        d = n6 != 0 && d != 0.0 ? (d /= (double)n6) : this.mMol.getAverageBondLength();
        for (n5 = 0; n5 < this.mMol.getAllAtoms(); ++n5) {
            if (!this.mMol.isMarkedAtom(n5) || this.mAtomHandled[n5]) continue;
            --n7;
        }
        if (n7 < 2) {
            return;
        }
        int[] nArray = new int[this.mMol.getAllAtoms()];
        n4 = this.mMol.getFragmentNumbers(nArray, true, true);
        int[] nArray2 = new int[n4];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (nArray[i] == -1) continue;
            int n9 = nArray[i];
            nArray2[n9] = nArray2[n9] + 1;
        }
        InventorFragment[] inventorFragmentArray = new InventorFragment[n4];
        for (int i = 0; i < n4; ++i) {
            inventorFragmentArray[i] = new InventorFragment(this.mMol, nArray2[i], true);
        }
        int[] nArray3 = new int[n4];
        for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
            n2 = nArray[n3];
            if (n2 == -1) continue;
            inventorFragmentArray[n2].mPriority[nArray3[n2]] = 1024;
            inventorFragmentArray[n2].mGlobalAtom[nArray3[n2]] = n3;
            inventorFragmentArray[n2].mAtomX[nArray3[n2]] = this.mMol.getAtomX(n3) / d;
            inventorFragmentArray[n2].mAtomY[nArray3[n2]] = this.mMol.getAtomY(n3) / d;
            int n10 = n2;
            nArray3[n10] = nArray3[n10] + 1;
        }
        n3 = -1;
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            if (n2 >= nArray2[n]) continue;
            n2 = nArray2[n];
            n3 = n;
        }
        this.mFragmentList.add(inventorFragmentArray[n3]);
        for (n = 0; n < n4; ++n) {
            if (n == n3) continue;
            this.mFragmentList.add(inventorFragmentArray[n]);
        }
    }

    private void locateInitialFragments() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mMol.getAllConnAtoms(i) <= 4) continue;
            InventorFragment inventorFragment = new InventorFragment(this.mMol, 1 + this.mMol.getAllConnAtoms(i), false);
            inventorFragment.mAtomX[this.mMol.getAllConnAtoms((int)i)] = 0.0;
            inventorFragment.mAtomY[this.mMol.getAllConnAtoms((int)i)] = 0.0;
            inventorFragment.mPriority[this.mMol.getAllConnAtoms((int)i)] = 32;
            inventorFragment.mGlobalAtom[this.mMol.getAllConnAtoms((int)i)] = i;
            this.mAtomHandled[i] = true;
            for (n6 = 0; n6 < this.mMol.getAllConnAtoms(i); ++n6) {
                int n7 = this.mMol.getConnAtom(i, n6);
                inventorFragment.mAtomX[n6] = Math.sin(1.0471975511965976 * (double)n6 - 2.0943951023931953);
                inventorFragment.mAtomY[n6] = Math.cos(1.0471975511965976 * (double)n6 - 2.0943951023931953);
                inventorFragment.mPriority[n6] = 32;
                inventorFragment.mGlobalAtom[n6] = n7;
                this.mAtomHandled[n7] = true;
                this.mBondHandled[this.mMol.getConnBond((int)i, (int)n6)] = true;
            }
            this.mFragmentList.add(inventorFragment);
        }
        RingCollection ringCollection = this.mMol.getRingSet();
        for (n5 = 0; n5 < ringCollection.getSize(); ++n5) {
            n6 = ringCollection.getRingSize(n5);
            int[] nArray = ringCollection.getRingAtoms(n5);
            boolean bl = false;
            if ((this.mMode & 0xC) != 0) {
                bl = true;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (this.mMol.isMarkedAtom(nArray[n4])) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) continue;
            n4 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                if (this.mMol.getAtomRingSize(nArray[n3]) != n6) continue;
                n4 = 1;
                break;
            }
            if (n4 == 0) continue;
            int[] nArray2 = ringCollection.getRingBonds(n5);
            this.addRingFragment(nArray, nArray2);
            for (n2 = 0; n2 < n6; ++n2) {
                this.mAtomHandled[nArray[n2]] = true;
                this.mBondHandled[nArray2[n2]] = true;
            }
        }
        for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
            if (!this.mMol.isRingBond(n5) || this.mBondHandled[n5]) continue;
            InventorChain inventorChain = this.getSmallestRingFromBond(n5);
            int[] nArray = inventorChain.getRingAtoms();
            int[] nArray3 = inventorChain.getRingBonds();
            this.addRingFragment(nArray, nArray3);
            for (n4 = 0; n4 < inventorChain.getChainLength(); ++n4) {
                this.mAtomHandled[nArray[n4]] = true;
                this.mBondHandled[nArray3[n4]] = true;
            }
        }
        for (n5 = 0; n5 < this.mMol.getAllBonds(); ++n5) {
            if (this.mBondHandled[n5] || this.mMol.getBondOrder(n5) != 3) continue;
            int n8 = this.mMol.getBondAtom(0, n5);
            int n9 = this.mMol.getBondAtom(1, n5);
            int n10 = this.mMol.getAllConnAtoms(n8) + this.mMol.getAllConnAtoms(n9);
            if (n10 <= 2) continue;
            InventorFragment inventorFragment = new InventorFragment(this.mMol, n10, false);
            n3 = 0;
            for (n2 = 0; n2 < this.mMol.getAllConnAtoms(n8); ++n2) {
                n = this.mMol.getConnAtom(n8, n2);
                if (n == n9) continue;
                inventorFragment.mGlobalAtom[n3++] = n;
                this.mAtomHandled[n] = true;
                this.mBondHandled[this.mMol.getConnBond((int)n8, (int)n2)] = true;
            }
            inventorFragment.mGlobalAtom[n3++] = n8;
            inventorFragment.mGlobalAtom[n3++] = n9;
            for (n2 = 0; n2 < this.mMol.getAllConnAtoms(n9); ++n2) {
                n = this.mMol.getConnAtom(n9, n2);
                if (n == n8) continue;
                inventorFragment.mGlobalAtom[n3++] = n;
                this.mAtomHandled[n] = true;
                this.mBondHandled[this.mMol.getConnBond((int)n9, (int)n2)] = true;
            }
            for (n2 = 0; n2 < n10; ++n2) {
                inventorFragment.mAtomX[n2] = n2;
                inventorFragment.mAtomY[n2] = 0.0;
                inventorFragment.mPriority[n2] = 1;
            }
            this.mAtomHandled[n8] = true;
            this.mAtomHandled[n9] = true;
            this.mBondHandled[n5] = true;
            this.mFragmentList.add(inventorFragment);
        }
        for (n5 = 0; n5 < this.mMol.getAllBonds(); ++n5) {
            if (this.mBondHandled[n5] || this.mMol.getBondOrder(n5) != 2) continue;
            int[] nArray = new int[this.mMol.getAllAtoms()];
            for (int i = 0; i < 2; ++i) {
                int n11;
                int n12;
                int n13;
                nArray[0] = this.mMol.getBondAtom(i, n5);
                nArray[1] = this.mMol.getBondAtom(1 - i, n5);
                if (this.mMol.getAtomPi(nArray[0]) != 1 || this.mMol.getAtomPi(nArray[1]) != 2 || this.mMol.getAllConnAtoms(nArray[1]) != 2) continue;
                this.mAtomHandled[nArray[0]] = true;
                this.mAtomHandled[nArray[1]] = true;
                this.mBondHandled[n5] = true;
                int n14 = 1;
                do {
                    n13 = this.mMol.getConnAtom(nArray[n14], 0) == nArray[n14 - 1] ? 1 : 0;
                    nArray[n14 + 1] = this.mMol.getConnAtom(nArray[n14], n13);
                    if (this.mMol.getAtomPi(nArray[n14 + 1]) == 2 && this.mMol.getAllConnAtoms(nArray[n14 + 1]) > 2) break;
                    this.mAtomHandled[nArray[n14 + 1]] = true;
                    this.mBondHandled[this.mMol.getConnBond((int)nArray[n14], (int)n13)] = true;
                } while (this.mMol.getAtomPi(nArray[++n14]) == 2 && this.mMol.getAllConnAtoms(nArray[n14]) == 2);
                n13 = this.mMol.getAllConnAtoms(nArray[0]) + this.mMol.getAllConnAtoms(nArray[n14]) + n14 - 1;
                InventorFragment inventorFragment = new InventorFragment(this.mMol, n13, false);
                for (n2 = 0; n2 <= n14; ++n2) {
                    inventorFragment.mAtomX[n2] = n2;
                    inventorFragment.mAtomY[n2] = 0.0;
                    inventorFragment.mPriority[n2] = 64;
                    inventorFragment.mGlobalAtom[n2] = nArray[n2];
                }
                n2 = n14 + 1;
                n = 0;
                for (n12 = 0; n12 < this.mMol.getAllConnAtoms(nArray[0]); ++n12) {
                    n11 = this.mMol.getConnAtom(nArray[0], n12);
                    if (n11 == nArray[1]) continue;
                    inventorFragment.mAtomX[n2] = -0.5;
                    inventorFragment.mAtomY[n2] = n != 0 ? Math.sin(1.0471975511965976) : -Math.sin(1.0471975511965976);
                    inventorFragment.mPriority[n2] = 64;
                    inventorFragment.mGlobalAtom[n2] = n11;
                    ++n2;
                    n = 1;
                }
                n = 0;
                for (n12 = 0; n12 < this.mMol.getAllConnAtoms(nArray[n14]); ++n12) {
                    n11 = this.mMol.getConnAtom(nArray[n14], n12);
                    if (n11 == nArray[n14 - 1]) continue;
                    inventorFragment.mAtomX[n2] = (double)n14 + 0.5;
                    inventorFragment.mAtomY[n2] = n != 0 ? -Math.sin(1.0471975511965976) : Math.sin(1.0471975511965976);
                    inventorFragment.mPriority[n2] = 64;
                    inventorFragment.mGlobalAtom[n2] = n11;
                    ++n2;
                    n = 1;
                }
                this.mFragmentList.add(inventorFragment);
            }
        }
        for (n5 = 0; n5 < this.mMol.getAllAtoms(); ++n5) {
            int n15;
            if (this.mMol.getAllConnAtoms(n5) != 4) continue;
            int[] nArray = new int[4];
            int[] nArray4 = new int[4];
            int n16 = 0;
            for (int i = 0; i < 4; ++i) {
                nArray[n16] = this.mMol.getConnAtom(n5, i);
                nArray4[n16] = this.mMol.getConnBond(n5, i);
                if (this.mMol.getAllConnAtoms(nArray[n16]) != 1 || this.mBondHandled[nArray4[n16]]) continue;
                ++n16;
            }
            if (n16 == 2) {
                InventorFragment inventorFragment = new InventorFragment(this.mMol, 3, false);
                for (int i = 0; i < 2; ++i) {
                    this.mAtomHandled[nArray[i]] = true;
                    this.mBondHandled[nArray4[i]] = true;
                    inventorFragment.mGlobalAtom[i] = nArray[i];
                    inventorFragment.mPriority[i] = 32;
                }
                inventorFragment.mAtomX[0] = -0.5;
                inventorFragment.mAtomY[0] = 0.866;
                inventorFragment.mAtomX[1] = 0.5;
                inventorFragment.mAtomY[1] = 0.866;
                inventorFragment.mAtomX[2] = 0.0;
                inventorFragment.mAtomY[2] = 0.0;
                inventorFragment.mPriority[2] = 32;
                inventorFragment.mGlobalAtom[2] = n5;
                this.mFragmentList.add(inventorFragment);
            }
            if (n16 != 3) continue;
            for (int i = 0; i < 2; ++i) {
                if (this.mMol.getBondOrder(nArray4[i]) != 1) continue;
                n15 = nArray[i];
                nArray[i] = nArray[2];
                nArray[2] = n15;
                n15 = nArray4[i];
                nArray4[i] = nArray4[2];
                nArray4[2] = n15;
            }
            InventorFragment inventorFragment = new InventorFragment(this.mMol, 4, false);
            for (n15 = 0; n15 < 3; ++n15) {
                this.mAtomHandled[nArray[n15]] = true;
                this.mBondHandled[nArray4[n15]] = true;
                inventorFragment.mGlobalAtom[n15] = nArray[n15];
                inventorFragment.mPriority[n15] = 32;
            }
            inventorFragment.mAtomX[0] = -1.0;
            inventorFragment.mAtomY[0] = 0.0;
            inventorFragment.mAtomX[1] = 1.0;
            inventorFragment.mAtomY[1] = 0.0;
            inventorFragment.mAtomX[2] = 0.0;
            inventorFragment.mAtomY[2] = 1.0;
            inventorFragment.mAtomX[3] = 0.0;
            inventorFragment.mAtomY[3] = 0.0;
            inventorFragment.mPriority[3] = 32;
            inventorFragment.mGlobalAtom[3] = n5;
            this.mFragmentList.add(inventorFragment);
        }
    }

    private void locateChainFragments() {
        while (true) {
            int n;
            InventorChain inventorChain = null;
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                n = 0;
                for (int j = 0; j < this.mMol.getAllConnAtoms(i); ++j) {
                    if (this.mBondHandled[this.mMol.getConnBond(i, j)]) continue;
                    ++n;
                }
                if (n != true) continue;
                InventorChain inventorChain2 = this.getLongestUnhandledChain(i);
                if (inventorChain != null && inventorChain2.getChainLength() <= inventorChain.getChainLength()) continue;
                inventorChain = inventorChain2;
            }
            if (inventorChain == null) break;
            InventorFragment inventorFragment = new InventorFragment(this.mMol, inventorChain.getChainLength(), false);
            for (n = 0; n < inventorChain.getChainLength(); ++n) {
                this.mAtomHandled[inventorChain.mAtom[n]] = true;
                if (n < inventorChain.getChainLength() - 1) {
                    this.mBondHandled[inventorChain.mBond[n]] = true;
                }
                inventorFragment.mGlobalAtom[n] = inventorChain.mAtom[n];
                inventorFragment.mAtomX[n] = Math.cos(0.5235987755982988) * (double)n;
                inventorFragment.mAtomY[n] = (n & 1) == 1 ? 0.0 : 0.5;
                inventorFragment.mPriority[n] = 128 + inventorChain.getChainLength();
            }
            this.mFragmentList.add(inventorFragment);
        }
    }

    private void locateSingleAtoms() {
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (this.mAtomHandled[i] || this.mMol.getAllConnAtoms(i) != 0) continue;
            InventorFragment inventorFragment = new InventorFragment(this.mMol, 1, false);
            this.mAtomHandled[i] = true;
            inventorFragment.mGlobalAtom[0] = i;
            inventorFragment.mAtomX[0] = 0.0;
            inventorFragment.mAtomY[0] = 0.0;
            inventorFragment.mPriority[0] = 0;
            this.mFragmentList.add(inventorFragment);
        }
    }

    private void addRingFragment(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        InventorFragment inventorFragment = new InventorFragment(this.mMol, n, false);
        inventorFragment.mAtomX[0] = 0.0;
        inventorFragment.mAtomY[0] = 0.0;
        for (int i = 0; i < n; ++i) {
            inventorFragment.mPriority[i] = 128 - n;
            inventorFragment.mGlobalAtom[i] = nArray[i];
        }
        if (n < 8) {
            this.createRegularRingFragment(inventorFragment);
        } else {
            this.createLargeRingFragment(inventorFragment, nArray, nArray2);
        }
        this.mFragmentList.add(inventorFragment);
    }

    private void createRegularRingFragment(InventorFragment inventorFragment) {
        double d = Math.PI - Math.PI * (double)(inventorFragment.size() - 2) / (double)inventorFragment.size();
        for (int i = 1; i < inventorFragment.size(); ++i) {
            inventorFragment.mAtomX[i] = inventorFragment.mAtomX[i - 1] + Math.sin(d * (double)(i - 1));
            inventorFragment.mAtomY[i] = inventorFragment.mAtomY[i - 1] + Math.cos(d * (double)(i - 1));
        }
    }

    private void createRegularRingFragment(InventorFragment inventorFragment, int n, int n2) {
        int n3;
        int n4;
        if (n == 0 || (n & n2) != 0) {
            this.createRegularRingFragment(inventorFragment);
            return;
        }
        int n5 = -1;
        int n6 = 0;
        int n7 = 1 << inventorFragment.size() - 2;
        int n8 = 1 << inventorFragment.size() - 1;
        int n9 = 1;
        int n10 = 2;
        for (n4 = 0; n4 < inventorFragment.size(); ++n4) {
            if ((n2 & (n8 | n9)) == 0 && (n & (n8 | n9)) != 0 && (n & n7) == 0) {
                n3 = 0;
                if ((n2 & n7) != 0) {
                    n3 += 4;
                }
                if ((n & n8) != 0) {
                    n3 += 2;
                }
                if ((n & n9) != 0) {
                    ++n3;
                }
                if (n6 < n3) {
                    n6 = n3;
                    n5 = n4;
                }
            }
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = 1 << (n4 + 2 < inventorFragment.size() ? n4 + 2 : n4 + 2 - inventorFragment.size());
        }
        if (n5 == -1) {
            this.createRegularRingFragment(inventorFragment);
            return;
        }
        n4 = 0;
        n4 |= 1 << n5;
        n3 = 2;
        while (n3 < inventorFragment.size() - 1) {
            int n11 = n5 + n3 < inventorFragment.size() ? n5 + n3 : n5 + n3 - inventorFragment.size();
            n8 = 1 << (n11 == 0 ? inventorFragment.size() - 1 : n11 - 1);
            if ((n2 & n8) != 0) {
                ++n3;
                continue;
            }
            n9 = 1 << n11;
            if ((n & n8) != 0) {
                if ((n2 & n9) != 0) {
                    this.createRegularRingFragment(inventorFragment);
                    return;
                }
                n4 |= n9;
                n3 += 2;
                continue;
            }
            n10 = 1 << (n11 + 1 < inventorFragment.size() ? n11 + 1 : n11 + 1 - inventorFragment.size());
            if ((n & n9) != 0 && (n2 & n10) != 0) {
                n4 |= n9;
                n3 += 3;
                continue;
            }
            ++n3;
        }
        if (n4 == 0) {
            this.createRegularRingFragment(inventorFragment);
            return;
        }
        double d = Math.PI - Math.PI * (double)(inventorFragment.size() - 2) / (double)inventorFragment.size();
        for (int i = 1; i < inventorFragment.size(); ++i) {
            inventorFragment.mAtomX[i] = inventorFragment.mAtomX[i - 1] + Math.sin(d * (double)(i - 1));
            inventorFragment.mAtomY[i] = inventorFragment.mAtomY[i - 1] + Math.cos(d * (double)(i - 1));
        }
        n9 = 1;
        double d2 = 2.0 * Math.sin(d / 2.0);
        for (int i = 0; i < inventorFragment.size(); ++i) {
            if ((n4 & n9) != 0) {
                int n12 = i;
                inventorFragment.mAtomX[n12] = inventorFragment.mAtomX[n12] + d2 * Math.cos(d * ((double)i - 0.5));
                int n13 = i;
                inventorFragment.mAtomY[n13] = inventorFragment.mAtomY[n13] - d2 * Math.sin(d * ((double)i - 0.5));
            }
            n9 <<= 1;
        }
    }

    private void createLargeRingFragment(InventorFragment inventorFragment, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        double[][] dArrayArray = new double[][]{{20.0}, null, null, {0.0, 10.0}, null, null, {-4.0, 12.0}, {0.0, 0.0, -7.5}, null, null, null, null, {8.0, -8.0}, null, null, null, {-2.4}};
        int[][] nArrayArray = new int[][]{{146}, {627}, null, {2457, 1170}, null, {2451, 8643, 2519}, {9362, 14798}, {34377, -2147448999, 26214}, null, {37449, 137313, 95703, 34371, 37815, 54891, 132867, -2147309741, 54857, 55129, -2147449005, -2147449065}, null, {530697, 531819, 899169, 137289, 694617, -2146951863, -2146952797, -2146939175, -2146929547, -2146929564, -2146625111, -2146931799, -2146940503, -2146931935}, {1007293, 610915}, {542985, 137283, 2122017, 530691, 2206773, -2144711351, 219209, 2840841, 137555, -2146871031, -2147264167, 613705, -2145360543, -2146625271, 694611, 2454837, -2145356703, -2147345133, -2146928951, -2146931805, -2144641719, -2146951869, -2146625237, -2146624183, 2841963, 1074905, -2146625117, 2799955, -2144723645, 138583, 859225, -2145264843, -2145216253, -2146624149, -2144700727, -2146928917, -2143905527, -2144045771, -2146789097, 2288547, 544407, 2104323, -2146911977, -2144479405, 3633737, -2146870089, -2146952169}, null, {0x818181, 2172633, 2116611, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8829813}, {14071213}};
        int n3 = 1 << inventorFragment.size();
        int n4 = 0;
        int n5 = 0;
        if (inventorFragment.size() > 7) {
            for (n2 = 0; n2 < inventorFragment.size(); ++n2) {
                n = this.getLargeRingBondParity(nArray, nArray2, n2);
                if (n == 1) {
                    n4 += n3;
                } else if (n == 2) {
                    n5 += n3;
                }
                n4 >>>= 1;
                n5 >>>= 1;
            }
        }
        n2 = inventorFragment.size() - 9;
        if (inventorFragment.size() >= 9 && inventorFragment.size() <= 25 && nArrayArray[n2] != null) {
            block1: for (n = 0; n < nArrayArray[n2].length; ++n) {
                boolean bl = (Integer.MIN_VALUE & nArrayArray[n2][n]) == 0;
                int n6 = Integer.MAX_VALUE & nArrayArray[n2][n];
                boolean bl2 = false;
                while (!bl2) {
                    int n7;
                    if (bl2) {
                        if (bl) continue block1;
                        n7 = 0;
                        for (int i = 1; i != n3; i <<= 1) {
                            n7 <<= 1;
                            if ((n6 & i) == 0) continue;
                            n7 |= 1;
                        }
                        n6 = n7;
                    }
                    for (n7 = 0; n7 < inventorFragment.size(); ++n7) {
                        if ((n6 & n4) == 0 && (~n6 & n5) == 0) {
                            int n8;
                            double d = 0.0;
                            double d2 = Math.PI / 180 * (dArrayArray[n2] == null ? 0.0 : dArrayArray[n2][n]);
                            int n9 = 0;
                            int n10 = n6;
                            boolean bl3 = true;
                            for (n8 = 0; n8 < inventorFragment.size(); ++n8) {
                                if (bl3) {
                                    ++n9;
                                }
                                if ((n10 & 1) == 0) {
                                    bl3 = !bl3;
                                }
                                n10 >>>= 1;
                            }
                            n8 = n9 > inventorFragment.size() / 2 ? 1 : 0;
                            for (int i = 1; i < inventorFragment.size(); ++i) {
                                inventorFragment.mAtomX[i] = inventorFragment.mAtomX[i - 1] + Math.sin(d);
                                inventorFragment.mAtomY[i] = inventorFragment.mAtomY[i - 1] + Math.cos(d);
                                if ((n6 & 1) == 0) {
                                    n8 = n8 == 0 ? 1 : 0;
                                }
                                d += d2 + (n8 != 0 ? 1.0471975511965976 : -1.0471975511965976);
                                n6 >>>= 1;
                            }
                            return;
                        }
                        if ((n6 & 1) != 0) {
                            n6 |= n3;
                        }
                        n6 >>>= 1;
                    }
                    bl2 = !bl2;
                }
            }
        }
        this.createRegularRingFragment(inventorFragment, n4, n5);
    }

    private int getLargeRingBondParity(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3;
        int n4 = n == nArray.length - 1 ? 0 : n + 1;
        int n5 = n == 0 ? nArray.length - 1 : n - 1;
        int n6 = n3 = n4 == nArray.length - 1 ? 0 : n4 + 1;
        if (this.mMol.getBondOrder(nArray2[n]) == 2 && ((n2 = this.mMol.getBondParity(nArray2[n])) == 1 || n2 == 2)) {
            if (this.isLowestIndexNeighbour(nArray[n5], nArray[n], nArray[n4]) ^ this.isLowestIndexNeighbour(nArray[n3], nArray[n4], nArray[n])) {
                n2 = n2 == 1 ? 2 : 1;
            }
            return n2;
        }
        if (this.mMol.isSmallRingBond(nArray2[n])) {
            n2 = this.mMol.getRingSet().getSharedRing(nArray2[n5], nArray2[n]);
            int n7 = this.mMol.getRingSet().getSharedRing(nArray2[n4], nArray2[n]);
            if (n2 != -1 || n7 != -1) {
                return n2 == n7 ? 2 : 1;
            }
            return 2;
        }
        return 0;
    }

    private boolean isLowestIndexNeighbour(int n, int n2, int n3) {
        for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
            int n4 = this.mMol.getConnAtom(n2, i);
            if (n4 == n3 || n4 >= n) continue;
            return false;
        }
        return true;
    }

    private InventorChain getSmallestRingFromBond(int n) {
        int n2 = this.mMol.getBondAtom(0, n);
        int n3 = this.mMol.getBondAtom(1, n);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int[] nArray2 = new int[this.mMol.getAllAtoms()];
        int[] nArray3 = new int[this.mMol.getAllAtoms()];
        int[] nArray4 = new int[this.mMol.getAllAtoms()];
        nArray[0] = n2;
        nArray[1] = n3;
        nArray2[1] = n;
        nArray3[n2] = 1;
        nArray3[n3] = 2;
        nArray4[0] = -1;
        nArray4[1] = 0;
        int n4 = 1;
        for (int i = 1; i <= n4; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                int n5 = this.mMol.getConnAtom(nArray[i], j);
                if (i > 1 && n5 == n2) {
                    InventorChain inventorChain = new InventorChain(nArray3[nArray[i]]);
                    nArray2[0] = this.mMol.getConnBond(nArray[i], j);
                    int n6 = i;
                    for (int k = 0; k < inventorChain.getChainLength(); ++k) {
                        inventorChain.mAtom[k] = nArray[n6];
                        inventorChain.mBond[k] = nArray2[n6];
                        n6 = nArray4[n6];
                    }
                    return inventorChain;
                }
                if (nArray3[n5] != 0 || !this.mMol.isRingAtom(n5)) continue;
                nArray[++n4] = n5;
                nArray2[n4] = this.mMol.getConnBond(nArray[i], j);
                nArray3[n5] = nArray3[nArray[i]] + 1;
                nArray4[n4] = i;
            }
        }
        return null;
    }

    private int getSmallestRingSize(int n, int n2, int n3) {
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int[] nArray2 = new int[this.mMol.getAllAtoms()];
        nArray[0] = n2;
        nArray[1] = n;
        nArray2[n2] = 1;
        nArray2[n] = 2;
        int n4 = 1;
        for (int i = 1; i <= n4; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                int n5 = this.mMol.getConnAtom(nArray[i], j);
                if (n5 == n3) {
                    return 1 + nArray2[nArray[i]];
                }
                if (nArray2[n5] != 0 || !this.mMol.isRingAtom(n5)) continue;
                nArray[++n4] = n5;
                nArray2[n5] = nArray2[nArray[i]] + 1;
            }
        }
        return 0;
    }

    private void joinOverlappingFragments() {
        while (true) {
            int n = 0;
            int n2 = 0;
            InventorFragment inventorFragment = null;
            InventorFragment inventorFragment2 = null;
            for (int i = 1; i < this.mFragmentList.size(); ++i) {
                InventorFragment inventorFragment3 = this.mFragmentList.get(i);
                for (int j = 0; j < i; ++j) {
                    int n3;
                    int n4;
                    int n5;
                    InventorFragment inventorFragment4 = this.mFragmentList.get(j);
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    for (n5 = 0; n5 < inventorFragment3.size(); ++n5) {
                        for (n4 = 0; n4 < inventorFragment4.size(); ++n4) {
                            if (inventorFragment3.mGlobalAtom[n5] != inventorFragment4.mGlobalAtom[n4]) continue;
                            ++n7;
                            n6 = inventorFragment3.mGlobalAtom[n5];
                            if (n8 < inventorFragment3.mPriority[n5]) {
                                n8 = inventorFragment3.mPriority[n5];
                            }
                            if (n9 >= inventorFragment4.mPriority[n4]) continue;
                            n9 = inventorFragment4.mPriority[n4];
                        }
                    }
                    if (n7 <= 0) continue;
                    n5 = n7 == 1 && this.getConnAtoms(inventorFragment3, n6) == 1 && this.getConnAtoms(inventorFragment4, n6) == 1 ? 0 : 1;
                    n4 = n8 > n9 ? (n5 << 24) + (n8 << 16) + (n9 << 8) + n7 : (n5 << 24) + (n9 << 16) + (n8 << 8) + n7;
                    if (n >= n4) continue;
                    n = n4;
                    n2 = n7;
                    n8 = 0;
                    n9 = 0;
                    for (n3 = 0; n3 < inventorFragment3.size(); ++n3) {
                        if (n8 >= inventorFragment3.mPriority[n3]) continue;
                        n8 = inventorFragment3.mPriority[n3];
                    }
                    for (n3 = 0; n3 < inventorFragment4.size(); ++n3) {
                        if (n9 >= inventorFragment4.mPriority[n3]) continue;
                        n9 = inventorFragment4.mPriority[n3];
                    }
                    if (n8 > n9) {
                        inventorFragment = inventorFragment3;
                        inventorFragment2 = inventorFragment4;
                        continue;
                    }
                    inventorFragment = inventorFragment4;
                    inventorFragment2 = inventorFragment3;
                }
            }
            if (n == 0) break;
            if (n2 == inventorFragment.size()) {
                this.mFragmentList.remove(inventorFragment);
                continue;
            }
            if (n2 == inventorFragment2.size()) {
                this.mFragmentList.remove(inventorFragment2);
                continue;
            }
            this.joinFragments(inventorFragment, inventorFragment2, n2);
        }
    }

    private void joinFragments(InventorFragment inventorFragment, InventorFragment inventorFragment2, int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < inventorFragment.mGlobalAtom.length; ++i) {
            for (int j = 0; j < inventorFragment2.mGlobalAtom.length; ++j) {
                if (inventorFragment.mGlobalAtom[i] != inventorFragment2.mGlobalAtom[j]) continue;
                nArray[n2++] = inventorFragment.mGlobalAtom[i];
            }
        }
        InventorFragment inventorFragment3 = n == 1 ? this.getFusedFragment(inventorFragment, inventorFragment2, nArray[0]) : this.getFusedFragment(inventorFragment, inventorFragment2, nArray, n);
        this.updateFragmentList(inventorFragment, inventorFragment2, inventorFragment3);
    }

    private InventorFragment getFusedFragment(InventorFragment inventorFragment, InventorFragment inventorFragment2, int n) {
        int n2 = inventorFragment.getLocalAtom(n);
        int n3 = inventorFragment2.getLocalAtom(n);
        inventorFragment2.translate(inventorFragment.mAtomX[n2] - inventorFragment2.mAtomX[n3], inventorFragment.mAtomY[n2] - inventorFragment2.mAtomY[n3]);
        double d = this.suggestNewBondAngle(inventorFragment, n);
        double d2 = this.suggestNewBondAngle(inventorFragment2, n);
        double d3 = 0.0;
        if (this.getConnAtoms(inventorFragment, n) == 1 && this.getConnAtoms(inventorFragment2, n) == 1) {
            d3 = 1.0471975511965976;
        }
        inventorFragment2.rotate(inventorFragment2.mAtomX[n3], inventorFragment2.mAtomY[n3], d - d2 + d3 + Math.PI);
        return this.getMergedFragment(inventorFragment, inventorFragment2, 1);
    }

    private InventorFragment getFusedFragment(InventorFragment inventorFragment, InventorFragment inventorFragment2, int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = inventorFragment.getLocalAtom(nArray[i]);
            nArray3[i] = inventorFragment2.getLocalAtom(nArray[i]);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += inventorFragment.mAtomX[nArray2[i]];
            d2 += inventorFragment.mAtomY[nArray2[i]];
            d3 += inventorFragment2.mAtomX[nArray3[i]];
            d4 += inventorFragment2.mAtomY[nArray3[i]];
        }
        inventorFragment2.translate((d /= (double)n) - (d3 /= (double)n), (d2 /= (double)n) - (d4 /= (double)n));
        InventorAngle[] inventorAngleArray = new InventorAngle[n];
        InventorAngle[] inventorAngleArray2 = new InventorAngle[n];
        InventorAngle[] inventorAngleArray3 = new InventorAngle[n];
        InventorAngle[] inventorAngleArray4 = new InventorAngle[n];
        for (int i = 0; i < n; ++i) {
            inventorAngleArray[i] = new InventorAngle(d, d2, inventorFragment.mAtomX[nArray2[i]], inventorFragment.mAtomY[nArray2[i]]);
            inventorAngleArray2[i] = new InventorAngle(d, d2, inventorFragment2.mAtomX[nArray3[i]], inventorFragment2.mAtomY[nArray3[i]]);
            inventorAngleArray3[i] = new InventorAngle(inventorAngleArray[i].mAngle - inventorAngleArray2[i].mAngle, inventorAngleArray[i].mLength * inventorAngleArray2[i].mLength);
            inventorAngleArray4[i] = new InventorAngle(inventorAngleArray[i].mAngle + inventorAngleArray2[i].mAngle, inventorAngleArray[i].mLength * inventorAngleArray2[i].mLength);
        }
        InventorAngle inventorAngle = CoordinateInventor.getMeanAngle(inventorAngleArray3, n);
        InventorAngle inventorAngle2 = CoordinateInventor.getMeanAngle(inventorAngleArray4, n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.mMol.getAllConnAtoms(nArray[i]); ++j) {
                int n4 = this.mMol.getConnAtom(nArray[i], j);
                if (inventorFragment.isMember(n4) && !inventorFragment2.isMember(n4)) {
                    ++n2;
                }
                if (inventorFragment.isMember(n4) || !inventorFragment2.isMember(n4)) continue;
                ++n3;
            }
        }
        InventorAngle[] inventorAngleArray5 = new InventorAngle[n2];
        InventorAngle[] inventorAngleArray6 = new InventorAngle[n3];
        InventorAngle[] inventorAngleArray7 = new InventorAngle[n3];
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.mMol.getAllConnAtoms(nArray[i]); ++j) {
                int n5;
                int n6 = this.mMol.getConnAtom(nArray[i], j);
                if (inventorFragment.isMember(n6) && !inventorFragment2.isMember(n6)) {
                    n5 = inventorFragment.getLocalAtom(n6);
                    inventorAngleArray5[n2] = new InventorAngle(inventorFragment.mAtomX[nArray2[i]], inventorFragment.mAtomY[nArray2[i]], inventorFragment.mAtomX[n5], inventorFragment.mAtomY[n5]);
                    ++n2;
                }
                if (inventorFragment.isMember(n6) || !inventorFragment2.isMember(n6)) continue;
                n5 = inventorFragment2.getLocalAtom(n6);
                InventorAngle inventorAngle3 = new InventorAngle(inventorFragment2.mAtomX[nArray3[i]], inventorFragment2.mAtomY[nArray3[i]], inventorFragment2.mAtomX[n5], inventorFragment2.mAtomY[n5]);
                inventorAngleArray6[n3] = new InventorAngle(inventorAngle.mAngle + inventorAngle3.mAngle, inventorAngle3.mLength);
                inventorAngleArray7[n3] = new InventorAngle(inventorAngle2.mAngle - inventorAngle3.mAngle, inventorAngle3.mLength);
                ++n3;
            }
        }
        InventorAngle inventorAngle4 = CoordinateInventor.getMeanAngle(inventorAngleArray5, n2);
        InventorAngle inventorAngle5 = CoordinateInventor.getMeanAngle(inventorAngleArray6, n3);
        InventorAngle inventorAngle6 = CoordinateInventor.getMeanAngle(inventorAngleArray7, n3);
        if (Math.abs(this.getAngleDif(inventorAngle4.mAngle, inventorAngle5.mAngle)) > Math.abs(this.getAngleDif(inventorAngle4.mAngle, inventorAngle6.mAngle))) {
            inventorFragment2.rotate(d, d2, inventorAngle.mAngle);
        } else {
            inventorFragment2.flip(d, d2, 0.0);
            inventorFragment2.rotate(d, d2, inventorAngle2.mAngle);
        }
        return this.getMergedFragment(inventorFragment, inventorFragment2, n);
    }

    private InventorFragment getMergedFragment(InventorFragment inventorFragment, InventorFragment inventorFragment2, int n) {
        int n2;
        InventorFragment inventorFragment3 = new InventorFragment(this.mMol, inventorFragment.mGlobalAtom.length + inventorFragment2.mGlobalAtom.length - n, inventorFragment.mKeepMarkedAtoms | inventorFragment2.mKeepMarkedAtoms);
        int n3 = 0;
        for (n2 = 0; n2 < inventorFragment.mGlobalAtom.length; ++n2) {
            inventorFragment3.mGlobalAtom[n3] = inventorFragment.mGlobalAtom[n2];
            inventorFragment3.mPriority[n3] = inventorFragment.mPriority[n2];
            inventorFragment3.mAtomX[n3] = inventorFragment.mAtomX[n2];
            inventorFragment3.mAtomY[n3++] = inventorFragment.mAtomY[n2];
        }
        for (n2 = 0; n2 < inventorFragment2.mGlobalAtom.length; ++n2) {
            int n4 = inventorFragment.getLocalAtom(inventorFragment2.mGlobalAtom[n2]);
            if (n4 == -1) {
                inventorFragment3.mGlobalAtom[n3] = inventorFragment2.mGlobalAtom[n2];
                inventorFragment3.mPriority[n3] = inventorFragment2.mPriority[n2];
                inventorFragment3.mAtomX[n3] = inventorFragment2.mAtomX[n2];
                inventorFragment3.mAtomY[n3++] = inventorFragment2.mAtomY[n2];
                continue;
            }
            if (inventorFragment3.mPriority[n4] >= inventorFragment2.mPriority[n2]) continue;
            inventorFragment3.mPriority[n4] = inventorFragment2.mPriority[n2];
            inventorFragment3.mAtomX[n4] = inventorFragment2.mAtomX[n2];
            inventorFragment3.mAtomY[n4] = inventorFragment2.mAtomY[n2];
        }
        return inventorFragment3;
    }

    private InventorChain getLongestUnhandledChain(int n) {
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int[] nArray2 = new int[this.mMol.getAllAtoms()];
        int[] nArray3 = new int[this.mMol.getAllAtoms()];
        int[] nArray4 = new int[this.mMol.getAllAtoms()];
        nArray[0] = n;
        nArray3[n] = 1;
        nArray4[0] = -1;
        int n2 = 0;
        for (int i = 0; i <= n2; ++i) {
            int n3;
            int n4;
            if (i == 0 || !this.mAtomHandled[nArray[i]]) {
                for (int j = 0; j < this.mMol.getAllConnAtoms(nArray[i]); ++j) {
                    n4 = this.mMol.getConnAtom(nArray[i], j);
                    n3 = this.mMol.getConnBond(nArray[i], j);
                    if (nArray3[n4] != 0 || this.mBondHandled[n3]) continue;
                    nArray[++n2] = n4;
                    nArray2[n2] = n3;
                    nArray3[n4] = nArray3[nArray[i]] + 1;
                    nArray4[n2] = i;
                }
            }
            if (i != n2) continue;
            InventorChain inventorChain = new InventorChain(nArray3[nArray[i]]);
            n4 = i;
            for (n3 = 0; n3 < inventorChain.getChainLength(); ++n3) {
                inventorChain.mAtom[n3] = nArray[n4];
                inventorChain.mBond[n3] = nArray2[n4];
                n4 = nArray4[n4];
            }
            return inventorChain;
        }
        return null;
    }

    private double suggestNewBondAngle(InventorFragment inventorFragment, int n) {
        int n2;
        int n3;
        double[] dArray = new double[this.mMol.getAllConnAtoms(n) + 1];
        int[] nArray = new int[this.mMol.getAllConnAtoms(n) + 1];
        int[] nArray2 = new int[this.mMol.getAllConnAtoms(n) + 1];
        int n4 = inventorFragment.getLocalAtom(n);
        int n5 = 0;
        for (n3 = 0; n3 < this.mMol.getAllConnAtoms(n); ++n3) {
            nArray[n5] = this.mMol.getConnAtom(n, n3);
            nArray2[n5] = this.mMol.getConnBond(n, n3);
            n2 = inventorFragment.getLocalAtom(nArray[n5]);
            if (n2 == -1) continue;
            dArray[n5++] = InventorAngle.getAngle(inventorFragment.mAtomX[n4], inventorFragment.mAtomY[n4], inventorFragment.mAtomX[n2], inventorFragment.mAtomY[n2]);
        }
        if (n5 == 1) {
            return dArray[0] + Math.PI;
        }
        for (n3 = n5 - 1; n3 > 0; --n3) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (!(dArray[n2] > dArray[n2 + 1])) continue;
                double d = dArray[n2];
                dArray[n2] = dArray[n2 + 1];
                dArray[n2 + 1] = d;
                int n6 = nArray[n2];
                nArray[n2] = nArray[n2 + 1];
                nArray[n2 + 1] = n6;
                int n7 = nArray2[n2];
                nArray2[n2] = nArray2[n2 + 1];
                nArray2[n2 + 1] = n7;
            }
        }
        dArray[n5] = dArray[0] + Math.PI * 2;
        nArray[n5] = nArray[0];
        nArray2[n5] = nArray2[0];
        double d = -100.0;
        int n8 = 0;
        for (int i = 0; i < n5; ++i) {
            int n9;
            double d2 = dArray[i + 1] - dArray[i];
            if (n5 > 2 && this.mMol.isRingBond(nArray2[i]) && this.mMol.isRingBond(nArray2[i + 1]) && (n9 = this.getSmallestRingSize(nArray[i], n, nArray[i + 1])) != 0) {
                d2 -= 100.0 - (double)n9;
            }
            if (!(d < d2)) continue;
            d = d2;
            n8 = i;
        }
        return (dArray[n8] + dArray[n8 + 1]) / 2.0;
    }

    private double getAngleDif(double d, double d2) {
        double d3;
        for (d3 = d - d2; d3 < -Math.PI; d3 += Math.PI * 2) {
        }
        while (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    protected static InventorAngle getMeanAngle(InventorAngle[] inventorAngleArray, int n) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += inventorAngleArray[i].mLength * Math.sin(inventorAngleArray[i].mAngle);
            d3 += inventorAngleArray[i].mLength * Math.cos(inventorAngleArray[i].mAngle);
        }
        if (d3 == 0.0) {
            d = d2 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            d = Math.atan(d2 / d3);
            if (d3 < 0.0) {
                d += Math.PI;
            }
        }
        double d4 = Math.sqrt(d2 * d2 + d3 * d3) / (double)n;
        return new InventorAngle(d, d4);
    }

    private int getConnAtoms(InventorFragment inventorFragment, int n) {
        int n2 = 0;
        for (int i = 0; i < this.mMol.getAllConnAtoms(n); ++i) {
            if (!inventorFragment.isMember(this.mMol.getConnAtom(n, i))) continue;
            ++n2;
        }
        return n2;
    }

    private void correctChainEZParities() {
        for (int i = 0; i < this.mFragmentList.size(); ++i) {
            InventorFragment inventorFragment = this.mFragmentList.get(i);
            for (int j = 0; j < inventorFragment.mGlobalBond.length; ++j) {
                int n = inventorFragment.mGlobalBond[j];
                if (this.mMol.getBondOrder(n) != 2) continue;
                if (!(this.mMol.isSmallRingBond(n) || this.mMol.getBondParity(n) != 3 && this.mMol.getBondParity(n) != 0)) {
                    this.mMol.setBondParityUnknownOrNone(n);
                }
                if (this.mMol.isRingBond(n) || this.mMol.getConnAtoms(this.mMol.getBondAtom(0, n)) <= 1 || this.mMol.getConnAtoms(this.mMol.getBondAtom(1, n)) <= 1 || this.mMol.getBondParity(n) != 1 && this.mMol.getBondParity(n) != 2) continue;
                int[] nArray = new int[2];
                int[] nArray2 = new int[2];
                for (int k = 0; k < 2; ++k) {
                    nArray[k] = this.mMol.getMaxAtoms();
                    nArray2[k] = this.mMol.getBondAtom(k, n);
                    for (int i2 = 0; i2 < this.mMol.getAllConnAtoms(nArray2[k]); ++i2) {
                        int n2 = this.mMol.getConnAtom(nArray2[k], i2);
                        if (n2 == this.mMol.getBondAtom(1 - k, n) || nArray[k] <= n2) continue;
                        nArray[k] = n2;
                    }
                }
                double d = InventorAngle.getAngle(inventorFragment.mAtomX[inventorFragment.mGlobalToLocalAtom[nArray2[0]]], inventorFragment.mAtomY[inventorFragment.mGlobalToLocalAtom[nArray2[0]]], inventorFragment.mAtomX[inventorFragment.mGlobalToLocalAtom[nArray2[1]]], inventorFragment.mAtomY[inventorFragment.mGlobalToLocalAtom[nArray2[1]]]);
                double d2 = InventorAngle.getAngle(inventorFragment.mAtomX[inventorFragment.mGlobalToLocalAtom[nArray[0]]], inventorFragment.mAtomY[inventorFragment.mGlobalToLocalAtom[nArray[0]]], inventorFragment.mAtomX[inventorFragment.mGlobalToLocalAtom[nArray2[0]]], inventorFragment.mAtomY[inventorFragment.mGlobalToLocalAtom[nArray2[0]]]);
                double d3 = InventorAngle.getAngle(inventorFragment.mAtomX[inventorFragment.mGlobalToLocalAtom[nArray2[1]]], inventorFragment.mAtomY[inventorFragment.mGlobalToLocalAtom[nArray2[1]]], inventorFragment.mAtomX[inventorFragment.mGlobalToLocalAtom[nArray[1]]], inventorFragment.mAtomY[inventorFragment.mGlobalToLocalAtom[nArray[1]]]);
                if (!(this.getAngleDif(d, d2) < 0.0 ^ this.getAngleDif(d, d3) < 0.0 ^ this.mMol.getBondParity(n) == 2)) continue;
                inventorFragment.flipOneSide(n);
            }
        }
    }

    private void optimizeFragments() {
        int n;
        int[] nArray = this.calculateAtomSymmetries();
        byte[] byArray = new byte[this.mMol.getAllBonds()];
        this.locateFlipBonds(byArray, nArray);
        for (n = 0; n < this.mMol.getAllBonds(); ++n) {
            if (byArray[n] != 2 || !this.mMol.isRingAtom(this.mMol.getBondAtom(0, n)) && !this.mMol.isRingAtom(this.mMol.getBondAtom(1, n))) continue;
            byArray[n] = 3;
        }
        for (n = 0; n < this.mFragmentList.size(); ++n) {
            int n2;
            int n3;
            InventorFragment inventorFragment = this.mFragmentList.get(n);
            ArrayList<int[]> arrayList = inventorFragment.getCollisionList();
            double d = inventorFragment.getCollisionPanalty();
            InventorFragment inventorFragment2 = new InventorFragment(inventorFragment);
            int n4 = -1;
            for (n3 = 0; n3 < 224 && arrayList.size() != 0; ++n3) {
                int n5;
                n2 = this.mRandom.nextInt(arrayList.size());
                int[] nArray2 = arrayList.get(n2);
                int[] nArray3 = this.getShortestConnection(nArray2[0], nArray2[1]);
                int[] nArray4 = new int[nArray3.length];
                int n6 = 0;
                if (n3 < 32) {
                    for (n5 = 1; n5 < nArray3.length - 1; ++n5) {
                        if (byArray[nArray3[n5]] != 3) continue;
                        nArray4[n6++] = nArray3[n5];
                    }
                } else if (n3 < 96) {
                    for (n5 = 1; n5 < nArray3.length - 1; ++n5) {
                        if (byArray[nArray3[n5]] < 2) continue;
                        nArray4[n6++] = nArray3[n5];
                    }
                } else {
                    for (n5 = 1; n5 < nArray3.length - 1; ++n5) {
                        if (byArray[nArray3[n5]] < 1) continue;
                        nArray4[n6++] = nArray3[n5];
                    }
                }
                if (n6 == 0) continue;
                n5 = nArray4[0];
                if (n6 > 1) {
                    while ((n5 = nArray4[this.mRandom.nextInt(n6)]) == n4) {
                    }
                }
                if (n5 == n4) continue;
                n4 = n5;
                inventorFragment.flipOneSide(n5);
                arrayList = inventorFragment.getCollisionList();
                if (!(d > inventorFragment.getCollisionPanalty())) continue;
                d = inventorFragment.getCollisionPanalty();
                inventorFragment2 = new InventorFragment(inventorFragment);
            }
            this.mFragmentList.set(n, inventorFragment2);
            inventorFragment = inventorFragment2;
            n3 = 1;
            do {
                n2 = 9999;
                for (int i = 0; i < inventorFragment.size(); ++i) {
                    int n7 = nArray[inventorFragment.mGlobalAtom[i]];
                    if (n7 == n3) {
                        inventorFragment.optimizeAtomCoordinates(i);
                        continue;
                    }
                    if (n7 <= n3 || n7 >= n2) continue;
                    n2 = n7;
                }
                n3 = n2;
            } while (n2 != 9999);
        }
    }

    private int[] getShortestConnection(int n, int n2) {
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int[] nArray2 = new int[this.mMol.getAllAtoms()];
        int[] nArray3 = new int[this.mMol.getAllAtoms()];
        int[] nArray4 = new int[this.mMol.getAllAtoms()];
        nArray[0] = n2;
        nArray3[n2] = 1;
        nArray4[0] = -1;
        int n3 = 0;
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < this.mMol.getAllConnAtomsPlusMetalBonds(nArray[i]); ++j) {
                int n4 = this.mMol.getConnAtom(nArray[i], j);
                int n5 = this.mMol.getConnBond(nArray[i], j);
                if (n4 == n) {
                    int n6 = nArray3[nArray[i]];
                    int[] nArray5 = new int[n6];
                    nArray5[0] = n5;
                    for (int k = 1; k < n6; ++k) {
                        nArray5[k] = nArray2[i];
                        i = nArray4[i];
                    }
                    return nArray5;
                }
                if (nArray3[n4] != 0) continue;
                nArray[++n3] = n4;
                nArray2[n3] = n5;
                nArray3[n4] = nArray3[nArray[i]] + 1;
                nArray4[n3] = i;
            }
            if (i != n3) continue;
            return null;
        }
        return null;
    }

    private void locateFlipBonds(byte[] byArray, int[] nArray) {
        for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
            int n = this.mMol.getBondAtom(0, i);
            int n2 = this.mMol.getBondAtom(1, i);
            if (this.mMol.isRingBond(i) || this.mMol.getBondOrder(i) != 1 || this.mMol.getAllConnAtoms(n) == 1 || this.mMol.getAllConnAtoms(n2) == 1 || (this.mMode & 4) != 0 && this.mMol.isMarkedAtom(n) && this.mMol.isMarkedAtom(n2)) continue;
            boolean bl = false;
            for (int j = 0; j < 2; ++j) {
                int n3 = this.mMol.getBondAtom(j, i);
                if (this.mMol.getAllConnAtoms(n3) <= 2) continue;
                boolean bl2 = true;
                int n4 = -1;
                for (int k = 0; k < this.mMol.getAllConnAtoms(n3); ++k) {
                    int n5 = this.mMol.getConnAtom(n3, k);
                    if (n5 == this.mMol.getBondAtom(1 - j, i)) continue;
                    if (n4 == -1) {
                        n4 = nArray[n5];
                        continue;
                    }
                    if (n4 == nArray[n5]) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            byArray[i] = (this.mMode & 8) != 0 && this.mMol.isMarkedAtom(n) && this.mMol.isMarkedAtom(n2) ? 1 : 2;
        }
    }

    private int[] calculateAtomSymmetries() {
        int n;
        int n2;
        int n3;
        int n4 = Canonizer.getNeededBits(this.mMol.getAtoms());
        int n5 = 2;
        for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
            n5 = Math.max(n5, this.mMol.getAllConnAtoms(n3));
        }
        n3 = (62 + 2 * n4 + n5 * (n4 + 1)) / 63;
        CanonizerBaseValue[] canonizerBaseValueArray = new CanonizerBaseValue[this.mMol.getAllAtoms()];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            canonizerBaseValueArray[i] = new CanonizerBaseValue(n3);
            canonizerBaseValueArray[i].init(i);
        }
        int[] nArray = new int[this.mMol.getAllAtoms()];
        for (n2 = 0; n2 < this.mMol.getBonds(); ++n2) {
            n = this.mMol.getBondParity(n2);
            if (n != 1 && n != 2) continue;
            canonizerBaseValueArray[this.mMol.getBondAtom(0, n2)].add(n);
            canonizerBaseValueArray[this.mMol.getBondAtom(1, n2)].add(n);
        }
        n = this.consolidateRanks(canonizerBaseValueArray, nArray);
        do {
            n2 = n;
            this.calcNextBaseValues(canonizerBaseValueArray, nArray, n4, n5);
        } while (n2 != (n = this.consolidateRanks(canonizerBaseValueArray, nArray)));
        return nArray;
    }

    private void calcNextBaseValues(CanonizerBaseValue[] canonizerBaseValueArray, int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            int n3;
            int n4;
            for (n4 = 0; n4 < this.mMol.getAllConnAtoms(i); ++n4) {
                int n5;
                n3 = nArray[this.mMol.getConnAtom(i, n4)];
                for (n5 = 0; n5 < n4 && n3 >= nArray2[n5]; ++n5) {
                }
                for (int j = n4; j > n5; --j) {
                    nArray2[j] = nArray2[j - 1];
                }
                nArray2[n5] = n3;
            }
            n4 = this.mMol.getAllConnAtoms(i);
            canonizerBaseValueArray[i].init(i);
            canonizerBaseValueArray[i].add(n, nArray[i]);
            canonizerBaseValueArray[i].add((n2 - n4) * (n + 1), 0L);
            for (n3 = 0; n3 < n4; ++n3) {
                canonizerBaseValueArray[i].add(n + 1, nArray2[n3]);
            }
        }
    }

    private int consolidateRanks(CanonizerBaseValue[] canonizerBaseValueArray, int[] nArray) {
        int n = 0;
        Arrays.sort(canonizerBaseValueArray);
        for (int i = 0; i < canonizerBaseValueArray.length; ++i) {
            if (i == 0 || canonizerBaseValueArray[i].compareTo(canonizerBaseValueArray[i - 1]) != 0) {
                // empty if block
            }
            nArray[canonizerBaseValueArray[i].getAtom()] = ++n;
        }
        return n;
    }

    private void joinMetalBondedFragments() {
        ArrayList<FragmentAssociation> arrayList = this.createMetalBondAssociations();
        while (arrayList != null) {
            FragmentAssociation fragmentAssociation = this.getMaxPriorityAssociation(arrayList);
            this.joinAssociatedFragments(fragmentAssociation, 1.2);
            arrayList = this.createMetalBondAssociations();
        }
    }

    private void joinChargedFragments() {
        FragmentAssociation fragmentAssociation = this.createChargeAssociation();
        while (fragmentAssociation != null) {
            this.joinAssociatedFragments(fragmentAssociation, 1.5);
            fragmentAssociation = this.createChargeAssociation();
        }
    }

    private void joinRemainingFragments() {
        FragmentAssociation fragmentAssociation = this.createDisconnectedAssociation();
        while (fragmentAssociation != null) {
            this.joinAssociatedFragments(fragmentAssociation, 1.8);
            fragmentAssociation = this.createDisconnectedAssociation();
        }
    }

    private void joinAssociatedFragments(FragmentAssociation fragmentAssociation, double d) {
        fragmentAssociation.arrange(d, (this.mMode & 0xC) != 0);
        InventorFragment inventorFragment = this.getMergedFragment(fragmentAssociation.getFragment(0), fragmentAssociation.getFragment(1), 0);
        this.updateFragmentList(fragmentAssociation.getFragment(0), fragmentAssociation.getFragment(1), inventorFragment);
    }

    private FragmentAssociation getMaxPriorityAssociation(ArrayList<FragmentAssociation> arrayList) {
        int n = 0;
        FragmentAssociation fragmentAssociation = null;
        for (FragmentAssociation fragmentAssociation2 : arrayList) {
            if (n >= fragmentAssociation2.getPriority()) continue;
            n = fragmentAssociation2.getPriority();
            fragmentAssociation = fragmentAssociation2;
        }
        return fragmentAssociation;
    }

    private ArrayList<FragmentAssociation> createMetalBondAssociations() {
        ArrayList<FragmentAssociation> arrayList = null;
        FragmentAssociation[][] fragmentAssociationArray = null;
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            int n;
            int n2;
            if (this.mMol.getBondType(i) != 32) continue;
            int n3 = this.mMol.getBondAtom(0, i);
            int n4 = -1;
            for (n2 = 0; n2 < this.mFragmentList.size() && (n4 = this.mFragmentList.get(n2).getLocalAtom(n3)) == -1; ++n2) {
            }
            int n5 = this.mMol.getBondAtom(1, i);
            int n6 = -1;
            for (n = 0; n < this.mFragmentList.size() && (n6 = this.mFragmentList.get(n).getLocalAtom(n5)) == -1; ++n) {
            }
            if (n2 == n) continue;
            if (n2 > n) {
                int n7 = n2;
                n2 = n;
                n = n7;
                n7 = n4;
                n4 = n6;
                n6 = n7;
            }
            if (fragmentAssociationArray == null) {
                fragmentAssociationArray = new FragmentAssociation[this.mFragmentList.size()][];
            }
            if (fragmentAssociationArray[n] == null) {
                fragmentAssociationArray[n] = new FragmentAssociation[n];
            }
            if (fragmentAssociationArray[n][n2] != null) {
                fragmentAssociationArray[n][n2].add(n4, n6);
                continue;
            }
            fragmentAssociationArray[n][n2] = new FragmentAssociation(this.mFragmentList.get(n2), this.mFragmentList.get(n), n4, n6);
            if (arrayList == null) {
                arrayList = new ArrayList<FragmentAssociation>();
            }
            arrayList.add(fragmentAssociationArray[n][n2]);
        }
        return arrayList;
    }

    private FragmentAssociation createChargeAssociation() {
        ArrayList<InventorCharge> arrayList = new ArrayList<InventorCharge>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<InventorCharge> arrayList3 = new ArrayList<InventorCharge>();
        block0: for (InventorFragment object : this.mFragmentList) {
            int n;
            int n2 = 0;
            arrayList3.clear();
            for (int i = 0; i < object.size(); ++i) {
                int n3 = object.getGlobalAtom(i);
                n = this.mUnPairedCharge[n3];
                if (n == 0) continue;
                arrayList3.add(new InventorCharge(object, i, n));
                n2 += n;
            }
            if (n2 == 0) continue;
            Collections.sort(arrayList3, new Comparator<InventorCharge>(){

                @Override
                public int compare(InventorCharge inventorCharge, InventorCharge inventorCharge2) {
                    int n;
                    int n2 = Math.abs(inventorCharge.charge);
                    return n2 < (n = Math.abs(inventorCharge2.charge)) ? -1 : (n2 == n ? 0 : 1);
                }
            });
            for (InventorCharge inventorCharge : arrayList3) {
                if (n2 * inventorCharge.charge <= 0) continue;
                n = Math.abs(n2) >= Math.abs(inventorCharge.charge) ? inventorCharge.charge : n2;
                (n < 0 ? arrayList : arrayList2).add(new InventorCharge(object, inventorCharge.atom, n));
                if ((n2 -= n) != 0) continue;
                continue block0;
            }
        }
        if (arrayList.size() == 0 || arrayList2.size() == 0) {
            return null;
        }
        Collections.sort(arrayList2, new Comparator<InventorCharge>(){

            @Override
            public int compare(InventorCharge inventorCharge, InventorCharge inventorCharge2) {
                int n;
                int n2 = inventorCharge.fragment.size();
                return n2 < (n = inventorCharge.fragment.size()) ? 1 : (n2 == n ? 0 : -1);
            }
        });
        Collections.sort(arrayList, new Comparator<InventorCharge>(){

            @Override
            public int compare(InventorCharge inventorCharge, InventorCharge inventorCharge2) {
                int n;
                int n2 = inventorCharge.fragment.size();
                return n2 < (n = inventorCharge.fragment.size()) ? -1 : (n2 == n ? 0 : 1);
            }
        });
        for (InventorCharge inventorCharge : arrayList2) {
            for (InventorCharge inventorCharge2 : arrayList) {
                if (inventorCharge.charge != -inventorCharge2.charge) continue;
                int n = inventorCharge.fragment.getGlobalAtom(inventorCharge.atom);
                this.mUnPairedCharge[n] = this.mUnPairedCharge[n] - inventorCharge.charge;
                int n4 = inventorCharge2.fragment.getGlobalAtom(inventorCharge2.atom);
                this.mUnPairedCharge[n4] = this.mUnPairedCharge[n4] - inventorCharge2.charge;
                return new FragmentAssociation(inventorCharge.fragment, inventorCharge2.fragment, inventorCharge.atom, inventorCharge2.atom);
            }
        }
        for (InventorCharge inventorCharge : arrayList2) {
            for (InventorCharge inventorCharge3 : arrayList) {
                if (inventorCharge.charge <= -inventorCharge3.charge) continue;
                int n = inventorCharge.fragment.getGlobalAtom(inventorCharge.atom);
                this.mUnPairedCharge[n] = this.mUnPairedCharge[n] + inventorCharge3.charge;
                int n5 = inventorCharge3.fragment.getGlobalAtom(inventorCharge3.atom);
                this.mUnPairedCharge[n5] = this.mUnPairedCharge[n5] - inventorCharge3.charge;
                return new FragmentAssociation(inventorCharge.fragment, inventorCharge3.fragment, inventorCharge.atom, inventorCharge3.atom);
            }
        }
        for (InventorCharge inventorCharge : arrayList2) {
            for (InventorCharge inventorCharge4 : arrayList) {
                if (inventorCharge.charge >= -inventorCharge4.charge) continue;
                int n = inventorCharge.fragment.getGlobalAtom(inventorCharge.atom);
                this.mUnPairedCharge[n] = this.mUnPairedCharge[n] - inventorCharge.charge;
                int n6 = inventorCharge4.fragment.getGlobalAtom(inventorCharge4.atom);
                this.mUnPairedCharge[n6] = this.mUnPairedCharge[n6] + inventorCharge.charge;
                return new FragmentAssociation(inventorCharge.fragment, inventorCharge4.fragment, inventorCharge.atom, inventorCharge4.atom);
            }
        }
        return null;
    }

    private FragmentAssociation createDisconnectedAssociation() {
        if (this.mFragmentList.size() < 2) {
            return null;
        }
        return new FragmentAssociation(this.mFragmentList.get(0), this.mFragmentList.get(1));
    }

    private void updateFragmentList(InventorFragment inventorFragment, InventorFragment inventorFragment2, InventorFragment inventorFragment3) {
        int n = Math.min(this.mFragmentList.indexOf(inventorFragment), this.mFragmentList.indexOf(inventorFragment2));
        this.mFragmentList.add(n, inventorFragment3);
        this.mFragmentList.remove(inventorFragment);
        this.mFragmentList.remove(inventorFragment2);
    }
}

