/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.descriptor.pharmacophoretree.HungarianAlgorithm;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class SymmetryCorrectedRMSDCalculator {
    private Conformer conf1;
    private Conformer conf2;

    public SymmetryCorrectedRMSDCalculator(Conformer conformer, Conformer conformer2) {
        this.conf1 = conformer;
        this.conf2 = conformer2;
    }

    public double calculate() {
        int[][] nArray = this.getAssignments();
        double d = 0.0;
        for (int[] nArray2 : nArray) {
            Coordinates coordinates = this.conf1.getCoordinates(nArray2[0]);
            Coordinates coordinates2 = this.conf2.getCoordinates(nArray2[1]);
            d += coordinates.distanceSquared(coordinates2);
        }
        d /= (double)nArray.length;
        d = Math.sqrt(d);
        return d;
    }

    private int[][] getAssignments() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        StereoMolecule stereoMolecule = new StereoMolecule(this.conf1.getMolecule());
        StereoMolecule stereoMolecule2 = new StereoMolecule(this.conf2.getMolecule());
        stereoMolecule.ensureHelperArrays(15);
        stereoMolecule2.ensureHelperArrays(15);
        Integer[] integerArray = this.getAtomTypes(stereoMolecule);
        Integer[] integerArray2 = this.getAtomTypes(stereoMolecule2);
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, integerArray);
        HashSet hashSet2 = new HashSet();
        Collections.addAll(hashSet2, integerArray2);
        assert (hashSet.equals(hashSet2));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            int n3 = (Integer)iterator.next();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (n2 = 0; n2 < integerArray.length; ++n2) {
                n = integerArray[n2];
                if (n != n3) continue;
                arrayList2.add(n2);
            }
            for (n2 = 0; n2 < integerArray2.length; ++n2) {
                n = integerArray2[n2];
                if (n != n3) continue;
                arrayList3.add(n2);
            }
            assert (arrayList2.size() == arrayList3.size());
            double[][] dArray = new double[arrayList2.size()][arrayList3.size()];
            n = 0;
            Object object = arrayList2.iterator();
            while (object.hasNext()) {
                int n4 = (Integer)object.next();
                int n5 = 0;
                Iterator iterator2 = arrayList3.iterator();
                while (iterator2.hasNext()) {
                    double d;
                    int n6 = (Integer)iterator2.next();
                    dArray[n][n5] = d = this.conf1.getCoordinates(n4).distanceSquared(this.conf2.getCoordinates(n6));
                    ++n5;
                }
                ++n;
            }
            for (Object object2 : object = (Object)HungarianAlgorithm.hgAlgorithm(dArray, "min")) {
                int n7 = (Integer)arrayList2.get((int)object2[0]);
                int n8 = (Integer)arrayList3.get((int)object2[1]);
                arrayList.add(new int[]{n7, n8});
            }
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][2]);
    }

    private Integer[] getAtomTypes(StereoMolecule stereoMolecule) {
        Integer[] integerArray = new Integer[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            integerArray[i] = InteractionAtomTypeCalculator.getAtomType(stereoMolecule, i);
        }
        return integerArray;
    }
}

