/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.calc.Matrix;
import com.actelion.research.chem.Coordinates;
import java.util.Random;

public class Quaternion {
    private double q0;
    private double q1;
    private double q2;
    private double q3;

    public Quaternion(double d, double d2, double d3, double d4) {
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
    }

    public Quaternion(Coordinates coordinates, double d) {
        int n;
        if (d > Math.PI) {
            n = (int)(d / Math.PI);
            d -= (double)n * Math.PI;
        }
        if (d < -Math.PI) {
            n = (int)(Math.abs(d) / Math.PI);
            d += (double)n * Math.PI;
        }
        double d2 = Math.cos(d * 0.5);
        double d3 = Math.sin(d * 0.5);
        this.q0 = d2;
        this.q1 = d3 * coordinates.x;
        this.q2 = d3 * coordinates.y;
        this.q3 = d3 * coordinates.z;
        this.normalize();
    }

    public void normalize() {
        double d = this.normSquared();
        double d2 = Math.sqrt(d);
        this.q0 = this.q0 * 1.0 / d2;
        this.q1 = this.q1 * 1.0 / d2;
        this.q2 = this.q2 * 1.0 / d2;
        this.q3 = this.q3 * 1.0 / d2;
    }

    public void setQ0(double d) {
        this.q0 = d;
    }

    public void setQ1(double d) {
        this.q1 = d;
    }

    public void setQ2(double d) {
        this.q2 = d;
    }

    public void setQ3(double d) {
        this.q3 = d;
    }

    public double getQ0() {
        return this.q0;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getQ3() {
        return this.q3;
    }

    public double normSquared() {
        return this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
    }

    public void multiply(Quaternion quaternion) {
        this.q0 = quaternion.q0 * this.q0 - quaternion.q1 * this.q1 - quaternion.q2 * this.q2 - quaternion.q3 * this.q3;
        this.q1 = quaternion.q0 * this.q1 + quaternion.q1 * this.q0 - quaternion.q2 * this.q3 + quaternion.q3 * this.q2;
        this.q2 = quaternion.q0 * this.q2 + quaternion.q1 * this.q3 + quaternion.q2 * this.q0 - quaternion.q3 * this.q1;
        this.q3 = quaternion.q0 * this.q3 - quaternion.q1 * this.q2 + quaternion.q2 * this.q1 + quaternion.q3 * this.q0;
    }

    public Matrix getRotMatrix() {
        Matrix matrix = new Matrix(3, 3);
        double[][] dArray = matrix.getArray();
        double d = this.q1 * this.q1;
        double d2 = this.q2 * this.q2;
        double d3 = this.q0 * this.q1;
        double d4 = this.q1 * this.q2;
        double d5 = this.q3 * this.q3;
        double d6 = this.q0 * this.q3;
        double d7 = this.q1 * this.q3;
        double d8 = this.q0 * this.q2;
        double d9 = this.q2 * this.q3;
        dArray[0][0] = 1.0 - 2.0 * (d2 + d5);
        dArray[1][0] = 2.0 * (d4 - d6);
        dArray[2][0] = 2.0 * (d7 + d8);
        dArray[0][1] = 2.0 * (d4 + d6);
        dArray[1][1] = 1.0 - 2.0 * (d + d5);
        dArray[2][1] = 2.0 * (d9 - d3);
        dArray[0][2] = 2.0 * (d7 - d8);
        dArray[1][2] = 2.0 * (d9 + d3);
        dArray[2][2] = 1.0 - 2.0 * (d + d2);
        return matrix;
    }

    public static Quaternion getRandomRotation() {
        Random random = new Random();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        boolean bl = true;
        while (bl) {
            d = -1.0 + 2.0 * random.nextDouble();
            d5 = d * d + (d2 = -1.0 + 2.0 * random.nextDouble()) * d2;
            if (!(d5 < 1.0)) continue;
            bl = false;
        }
        bl = true;
        while (bl) {
            d3 = -1.0 + 2.0 * random.nextDouble();
            d6 = d3 * d3 + (d4 = -1.0 + 2.0 * random.nextDouble()) * d4;
            if (!(d6 < 1.0)) continue;
            bl = false;
        }
        double d7 = Math.sqrt((1.0 - d5) / d6);
        return new Quaternion(d, d2, d3 *= d7, d4 *= d7);
    }

    public String toString() {
        String string = this.q0 + " " + this.q1 + " " + this.q2 + " " + this.q3;
        return string;
    }
}

