/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.descriptor.DescriptorHelper;
import java.io.Serializable;

public class StructureSearchSpecification
implements Serializable {
    static final long serialVersionUID = 538051586L;
    private static final int TYPE_MASK = 255;
    public static final int TYPE_NO_STRUCTURE = 0;
    public static final int TYPE_SUBSTRUCTURE = 1;
    public static final int TYPE_SIMILARITY = 2;
    public static final int TYPE_EXACT_STRICT = 3;
    public static final int TYPE_EXACT_NO_STEREO = 4;
    public static final int TYPE_TAUTOMER = 5;
    public static final int TYPE_TAUTOMER_NO_STEREO = 6;
    public static final int TYPE_BACKBONE_NO_STEREO = 7;
    public static final int MODE_LARGEST_FRAGMENT_ONLY = 256;
    private int mSearchType;
    private byte[][] mIDCode;
    private Object[] mDescriptor;
    private String mDescriptorShortName;
    private float mSimilarityThreshold;

    public StructureSearchSpecification(int n, byte[][] byArray, Object[] objectArray, String string, float f) {
        this.mSearchType = n;
        this.mIDCode = byArray;
        this.mDescriptor = objectArray;
        this.mDescriptorShortName = string;
        this.mSimilarityThreshold = f;
    }

    public int getStructureCount() {
        return this.mIDCode == null ? 0 : this.mIDCode.length;
    }

    public byte[] getIDCode(int n) {
        return this.mIDCode[n];
    }

    public Object getDescriptor(int n) {
        return this.mDescriptor == null ? null : this.mDescriptor[n];
    }

    public boolean isSimilaritySearch() {
        return (this.mSearchType & 0xFF) == 2;
    }

    public boolean isNoStructureSearch() {
        return (this.mSearchType & 0xFF) == 0;
    }

    public boolean isSubstructureSearch() {
        return (this.mSearchType & 0xFF) == 1;
    }

    public boolean isExactSearch() {
        return (this.mSearchType & 0xFF) == 3;
    }

    public boolean isNoStereoSearch() {
        return (this.mSearchType & 0xFF) == 4;
    }

    public boolean isTautomerSearch() {
        return (this.mSearchType & 0xFF) == 5;
    }

    public boolean isNoStereoTautomerSearch() {
        return (this.mSearchType & 0xFF) == 6;
    }

    public boolean isBackboneSearch() {
        return (this.mSearchType & 0xFF) == 7;
    }

    public boolean isLargestFragmentOnly() {
        return (this.mSearchType & 0x100) != 0;
    }

    public void removeDescriptors() {
        this.mDescriptor = null;
    }

    public void setLargestFragmentOnly(boolean bl) {
        this.mSearchType &= 0xFFFFFEFF;
        if (bl) {
            this.mSearchType |= 0x100;
        }
    }

    public String getDescriptorShortName() {
        return this.mDescriptorShortName;
    }

    public float getSimilarityThreshold() {
        return this.mSimilarityThreshold;
    }

    public String validate() {
        int n = this.getStructureCount();
        if (n == 0) {
            return "No query structures defined.";
        }
        for (int i = 0; i < n; ++i) {
            if (new IDCodeParser(false).getAtomCount(this.getIDCode(i), 0) != 0) continue;
            return "Empty structure among query structures.";
        }
        if (this.isSimilaritySearch()) {
            if (!DescriptorHelper.isDescriptorShortName(this.getDescriptorShortName())) {
                return "No descriptor type defined.";
            }
            if ((double)this.getSimilarityThreshold() < 0.5 || (double)this.getSimilarityThreshold() > 1.0) {
                return "Similarity threshold out of allowed range.";
            }
        }
        return null;
    }

    public String toString() {
        int n = this.mSearchType & 0xFF;
        String string = (n == 1 ? "substructure" : (n == 2 ? "similarity/" + this.mDescriptorShortName + "(" + this.mSimilarityThreshold + ")" : (n == 3 ? "exact" : (n == 4 ? "noStereo" : (n == 5 ? "tautomer" : (n == 6 ? "no-stereo tautomer" : (n == 7 ? "backbone" : "undefined"))))))) + ((this.mSearchType & 0x100) != 0 ? "/largestFragmentOnly" : "");
        return "type:" + string + (this.mIDCode == null ? " idcodes:null" : (this.mIDCode.length == 1 ? " idcode:" + (this.mIDCode[0] == null ? "null" : new String(this.mIDCode[0])) : " idcodeCount:" + this.mIDCode.length)) + (this.mDescriptor == null ? " descriptors:null" : " descriptorCount:" + this.mDescriptor.length);
    }
}

