/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.calc.ProgressController;
import com.actelion.research.chem.CanonizerUtil;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.StructureSearchController;
import com.actelion.research.chem.StructureSearchDataSource;
import com.actelion.research.chem.StructureSearchSpecification;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorHandlerFactory;
import com.actelion.research.chem.descriptor.DescriptorHandlerLongFFP512;
import com.actelion.research.chem.descriptor.DescriptorHandlerStandard2DFactory;
import com.actelion.research.util.ByteArrayComparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class StructureSearch {
    private volatile StructureSearchSpecification mSpecification;
    private volatile StructureSearchDataSource mDataSource;
    private volatile StructureSearchController mSearchController;
    private volatile ProgressController mProgressController;
    private volatile StereoMolecule[] mQueryFragment;
    private volatile ByteArrayComparator mIDCodeComparator;
    private volatile DescriptorHandler mDescriptorHandler;
    private volatile Object[] mQueryDescriptor;
    private volatile long[] mQueryHashCode;
    private volatile byte[][] mQueryIDCode;
    private volatile int mDescriptorColumn;
    private volatile int mMaxSSSMatches;
    private volatile int mMaxNonSSSMatches;
    private ConcurrentLinkedQueue<Integer> mResultQueue;
    private AtomicInteger mSMPIndex;
    private AtomicInteger mMatchCount;

    public StructureSearch(StructureSearchSpecification structureSearchSpecification, StructureSearchDataSource structureSearchDataSource, StructureSearchController structureSearchController, ProgressController progressController, DescriptorHandlerFactory descriptorHandlerFactory) {
        this.mSpecification = structureSearchSpecification;
        this.mDataSource = structureSearchDataSource;
        this.mSearchController = structureSearchController;
        this.mProgressController = progressController;
        if (this.mSpecification != null) {
            if (this.mSpecification.isSimilaritySearch()) {
                DescriptorHandlerFactory descriptorHandlerFactory2 = descriptorHandlerFactory != null ? descriptorHandlerFactory : DescriptorHandlerStandard2DFactory.getFactory();
                this.mDescriptorHandler = descriptorHandlerFactory2.getDefaultDescriptorHandler(structureSearchSpecification.getDescriptorShortName());
            } else if (this.mSpecification.isSubstructureSearch()) {
                this.mDescriptorHandler = DescriptorHandlerLongFFP512.getDefaultInstance();
            }
        }
    }

    public void setMatchLimit(int n, int n2) {
        this.mMaxSSSMatches = n;
        this.mMaxNonSSSMatches = n2;
    }

    public int[] start() {
        int n;
        int n2;
        int n3;
        if (!this.mDataSource.isSupportedSearchType(this.mSpecification)) {
            return null;
        }
        this.mMatchCount = new AtomicInteger(0);
        if (!this.mSpecification.isNoStructureSearch()) {
            n3 = this.mSpecification.getStructureCount();
            if (n3 == 0) {
                return null;
            }
            this.mDescriptorColumn = -1;
            boolean bl = this.mSpecification.isLargestFragmentOnly();
            if (this.mSpecification.isSubstructureSearch() || this.mSpecification.isSimilaritySearch()) {
                if (this.mSpecification.isSubstructureSearch()) {
                    this.mDescriptorColumn = this.mDataSource.getDescriptorColumn(DescriptorConstants.DESCRIPTOR_FFP512.shortName);
                    this.mQueryFragment = new StereoMolecule[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.mQueryFragment[n2] = new IDCodeParser(false).getCompactMolecule(this.mSpecification.getIDCode(n2));
                        this.mQueryFragment[n2].ensureHelperArrays(15);
                    }
                } else {
                    String string = this.mSpecification.getDescriptorShortName();
                    this.mDescriptorColumn = string == null ? -1 : this.mDataSource.getDescriptorColumn(string);
                }
                this.mQueryDescriptor = new Object[n3];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    this.mQueryDescriptor[n] = this.mSpecification.getDescriptor(n);
                    if (this.mQueryDescriptor[n] != null) continue;
                    n2 = 1;
                }
                if (n2 != 0) {
                    this.calculateQueryDescriptorsAndWait();
                }
            } else if (this.mSpecification.isExactSearch()) {
                this.mIDCodeComparator = new ByteArrayComparator();
                this.mQueryIDCode = new byte[n3][];
                for (n2 = 0; n2 < n3; ++n2) {
                    if (bl) {
                        StereoMolecule stereoMolecule = new IDCodeParser(true).getCompactMolecule(this.mSpecification.getIDCode(n2));
                        this.mQueryIDCode[n2] = CanonizerUtil.getIDCode(stereoMolecule, CanonizerUtil.IDCODE_TYPE.NORMAL, bl).getBytes();
                        continue;
                    }
                    this.mQueryIDCode[n2] = this.mSpecification.getIDCode(n2);
                }
            } else if (this.mSpecification.isNoStereoSearch()) {
                this.mQueryHashCode = new long[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mQueryHashCode[n2] = CanonizerUtil.getNoStereoHash(new IDCodeParser(false).getCompactMolecule(this.mSpecification.getIDCode(n2)), bl);
                }
            } else if (this.mSpecification.isTautomerSearch()) {
                this.mQueryHashCode = new long[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mQueryHashCode[n2] = CanonizerUtil.getTautomerHash(new IDCodeParser(true).getCompactMolecule(this.mSpecification.getIDCode(n2)), bl);
                }
            } else if (this.mSpecification.isNoStereoTautomerSearch()) {
                this.mQueryHashCode = new long[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mQueryHashCode[n2] = CanonizerUtil.getNoStereoTautomerHash(new IDCodeParser(false).getCompactMolecule(this.mSpecification.getIDCode(n2)), bl);
                }
            } else if (this.mSpecification.isBackboneSearch()) {
                this.mQueryHashCode = new long[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mQueryHashCode[n2] = CanonizerUtil.getBackboneHash(new IDCodeParser(false).getCompactMolecule(this.mSpecification.getIDCode(n2)), bl);
                }
            }
        }
        this.mSMPIndex = new AtomicInteger(this.mDataSource.getRowCount());
        this.mResultQueue = new ConcurrentLinkedQueue();
        if (this.mProgressController != null && this.mSpecification.getStructureCount() > 1023) {
            this.mProgressController.startProgress("Searching structures", 0, this.mSpecification.getStructureCount());
        }
        n3 = Runtime.getRuntime().availableProcessors();
        SearchThread[] searchThreadArray = new SearchThread[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            searchThreadArray[n2] = new SearchThread("Structure Search " + (n2 + 1));
            searchThreadArray[n2].setPriority(1);
            searchThreadArray[n2].start();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                searchThreadArray[n2].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int[] nArray = new int[this.mResultQueue.size()];
        n = 0;
        for (Integer n4 : this.mResultQueue) {
            nArray[n++] = n4;
        }
        return nArray;
    }

    private void calculateQueryDescriptorsAndWait() {
        int n;
        this.mSMPIndex = new AtomicInteger(this.mQueryDescriptor.length);
        int n2 = Math.min(this.mQueryDescriptor.length, Runtime.getRuntime().availableProcessors());
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            threadArray[n] = new Thread("Query Descriptor Calculation " + (n + 1)){

                @Override
                public void run() {
                    int n;
                    while ((n = StructureSearch.this.mSMPIndex.decrementAndGet()) >= 0) {
                        StereoMolecule stereoMolecule = new IDCodeParser(false).getCompactMolecule(StructureSearch.this.mSpecification.getIDCode(n));
                        ((StructureSearch)StructureSearch.this).mQueryDescriptor[n] = StructureSearch.this.mDescriptorHandler.createDescriptor(stereoMolecule);
                    }
                }
            };
            threadArray[n].setPriority(1);
            threadArray[n].start();
        }
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class SearchThread
    extends Thread {
        private SSSearcherWithIndex mSSSearcher;

        public SearchThread(String string) {
            super(string);
            if (StructureSearch.this.mSpecification.isSubstructureSearch()) {
                this.mSSSearcher = new SSSearcherWithIndex();
            }
        }

        @Override
        public void run() {
            int n = StructureSearch.this.mSMPIndex.decrementAndGet();
            while (!(n < 0 || StructureSearch.this.mProgressController != null && StructureSearch.this.mProgressController.threadMustDie())) {
                if (StructureSearch.this.mProgressController != null && n % 1024 == 1023) {
                    StructureSearch.this.mProgressController.updateProgress(StructureSearch.this.mSpecification.getStructureCount() - n);
                }
                if (StructureSearch.this.mSearchController == null || StructureSearch.this.mSearchController.rowQualifies(n)) {
                    int n2;
                    int n3;
                    boolean bl = false;
                    if (StructureSearch.this.mSpecification.isSubstructureSearch()) {
                        if (StructureSearch.this.mMaxSSSMatches != 0 && StructureSearch.this.mMatchCount.get() > StructureSearch.this.mMaxSSSMatches) break;
                        block1: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                            this.mSSSearcher.setMolecule(StructureSearch.this.mDataSource.getIDCode(n, n3, false), (long[])StructureSearch.this.mDataSource.getDescriptor(StructureSearch.this.mDescriptorColumn, n, n3, false));
                            for (n2 = 0; n2 < StructureSearch.this.mQueryFragment.length; ++n2) {
                                this.mSSSearcher.setFragment(StructureSearch.this.mQueryFragment[n2], (long[])StructureSearch.this.mQueryDescriptor[n2]);
                                if (!this.mSSSearcher.isFragmentInMolecule()) continue;
                                bl = true;
                                continue block1;
                            }
                        }
                    } else {
                        if (StructureSearch.this.mMaxNonSSSMatches != 0 && StructureSearch.this.mMatchCount.get() > StructureSearch.this.mMaxNonSSSMatches) break;
                        if (StructureSearch.this.mSpecification.isNoStructureSearch()) {
                            bl = true;
                        } else if (StructureSearch.this.mSpecification.isSimilaritySearch()) {
                            block3: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                                for (n2 = 0; n2 < StructureSearch.this.mQueryDescriptor.length; ++n2) {
                                    if (!(StructureSearch.this.mDescriptorHandler.getSimilarity(StructureSearch.this.mQueryDescriptor[n2], StructureSearch.this.mDataSource.getDescriptor(StructureSearch.this.mDescriptorColumn, n, n3, StructureSearch.this.mSpecification.isLargestFragmentOnly())) >= StructureSearch.this.mSpecification.getSimilarityThreshold())) continue;
                                    bl = true;
                                    continue block3;
                                }
                            }
                        } else if (StructureSearch.this.mSpecification.isExactSearch()) {
                            block5: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                                for (n2 = 0; n2 < StructureSearch.this.mQueryIDCode.length; ++n2) {
                                    if (StructureSearch.this.mIDCodeComparator.compare(StructureSearch.this.mQueryIDCode[n2], StructureSearch.this.mDataSource.getIDCode(n, n3, StructureSearch.this.mSpecification.isLargestFragmentOnly())) != 0) continue;
                                    bl = true;
                                    continue block5;
                                }
                            }
                        } else if (StructureSearch.this.mSpecification.isNoStereoSearch()) {
                            block7: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                                for (n2 = 0; n2 < StructureSearch.this.mQueryHashCode.length; ++n2) {
                                    if (StructureSearch.this.mQueryHashCode[n2] == 0L || StructureSearch.this.mQueryHashCode[n2] != StructureSearch.this.mDataSource.getNoStereoCode(n, n3, StructureSearch.this.mSpecification.isLargestFragmentOnly())) continue;
                                    bl = true;
                                    continue block7;
                                }
                            }
                        } else if (StructureSearch.this.mSpecification.isTautomerSearch()) {
                            block9: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                                for (n2 = 0; n2 < StructureSearch.this.mQueryHashCode.length; ++n2) {
                                    if (StructureSearch.this.mQueryHashCode[n2] == 0L || StructureSearch.this.mQueryHashCode[n2] != StructureSearch.this.mDataSource.getTautomerCode(n, n3, StructureSearch.this.mSpecification.isLargestFragmentOnly())) continue;
                                    bl = true;
                                    continue block9;
                                }
                            }
                        } else if (StructureSearch.this.mSpecification.isNoStereoTautomerSearch()) {
                            block11: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                                for (n2 = 0; n2 < StructureSearch.this.mQueryHashCode.length; ++n2) {
                                    if (StructureSearch.this.mQueryHashCode[n2] == 0L || StructureSearch.this.mQueryHashCode[n2] != StructureSearch.this.mDataSource.getNoStereoTautomerCode(n, n3, StructureSearch.this.mSpecification.isLargestFragmentOnly())) continue;
                                    bl = true;
                                    continue block11;
                                }
                            }
                        } else if (StructureSearch.this.mSpecification.isBackboneSearch()) {
                            block13: for (n3 = 0; !bl && n3 < StructureSearch.this.mDataSource.getStructureCount(n); ++n3) {
                                for (n2 = 0; n2 < StructureSearch.this.mQueryHashCode.length; ++n2) {
                                    if (StructureSearch.this.mQueryHashCode[n2] == 0L || StructureSearch.this.mQueryHashCode[n2] != StructureSearch.this.mDataSource.getBackboneCode(n, n3, StructureSearch.this.mSpecification.isLargestFragmentOnly())) continue;
                                    bl = true;
                                    continue block13;
                                }
                            }
                        }
                    }
                    if (bl) {
                        StructureSearch.this.mResultQueue.add(new Integer(n));
                        StructureSearch.this.mMatchCount.incrementAndGet();
                    }
                }
                n = StructureSearch.this.mSMPIndex.decrementAndGet();
            }
        }
    }
}

