/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import java.util.ArrayList;

public class NastyFunctionDetector {
    public static final String[] cNastyFunctionsUnknown = null;
    public static final String[][] sNastyFunction = new String[][]{{"gGP@LdbKT`]RMdmGJFCPpWN@PBJpd@", "polar activated DB"}, {"gGP@DjVePNlFJXhypB@Q\\xA@HjlPd@", "twice activated DB"}, {"eM@HvCjFtQ[N@PBDiBHqJrlD@", "acyl-halogenide type"}, {"eFBJHcAbc\\@axABIVVQFIV@", "Cl,Br,I on N,O,P,S,Se,I"}, {"gC`HADIKRAuHubL", "allyl/benzyl chloride"}, {"eM@HzCBKUFTqJp", "prim. alkyl-bromide/iodide"}, {"gC`@H}PFrbcLfIV@", "sec./tert. alkyl-bromide/iodide"}, {"gC`hH`DIVtAuL`", "alkyl sulfonate/sulfate type"}, {"gJQ`@bdjt`P", "anhydride"}, {"gJXA@IczhB", "quart. ammonium"}, {"gChA@Icm@P", "tert. immonium"}, {"fHT`P", "carbenium"}, {"gCh`hEIWILtAuM@", "aromatic nitro"}, {"gCd@Adeb@p`}M@", "1,2-diamino-aryl"}, {"gJT@@TeXHCA@`", "1,3-diamino-aryl"}, {"gGT@ATeV@`LDJ", "1,4-diamino-aryl"}, {"gCd@ADiZDEsA@", "azo"}, {"gJU@h`NdiLsPdh", "azoxy"}, {"eMPRIncTH", "diazo"}, {"eMPRI^cxH", "diazo"}, {"gJT@@Te^lB", "1,1-dinitrile"}, {"eMHAIhLDhsW@H^@Pb@", "formaldehyde aduct"}, {"eO@HyjCYJLipB@", "oxiran/aziridine"}, {"eMPBchLDkR", "hydrazine"}, {"eM`AITLYs`D@`", "isocyanate type"}, {"fH@MjM~@p\\@aHZA`x^@QDYAQbU`", "unwanted atom"}, {"fHw`dB", "phosphonium"}, {"gCi@hAteIi`H", "nitrone"}, {"eMhHRVCZP", "nitroso"}, {"gCa`@lduPD", "orthoester/acid"}, {"eFDBcA@", "peroxo"}, {"gGY@HDiViPMdmEGN@PBKg@HA@", "N-acyloxy-amide"}, {"gC`@H{PFJVQFIV[HcDk@", "1,1-dihalo-alkene"}, {"gC`@DiZDEbedQbUfrHqJp", "1,2-dihalo-alkene"}, {"fIRPNj@", "pyrylium"}, {"gCaHHGAIZPMXb@", "silylenol-ether"}, {"gCd@ADie@y``", "dimethylene-hydrazine"}, {"eMPARZCJg}T@", "methanediamine"}, {"daFD`Bs`BLdTTIUSRpA@", "limit! methylene-thiazolidine-2,4-dione"}, {"gOtHLPDISOkSM@XP`", "limit! thiazol-2-ylamine"}, {"gGU@DPdsmRAeDx", "acyl-hydrazone"}, {"gCh@@eKP`lIIROFIFC`@", "imine/hydrazone of aldehyde"}, {"deUD@BxIrJJKPlKTmL@ZqP`", "2,3-diamino-quinone"}, {"difL@DBarJIPhfZif@LHh", "limit! 4-acyl-3-azoline-2-one-3-ol"}, {"gGT`EPTfyi`H", "limit! oxal-diamide"}, {"daED@DpFRYUJfjV@H", "limit! 5-methylene-imidazolidine-2,4-dione"}, {"gJQ@@dls@XpyDXeX", "2-halo-enone"}, {"gJQ@@djsBJqarHqJp", "3-halo-enone"}, {"gCd`i`iJyIf`H", "N-nitro"}, {"gChHD@aIf`LYdXN@", "thio-amide/urea"}};
    private static StereoMolecule[] sFragmentList;
    private static long[][] sIndexList;
    private static boolean sInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NastyFunctionDetector() {
        Class<NastyFunctionDetector> clazz = NastyFunctionDetector.class;
        synchronized (NastyFunctionDetector.class) {
            if (!sInitialized) {
                try {
                    sFragmentList = new StereoMolecule[sNastyFunction.length];
                    sIndexList = new long[sNastyFunction.length][];
                    SSSearcherWithIndex sSSearcherWithIndex = new SSSearcherWithIndex(1);
                    for (int i = 0; i < sNastyFunction.length; ++i) {
                        NastyFunctionDetector.sFragmentList[i] = new IDCodeParser(false).getCompactMolecule(sNastyFunction[i][0]);
                        NastyFunctionDetector.sIndexList[i] = sSSearcherWithIndex.createLongIndex(sFragmentList[i]);
                    }
                    sInitialized = true;
                }
                catch (Exception exception) {
                    System.out.println("Unable to initialize NastyFunctionDetector");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String[] getNastyFunctionList(StereoMolecule stereoMolecule, long[] lArray) {
        if (!sInitialized) {
            return cNastyFunctionsUnknown;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        SSSearcherWithIndex sSSearcherWithIndex = new SSSearcherWithIndex(1);
        sSSearcherWithIndex.setMolecule(stereoMolecule, lArray);
        for (int i = 0; i < sNastyFunction.length; ++i) {
            sSSearcherWithIndex.setFragment(sFragmentList[i], sIndexList[i]);
            if (!sSSearcherWithIndex.isFragmentInMolecule()) continue;
            arrayList.add(sNastyFunction[i][1]);
        }
        this.addPolyHaloAromaticRings(stereoMolecule, arrayList);
        return arrayList.toArray(new String[0]);
    }

    public String getNastyFunctionString(StereoMolecule stereoMolecule, long[] lArray) {
        String[] stringArray = this.getNastyFunctionList(stereoMolecule, lArray);
        if (stringArray == null) {
            return "initialization error";
        }
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append("; " + stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private void addPolyHaloAromaticRings(StereoMolecule stereoMolecule, ArrayList<String> arrayList) {
        RingCollection ringCollection = stereoMolecule.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (!ringCollection.isAromatic(i)) continue;
            int n = 0;
            int[] nArray = ringCollection.getRingAtoms(i);
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < stereoMolecule.getConnAtoms(nArray[j]); ++k) {
                    int n2 = stereoMolecule.getConnAtom(nArray[j], k);
                    if (stereoMolecule.isRingAtom(n2) || stereoMolecule.getAtomicNo(n2) != 9 && stereoMolecule.getAtomicNo(n2) != 17 && stereoMolecule.getAtomicNo(n2) != 35 && stereoMolecule.getAtomicNo(n2) != 53) continue;
                    ++n;
                }
            }
            if (n <= 2) continue;
            arrayList.add("polyhalo aromatic ring");
        }
    }
}

