/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MolfileCreator {
    private static final float TARGET_AVBL = 1.5f;
    private StringBuilder mBuilder;
    private DecimalFormat mDoubleFormat = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.ENGLISH));

    public MolfileCreator(ExtendedMolecule extendedMolecule) {
        this(extendedMolecule, true);
    }

    public MolfileCreator(ExtendedMolecule extendedMolecule, boolean bl) {
        this(extendedMolecule, bl, new StringBuilder(32768));
    }

    public MolfileCreator(ExtendedMolecule extendedMolecule, boolean bl, StringBuilder stringBuilder) {
        this(extendedMolecule, bl, 0.0, stringBuilder);
    }

    public MolfileCreator(ExtendedMolecule extendedMolecule, boolean bl, double d, StringBuilder stringBuilder) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        String string = System.lineSeparator();
        extendedMolecule.ensureHelperArrays(15);
        boolean bl2 = true;
        for (n8 = 0; n8 < extendedMolecule.getAtoms(); ++n8) {
            if (extendedMolecule.getAtomParity(n8) == 0 || extendedMolecule.getAtomParity(n8) == 3 || extendedMolecule.getAtomESRType(n8) == 1) continue;
            bl2 = false;
            break;
        }
        n8 = -1;
        if (bl2) {
            object = new int[32];
            n7 = 0;
            for (n6 = 0; n6 < extendedMolecule.getAtoms(); ++n6) {
                int n9;
                if (extendedMolecule.getAtomParity(n6) == 0 || extendedMolecule.getAtomParity(n6) == 3 || extendedMolecule.getAtomESRType(n6) != 1) continue;
                int n10 = n9 = extendedMolecule.getAtomESRGroup(n6);
                object[n10] = object[n10] + 1;
                if (n7 >= object[n9]) break;
                n7 = object[n9];
                n8 = n9;
                break;
            }
        }
        this.mBuilder = stringBuilder == null ? new StringBuilder() : stringBuilder;
        object = extendedMolecule.getName() != null ? extendedMolecule.getName() : "";
        this.mBuilder.append((String)object + string);
        this.mBuilder.append("Actelion Java MolfileCreator 1.0" + string + string);
        this.appendThreeDigitInt(extendedMolecule.getAllAtoms());
        this.appendThreeDigitInt(extendedMolecule.getAllBonds());
        this.mBuilder.append("  0  0");
        this.appendThreeDigitInt(!bl2 ? 1 : 0);
        this.mBuilder.append("  0  0  0  0  0999 V2000" + string);
        n7 = extendedMolecule.getAllAtoms() == 1 ? 1 : 0;
        for (n6 = 1; n6 < extendedMolecule.getAllAtoms(); ++n6) {
            if (extendedMolecule.getAtomX(n6) == extendedMolecule.getAtomX(0) && extendedMolecule.getAtomY(n6) == extendedMolecule.getAtomY(0) && extendedMolecule.getAtomZ(n6) == extendedMolecule.getAtomZ(0)) continue;
            n7 = 1;
            break;
        }
        double d2 = 1.0;
        if (n7 != 0) {
            if (d != 0.0) {
                d2 = d;
            } else if (bl) {
                double d3 = extendedMolecule.getAverageBondLength();
                if (d3 != 0.0) {
                    if (d3 < 1.0 || d3 > 3.0) {
                        d2 = 1.5 / d3;
                    }
                } else {
                    double d4 = Double.MAX_VALUE;
                    for (n5 = 1; n5 < extendedMolecule.getAllAtoms(); ++n5) {
                        for (n4 = 0; n4 < n5; ++n4) {
                            double d5;
                            double d6;
                            double d7 = extendedMolecule.getAtomX(n4) - extendedMolecule.getAtomX(n5);
                            double d8 = d7 * d7 + (d6 = extendedMolecule.getAtomY(n4) - extendedMolecule.getAtomY(n5)) * d6 + (d5 = extendedMolecule.getAtomZ(n4) - extendedMolecule.getAtomZ(n5)) * d5;
                            if (!(d4 > d8)) continue;
                            d4 = d8;
                        }
                    }
                    d2 = 3.0 / d4;
                }
            }
        }
        for (n3 = 0; n3 < extendedMolecule.getAllAtoms(); ++n3) {
            if (n7 != 0) {
                this.appendTenDigitDouble(d2 * extendedMolecule.getAtomX(n3));
                this.appendTenDigitDouble(d2 * -extendedMolecule.getAtomY(n3));
                this.appendTenDigitDouble(d2 * -extendedMolecule.getAtomZ(n3));
            } else {
                this.mBuilder.append("    0.0000    0.0000    0.0000");
            }
            if (extendedMolecule.getAtomList(n3) != null) {
                this.mBuilder.append(" L  ");
            } else if ((extendedMolecule.getAtomQueryFeatures(n3) & 1L) != 0L) {
                this.mBuilder.append(" A  ");
            } else if (extendedMolecule.getAtomicNo(n3) >= 129 && extendedMolecule.getAtomicNo(n3) <= 144 || extendedMolecule.getAtomicNo(n3) == 154) {
                this.mBuilder.append(" R# ");
            } else {
                String string2 = extendedMolecule.getAtomLabel(n3);
                this.mBuilder.append(" " + string2);
                if (string2.length() == 1) {
                    this.mBuilder.append("  ");
                } else if (string2.length() == 2) {
                    this.mBuilder.append(" ");
                }
            }
            this.mBuilder.append(" 0  0  0");
            long l = 0x780L & extendedMolecule.getAtomQueryFeatures(n3);
            if (l == 0L) {
                this.mBuilder.append("  0");
            } else if (l == 384L) {
                this.mBuilder.append("  3");
            } else if (l == 128L) {
                this.mBuilder.append("  2");
            } else if (l == 1792L) {
                this.mBuilder.append("  1");
            } else if (l == 1664L) {
                this.mBuilder.append("  2");
            }
            this.mBuilder.append((extendedMolecule.getAtomQueryFeatures(n3) & 0x2000L) != 0L ? "  1" : "  0");
            n2 = extendedMolecule.getAtomAbnormalValence(n3);
            if (n2 == -1) {
                this.mBuilder.append("  0");
            } else if (n2 == 0) {
                this.mBuilder.append(" 15");
            } else {
                this.appendThreeDigitInt(n2);
            }
            this.mBuilder.append("  0  0  0");
            this.appendThreeDigitInt(extendedMolecule.getAtomMapNo(n3));
            this.mBuilder.append("  0  0" + string);
        }
        for (n3 = 0; n3 < extendedMolecule.getAllBonds(); ++n3) {
            int n11;
            int n12;
            switch (extendedMolecule.getBondType(n3)) {
                case 1: {
                    n12 = 1;
                    n11 = 0;
                    break;
                }
                case 2: {
                    n12 = 2;
                    n11 = 0;
                    break;
                }
                case 4: {
                    n12 = 3;
                    n11 = 0;
                    break;
                }
                case 129: {
                    n12 = 1;
                    n11 = 6;
                    break;
                }
                case 257: {
                    n12 = 1;
                    n11 = 1;
                    break;
                }
                case 386: {
                    n12 = 2;
                    n11 = 3;
                    break;
                }
                case 64: {
                    n12 = 4;
                    n11 = 0;
                    break;
                }
                case 32: {
                    n12 = 8;
                    n11 = 0;
                    break;
                }
                default: {
                    n12 = 1;
                    n11 = 0;
                }
            }
            if (bl2 && (n11 == 1 || n11 == 6)) {
                n2 = extendedMolecule.getBondAtom(0, n3);
                if (extendedMolecule.getAtomESRType(n2) == 2) {
                    n11 = 0;
                } else if (extendedMolecule.getAtomESRType(n2) == 1 && extendedMolecule.getAtomESRGroup(n2) != n8) {
                    n11 = 4;
                }
            }
            if ((n2 = extendedMolecule.getBondQueryFeatures(n3) & 0x1F) != 0) {
                n12 = n2 == 8 ? 4 : (n2 == 3 ? 5 : (n2 == 9 ? 6 : (n2 == 10 ? 7 : 8)));
            }
            n4 = (n5 = extendedMolecule.getBondQueryFeatures(n3) & 0x180) == 0 ? 0 : (n5 == 256 ? 1 : 2);
            this.appendThreeDigitInt(1 + extendedMolecule.getBondAtom(0, n3));
            this.appendThreeDigitInt(1 + extendedMolecule.getBondAtom(1, n3));
            this.appendThreeDigitInt(n12);
            this.appendThreeDigitInt(n11);
            this.mBuilder.append("  0");
            this.appendThreeDigitInt(n4);
            this.mBuilder.append("  0" + string);
        }
        n3 = 0;
        for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
            if (extendedMolecule.getAtomCharge(n) == 0) continue;
            ++n3;
        }
        if (n3 != 0) {
            n = 0;
            for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
                if (extendedMolecule.getAtomCharge(i) == 0) continue;
                if (n == 0) {
                    this.mBuilder.append("M  CHG");
                    this.appendThreeDigitInt(Math.min(8, n3));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(i + 1);
                n2 = extendedMolecule.getAtomCharge(i);
                if (n2 < 0) {
                    this.mBuilder.append("  -");
                    n2 = -n2;
                } else {
                    this.mBuilder.append("   ");
                }
                this.mBuilder.append((char)(48 + n2));
                if (++n != 8 && --n3 != 0) continue;
                n = 0;
                this.mBuilder.append(string);
            }
        }
        n3 = 0;
        for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
            if (extendedMolecule.isNaturalAbundance(n)) continue;
            ++n3;
        }
        if (n3 != 0) {
            n = 0;
            for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
                if (extendedMolecule.isNaturalAbundance(i)) continue;
                if (n == 0) {
                    this.mBuilder.append("M  ISO");
                    this.appendThreeDigitInt(Math.min(8, n3));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(i + 1);
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(extendedMolecule.getAtomMass(i));
                if (++n != 8 && --n3 != 0) continue;
                n = 0;
                this.mBuilder.append(string);
            }
        }
        n3 = 0;
        for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
            if (extendedMolecule.getAtomRadical(n) == 0) continue;
            ++n3;
        }
        if (n3 != 0) {
            n = 0;
            for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
                if (extendedMolecule.getAtomRadical(i) == 0) continue;
                if (n == 0) {
                    this.mBuilder.append("M  RAD");
                    this.appendThreeDigitInt(Math.min(8, n3));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(i + 1);
                switch (extendedMolecule.getAtomRadical(i)) {
                    case 16: {
                        this.mBuilder.append("   1");
                        break;
                    }
                    case 32: {
                        this.mBuilder.append("   2");
                        break;
                    }
                    case 48: {
                        this.mBuilder.append("   3");
                    }
                }
                if (++n != 8 && --n3 != 0) continue;
                n = 0;
                this.mBuilder.append(string);
            }
        }
        n3 = 0;
        for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
            if ((extendedMolecule.getAtomicNo(n) < 129 || extendedMolecule.getAtomicNo(n) > 144) && extendedMolecule.getAtomicNo(n) != 154) continue;
            ++n3;
        }
        if (n3 != 0) {
            n = 0;
            for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
                n2 = extendedMolecule.getAtomicNo(i);
                if ((n2 < 129 || n2 > 144) && n2 != 154) continue;
                if (n == 0) {
                    this.mBuilder.append("M  RGP");
                    this.appendThreeDigitInt(Math.min(8, n3));
                }
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(i + 1);
                this.mBuilder.append(" ");
                this.appendThreeDigitInt(n2 == 154 ? 0 : (n2 >= 142 ? n2 - 141 : n2 - 125));
                if (++n != 8 && --n3 != 0) continue;
                n = 0;
                this.mBuilder.append(string);
            }
        }
        if (extendedMolecule.isFragment()) {
            n3 = 0;
            for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
                if ((extendedMolecule.getAtomQueryFeatures(n) & 0x78L) == 0L) continue;
                ++n3;
            }
            if (n3 != 0) {
                n = 0;
                for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
                    long l = extendedMolecule.getAtomQueryFeatures(i) & 0x78L;
                    if (l == 0L) continue;
                    if (n == 0) {
                        this.mBuilder.append("M  RBC");
                        this.appendThreeDigitInt(Math.min(8, n3));
                    }
                    this.mBuilder.append(" ");
                    this.appendThreeDigitInt(i + 1);
                    if (l == 112L) {
                        this.mBuilder.append("  -1");
                    } else if (l == 8L) {
                        this.mBuilder.append("   1");
                    } else if (l == 104L) {
                        this.mBuilder.append("   2");
                    } else if (l == 88L) {
                        this.mBuilder.append("   3");
                    } else if (l == 56L) {
                        this.mBuilder.append("   4");
                    }
                    if (++n != 8 && --n3 != 0) continue;
                    n = 0;
                    this.mBuilder.append(string);
                }
            }
            for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
                int[] nArray = extendedMolecule.getAtomList(n);
                if (nArray == null) continue;
                this.mBuilder.append("M  ALS ");
                this.appendThreeDigitInt(n + 1);
                this.appendThreeDigitInt(nArray.length);
                this.mBuilder.append((extendedMolecule.getAtomQueryFeatures(n) & 1L) != 0L ? " T " : " F ");
                block38: for (int i = 0; i < nArray.length; ++i) {
                    String string3 = Molecule.cAtomLabel[nArray[i]];
                    switch (string3.length()) {
                        case 1: {
                            this.mBuilder.append(string3 + "   ");
                            continue block38;
                        }
                        case 2: {
                            this.mBuilder.append(string3 + "  ");
                            continue block38;
                        }
                        case 3: {
                            this.mBuilder.append(string3 + " ");
                            continue block38;
                        }
                        default: {
                            this.mBuilder.append("   ?");
                        }
                    }
                }
                this.mBuilder.append(string);
            }
            n3 = 0;
            for (n = 0; n < extendedMolecule.getAllAtoms(); ++n) {
                if ((extendedMolecule.getAtomQueryFeatures(n) & 0x1800L) == 0L) continue;
                ++n3;
            }
            if (n3 != 0) {
                n = 0;
                for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
                    long l = extendedMolecule.getAtomQueryFeatures(i) & 0x1800L;
                    if (l == 0L) continue;
                    if (n == 0) {
                        this.mBuilder.append("M  SUB");
                        this.appendThreeDigitInt(Math.min(8, n3));
                    }
                    this.mBuilder.append(" ");
                    this.appendThreeDigitInt(i + 1);
                    if ((l & 0x1000L) != 0L) {
                        this.mBuilder.append("   " + (extendedMolecule.getAllConnAtoms(i) + 1));
                    } else {
                        this.mBuilder.append("  -2");
                    }
                    if (++n != 8 && --n3 != 0) continue;
                    n = 0;
                    this.mBuilder.append(string);
                }
            }
        }
        this.mBuilder.append("M  END" + string);
    }

    public String getMolfile() {
        return this.mBuilder.toString();
    }

    public void writeMolfile(Writer writer) throws IOException {
        writer.write(this.mBuilder.toString());
    }

    private void appendThreeDigitInt(int n) {
        if (n < 0 || n > 999) {
            this.mBuilder.append("  ?");
            return;
        }
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            int n2 = n / 100;
            if (n2 == 0) {
                if (i == 2 || bl) {
                    this.mBuilder.append('0');
                } else {
                    this.mBuilder.append(' ');
                }
            } else {
                this.mBuilder.append((char)(48 + n2));
                bl = true;
            }
            n = 10 * (n % 100);
        }
    }

    private void appendTenDigitDouble(double d) {
        String string = this.mDoubleFormat.format(d);
        for (int i = string.length(); i < 10; ++i) {
            this.mBuilder.append(' ');
        }
        this.mBuilder.append(string);
    }
}

