/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Molecule3D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;

public class Molecule3DFunctions {
    public static final Molecule3D removeAllAtomsWithoutNeighbours(Molecule3D molecule3D) {
        Molecule3D molecule3D2 = new Molecule3D(molecule3D);
        molecule3D2.ensureHelperArrays(7);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < molecule3D2.getAllAtoms(); ++i) {
            if (molecule3D2.getConnAtoms(i) != 0) continue;
            hashSet.add(i);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        for (Integer n : arrayList) {
            molecule3D2.deleteAtom(n);
        }
        molecule3D2.ensureHelperArrays(7);
        return molecule3D2;
    }

    public static final String toStringSerialized(Molecule3D molecule3D) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(molecule3D);
        objectOutputStream.close();
        return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
    }

    public static final Molecule3D readSerialized(String string) throws IOException, ClassNotFoundException {
        byte[] byArray = Base64.getDecoder().decode(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        Molecule3D molecule3D = (Molecule3D)objectInputStream.readObject();
        objectInputStream.close();
        return molecule3D;
    }
}

