/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.DoubleFormat;

public class IDCodeParserWithoutCoordinateInvention {
    private StereoMolecule mMol;
    private byte[] mDecodingBytes;
    private int mIDCodeBitsAvail;
    private int mIDCodeTempData;
    private int mIDCodeBufferIndex;
    private boolean mNeglectSpaceDelimitedCoordinates;

    protected boolean ensure2DCoordinates() {
        return false;
    }

    public void neglectSpaceDelimitedCoordinates() {
        this.mNeglectSpaceDelimitedCoordinates = true;
    }

    public StereoMolecule getCompactMolecule(String string) {
        return string == null || string.length() == 0 ? null : this.getCompactMolecule(string.getBytes(), null);
    }

    public StereoMolecule getCompactMolecule(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        for (int i = 2; i < byArray.length - 2; ++i) {
            if (byArray[i] != 32) continue;
            return this.getCompactMolecule(byArray, byArray, 0, i + 1);
        }
        return this.getCompactMolecule(byArray, null);
    }

    public StereoMolecule getCompactMolecule(String string, String string2) {
        return string == null ? null : this.getCompactMolecule(string.getBytes(), string2 == null ? null : string2.getBytes());
    }

    public StereoMolecule getCompactMolecule(byte[] byArray, byte[] byArray2) {
        return this.getCompactMolecule(byArray, byArray2, 0, 0);
    }

    public StereoMolecule getCompactMolecule(byte[] byArray, int n) {
        return this.getCompactMolecule(byArray, null, n, -1);
    }

    public StereoMolecule getCompactMolecule(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        this.decodeBitsStart(byArray, n);
        int n3 = this.decodeBits(4);
        int n4 = this.decodeBits(4);
        if (n3 > 8) {
            n3 = n4;
        }
        int n5 = this.decodeBits(n3);
        int n6 = this.decodeBits(n4);
        StereoMolecule stereoMolecule = new StereoMolecule(n5, n6);
        this.parse(stereoMolecule, byArray, byArray2, n, n2);
        return stereoMolecule;
    }

    public void parse(StereoMolecule stereoMolecule, String string) {
        if (string == null || string.length() == 0) {
            this.parse(stereoMolecule, (byte[])null, (byte[])null);
            return;
        }
        int n = string.indexOf(32);
        if (n > 0 && n < string.length() - 1) {
            this.parse(stereoMolecule, string.substring(0, n).getBytes(), string.substring(n + 1).getBytes());
        } else {
            this.parse(stereoMolecule, string.getBytes(), null);
        }
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray) {
        this.parse(stereoMolecule, byArray, null);
    }

    public void parse(StereoMolecule stereoMolecule, String string, String string2) {
        byte[] byArray = string == null ? null : string.getBytes();
        byte[] byArray2 = string2 == null ? null : string2.getBytes();
        this.parse(stereoMolecule, byArray, byArray2);
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0) {
            stereoMolecule.clear();
            return;
        }
        this.parse(stereoMolecule, byArray, byArray2, 0, 0);
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray, int n) {
        this.parse(stereoMolecule, byArray, null, n, -1);
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray, byte[] byArray2, int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        stereoMolecule.clear();
        if (byArray == null || n < 0 || n >= byArray.length) {
            return;
        }
        this.mMol = stereoMolecule;
        int n14 = 8;
        if (byArray2 != null && (n2 < 0 || n2 >= byArray2.length)) {
            byArray2 = null;
        }
        this.decodeBitsStart(byArray, n);
        int n15 = this.decodeBits(4);
        int n16 = this.decodeBits(4);
        if (n15 > 8) {
            n14 = n15;
            n15 = n16;
        }
        if (n15 == 0) {
            this.mMol.setFragment(this.decodeBits(1) == 1);
            return;
        }
        int n17 = this.decodeBits(n15);
        int n18 = this.decodeBits(n16);
        int n19 = this.decodeBits(n15);
        int n20 = this.decodeBits(n15);
        int n21 = this.decodeBits(n15);
        int n22 = this.decodeBits(n15);
        for (n13 = 0; n13 < n17; ++n13) {
            this.mMol.addAtom(6);
        }
        for (n13 = 0; n13 < n19; ++n13) {
            this.mMol.setAtomicNo(this.decodeBits(n15), 7);
        }
        for (n13 = 0; n13 < n20; ++n13) {
            this.mMol.setAtomicNo(this.decodeBits(n15), 8);
        }
        for (n13 = 0; n13 < n21; ++n13) {
            this.mMol.setAtomicNo(this.decodeBits(n15), this.decodeBits(8));
        }
        for (n13 = 0; n13 < n22; ++n13) {
            this.mMol.setAtomCharge(this.decodeBits(n15), this.decodeBits(4) - 8);
        }
        n13 = 1 + n18 - n17;
        int n23 = this.decodeBits(4);
        int n24 = 0;
        this.mMol.setAtomX(0, 0.0);
        this.mMol.setAtomY(0, 0.0);
        this.mMol.setAtomZ(0, 0.0);
        boolean bl2 = byArray2 != null && byArray2[n2] >= 39;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl2) {
            if (byArray2.length > 2 * n17 - 2 && byArray2[2 * n17 - 2] == 39 || byArray2.length > 3 * n17 - 3 && byArray2[3 * n17 - 3] == 39) {
                bl4 = true;
                bl3 = byArray2.length == 3 * n17 - 3 + 9;
                n12 = bl3 ? 3 * n17 - 3 : 2 * n17 - 2;
                n11 = 86 * (byArray2[n12 + 1] - 40) + byArray2[n12 + 2] - 40;
                d = Math.pow(10.0, (double)n11 / 2000.0 - 1.0);
                n10 = 86 * (byArray2[(n12 += 2) + 1] - 40) + byArray2[n12 + 2] - 40;
                d2 = Math.pow(10.0, (double)n10 / 1500.0 - 1.0);
                n9 = 86 * (byArray2[(n12 += 2) + 1] - 40) + byArray2[n12 + 2] - 40;
                d3 = Math.pow(10.0, (double)n9 / 1500.0 - 1.0);
                if (bl3) {
                    n8 = 86 * (byArray2[(n12 += 2) + 1] - 40) + byArray2[n12 + 2] - 40;
                    d4 = Math.pow(10.0, (double)n8 / 1500.0 - 1.0);
                }
            } else {
                boolean bl5 = bl3 = byArray2.length == 3 * n17 - 3;
            }
        }
        if (this.ensure2DCoordinates() && bl3) {
            byArray2 = null;
            bl2 = false;
        }
        for (n12 = 1; n12 < n17; ++n12) {
            n11 = this.decodeBits(n23);
            if (n11 == 0) {
                if (bl2) {
                    this.mMol.setAtomX(n12, this.mMol.getAtomX(0) + (double)(8 * (byArray2[n12 * 2 - 2] - 83)));
                    this.mMol.setAtomY(n12, this.mMol.getAtomY(0) + (double)(8 * (byArray2[n12 * 2 - 1] - 83)));
                    if (bl3) {
                        this.mMol.setAtomZ(n12, this.mMol.getAtomZ(0) + (double)(8 * (byArray2[2 * n17 - 3 + n12] - 83)));
                    }
                }
                ++n13;
                continue;
            }
            n24 += n11 - 1;
            if (bl2) {
                this.mMol.setAtomX(n12, this.mMol.getAtomX(n24) + (double)byArray2[n12 * 2 - 2] - 83.0);
                this.mMol.setAtomY(n12, this.mMol.getAtomY(n24) + (double)byArray2[n12 * 2 - 1] - 83.0);
                if (bl3) {
                    this.mMol.setAtomZ(n12, this.mMol.getAtomZ(n24) + (double)(byArray2[2 * n17 - 3 + n12] - 83));
                }
            }
            this.mMol.addBond(n24, n12, 1);
        }
        for (n12 = 0; n12 < n13; ++n12) {
            this.mMol.addBond(this.decodeBits(n15), this.decodeBits(n15), 1);
        }
        boolean[] blArray = new boolean[n18];
        block67: for (n11 = 0; n11 < n18; ++n11) {
            n10 = this.decodeBits(2);
            switch (n10) {
                case 0: {
                    blArray[n11] = true;
                    continue block67;
                }
                case 2: {
                    this.mMol.setBondType(n11, 2);
                    continue block67;
                }
                case 3: {
                    this.mMol.setBondType(n11, 4);
                }
            }
        }
        n11 = this.decodeBits(n15);
        block68: for (n10 = 0; n10 < n11; ++n10) {
            n9 = this.decodeBits(n15);
            if (n14 == 8) {
                n8 = this.decodeBits(2);
                if (n8 == 3) {
                    this.mMol.setAtomESR(n9, 1, 0);
                    this.mMol.setAtomParity(n9, 1, false);
                    continue;
                }
                this.mMol.setAtomParity(n9, n8, false);
                continue;
            }
            n8 = this.decodeBits(3);
            switch (n8) {
                case 4: {
                    this.mMol.setAtomParity(n9, 1, false);
                    this.mMol.setAtomESR(n9, 1, this.decodeBits(3));
                    continue block68;
                }
                case 5: {
                    this.mMol.setAtomParity(n9, 2, false);
                    this.mMol.setAtomESR(n9, 1, this.decodeBits(3));
                    continue block68;
                }
                case 6: {
                    this.mMol.setAtomParity(n9, 1, false);
                    this.mMol.setAtomESR(n9, 2, this.decodeBits(3));
                    continue block68;
                }
                case 7: {
                    this.mMol.setAtomParity(n9, 2, false);
                    this.mMol.setAtomESR(n9, 2, this.decodeBits(3));
                    continue block68;
                }
                default: {
                    this.mMol.setAtomParity(n9, n8, false);
                }
            }
        }
        if (n14 == 8 && this.decodeBits(1) == 0) {
            this.mMol.setToRacemate();
        }
        n10 = this.decodeBits(n16);
        for (n9 = 0; n9 < n10; ++n9) {
            n8 = this.decodeBits(n16);
            if (this.mMol.getBondType(n8) == 1) {
                n7 = this.decodeBits(3);
                switch (n7) {
                    case 4: {
                        this.mMol.setBondParity(n8, 1, false);
                        this.mMol.setBondESR(n8, 1, this.decodeBits(3));
                        break;
                    }
                    case 5: {
                        this.mMol.setBondParity(n8, 2, false);
                        this.mMol.setBondESR(n8, 1, this.decodeBits(3));
                        break;
                    }
                    case 6: {
                        this.mMol.setBondParity(n8, 1, false);
                        this.mMol.setBondESR(n8, 2, this.decodeBits(3));
                        break;
                    }
                    case 7: {
                        this.mMol.setBondParity(n8, 2, false);
                        this.mMol.setBondESR(n8, 2, this.decodeBits(3));
                        break;
                    }
                    default: {
                        this.mMol.setBondParity(n8, n7, false);
                        break;
                    }
                }
                continue;
            }
            this.mMol.setBondParity(n8, this.decodeBits(2), false);
        }
        this.mMol.setFragment(this.decodeBits(1) == 1);
        int[] nArray = null;
        n8 = 0;
        block70: while (this.decodeBits(1) == 1) {
            n7 = n8 + this.decodeBits(4);
            switch (n7) {
                case 0: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n4, 2048L, true);
                    }
                    continue block70;
                }
                case 1: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        int n25 = this.decodeBits(8);
                        this.mMol.setAtomMass(n4, n25);
                    }
                    continue block70;
                }
                case 2: {
                    n6 = this.decodeBits(n16);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n16);
                    }
                    continue block70;
                }
                case 3: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n4, 4096L, true);
                    }
                    continue block70;
                }
                case 4: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(4) << 3;
                        this.mMol.setAtomQueryFeature(n4, l, true);
                    }
                    continue block70;
                }
                case 5: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(2) << 1;
                        this.mMol.setAtomQueryFeature(n4, l, true);
                    }
                    continue block70;
                }
                case 6: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n4, 1L, true);
                    }
                    continue block70;
                }
                case 7: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(4) << 7;
                        this.mMol.setAtomQueryFeature(n4, l, true);
                    }
                    continue block70;
                }
                case 8: {
                    int n26;
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        int n27 = this.decodeBits(4);
                        int[] nArray2 = new int[n27];
                        for (n3 = 0; n3 < n27; ++n3) {
                            nArray2[n3] = n26 = this.decodeBits(8);
                        }
                        this.mMol.setAtomList(n4, nArray2);
                    }
                    continue block70;
                }
                case 9: {
                    n6 = this.decodeBits(n16);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n16);
                        int n28 = this.decodeBits(2) << 7;
                        this.mMol.setBondQueryFeature(n4, n28, true);
                    }
                    continue block70;
                }
                case 10: {
                    n6 = this.decodeBits(n16);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n16);
                        int n29 = this.decodeBits(5) << 0;
                        this.mMol.setBondQueryFeature(n4, n29, true);
                    }
                    continue block70;
                }
                case 11: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n4, 8192L, true);
                    }
                    continue block70;
                }
                case 12: {
                    n6 = this.decodeBits(n16);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n16);
                        int n30 = this.decodeBits(8) << 9;
                        this.mMol.setBondQueryFeature(n4, n30, true);
                    }
                    continue block70;
                }
                case 13: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(3) << 14;
                        this.mMol.setAtomQueryFeature(n4, l, true);
                    }
                    continue block70;
                }
                case 14: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(5) << 17;
                        this.mMol.setAtomQueryFeature(n4, l, true);
                    }
                    continue block70;
                }
                case 15: 
                case 31: {
                    n8 += 16;
                    break;
                }
                case 16: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(3) << 22;
                        this.mMol.setAtomQueryFeature(n4, l, true);
                    }
                    continue block70;
                }
                case 17: {
                    n6 = this.decodeBits(n15);
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.decodeBits(n15);
                        this.mMol.setAtomAbnormalValence(n4, this.decodeBits(4));
                    }
                    continue block70;
                }
                case 18: {
                    int n26;
                    n6 = this.decodeBits(n15);
                    n5 = this.decodeBits(4);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n31 = this.decodeBits(n15);
                        int n32 = this.decodeBits(n5);
                        byte[] byArray3 = new byte[n32];
                        for (n26 = 0; n26 < n32; ++n26) {
                            byArray3[n26] = (byte)this.decodeBits(7);
                        }
                        this.mMol.setAtomCustomLabel(n31, new String(byArray3));
                    }
                    continue block70;
                }
                case 19: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n33 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(3) << 25;
                        this.mMol.setAtomQueryFeature(n33, l, true);
                    }
                    continue block70;
                }
                case 20: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n34 = this.decodeBits(n16);
                        int n35 = this.decodeBits(3) << 17;
                        this.mMol.setBondQueryFeature(n34, n35, true);
                    }
                    continue block70;
                }
                case 21: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n36 = this.decodeBits(n15);
                        this.mMol.setAtomRadical(n36, this.decodeBits(2) << 4);
                    }
                    continue block70;
                }
                case 22: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n37 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n37, 0x10000000L, true);
                    }
                    continue block70;
                }
                case 23: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n38 = this.decodeBits(n16);
                        this.mMol.setBondQueryFeature(n38, 0x100000, true);
                    }
                    continue block70;
                }
                case 24: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n39 = this.decodeBits(n16);
                        int n40 = this.decodeBits(2) << 21;
                        this.mMol.setBondQueryFeature(n39, n40, true);
                    }
                    continue block70;
                }
                case 25: {
                    for (n4 = 0; n4 < n17; ++n4) {
                        if (this.decodeBits(1) != 1) continue;
                        this.mMol.setAtomSelection(n4, true);
                    }
                    continue block70;
                }
                case 26: {
                    n6 = this.decodeBits(n16);
                    nArray = new int[n6];
                    for (n4 = 0; n4 < n6; ++n4) {
                        nArray[n4] = this.decodeBits(n16);
                    }
                    continue block70;
                }
                case 27: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n41 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n41, 0x20000000L, true);
                    }
                    continue block70;
                }
                case 28: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        this.mMol.setBondType(this.decodeBits(n16), 32);
                    }
                    continue block70;
                }
                case 29: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n42 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(2) << 30;
                        this.mMol.setAtomQueryFeature(n42, l, true);
                    }
                    continue block70;
                }
                case 30: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n43 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(7) << 32;
                        this.mMol.setAtomQueryFeature(n43, l, true);
                    }
                    continue block70;
                }
                case 32: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n44 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(2) << 44;
                        this.mMol.setAtomQueryFeature(n44, l, true);
                    }
                    continue block70;
                }
                case 33: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n45 = this.decodeBits(n15);
                        long l = (long)this.decodeBits(5) << 39;
                        this.mMol.setAtomQueryFeature(n45, l, true);
                    }
                    continue block70;
                }
                case 34: {
                    n6 = this.decodeBits(n15);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n46 = this.decodeBits(n15);
                        this.mMol.setAtomQueryFeature(n46, 0x400000000000L, true);
                    }
                    continue block70;
                }
                case 35: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n47 = this.decodeBits(n16);
                        this.mMol.setBondQueryFeature(n47, 0x800000, true);
                    }
                    continue block70;
                }
                case 36: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n48 = this.decodeBits(n16);
                        int n49 = this.decodeBits(2) << 5;
                        this.mMol.setBondQueryFeature(n48, n49, true);
                    }
                    continue block70;
                }
                case 37: {
                    n6 = this.decodeBits(n16);
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n50 = this.decodeBits(n16);
                        int n51 = this.decodeBits(1) == 0 ? 8 : 16;
                        this.mMol.setBondType(n50, n51);
                    }
                    break;
                }
            }
        }
        new AromaticityResolver(this.mMol).locateDelocalizedDoubleBonds(blArray);
        if (nArray != null) {
            int[] nArray3 = nArray;
            n6 = nArray3.length;
            for (n5 = 0; n5 < n6; ++n5) {
                this.mMol.setBondType(n4, this.mMol.getBondType(n4 = nArray3[n5]) == 2 ? 4 : 2);
            }
        }
        if (!(byArray2 != null || this.mNeglectSpaceDelimitedCoordinates || byArray.length <= this.mIDCodeBufferIndex + 1 || byArray[this.mIDCodeBufferIndex + 1] != 32 && byArray[this.mIDCodeBufferIndex + 1] != 9)) {
            byArray2 = byArray;
            n2 = this.mIDCodeBufferIndex + 2;
        }
        if (byArray2 != null) {
            try {
                if (byArray2[n2] == 33 || byArray2[n2] == 35) {
                    double d5;
                    int n52;
                    this.decodeBitsStart(byArray2, n2 + 1);
                    bl3 = this.decodeBits(1) == 1;
                    bl4 = this.decodeBits(1) == 1;
                    int n53 = 2 * this.decodeBits(4);
                    n6 = 1 << n53;
                    int n54 = 0;
                    int n55 = 0;
                    for (n3 = 1; n3 < n17; ++n3) {
                        double d6;
                        if (n55 < n18 && this.mMol.getBondAtom(1, n55) == n3) {
                            n54 = this.mMol.getBondAtom(0, n55++);
                            d6 = 1.0;
                        } else {
                            n54 = 0;
                            d6 = 8.0;
                        }
                        this.mMol.setAtomX(n3, this.mMol.getAtomX(n54) + d6 * (double)(this.decodeBits(n53) - n6 / 2));
                        this.mMol.setAtomY(n3, this.mMol.getAtomY(n54) + d6 * (double)(this.decodeBits(n53) - n6 / 2));
                        if (!bl3) continue;
                        this.mMol.setAtomZ(n3, this.mMol.getAtomZ(n54) + d6 * (double)(this.decodeBits(n53) - n6 / 2));
                    }
                    if (byArray2[n2] == 35) {
                        int n56;
                        n3 = 0;
                        int[] nArray4 = new int[n17];
                        for (n56 = 0; n56 < n17; ++n56) {
                            nArray4[n56] = this.mMol.getImplicitHydrogens(n56);
                            n3 += nArray4[n56];
                        }
                        for (n56 = 0; n56 < n17; ++n56) {
                            for (int i = 0; i < nArray4[n56]; ++i) {
                                n52 = this.mMol.addAtom(1);
                                this.mMol.addBond(n56, n52, 1);
                                this.mMol.setAtomX(n52, this.mMol.getAtomX(n56) + (double)(this.decodeBits(n53) - n6 / 2));
                                this.mMol.setAtomY(n52, this.mMol.getAtomY(n56) + (double)(this.decodeBits(n53) - n6 / 2));
                                if (!bl3) continue;
                                this.mMol.setAtomZ(n52, this.mMol.getAtomZ(n56) + (double)(this.decodeBits(n53) - n6 / 2));
                            }
                        }
                        n17 += n3;
                        n18 += n3;
                    }
                    double d7 = bl3 ? 1.5 : Molecule.getDefaultAverageBondLength();
                    double d8 = this.mMol.getAverageBondLength(n17, n18, d7);
                    if (bl4) {
                        d = this.decodeAVBL(this.decodeBits(n53), n6);
                        d2 = d * this.decodeShift(this.decodeBits(n53), n6);
                        d3 = d * this.decodeShift(this.decodeBits(n53), n6);
                        if (bl3) {
                            d4 = d * this.decodeShift(this.decodeBits(n53), n6);
                        }
                        d5 = d / d8;
                        for (n52 = 0; n52 < n17; ++n52) {
                            this.mMol.setAtomX(n52, d2 + d5 * this.mMol.getAtomX(n52));
                            this.mMol.setAtomY(n52, d3 + d5 * this.mMol.getAtomY(n52));
                            if (!bl3) continue;
                            this.mMol.setAtomZ(n52, d4 + d5 * this.mMol.getAtomZ(n52));
                        }
                    } else {
                        d = 1.5;
                        d5 = d / d8;
                        for (n52 = 0; n52 < n17; ++n52) {
                            this.mMol.setAtomX(n52, d5 * this.mMol.getAtomX(n52));
                            this.mMol.setAtomY(n52, d5 * this.mMol.getAtomY(n52));
                            if (!bl3) continue;
                            this.mMol.setAtomZ(n52, d5 * this.mMol.getAtomZ(n52));
                        }
                    }
                } else {
                    if (bl3 && !bl4 && d == 0.0) {
                        d = 1.5;
                    }
                    if (d != 0.0 && this.mMol.getAllBonds() != 0) {
                        double d9 = 0.0;
                        for (n5 = 0; n5 < this.mMol.getAllBonds(); ++n5) {
                            double d10 = this.mMol.getAtomX(this.mMol.getBondAtom(0, n5)) - this.mMol.getAtomX(this.mMol.getBondAtom(1, n5));
                            double d11 = this.mMol.getAtomY(this.mMol.getBondAtom(0, n5)) - this.mMol.getAtomY(this.mMol.getBondAtom(1, n5));
                            double d12 = bl3 ? this.mMol.getAtomZ(this.mMol.getBondAtom(0, n5)) - this.mMol.getAtomZ(this.mMol.getBondAtom(1, n5)) : 0.0;
                            d9 += Math.sqrt(d10 * d10 + d11 * d11 + d12 * d12);
                        }
                        double d13 = d / (d9 /= (double)this.mMol.getAllBonds());
                        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                            this.mMol.setAtomX(i, this.mMol.getAtomX(i) * d13 + d2);
                            this.mMol.setAtomY(i, this.mMol.getAtomY(i) * d13 + d3);
                            if (!bl3) continue;
                            this.mMol.setAtomZ(i, this.mMol.getAtomZ(i) * d13 + d4);
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Faulty id-coordinates:" + exception.toString() + " " + new String(byArray) + " " + new String(byArray2));
                byArray2 = null;
                bl3 = false;
            }
        }
        boolean bl6 = bl = byArray2 != null && !bl3;
        if (bl || this.ensure2DCoordinates()) {
            this.mMol.ensureHelperArrays(7);
            for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
                if (this.mMol.getBondOrder(n6) != 2 || this.mMol.isSmallRingBond(n6) || this.mMol.getBondParity(n6) != 0) continue;
                this.mMol.setBondParityUnknownOrNone(n6);
            }
        }
        this.mMol.setParitiesValid(0);
        if (!bl && this.ensure2DCoordinates()) {
            try {
                this.inventCoordinates(this.mMol);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("2D-coordinate creation failed:" + exception.toString() + " " + new String(byArray));
            }
        }
        if (bl) {
            this.mMol.setStereoBondsFromParity();
            this.mMol.setUnknownParitiesToExplicitlyUnknown();
        } else if (!bl3) {
            this.mMol.setParitiesValid(0);
        }
    }

    protected void inventCoordinates(StereoMolecule stereoMolecule) throws Exception {
        throw new Exception("Unexpected request to invent coordinates. Check source code logic!");
    }

    public void parseCoordinates(byte[] byArray, int n, StereoMolecule stereoMolecule, Coordinates[] coordinatesArray) throws Exception {
        int n2;
        int n3;
        double d;
        double d2;
        stereoMolecule.ensureHelperArrays(1);
        int n4 = stereoMolecule.getAtoms();
        int n5 = stereoMolecule.getBonds();
        this.decodeBitsStart(byArray, n + 1);
        boolean bl = this.decodeBits(1) == 1;
        boolean bl2 = this.decodeBits(1) == 1;
        int n6 = 2 * this.decodeBits(4);
        int n7 = 1 << n6;
        int n8 = 0;
        int n9 = 0;
        for (int i = 1; i < n4; ++i) {
            if (n9 < n5 && stereoMolecule.getBondAtom(1, n9) == i) {
                n8 = stereoMolecule.getBondAtom(0, n9++);
                d2 = 1.0;
            } else {
                n8 = 0;
                d2 = 8.0;
            }
            coordinatesArray[i].x = coordinatesArray[n8].x + d2 * (double)(this.decodeBits(n6) - n7 / 2);
            coordinatesArray[i].y = coordinatesArray[n8].y + d2 * (double)(this.decodeBits(n6) - n7 / 2);
            if (!bl) continue;
            coordinatesArray[i].z = coordinatesArray[n8].z + d2 * (double)(this.decodeBits(n6) - n7 / 2);
        }
        double d3 = d = bl ? 1.5 : Molecule.getDefaultAverageBondLength();
        if (n5 != 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                d += coordinatesArray[stereoMolecule.getBondAtom(0, n3)].distance(coordinatesArray[stereoMolecule.getBondAtom(1, n3)]);
            }
        }
        d /= (double)n5;
        if (byArray[n] == 35) {
            n3 = 0;
            int n10 = n4;
            for (n2 = 0; n2 < n4; ++n2) {
                int n11 = stereoMolecule.getAllConnAtoms(n2) - stereoMolecule.getConnAtoms(n2);
                for (int i = 0; i < n11; ++i) {
                    coordinatesArray[n10].x = coordinatesArray[n2].x + (double)(this.decodeBits(n6) - n7 / 2);
                    coordinatesArray[n10].y = coordinatesArray[n2].y + (double)(this.decodeBits(n6) - n7 / 2);
                    if (bl) {
                        coordinatesArray[n10].z = coordinatesArray[n2].z + (double)(this.decodeBits(n6) - n7 / 2);
                    }
                    ++n10;
                }
                n3 += n11;
            }
            n4 += n3;
            n5 += n3;
        }
        if (bl2) {
            double d4 = this.decodeAVBL(this.decodeBits(n6), n7);
            double d5 = d4 * this.decodeShift(this.decodeBits(n6), n7);
            double d6 = d4 * this.decodeShift(this.decodeBits(n6), n7);
            double d7 = 0.0;
            if (bl) {
                d7 = d4 * this.decodeShift(this.decodeBits(n6), n7);
            }
            d2 = d4 / d;
            for (int i = 0; i < n4; ++i) {
                coordinatesArray[i].x = d5 + d2 * coordinatesArray[i].x;
                coordinatesArray[i].y = d6 + d2 * coordinatesArray[i].y;
                if (!bl) continue;
                coordinatesArray[i].z = d7 + d2 * coordinatesArray[i].z;
            }
        } else {
            double d8 = 1.5;
            d2 = d8 / d;
            for (n2 = 0; n2 < n4; ++n2) {
                coordinatesArray[n2].x = d2 * coordinatesArray[n2].x;
                coordinatesArray[n2].y = d2 * coordinatesArray[n2].y;
                if (!bl) continue;
                coordinatesArray[n2].z = d2 * coordinatesArray[n2].z;
            }
        }
    }

    public void parseMapping(byte[] byArray) {
        this.parseMapping(byArray, 0);
    }

    public void parseMapping(byte[] byArray, int n) {
        if (byArray == null || byArray.length <= n || byArray[n] < 64) {
            return;
        }
        this.decodeBitsStart(byArray, n);
        int n2 = this.decodeBits(4);
        boolean bl = this.decodeBits(1) == 1;
        boolean bl2 = this.decodeBits(1) == 1;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n3 = this.decodeBits(n2);
            boolean bl3 = bl;
            if (bl && bl2) {
                bl3 = this.decodeBits(1) == 1;
            }
            this.mMol.setAtomMapNo(i, n3, bl3);
        }
    }

    public boolean coordinatesAre3D(String string, String string2) {
        return string2 != null && this.coordinatesAre3D(string.getBytes(), string2.getBytes());
    }

    public boolean coordinatesAre3D(byte[] byArray, byte[] byArray2) {
        return this.coordinatesAre3D(byArray, byArray2, 0, 0);
    }

    public boolean coordinatesAre3D(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray2 == null || byArray2.length <= n2) {
            return false;
        }
        if (byArray2[n2] == 33 || byArray2[n2] == 35) {
            this.decodeBitsStart(byArray2, n2 + 1);
            return this.decodeBits(1) == 1;
        }
        int n3 = this.getAtomCount(byArray, n);
        return n3 != 0 && byArray2.length >= n2 + 3 * n3 - 3 && byArray2[n2 + 2 * n3 - 2] != 39;
    }

    public boolean coordinatesAreAbsolute(String string) {
        return string != null && this.coordinatesAreAbsolute(string.getBytes());
    }

    public boolean coordinatesAreAbsolute(byte[] byArray) {
        return this.coordinatesAreAbsolute(byArray, 0);
    }

    public boolean coordinatesAreAbsolute(byte[] byArray, int n) {
        if (byArray == null || byArray.length <= n) {
            return false;
        }
        if (byArray[n] >= 39) {
            for (int i = n; i < byArray.length; ++i) {
                if (byArray[i] != 39 && byArray[i] != 38) continue;
                return true;
            }
        } else if (byArray[n] == 33 || byArray[n] == 35) {
            this.decodeBitsStart(byArray, n + 1);
            this.decodeBits(1);
            return this.decodeBits(1) == 1;
        }
        return false;
    }

    public int getIDCodeVersion(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        return this.getIDCodeVersion(string.getBytes());
    }

    public int getIDCodeVersion(byte[] byArray) {
        int n = 8;
        this.decodeBitsStart(byArray, 0);
        int n2 = this.decodeBits(4);
        if (n2 > 8) {
            n = n2;
        }
        return n;
    }

    public int getAtomCount(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return this.getAtomCount(string.getBytes(), 0);
    }

    public int getAtomCount(byte[] byArray, int n) {
        if (byArray == null || byArray.length <= n) {
            return 0;
        }
        this.decodeBitsStart(byArray, n);
        int n2 = this.decodeBits(4);
        int n3 = this.decodeBits(4);
        if (n2 > 8) {
            n2 = n3;
        }
        if (n2 == 0) {
            return 0;
        }
        return this.decodeBits(n2);
    }

    public int[] getAtomAndBondCounts(String string, int[] nArray) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return this.getAtomAndBondCounts(string.getBytes(), 0, nArray);
    }

    public int[] getAtomAndBondCounts(byte[] byArray, int n, int[] nArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        this.decodeBitsStart(byArray, 0);
        int n2 = this.decodeBits(4);
        int n3 = this.decodeBits(4);
        if (n2 > 8) {
            n2 = n3;
        }
        if (nArray == null) {
            nArray = new int[2];
        }
        if (n2 == 0) {
            nArray[0] = 0;
            nArray[1] = 0;
        } else {
            nArray[0] = this.decodeBits(n2);
            nArray[1] = this.decodeBits(n3);
        }
        return nArray;
    }

    private void decodeBitsStart(byte[] byArray, int n) {
        this.mIDCodeBitsAvail = 6;
        this.mIDCodeBufferIndex = n;
        this.mDecodingBytes = byArray;
        this.mIDCodeTempData = (byArray[this.mIDCodeBufferIndex] & 0x3F) << 11;
    }

    private int decodeBits(int n) {
        int n2 = n;
        int n3 = 0;
        while (n != 0) {
            if (this.mIDCodeBitsAvail == 0) {
                this.mIDCodeTempData = (this.mDecodingBytes[++this.mIDCodeBufferIndex] & 0x3F) << 11;
                this.mIDCodeBitsAvail = 6;
            }
            n3 |= (0x10000 & this.mIDCodeTempData) >> 16 - n2 + n;
            this.mIDCodeTempData <<= 1;
            --n;
            --this.mIDCodeBitsAvail;
        }
        return n3;
    }

    private double decodeAVBL(int n, int n2) {
        return Math.pow(10.0, Math.log10(2000.0) * (double)n / (double)(n2 - 1) - 1.0);
    }

    private double decodeShift(int n, int n2) {
        boolean bl;
        int n3 = n2 / 2;
        boolean bl2 = bl = n >= n3;
        if (bl) {
            n -= n3;
        }
        double d = n2 / 32;
        double d2 = d * (double)n / (double)(n3 - n);
        return bl ? -d2 : d2;
    }

    public void printContent(byte[] byArray, byte[] byArray2) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = 8;
            if (byArray == null || byArray.length == 0) {
                return;
            }
            if (byArray2 != null && byArray2.length == 0) {
                byArray2 = null;
            }
            System.out.println("idcode: " + new String(byArray));
            if (byArray2 != null) {
                System.out.println("coords: " + new String(byArray2));
            }
            this.decodeBitsStart(byArray, 0);
            int n11 = this.decodeBits(4);
            int n12 = this.decodeBits(4);
            if (n11 > 8) {
                n10 = n11;
                n11 = n12;
            }
            System.out.println("version:" + n10);
            int n13 = this.decodeBits(n11);
            if (n13 == 0) {
                return;
            }
            int n14 = this.decodeBits(n12);
            int n15 = this.decodeBits(n11);
            int n16 = this.decodeBits(n11);
            int n17 = this.decodeBits(n11);
            int n18 = this.decodeBits(n11);
            System.out.println("allAtoms:" + n13 + " allBonds:" + n14);
            if (n15 != 0) {
                System.out.print("nitrogens:");
                for (n9 = 0; n9 < n15; ++n9) {
                    System.out.print(" " + this.decodeBits(n11));
                }
                System.out.println();
            }
            if (n16 != 0) {
                System.out.print("oxygens:");
                for (n9 = 0; n9 < n16; ++n9) {
                    System.out.print(" " + this.decodeBits(n11));
                }
                System.out.println();
            }
            if (n17 != 0) {
                System.out.print("otherAtoms:");
                for (n9 = 0; n9 < n17; ++n9) {
                    System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(8));
                }
                System.out.println();
            }
            if (n18 != 0) {
                System.out.print("chargedAtoms:");
                for (n9 = 0; n9 < n18; ++n9) {
                    System.out.print(" " + this.decodeBits(n11) + ":" + (this.decodeBits(4) - 8));
                }
                System.out.println();
            }
            n9 = 1 + n14 - n13;
            int n19 = this.decodeBits(4);
            int n20 = 0;
            int[][] nArray = new int[2][n14];
            int n21 = 0;
            for (n8 = 1; n8 < n13; ++n8) {
                n7 = this.decodeBits(n19);
                if (n7 == 0) {
                    ++n9;
                    continue;
                }
                nArray[0][n21] = n20 += n7 - 1;
                nArray[1][n21++] = n8;
            }
            for (n8 = 0; n8 < n9; ++n8) {
                nArray[0][n21] = this.decodeBits(n11);
                nArray[1][n21++] = this.decodeBits(n11);
            }
            int[] nArray2 = new int[n14];
            System.out.print("bonds:");
            for (n7 = 0; n7 < n14; ++n7) {
                System.out.print(" " + nArray[0][n7]);
                nArray2[n7] = this.decodeBits(2);
                System.out.print(nArray2[n7] == 0 ? "." : (nArray2[n7] == 1 ? "-" : (nArray2[n7] == 2 ? "=" : "#")));
                System.out.print("" + nArray[1][n7]);
            }
            System.out.println();
            n7 = this.decodeBits(n11);
            if (n7 != 0) {
                System.out.print("parities:");
                block60: for (n6 = 0; n6 < n7; ++n6) {
                    n5 = this.decodeBits(n11);
                    if (n10 == 8) {
                        n4 = this.decodeBits(2);
                        if (n4 == 3) {
                            System.out.print(" " + n5 + ":1&0");
                            continue;
                        }
                        System.out.print(" " + n5 + ":" + n4);
                        continue;
                    }
                    n4 = this.decodeBits(3);
                    switch (n4) {
                        case 4: {
                            System.out.print(" " + n5 + ":1&" + this.decodeBits(3));
                            continue block60;
                        }
                        case 5: {
                            System.out.print(" " + n5 + ":2&" + this.decodeBits(3));
                            continue block60;
                        }
                        case 6: {
                            System.out.print(" " + n5 + ":1|" + this.decodeBits(3));
                            continue block60;
                        }
                        case 7: {
                            System.out.print(" " + n5 + ":2|" + this.decodeBits(3));
                            continue block60;
                        }
                        default: {
                            System.out.print(" " + n5 + ":" + n4);
                        }
                    }
                }
                System.out.println();
            }
            if (n10 == 8 && this.decodeBits(1) == 0) {
                System.out.println("isRacemate");
            }
            if ((n6 = this.decodeBits(n12)) != 0) {
                System.out.print("EZ:");
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = this.decodeBits(n12);
                    if (nArray2[n4] == 1) {
                        n3 = this.decodeBits(3);
                        switch (n3) {
                            case 4: {
                                System.out.print(" " + n4 + ":1&" + this.decodeBits(3));
                                break;
                            }
                            case 5: {
                                System.out.print(" " + n4 + ":2&" + this.decodeBits(3));
                                break;
                            }
                            case 6: {
                                System.out.print(" " + n4 + ":1|" + this.decodeBits(3));
                                break;
                            }
                            case 7: {
                                System.out.print(" " + n4 + ":2|" + this.decodeBits(3));
                                break;
                            }
                            default: {
                                System.out.print(" " + n4 + ":" + n3);
                                break;
                            }
                        }
                        continue;
                    }
                    System.out.print(" " + n4 + ":" + this.decodeBits(2));
                }
                System.out.println();
            }
            if (this.decodeBits(1) == 1) {
                System.out.println("isFragment = true");
            }
            n5 = 0;
            block62: while (this.decodeBits(1) == 1) {
                n4 = n5 + this.decodeBits(4);
                switch (n4) {
                    case 0: {
                        n3 = this.decodeBits(n11);
                        System.out.print("noMoreNeighbours:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 1: {
                        n3 = this.decodeBits(n11);
                        System.out.print("mass:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(8));
                        }
                        System.out.println();
                        break;
                    }
                    case 2: {
                        n3 = this.decodeBits(n12);
                        System.out.print("delocalizedBonds (outdated, redundant and wrong):");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n12));
                        }
                        System.out.println();
                        break;
                    }
                    case 3: {
                        n3 = this.decodeBits(n11);
                        System.out.print("moreNeighbours:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 4: {
                        n3 = this.decodeBits(n11);
                        System.out.print("atomRingState:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(4));
                        }
                        System.out.println();
                        break;
                    }
                    case 5: {
                        n3 = this.decodeBits(n11);
                        System.out.print("atomAromState:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 6: {
                        n3 = this.decodeBits(n11);
                        System.out.print("atomAny:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 7: {
                        n3 = this.decodeBits(n11);
                        System.out.print("atomHydrogen:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(4));
                        }
                        System.out.println();
                        break;
                    }
                    case 8: {
                        int n22;
                        int n23;
                        n3 = this.decodeBits(n11);
                        System.out.print("atomList:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            n = this.decodeBits(n11);
                            n23 = this.decodeBits(4);
                            System.out.print(" " + n);
                            for (n22 = 0; n22 < n23; ++n22) {
                                System.out.print(n22 == 0 ? ":" : ",");
                                System.out.print("" + this.decodeBits(8));
                            }
                        }
                        System.out.println();
                        break;
                    }
                    case 9: {
                        n3 = this.decodeBits(n12);
                        System.out.print("bondRingState:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n12) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 10: {
                        n3 = this.decodeBits(n12);
                        System.out.print("bondTypes:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n12) + ":" + this.decodeBits(5));
                        }
                        System.out.println();
                        break;
                    }
                    case 11: {
                        n3 = this.decodeBits(n11);
                        System.out.print("atomMatchStereo:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 12: {
                        int n23;
                        n3 = this.decodeBits(n12);
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print("bridgeBond:" + this.decodeBits(n12));
                            n = this.decodeBits(4);
                            n23 = n + this.decodeBits(4);
                            System.out.println("(" + n + "-" + n23 + ")");
                        }
                        continue block62;
                    }
                    case 13: {
                        n3 = this.decodeBits(n11);
                        System.out.print("atomPiElectrons:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 14: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFNeighbours:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(5));
                        }
                        System.out.println();
                        break;
                    }
                    case 15: 
                    case 31: {
                        n5 += 16;
                        System.out.println("<start next feature set>");
                        break;
                    }
                    case 16: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFSmallRingSize:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 17: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomAbnormalValence:");
                        for (n2 = 0; n2 < n3; ++n2) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(4));
                        }
                        System.out.println();
                        break;
                    }
                    case 18: {
                        int n22;
                        int n23;
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomCustomLabel:");
                        n2 = this.decodeBits(4);
                        for (n = 0; n < n3; ++n) {
                            n23 = this.decodeBits(n11);
                            n22 = this.decodeBits(n2);
                            byte[] byArray3 = new byte[n22];
                            for (int i = 0; i < n22; ++i) {
                                byArray3[i] = (byte)this.decodeBits(7);
                            }
                            System.out.print(" " + n23 + ":" + new String(byArray3));
                        }
                        System.out.println();
                        break;
                    }
                    case 19: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFCharge:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 20: {
                        n3 = this.decodeBits(n12);
                        System.out.print("BondQFRingSize:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n12) + ":" + this.decodeBits(3));
                        }
                        System.out.println();
                        break;
                    }
                    case 21: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomRadicalState:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 22: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFFlatNitrogen:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 23: {
                        n3 = this.decodeBits(n12);
                        System.out.print("cBondQFMatchStereo:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 24: {
                        n3 = this.decodeBits(n12);
                        System.out.print("BondQFAromState:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n12) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 25: {
                        System.out.print("AtomSelection:");
                        for (n = 0; n < n13; ++n) {
                            if (this.decodeBits(1) != 1) continue;
                            System.out.print(" " + n);
                        }
                        System.out.println();
                        break;
                    }
                    case 26: {
                        System.out.print("DelocalizedHigherOrderBonds:");
                        n3 = this.decodeBits(n12);
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n12));
                        }
                        continue block62;
                    }
                    case 27: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFExcludeGroup:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 28: {
                        n3 = this.decodeBits(n12);
                        System.out.print("Coordinate Bonds:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n12));
                        }
                        System.out.println();
                        break;
                    }
                    case 29: {
                        n3 = this.decodeBits(n11);
                        System.out.print("ReactionParityHint:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 30: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFNewRingSize:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(7));
                        }
                        System.out.println();
                        break;
                    }
                    case 32: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFStereoState:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 33: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFENeighbours:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11) + ":" + this.decodeBits(5));
                        }
                        System.out.println();
                        break;
                    }
                    case 34: {
                        n3 = this.decodeBits(n11);
                        System.out.print("AtomQFHeteroAromatic:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 35: {
                        n3 = this.decodeBits(n12);
                        System.out.print("BondQFMatchFormalOrder:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n11));
                        }
                        System.out.println();
                        break;
                    }
                    case 36: {
                        n3 = this.decodeBits(n12);
                        System.out.print("BondQFRareBondType:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n12) + ":" + this.decodeBits(2));
                        }
                        System.out.println();
                        break;
                    }
                    case 37: {
                        n3 = this.decodeBits(n12);
                        System.out.print("Rare Bond Type:");
                        for (n = 0; n < n3; ++n) {
                            System.out.print(" " + this.decodeBits(n12) + ":" + (this.decodeBits(1) == 0 ? "quadruple" : "quintuple"));
                        }
                        break;
                    }
                }
            }
            if (byArray2 != null && (byArray2[0] == 33 || byArray2[0] == 35)) {
                double d;
                double d2;
                double d3;
                int n24;
                Object object;
                this.decodeBitsStart(byArray2, 1);
                n4 = this.decodeBits(1) == 1 ? 1 : 0;
                n3 = this.decodeBits(1) == 1 ? 1 : 0;
                n2 = 2 * this.decodeBits(4);
                n = 1 << n2;
                int n25 = 0;
                int[] nArray3 = null;
                if (byArray2[0] == 35) {
                    object = new IDCodeParserWithoutCoordinateInvention().getCompactMolecule(byArray);
                    nArray3 = new int[n13];
                    for (n24 = 0; n24 < n13; ++n24) {
                        nArray3[n24] = ((ExtendedMolecule)object).getImplicitHydrogens(n24);
                        n25 += nArray3[n24];
                    }
                }
                object = new double[n4 != 0 ? 3 : 2][n13 + n25];
                n24 = 0;
                int n26 = 0;
                System.out.print("Raw coords:");
                for (int i = 1; i < n13; ++i) {
                    double d4;
                    if (n26 < n14 && nArray[1][n26] == i) {
                        n24 = nArray[0][n26++];
                        d4 = 1.0;
                    } else {
                        n24 = 0;
                        d4 = 8.0;
                    }
                    System.out.print(i + " (");
                    object[0][i] = object[0][n24] + d4 * (double)(this.decodeBits(n2) - n / 2);
                    System.out.print((int)object[0][i] + ",");
                    object[1][i] = object[1][n24] + d4 * (double)(this.decodeBits(n2) - n / 2);
                    System.out.print((int)object[1][i]);
                    if (n4) {
                        object[2][i] = object[2][n24] + d4 * (double)(this.decodeBits(n2) - n / 2);
                        System.out.print("," + (int)object[0][i]);
                    }
                    System.out.print("), ");
                    if ((i & 3) != 3 && i != n13 - 1) continue;
                    System.out.println();
                }
                double d5 = 0.0;
                if (n14 != 0) {
                    for (n26 = 0; n26 < n14; ++n26) {
                        d5 += this.getDistance((double[][])object, nArray[0][n26], nArray[1][n26], n4 != 0);
                    }
                    d5 /= (double)n14;
                } else {
                    double d6 = d3 = n4 != 0 ? 1.5 : Molecule.getDefaultAverageBondLength();
                    if (n13 < 2) {
                        d5 = d3;
                    } else {
                        d2 = Double.MAX_VALUE;
                        for (int i = 1; i < n13; ++i) {
                            for (int j = 0; j < i; ++j) {
                                d = this.getDistance((double[][])object, i, j, n4 != 0);
                                if (!(d > 0.0) || !(d < d2)) continue;
                                d2 = d;
                            }
                        }
                        double d7 = d5 = d2 == Double.MAX_VALUE ? d3 : d2;
                    }
                }
                if (byArray2[0] == 35) {
                    System.out.print("hydrogen coords (" + n25 + " expected): ");
                    int n27 = n13;
                    for (int i = 0; i < n13; ++i) {
                        if (nArray3[i] != 0) {
                            System.out.print(i);
                        }
                        for (int j = 0; j < nArray3[i]; ++j) {
                            System.out.print(" (");
                            object[0][n27] = object[0][i] + (double)(this.decodeBits(n2) - n / 2);
                            System.out.print((int)object[0][n27] + ",");
                            object[1][n27] = object[1][i] + (double)(this.decodeBits(n2) - n / 2);
                            System.out.print((int)object[1][n27]);
                            if (n4) {
                                object[2][n27] = object[2][i] + (double)(this.decodeBits(n2) - n / 2);
                                System.out.print("," + (int)object[2][n27]);
                            }
                            System.out.print("), ");
                            ++n27;
                        }
                    }
                    System.out.println();
                }
                System.out.print(n3 != 0 ? "absolute coords:" : "relative coords:");
                if (n25 != 0) {
                    System.out.println("Coordinates contain " + n25 + " hydrogen atoms!");
                }
                if (n3 != 0) {
                    d3 = this.decodeAVBL(this.decodeBits(n2), n);
                    d2 = d3 * this.decodeShift(this.decodeBits(n2), n);
                    double d8 = d3 * this.decodeShift(this.decodeBits(n2), n);
                    d = 0.0;
                    if (n4) {
                        d = d3 * this.decodeShift(this.decodeBits(n2), n);
                    }
                    System.out.println("Abs-coord transformation: targetAVBL:" + d3 + " xOffset:" + d2 + " yOffset:" + d8 + " zOffset:" + d);
                    double d9 = d3 / d5;
                    for (int i = 0; i < n13; ++i) {
                        object[0][i] = d2 + d9 * object[0][i];
                        object[1][i] = d2 + d9 * object[1][i];
                        if (!n4) continue;
                        object[2][i] = d2 + d9 * object[2][i];
                    }
                } else {
                    d3 = 1.5;
                    double d10 = d3 / d5;
                    for (int i = 0; i < n13; ++i) {
                        System.out.print(i + " (");
                        object[0][i] = object[0][i] * d10;
                        System.out.print(DoubleFormat.toString((double)object[0][i]) + ",");
                        object[1][i] = object[1][i] * d10;
                        System.out.print(DoubleFormat.toString((double)object[1][i]));
                        if (n4) {
                            object[2][i] = object[2][i] * d10;
                            System.out.print("," + DoubleFormat.toString((double)object[2][i]));
                        }
                        System.out.print("), ");
                        if ((i & 3) != 3 && i != n13 - 1) continue;
                        System.out.println();
                    }
                }
            }
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private double getDistance(double[][] dArray, int n, int n2, boolean bl) {
        double d = dArray[0][n] - dArray[0][n2];
        double d2 = dArray[1][n] - dArray[1][n2];
        double d3 = bl ? dArray[2][n] - dArray[2][n2] : 0.0;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }
}

