/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.AtomFunctionAnalyzer;
import com.actelion.research.chem.AtomTypeCalculator;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ExtendedMoleculeFunctions {
    public static final int NUMBER_ELEMENTS = 118;
    public static final int COLOR_FOR_CENTER_SELECTION = 128;
    public static final int[] arrRGroupsAtomicNo = new int[]{142, 143, 144, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141};
    public static final String[] arrRGroupsSymbol = new String[]{"R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15", "R16"};

    public static void makeSkeleton(StereoMolecule stereoMolecule) {
        int n;
        for (n = 0; n < stereoMolecule.getAllBonds(); ++n) {
            stereoMolecule.setBondType(n, 1);
        }
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            stereoMolecule.setAtomicNo(n, 6);
        }
    }

    public static void analyzeMolecule(StereoMolecule stereoMolecule) {
        int n;
        int n2 = stereoMolecule.getAtoms();
        for (n = 0; n < n2; ++n) {
            if (AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, n)) {
                System.out.println("Acidic oxygen " + n);
            }
            if (AtomFunctionAnalyzer.isNitroGroupN(stereoMolecule, n)) {
                System.out.println("Nitro group N " + n);
            }
            if (AtomFunctionAnalyzer.isMemberOfNitroGroup(stereoMolecule, n)) {
                System.out.println("Member of group " + n);
            }
            if (!AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, n)) continue;
            System.out.println("Basic nitrogen " + n);
        }
        System.out.println("Index\tAtomic no\tAtom type");
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            long l = -1L;
            try {
                l = AtomTypeCalculator.getAtomType(stereoMolecule, n, 6241);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println(n + "\t" + stereoMolecule.getAtomicNo(n) + "\t" + l + "\t" + AtomTypeCalculator.toString(l));
        }
        System.out.println();
    }

    public static String getColorVal2String(Molecule molecule, int n) {
        int n2 = molecule.getAtomColor(n);
        return ExtendedMoleculeFunctions.getcAtomColor2String(n2);
    }

    public static String getcAtomColor2String(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "black";
                break;
            }
            case 64: {
                string = "blue";
                break;
            }
            case 128: {
                string = "red";
                break;
            }
            case 192: {
                string = "green";
                break;
            }
            case 256: {
                string = "magenta";
                break;
            }
            case 320: {
                string = "orange";
                break;
            }
            case 384: {
                string = "darkGreen";
                break;
            }
            case 448: {
                string = "darkRed";
                break;
            }
        }
        return string;
    }

    public static String getColorRecord(Molecule molecule, Collection<Integer> collection, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int n3 : collection) {
            String string = ExtendedMoleculeFunctions.getcAtomColor2String(n);
            string = string + ":" + n3;
            stringBuilder.append(string);
            if (n2 < collection.size() - 1) {
                stringBuilder.append(";");
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int getNumQueryAtoms(ExtendedMolecule extendedMolecule, int[] nArray) {
        int n = 0;
        block0: for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            int n2 = extendedMolecule.getAtomicNo(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != n2) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    public static int getNumBondsNoHydrogen(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getBonds(); ++i) {
            int n2 = extendedMolecule.getBondAtom(0, i);
            int n3 = extendedMolecule.getAtomicNo(n2);
            int n4 = extendedMolecule.getBondAtom(1, i);
            int n5 = extendedMolecule.getAtomicNo(n4);
            if (n3 == 1 || n5 == 1) continue;
            ++n;
        }
        return n;
    }

    public static int getNumNonHydrogenAtoms(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAtoms(); ++i) {
            int n2 = extendedMolecule.getAtomicNo(i);
            if (n2 == 1) continue;
            ++n;
        }
        return n;
    }

    public static int getNumCarbonAtoms(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            int n2 = extendedMolecule.getAtomicNo(i);
            if (n2 != 6) continue;
            ++n;
        }
        return n;
    }

    public static int getNumHeteroAtoms(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            int n2 = extendedMolecule.getAtomicNo(i);
            if (n2 <= 1 || n2 == 6 || n2 > 118) continue;
            ++n;
        }
        return n;
    }

    public static boolean isHetero(ExtendedMolecule extendedMolecule, int n) {
        boolean bl = false;
        int n2 = extendedMolecule.getAtomicNo(n);
        if (n2 > 1 && n2 != 6 && n2 <= 118) {
            bl = true;
        }
        return bl;
    }

    public static int getNumNitroGroupN(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isNitroGroupN(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAmide(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isAmide(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumCarboxy(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isCarboxyC(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAcidicOxygen(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isAcidicOxygen(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumBasicNitrogen(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isBasicNitrogen(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAliphaticRingAtoms(ExtendedMolecule extendedMolecule, int n) {
        int n2 = 0;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            int n3 = extendedMolecule.getAtomicNo(i);
            if (!extendedMolecule.isRingAtom(i) || n3 != n) continue;
            ++n2;
        }
        return n2;
    }

    public static int getNumHeavyAtoms(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            int n2 = extendedMolecule.getAtomicNo(i);
            if (n2 <= 1 || n2 > 118) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAromaticAtoms(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAtoms(); ++i) {
            if (!extendedMolecule.isAromaticAtom(i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumArylAmine(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (!AtomFunctionAnalyzer.isArylAmine(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumHeteroAromaticAtoms(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAtoms(); ++i) {
            if (!extendedMolecule.isRingAtom(i) || !extendedMolecule.isAromaticAtom(i) || extendedMolecule.getAtomicNo(i) == 6) continue;
            ++n;
        }
        return n;
    }

    public static int getNumIsopropyl(ExtendedMolecule extendedMolecule) {
        int n = 0;
        for (int i = 0; i < extendedMolecule.getAtoms(); ++i) {
            if (!extendedMolecule.isRingAtom(i) || !extendedMolecule.isAromaticAtom(i) || extendedMolecule.getAtomicNo(i) == 6) continue;
            ++n;
        }
        return n;
    }

    public static int getNumSubstructure(StereoMolecule stereoMolecule, String string) {
        IDCodeParser iDCodeParser = new IDCodeParser();
        StereoMolecule stereoMolecule2 = iDCodeParser.getCompactMolecule(string);
        stereoMolecule2.ensureHelperArrays(7);
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setMol(stereoMolecule2, stereoMolecule);
        int n = sSSearcher.findFragmentInMolecule();
        return n;
    }

    public static int getBondNo(ExtendedMolecule extendedMolecule, int n, int n2) {
        for (int i = 0; i < extendedMolecule.getAllBonds(); ++i) {
            if ((extendedMolecule.getBondAtom(0, i) != n || extendedMolecule.getBondAtom(1, i) != n2) && (extendedMolecule.getBondAtom(0, i) != n2 || extendedMolecule.getBondAtom(1, i) != n)) continue;
            return i;
        }
        return -1;
    }

    public static int getBondOrder(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3 = ExtendedMoleculeFunctions.getBondNo(extendedMolecule, n, n2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = extendedMolecule.getBondOrder(n3);
        return n4;
    }

    public static int getBondType(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3 = ExtendedMoleculeFunctions.getBondNo(extendedMolecule, n, n2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = extendedMolecule.getBondType(n3);
        return n4;
    }

    public static int getBondParity(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3 = ExtendedMoleculeFunctions.getBondNo(extendedMolecule, n, n2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = extendedMolecule.getBondParity(n3);
        return n4;
    }

    public static boolean deleteBond(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3 = ExtendedMoleculeFunctions.getBondNo(extendedMolecule, n, n2);
        if (n3 == -1) {
            return false;
        }
        extendedMolecule.deleteBond(n3);
        return true;
    }

    public static String getBiggestFragmentIDCode(String string) {
        StereoMolecule stereoMolecule = new StereoMolecule();
        new IDCodeParser(false).parse(stereoMolecule, string);
        StereoMolecule[] stereoMoleculeArray = stereoMolecule.getFragments();
        String string2 = string;
        if (stereoMoleculeArray.length > 1) {
            StereoMolecule stereoMolecule2 = stereoMolecule;
            int n = 0;
            for (int i = 0; i < stereoMoleculeArray.length; ++i) {
                if (stereoMoleculeArray[i].getAllAtoms() <= n) continue;
                n = stereoMoleculeArray[i].getAllAtoms();
                stereoMolecule2 = stereoMoleculeArray[i];
            }
            Canonizer canonizer = new Canonizer(stereoMolecule2);
            string2 = canonizer.getIDCode();
        }
        return string2;
    }

    public static StereoMolecule getBiggestFragment(StereoMolecule stereoMolecule) {
        StereoMolecule[] stereoMoleculeArray = stereoMolecule.getFragments();
        StereoMolecule stereoMolecule2 = stereoMolecule;
        if (stereoMoleculeArray.length > 1) {
            int n = 0;
            for (int i = 0; i < stereoMoleculeArray.length; ++i) {
                if (stereoMoleculeArray[i].getAllAtoms() <= n) continue;
                n = stereoMoleculeArray[i].getAllAtoms();
                stereoMolecule2 = stereoMoleculeArray[i];
            }
        }
        return stereoMolecule2;
    }

    public static StereoMolecule getConverted2CarbonSkeleton(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(7);
        for (int i = 0; i < stereoMolecule2.getAtoms(); ++i) {
            if (stereoMolecule2.getAtomicNo(i) <= 1) continue;
            stereoMolecule2.setAtomicNo(i, 6);
        }
        stereoMolecule2.ensureHelperArrays(7);
        return stereoMolecule2;
    }

    public static Comparator<StereoMolecule> getComparatorAtomsBonds() {
        return new Comparator<StereoMolecule>(){

            @Override
            public int compare(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
                if (stereoMolecule.getAllAtoms() > stereoMolecule2.getAllAtoms()) {
                    return 1;
                }
                if (stereoMolecule.getAllAtoms() < stereoMolecule2.getAllAtoms()) {
                    return -1;
                }
                if (stereoMolecule.getAllBonds() > stereoMolecule2.getAllBonds()) {
                    return 1;
                }
                if (stereoMolecule.getAllBonds() < stereoMolecule2.getAllBonds()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static boolean checkBiggestFragmentForUnwanted(StereoMolecule stereoMolecule, List<Integer> list) {
        int n;
        boolean bl = true;
        StereoMolecule[] stereoMoleculeArray = stereoMolecule.getFragments();
        int n2 = 0;
        if (stereoMoleculeArray.length > 1) {
            int n3 = 0;
            for (n = 0; n < stereoMoleculeArray.length; ++n) {
                if (stereoMoleculeArray[n].getAllAtoms() <= n3) continue;
                n2 = n;
                n3 = stereoMoleculeArray[n].getAllAtoms();
            }
        }
        StereoMolecule stereoMolecule2 = stereoMoleculeArray[n2];
        for (n = 0; n < stereoMolecule2.getAllAtoms(); ++n) {
            if (!list.contains(new Integer(stereoMolecule2.getAtomicNo(n)))) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsAtLeastOneAtomicNumbersFromHashSet(ExtendedMolecule extendedMolecule, HashSet<Integer> hashSet) {
        boolean bl = false;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            if (!hashSet.contains(extendedMolecule.getAtomicNo(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsHeteroAtom(ExtendedMolecule extendedMolecule, int[] nArray) {
        boolean bl = false;
        for (int n : nArray) {
            if (extendedMolecule.getAtomicNo(n) == 6 || extendedMolecule.getAtomicNo(n) == 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsSolelyAtomicNumbersFromHashSet(ExtendedMolecule extendedMolecule, HashSet<Integer> hashSet) {
        boolean bl = true;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            if (hashSet.contains(extendedMolecule.getAtomicNo(i))) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static final boolean atomAtomSubStrucMatch(StereoMolecule stereoMolecule, int n, StereoMolecule stereoMolecule2) {
        boolean bl = false;
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setMol(stereoMolecule2, stereoMolecule);
        int n2 = sSSearcher.findFragmentInMolecule(4, 8);
        if (n2 == 0) {
            return false;
        }
        ArrayList<int[]> arrayList = sSSearcher.getMatchList();
        ArrayUtilsCalc.removeDoubletsIntOrderIndepend(arrayList);
        int n3 = -1;
        for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
            if (stereoMolecule2.getAtomColor(i) != 128) continue;
            n3 = i;
        }
        for (int[] nArray : arrayList) {
            if (nArray[n3] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static double[][] getDistanceArray(ExtendedMolecule extendedMolecule) {
        double[][] dArray = new double[extendedMolecule.getAllAtoms()][extendedMolecule.getAllAtoms()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray.length; ++j) {
                double d;
                double d2 = extendedMolecule.getAtomX(i) - extendedMolecule.getAtomX(j);
                double d3 = extendedMolecule.getAtomY(i) - extendedMolecule.getAtomY(j);
                double d4 = extendedMolecule.getAtomZ(i) - extendedMolecule.getAtomZ(j);
                dArray[i][j] = d = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    public static final int getTopologicalDistance(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3 = 0;
        if (n == n2) {
            return 0;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        arrayList.add(new Integer(n));
        arrayList2.add(new Integer(1));
        boolean bl = false;
        while (!arrayList.isEmpty()) {
            n3 = (Integer)arrayList2.remove(0);
            int n4 = (Integer)arrayList.remove(0);
            arrayList3.add(new Integer(n4));
            int n5 = extendedMolecule.getAllConnAtoms(n4);
            for (int i = 0; i < n5; ++i) {
                int n6 = extendedMolecule.getConnAtom(n4, i);
                if (n6 == n2) {
                    bl = true;
                    break;
                }
                if (arrayList3.contains(new Integer(n6))) continue;
                arrayList.add(new Integer(n6));
                arrayList2.add(new Integer(n3 + 1));
            }
            if (!bl) continue;
            break;
        }
        if (!bl) {
            n3 = -1;
        }
        return n3;
    }

    public static final int[][] getTopologicalDistanceMatrix(StereoMolecule stereoMolecule) {
        return ExtendedMoleculeFunctions.getNumberOfBondsBetweenAtoms(stereoMolecule, stereoMolecule.getBonds(), null);
    }

    public static int[][] getNumberOfBondsBetweenAtoms(StereoMolecule stereoMolecule, int n, int[][] nArray) {
        int n2;
        int n3;
        if (nArray == null) {
            nArray = new int[stereoMolecule.getAtoms()][stereoMolecule.getAtoms()];
        }
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3][n3] = 0;
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                nArray[n2][n3] = -1;
                nArray[n3][n2] = -1;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
                int n5 = stereoMolecule.getBondAtom(0, n2);
                int n6 = stereoMolecule.getBondAtom(1, n2);
                if (n5 >= n4 || n6 >= n4) continue;
                for (int i = 0; i < n4; ++i) {
                    if (nArray[i][n5] >= 0 && (nArray[i][n6] == -1 || nArray[i][n5] + 1 < nArray[i][n6]) && nArray[i][n5] < n) {
                        int n7 = nArray[i][n5] + 1;
                        nArray[i][n6] = n7;
                        nArray[n6][i] = n7;
                    }
                    if (nArray[i][n6] < 0 || nArray[i][n5] != -1 && nArray[i][n6] + 1 >= nArray[i][n5] || nArray[i][n6] >= n) continue;
                    int n8 = nArray[i][n6] + 1;
                    nArray[i][n5] = n8;
                    nArray[n5][i] = n8;
                }
            }
        }
        return nArray;
    }

    public static boolean isAliphaticAtom(StereoMolecule stereoMolecule, int n) {
        boolean bl = true;
        if (stereoMolecule.getAtomicNo(n) != 6) {
            return false;
        }
        int n2 = stereoMolecule.getAllConnAtoms(n);
        for (int i = 0; i < n2; ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            int n4 = stereoMolecule.getAtomicNo(n3);
            if (n4 != 7 && n4 != 8 && n4 != 9 && n4 != 15 && n4 != 16 && n4 != 17) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isAcceptor(StereoMolecule stereoMolecule, int n) {
        boolean bl = true;
        if (stereoMolecule.getAtomicNo(n) != 8 && stereoMolecule.getAtomicNo(n) != 7) {
            return false;
        }
        return bl;
    }

    public static boolean isDonor(StereoMolecule stereoMolecule, int n) {
        boolean bl = true;
        if (stereoMolecule.getAtomicNo(n) != 8 && stereoMolecule.getAtomicNo(n) != 7) {
            return false;
        }
        if (stereoMolecule.getAllHydrogens(n) == 0) {
            return false;
        }
        return bl;
    }

    public static boolean isCarbonTwoValencesMinimum(StereoMolecule stereoMolecule) {
        boolean bl = true;
        int n = stereoMolecule.getAtoms();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = stereoMolecule.getAtomicNo(i);
            if (n3 != 6 || (n2 = stereoMolecule.getConnAtoms(i)) >= 2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isCarbonOnlyConnected2Hetero(StereoMolecule stereoMolecule) {
        boolean bl = true;
        int n = stereoMolecule.getAtoms();
        block0: for (int i = 0; i < n; ++i) {
            int n2 = stereoMolecule.getAtomicNo(i);
            if (n2 != 6) continue;
            int n3 = stereoMolecule.getConnAtoms(i);
            for (int j = 0; j < n3; ++j) {
                int n4 = stereoMolecule.getConnAtom(i, j);
                if (stereoMolecule.getAtomicNo(n4) != 6) continue;
                bl = false;
                break block0;
            }
            if (!stereoMolecule.isRingAtom(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isCarbonConnected2Hetero(StereoMolecule stereoMolecule, int n) {
        boolean bl = false;
        int n2 = stereoMolecule.getAtomicNo(n);
        if (n2 == 6) {
            int n3 = stereoMolecule.getConnAtoms(n);
            for (int i = 0; i < n3; ++i) {
                int n4 = stereoMolecule.getConnAtom(n, i);
                if (stereoMolecule.getAtomicNo(n4) == 6 || stereoMolecule.getAtomicNo(n4) == 1) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean isConnected2Hetero(StereoMolecule stereoMolecule, int[] nArray) {
        boolean bl = false;
        block0: for (int n : nArray) {
            int n2 = stereoMolecule.getConnAtoms(n);
            for (int i = 0; i < n2; ++i) {
                int n3 = stereoMolecule.getConnAtom(n, i);
                if (stereoMolecule.getAtomicNo(n3) == 6 || stereoMolecule.getAtomicNo(n3) == 1) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public static boolean isRingInMolecule(StereoMolecule stereoMolecule) {
        boolean bl = false;
        int n = stereoMolecule.getAtoms();
        for (int i = 0; i < n; ++i) {
            if (!stereoMolecule.isRingAtom(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isRingExclusively(StereoMolecule stereoMolecule) {
        boolean bl = true;
        int n = stereoMolecule.getAtoms();
        for (int i = 0; i < n; ++i) {
            if (stereoMolecule.isRingAtom(i)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean containsFiveBindingCarbon(StereoMolecule stereoMolecule) {
        boolean bl = false;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 6) continue;
            int n = 0;
            for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                int n2 = stereoMolecule.getConnBondOrder(i, j);
                n += n2;
            }
            bl = n > 4;
        }
        return bl;
    }

    public static boolean isCyanoN(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 7) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtoms(n);
        if (n2 != 1) {
            return false;
        }
        int n3 = stereoMolecule.getConnAtom(n, 0);
        int n4 = stereoMolecule.getBond(n, n3);
        return stereoMolecule.getBondOrder(n4) == 3;
    }

    public static boolean isThioEther(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 16) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtoms(n);
        if (n2 != 2) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n3) == 6) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isWildcard(StereoMolecule stereoMolecule, int n) {
        return stereoMolecule.getAtomicNo(n) == 0;
    }

    public static boolean isSulfoxyGroup(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 16) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtoms(n);
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAtomicNo(n3) != 8) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isIsolatedCarbon(StereoMolecule stereoMolecule, int n, int[] nArray) {
        boolean bl = true;
        int n2 = stereoMolecule.getConnAtoms(n);
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < n2; ++i) {
            blArray[stereoMolecule.getConnAtom((int)n, (int)i)] = true;
        }
        for (int n3 : nArray) {
            if (!blArray[n3] || stereoMolecule.getAtomicNo(n3) != 6) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static int[] extractAromaticRing(StereoMolecule stereoMolecule, int[] nArray) {
        RingCollection ringCollection = stereoMolecule.getRingSet();
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        int[] nArray2 = null;
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            int[] nArray3;
            if (!ringCollection.isAromatic(i)) continue;
            Arrays.fill(blArray, false);
            for (int n : nArray3 = ringCollection.getRingAtoms(i)) {
                blArray[n] = true;
            }
            int n = 0;
            for (int n2 : nArray) {
                if (!blArray[n2]) continue;
                ++n;
            }
            if (n != nArray3.length) continue;
            nArray2 = nArray3;
            break;
        }
        return nArray2;
    }

    public static int getNumCyanoGroups(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isCyanoN(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAlcoholicOxygen(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isAlcoholicOxygen(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumThioEther(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isThioEther(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumSulfOxyGroups(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isSulfoxyGroup(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumWildcards(StereoMolecule stereoMolecule) {
        int n = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!ExtendedMoleculeFunctions.isWildcard(stereoMolecule, i)) continue;
            ++n;
        }
        return n;
    }

    public static boolean isAlcoholicOxygen(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.isAromaticAtom(n)) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtoms(n);
        if (n2 != 1) {
            return false;
        }
        int n3 = stereoMolecule.getConnAtom(n, 0);
        if (stereoMolecule.getAtomicNo(n3) != 6) {
            return false;
        }
        return AtomFunctionAnalyzer.getNegativeNeighbourCount(stereoMolecule, n3) <= 1;
    }

    public static boolean isEtherOxygenAtAromatic(StereoMolecule stereoMolecule, int n) {
        boolean bl = false;
        if (stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.isAromaticAtom(n)) {
            return false;
        }
        int n2 = stereoMolecule.getConnAtoms(n);
        if (n2 != 2) {
            return false;
        }
        int n3 = stereoMolecule.getConnAtom(n, 0);
        int n4 = stereoMolecule.getConnAtom(n, 1);
        if (stereoMolecule.isAromaticAtom(n3)) {
            bl = true;
        } else if (stereoMolecule.isAromaticAtom(n4)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isCarboxyC(StereoMolecule stereoMolecule, int n) {
        int n2;
        if (stereoMolecule.getAtomicNo(n) != 6 || stereoMolecule.getAtomPi(n) != 0) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n); ++n2) {
            int n3 = stereoMolecule.getConnAtom(n, n2);
            if (stereoMolecule.getAtomicNo(n3) != 6) continue;
            int n4 = stereoMolecule.getBond(n, n3);
            int n5 = stereoMolecule.getBondOrder(n4);
            if (n5 == 1) {
                bl2 = true;
                continue;
            }
            if (n5 != 2) continue;
            bl = true;
        }
        n2 = 0;
        if (bl && bl2) {
            n2 = 1;
        }
        return n2 != 0;
    }

    public static int replaceAtoms(ExtendedMolecule[] extendedMoleculeArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < extendedMoleculeArray.length; ++i) {
            n3 += ExtendedMoleculeFunctions.replaceAtoms(extendedMoleculeArray[i], n, n2);
        }
        return n3;
    }

    public static int replaceAtoms(ExtendedMolecule extendedMolecule, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < extendedMolecule.getAllAtoms(); ++i) {
            if (extendedMolecule.getAtomicNo(i) != n) continue;
            extendedMolecule.setAtomicNo(i, n2);
            ++n3;
        }
        return n3;
    }

    public static final LinkedList<StereoMolecule> removeSubStructures(List<StereoMolecule> list) {
        SSSearcher sSSearcher = new SSSearcher();
        LinkedList<StereoMolecule> linkedList = new LinkedList<StereoMolecule>(list);
        block0: for (int i = linkedList.size() - 1; i >= 0; --i) {
            StereoMolecule stereoMolecule = linkedList.get(i);
            for (int j = 0; j < linkedList.size(); ++j) {
                if (i == j) continue;
                StereoMolecule stereoMolecule2 = linkedList.get(j);
                if (stereoMolecule.getAtoms() >= stereoMolecule2.getAtoms()) continue;
                sSSearcher.setMol(stereoMolecule, stereoMolecule2);
                if (!sSSearcher.isFragmentInMolecule()) continue;
                linkedList.remove(i);
                continue block0;
            }
        }
        return linkedList;
    }

    public static StereoMolecule removeSubstructuresFromMolecule(StereoMolecule stereoMolecule, List<StereoMolecule> list) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(7);
        SSSearcher sSSearcher = new SSSearcher();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (StereoMolecule stereoMolecule3 : list) {
            sSSearcher.setMol(stereoMolecule3, stereoMolecule2);
            if (sSSearcher.findFragmentInMolecule() <= 0) continue;
            ArrayList<int[]> arrayList = sSSearcher.getMatchList();
            hashSet.clear();
            for (int[] nArray : arrayList) {
                for (int i = 0; i < nArray.length; ++i) {
                    hashSet.add(nArray[i]);
                }
            }
            Object object = ArrayUtilsCalc.toIntArray(hashSet);
            stereoMolecule2.deleteAtoms((int[])object);
            stereoMolecule2.ensureHelperArrays(7);
        }
        return stereoMolecule2;
    }

    public static StereoMolecule removeSubstructureFromMolecule(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        StereoMolecule stereoMolecule3 = new StereoMolecule(stereoMolecule);
        stereoMolecule3.ensureHelperArrays(7);
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setMol(stereoMolecule2, stereoMolecule3);
        if (sSSearcher.findFragmentInMolecule() > 0) {
            ArrayList<int[]> arrayList = sSSearcher.getMatchList();
            if (arrayList.size() > 1) {
                throw new RuntimeException("Fragment found more than once!");
            }
            if (arrayList.size() == 1) {
                int[] nArray = (int[])arrayList.get(0);
                stereoMolecule3.deleteAtoms(nArray);
                stereoMolecule3.ensureHelperArrays(7);
            }
        }
        return stereoMolecule3;
    }

    public static StereoMolecule removeWildcards(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(7);
        for (int i = stereoMolecule2.getAtoms() - 1; i >= 0; --i) {
            if (stereoMolecule2.getAtomicNo(i) != 0) continue;
            stereoMolecule2.deleteAtom(i);
        }
        stereoMolecule2.ensureHelperArrays(7);
        return stereoMolecule2;
    }

    public static void setColorMCS2Molecule(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            stereoMolecule.setAtomColor(i, 0);
        }
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setMol(stereoMolecule2, stereoMolecule);
        if (sSSearcher.findFragmentInMolecule() > 0) {
            ArrayList<int[]> arrayList = sSSearcher.getMatchList();
            int[] nArray = (int[])arrayList.get(0);
            for (int i = 0; i < nArray.length; ++i) {
                stereoMolecule.setAtomColor(nArray[i], 64);
            }
        }
    }

    public static void setColorMolecule(StereoMolecule stereoMolecule, int[] nArray) {
        int n;
        for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
            stereoMolecule.setAtomColor(n, 0);
        }
        for (n = 0; n < nArray.length; ++n) {
            stereoMolecule.setAtomColor(nArray[n], 64);
        }
    }

    public static void setColorMoleculeFromBondIndex(StereoMolecule stereoMolecule, int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = stereoMolecule.getBondAtom(0, nArray[i]);
            int n3 = stereoMolecule.getBondAtom(1, nArray[i]);
            stereoMolecule.setAtomColor(n2, n);
            stereoMolecule.setAtomColor(n3, n);
        }
    }

    public static void setCoordinatesNull(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            stereoMolecule.setAtomX(i, 0.0);
            stereoMolecule.setAtomY(i, 0.0);
            stereoMolecule.setAtomZ(i, 0.0);
        }
    }

    public static String getColorVectorSubstructure(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n) {
        Object object;
        SSSearcher sSSearcher = new SSSearcher();
        sSSearcher.setMol(stereoMolecule2, stereoMolecule);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (sSSearcher.findFragmentInMolecule() > 0) {
            object = sSSearcher.getMatchList();
            int[] nArray = (int[])object.get(0);
            for (int i = 0; i < nArray.length; ++i) {
                hashSet.add(nArray[i]);
            }
        }
        object = ExtendedMoleculeFunctions.getColorRecord(stereoMolecule, hashSet, n);
        return object;
    }

    public static float getSimilarity(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, DescriptorHandler descriptorHandler) {
        Object t = descriptorHandler.createDescriptor(stereoMolecule);
        Object t2 = descriptorHandler.createDescriptor(stereoMolecule2);
        return descriptorHandler.getSimilarity(t, t2);
    }

    public static StereoMolecule getSphere(StereoMolecule stereoMolecule, int n, int n2) {
        stereoMolecule.ensureHelperArrays(7);
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAtoms(), stereoMolecule.getBonds());
        int[] nArray = new int[stereoMolecule.getAtoms()];
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        if (n != 0) {
            Arrays.fill(blArray, false);
        }
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2 && n4 < stereoMolecule.getAtoms(); ++i) {
            if (n4 == 0) {
                nArray[0] = n;
                blArray[n] = true;
                n4 = 1;
            } else {
                int n5 = n4;
                for (int j = n3; j < n4; ++j) {
                    int n6 = nArray[j];
                    for (int k = 0; k < stereoMolecule.getConnAtoms(n6); ++k) {
                        int n7 = stereoMolecule.getConnAtom(n6, k);
                        if (blArray[n7]) continue;
                        blArray[n7] = true;
                        nArray[n5++] = n7;
                    }
                }
                n3 = n4;
                n4 = n5;
            }
            stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, true, null);
        }
        return stereoMolecule2;
    }

    public static int getAtomicNoRGroup(int n) {
        if (n > arrRGroupsAtomicNo.length) {
            throw new RuntimeException("");
        }
        return arrRGroupsAtomicNo[n - 1];
    }
}

