/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.calc.DataProcessor;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class Clusterer<T>
extends DataProcessor {
    private volatile int[] mClusterNo;
    private volatile int[] mNoOfMembers;
    private volatile int mNoOfCompounds;
    private volatile float[][] mSimilarityMatrix;
    private volatile T[] mDescriptor;
    private volatile DescriptorHandler<T, ?> mDescriptorHandler;
    private volatile AtomicInteger mSMPCompoundIndex;
    private boolean[] mIsRepresentative;
    private int mNoOfClusters;
    private int mThreadCount;
    private ExecutorService mExecutor;
    private ClusterWorker<T>[] mClusterWorker;

    public Clusterer(DescriptorHandler<T, ?> descriptorHandler, T[] TArray) {
        int n;
        this.mDescriptorHandler = descriptorHandler;
        this.mDescriptor = TArray;
        this.mNoOfCompounds = this.mDescriptor.length;
        this.mSimilarityMatrix = new float[this.mNoOfCompounds][];
        for (n = 1; n < this.mNoOfCompounds; ++n) {
            this.mSimilarityMatrix[n] = new float[n];
        }
        this.mThreadCount = Runtime.getRuntime().availableProcessors();
        if (this.mThreadCount != 1) {
            this.mExecutor = Executors.newFixedThreadPool(this.mThreadCount);
            this.mClusterWorker = new ClusterWorker[this.mThreadCount];
            for (n = 0; n < this.mThreadCount; ++n) {
                this.mClusterWorker[n] = new ClusterWorker();
            }
        }
    }

    public void cluster(double d, int n) {
        this.calculateSimilarityMatrix(false);
        if (this.threadMustDie()) {
            this.stopProgress("clustering cancelled");
            return;
        }
        this.mNoOfMembers = new int[this.mNoOfCompounds];
        this.mClusterNo = new int[this.mNoOfCompounds];
        for (int i = 0; i < this.mNoOfCompounds; ++i) {
            this.mNoOfMembers[i] = 1;
            this.mClusterNo[i] = i;
        }
        if (n < 1) {
            n = 1;
        }
        if (d != 0.0) {
            this.startProgress("Clustering Compounds...", 0, (int)(5000.0 * (1.0 - d)));
        } else {
            this.startProgress("Clustering Compounds...", 0, this.mNoOfCompounds - n);
        }
        this.mNoOfClusters = this.mNoOfCompounds;
        while (this.mNoOfClusters > n) {
            int n2;
            int n3;
            float f = 0.0f;
            int n4 = -1;
            int n5 = -1;
            if (this.mThreadCount == 1) {
                for (n3 = 1; n3 < this.mNoOfCompounds; ++n3) {
                    if (this.mNoOfMembers[n3] <= 0) continue;
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (this.mNoOfMembers[n2] == 0 || !(f < this.mSimilarityMatrix[n3][n2])) continue;
                        f = this.mSimilarityMatrix[n3][n2];
                        n4 = n2;
                        n5 = n3;
                    }
                }
            } else {
                this.runInParallel(3);
                ClusterWorker<T>[] clusterWorkerArray = this.mClusterWorker;
                n2 = clusterWorkerArray.length;
                for (int i = 0; i < n2; ++i) {
                    ClusterWorker<T> clusterWorker = clusterWorkerArray[i];
                    if (!(f < clusterWorker.getMaxSimilarity())) continue;
                    f = clusterWorker.getMaxSimilarity();
                    n4 = clusterWorker.getCluster1();
                    n5 = clusterWorker.getCluster2();
                }
            }
            if ((double)f < d) break;
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.mNoOfMembers[n3] == 0) continue;
                this.mSimilarityMatrix[n4][n3] = ((float)this.mNoOfMembers[n4] * this.mSimilarityMatrix[n4][n3] + (float)this.mNoOfMembers[n5] * this.mSimilarityMatrix[n5][n3]) / (float)(this.mNoOfMembers[n4] + this.mNoOfMembers[n5]);
            }
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                if (this.mNoOfMembers[n3] == 0) continue;
                this.mSimilarityMatrix[n3][n4] = ((float)this.mNoOfMembers[n4] * this.mSimilarityMatrix[n3][n4] + (float)this.mNoOfMembers[n5] * this.mSimilarityMatrix[n5][n3]) / (float)(this.mNoOfMembers[n4] + this.mNoOfMembers[n5]);
            }
            for (n3 = n5 + 1; n3 < this.mNoOfCompounds; ++n3) {
                if (this.mNoOfMembers[n3] == 0) continue;
                this.mSimilarityMatrix[n3][n4] = ((float)this.mNoOfMembers[n4] * this.mSimilarityMatrix[n3][n4] + (float)this.mNoOfMembers[n5] * this.mSimilarityMatrix[n3][n5]) / (float)(this.mNoOfMembers[n4] + this.mNoOfMembers[n5]);
            }
            int n6 = n4;
            this.mNoOfMembers[n6] = this.mNoOfMembers[n6] + this.mNoOfMembers[n5];
            this.mNoOfMembers[n5] = 0;
            for (n3 = 0; n3 < this.mNoOfCompounds; ++n3) {
                if (this.mClusterNo[n3] != n5) continue;
                this.mClusterNo[n3] = n4;
            }
            --this.mNoOfClusters;
            if (this.threadMustDie()) {
                this.stopProgress("clustering cancelled");
                return;
            }
            if (d != 0.0) {
                this.updateProgress((int)(5000.0 * (1.0 - (double)f)));
                continue;
            }
            this.updateProgress(this.mNoOfCompounds - this.mNoOfClusters);
        }
        this.findRepresentatives();
        this.mExecutor.shutdown();
        while (!this.mExecutor.isTerminated()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.stopProgress("clustering finished");
    }

    public boolean isRepresentative(int n) {
        return this.mIsRepresentative[n];
    }

    public int getClusterNo(int n) {
        return this.mClusterNo[n];
    }

    public int getClusterCount() {
        return this.mNoOfClusters;
    }

    public void regenerateClusterNos() {
        int[] nArray = new int[this.mNoOfCompounds];
        int n = 1;
        for (int i = 0; i < this.mNoOfCompounds; ++i) {
            if (nArray[this.mClusterNo[i]] == 0) {
                nArray[i] = n++;
            }
            this.mClusterNo[i] = nArray[this.mClusterNo[i]];
        }
    }

    private void calculateSimilarityMatrix(boolean bl) {
        this.startProgress("Calculating Similaries...", 0, 1000);
        if (this.mThreadCount == 1) {
            for (int i = 1; i < this.mNoOfCompounds && !this.threadMustDie(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (bl && this.mClusterNo[j] != this.mClusterNo[i]) continue;
                    this.mSimilarityMatrix[i][j] = this.mDescriptorHandler.getSimilarity(this.mDescriptor[j], this.mDescriptor[i]);
                }
                this.updateProgress((int)(1000.0 * (double)i * (double)i / (double)this.mNoOfCompounds / (double)this.mNoOfCompounds));
            }
        } else if (bl) {
            this.runInParallel(2);
        } else {
            this.runInParallel(1);
        }
    }

    public float getSimilarity(int n, int n2) {
        if (n == n2) {
            return 1.0f;
        }
        return this.mSimilarityMatrix[Math.max(n, n2)][Math.min(n, n2)];
    }

    private void findRepresentatives() {
        int n;
        int n2;
        this.calculateSimilarityMatrix(true);
        if (this.threadMustDie()) {
            return;
        }
        float[] fArray = new float[this.mNoOfCompounds];
        float[] fArray2 = new float[this.mNoOfCompounds];
        for (n2 = 0; n2 < this.mNoOfCompounds; ++n2) {
            fArray[n2] = 1.0f;
            fArray2[n2] = 0.0f;
        }
        this.startProgress("Locating Representatives...", 0, this.mNoOfCompounds);
        for (n2 = 1; n2 < this.mNoOfCompounds; ++n2) {
            if (this.threadMustDie()) {
                return;
            }
            this.updateProgress(n2);
            for (n = 0; n < n2; ++n) {
                if (this.mClusterNo[n] != this.mClusterNo[n2]) continue;
                if (fArray[this.mClusterNo[n]] > this.mSimilarityMatrix[n2][n]) {
                    fArray[this.mClusterNo[n]] = this.mSimilarityMatrix[n2][n];
                }
                int n3 = n;
                fArray2[n3] = fArray2[n3] + this.mSimilarityMatrix[n2][n];
                int n4 = n2;
                fArray2[n4] = fArray2[n4] + this.mSimilarityMatrix[n2][n];
            }
        }
        int[] nArray = new int[this.mNoOfCompounds];
        for (n = 0; n < this.mNoOfCompounds; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < this.mNoOfCompounds; ++n) {
            if (nArray[this.mClusterNo[n]] != -1 && !(fArray2[nArray[this.mClusterNo[n]]] < fArray2[n])) continue;
            nArray[this.mClusterNo[n]] = n;
        }
        this.mIsRepresentative = new boolean[this.mNoOfCompounds];
        for (n = 0; n < this.mNoOfCompounds; ++n) {
            if (nArray[this.mClusterNo[n]] != n) continue;
            this.mIsRepresentative[n] = true;
        }
    }

    private void runInParallel(int n) {
        CountDownLatch countDownLatch = new CountDownLatch(this.mThreadCount);
        for (ClusterWorker<T> clusterWorker : this.mClusterWorker) {
            clusterWorker.initJob(n, countDownLatch);
            this.mExecutor.execute(clusterWorker);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class ClusterWorker<U>
    implements Runnable {
        private static final int CALC_ALL_SIMILARITIES = 1;
        private static final int CALC_CLUSTER_SIMILARITIES = 2;
        private static final int FIND_MAXIMUM_SIMILARITY = 3;
        private CountDownLatch mDoneSignal;
        private int mWhatToDo;
        private int mCluster1;
        private int mCluster2;
        private float mMaxSimilarity;
        private DescriptorHandler<T, ?> mThreadSafeDH;

        private ClusterWorker() {
        }

        public void initJob(int n, CountDownLatch countDownLatch) {
            this.mWhatToDo = n;
            this.mDoneSignal = countDownLatch;
            Clusterer.this.mSMPCompoundIndex = new AtomicInteger(Clusterer.this.mNoOfCompounds);
            this.mThreadSafeDH = Clusterer.this.mDescriptorHandler.getThreadSafeCopy();
        }

        @Override
        public void run() {
            switch (this.mWhatToDo) {
                case 1: {
                    int n = Clusterer.this.mSMPCompoundIndex.decrementAndGet();
                    while (n >= 1 && !Clusterer.this.threadMustDie()) {
                        for (int i = 0; i < n; ++i) {
                            ((Clusterer)Clusterer.this).mSimilarityMatrix[n][i] = this.mThreadSafeDH.getSimilarity(Clusterer.this.mDescriptor[i], Clusterer.this.mDescriptor[n]);
                        }
                        n = Clusterer.this.mSMPCompoundIndex.decrementAndGet();
                        Clusterer.this.updateProgress(1000 - (int)(1000.0 * (double)n * (double)n / (double)Clusterer.this.mNoOfCompounds / (double)Clusterer.this.mNoOfCompounds));
                    }
                    break;
                }
                case 2: {
                    int n = Clusterer.this.mSMPCompoundIndex.decrementAndGet();
                    while (n >= 1 && !Clusterer.this.threadMustDie()) {
                        for (int i = 0; i < n; ++i) {
                            if (Clusterer.this.mClusterNo[i] != Clusterer.this.mClusterNo[n]) continue;
                            ((Clusterer)Clusterer.this).mSimilarityMatrix[n][i] = this.mThreadSafeDH.getSimilarity(Clusterer.this.mDescriptor[i], Clusterer.this.mDescriptor[n]);
                        }
                        n = Clusterer.this.mSMPCompoundIndex.decrementAndGet();
                        Clusterer.this.updateProgress(1000 - (int)(1000.0 * (double)n * (double)n / (double)Clusterer.this.mNoOfCompounds / (double)Clusterer.this.mNoOfCompounds));
                    }
                    break;
                }
                case 3: {
                    this.mMaxSimilarity = 0.0f;
                    this.mCluster1 = -1;
                    this.mCluster2 = -1;
                    int n = Clusterer.this.mSMPCompoundIndex.decrementAndGet();
                    while (n >= 1 && !Clusterer.this.threadMustDie()) {
                        if (Clusterer.this.mNoOfMembers[n] > 0) {
                            for (int i = 0; i < n; ++i) {
                                if (Clusterer.this.mNoOfMembers[i] == 0 || !(this.mMaxSimilarity < Clusterer.this.mSimilarityMatrix[n][i])) continue;
                                this.mMaxSimilarity = Clusterer.this.mSimilarityMatrix[n][i];
                                this.mCluster1 = i;
                                this.mCluster2 = n;
                            }
                        }
                        n = Clusterer.this.mSMPCompoundIndex.decrementAndGet();
                    }
                    break;
                }
            }
            this.mDoneSignal.countDown();
        }

        public float getMaxSimilarity() {
            return this.mMaxSimilarity;
        }

        public int getCluster1() {
            return this.mCluster1;
        }

        public int getCluster2() {
            return this.mCluster2;
        }
    }
}

