/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectFactory;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.generic.GenericShape;

public abstract class AbstractDrawingObject {
    protected static final String DESCRIPTOR_START = "<DrawingObject";
    protected static final String DESCRIPTOR_END = "></DrawingObject>";
    protected static final String DESCRIPTOR_TYPE = " type=\"";
    protected GenericPoint[] mPoint;
    protected boolean mIsSelected;
    protected boolean mProtectedFromDeletion;
    protected double mTransformationReferenceX;
    protected double mTransformationReferenceY;
    protected double[] mTransformationValue1;
    protected double[] mTransformationValue2;

    public abstract void draw(GenericDrawContext var1, DepictorTransformation var2);

    public abstract void hilite(GenericDrawContext var1);

    public abstract void clearHiliting();

    public abstract boolean contains(double var1, double var3);

    public abstract boolean checkHiliting(double var1, double var3);

    public abstract AbstractDrawingObject clone();

    public abstract String getDescriptorDetail();

    public abstract String getTypeString();

    public static AbstractDrawingObject instantiate(String string) {
        return DrawingObjectFactory.createObject(string);
    }

    public void move(double d, double d2) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                this.mPoint[i].x += d;
                this.mPoint[i].y += d2;
            }
        }
    }

    public void scale(double d) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                this.mPoint[i].x *= d;
                this.mPoint[i].y *= d;
            }
        }
    }

    public boolean isDeletable() {
        return !this.mProtectedFromDeletion;
    }

    public void setDeletable(boolean bl) {
        this.mProtectedFromDeletion = !bl;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean bl) {
        this.mIsSelected = bl;
    }

    public GenericRectangle getBoundingRect(GenericDrawContext genericDrawContext) {
        if (this.mPoint == null) {
            return null;
        }
        GenericRectangle genericRectangle = new GenericRectangle(this.mPoint[0].x, this.mPoint[0].y, 0.0, 0.0);
        for (int i = 1; i < this.mPoint.length; ++i) {
            if (genericRectangle.x > this.mPoint[i].x) {
                genericRectangle.width += genericRectangle.x - this.mPoint[i].x;
                genericRectangle.x = this.mPoint[i].x;
            } else if (genericRectangle.width < this.mPoint[i].x - genericRectangle.x) {
                genericRectangle.width = this.mPoint[i].x - genericRectangle.x;
            }
            if (genericRectangle.y > this.mPoint[i].y) {
                genericRectangle.height += genericRectangle.y - this.mPoint[i].y;
                genericRectangle.y = this.mPoint[i].y;
                continue;
            }
            if (!(genericRectangle.height < this.mPoint[i].y - genericRectangle.y)) continue;
            genericRectangle.height = this.mPoint[i].y - genericRectangle.y;
        }
        return genericRectangle;
    }

    public boolean isSurroundedBy(GenericShape genericShape) {
        if (this.mPoint == null) {
            return false;
        }
        for (int i = 0; i < this.mPoint.length; ++i) {
            if (genericShape.contains(this.mPoint[i].x, this.mPoint[i].y)) continue;
            return false;
        }
        return true;
    }

    public void translateInit(double d, double d2) {
        this.mTransformationReferenceX = d;
        this.mTransformationReferenceY = d2;
        if (this.mPoint != null) {
            int n = this.mPoint.length;
            this.mTransformationValue1 = new double[n];
            this.mTransformationValue2 = new double[n];
            for (int i = 0; i < n; ++i) {
                this.mTransformationValue1[i] = this.mPoint[i].x;
                this.mTransformationValue2[i] = this.mPoint[i].y;
            }
        }
    }

    public void translate(double d, double d2) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                this.mPoint[i].x = this.mTransformationValue1[i] + d - this.mTransformationReferenceX;
                this.mPoint[i].y = this.mTransformationValue2[i] + d2 - this.mTransformationReferenceY;
            }
        }
    }

    public void zoomAndRotateInit(double d, double d2) {
        this.mTransformationReferenceX = d;
        this.mTransformationReferenceY = d2;
        if (this.mPoint != null) {
            int n = this.mPoint.length;
            this.mTransformationValue1 = new double[n];
            this.mTransformationValue2 = new double[n];
            for (int i = 0; i < n; ++i) {
                double d3 = d - this.mPoint[i].x;
                double d4 = d2 - this.mPoint[i].y;
                this.mTransformationValue2[i] = Math.sqrt(d3 * d3 + d4 * d4);
                this.mTransformationValue1[i] = Molecule.getAngle(d, d2, this.mPoint[i].x, this.mPoint[i].y);
            }
        }
    }

    public void zoomAndRotate(double d, double d2) {
        if (this.mPoint != null) {
            for (int i = 0; i < this.mPoint.length; ++i) {
                double d3 = this.mTransformationValue2[i] * d;
                double d4 = this.mTransformationValue1[i] - d2;
                this.mPoint[i].x = this.mTransformationReferenceX + d3 * Math.sin(d4);
                this.mPoint[i].y = this.mTransformationReferenceY + d3 * Math.cos(d4);
            }
        }
    }

    public String getDescriptor() {
        return "<DrawingObject type=\"" + this.getTypeString() + "\"" + this.getDescriptorDetail() + DESCRIPTOR_END;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDescriptor());
        return stringBuffer.toString();
    }
}

