/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.histogram;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.histogram.Histogram;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;

public class MatrixBasedHistogram {
    public static boolean VERBOSE = false;

    public static Histogram getFromQuadraticMatrix(Matrix matrix, double d, double d2, int n) {
        int n2 = matrix.rows();
        int n3 = (n2 * n2 - n2) / 2;
        double[] dArray = new double[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                dArray[n4++] = matrix.get(i, j);
            }
        }
        return new Histogram(dArray, d, d2, n);
    }

    public static Matrix getHistogram(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = new Matrix(matrix2);
        matrix3.resize(3, matrix2.getColDim());
        for (int i = 0; i < matrix.getRowDim(); ++i) {
            for (int j = 0; j < matrix.getColDim(); ++j) {
                double d = matrix.get(i, j);
                MatrixBasedHistogram.placeValueInHistogramBin(d, matrix3);
            }
        }
        return matrix3;
    }

    public static Matrix getHistogram(double[] dArray, Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix);
        matrix2.resize(3, matrix.getColDim());
        for (int i = 0; i < dArray.length; ++i) {
            MatrixBasedHistogram.placeValueInHistogramBin(dArray[i], matrix2);
        }
        return matrix2;
    }

    private static void placeValueInHistogramBin(double d, Matrix matrix) {
        if (Double.isNaN(d)) {
            if (VERBOSE) {
                System.err.println("Warning NaN in placeValueInHistogramBin(...).");
            }
            return;
        }
        if (d < matrix.get(0, 0) || d > matrix.get(1, matrix.cols() - 1)) {
            return;
        }
        int n = matrix.cols();
        boolean bl = false;
        int n2 = matrix.cols() / 2;
        int n3 = 0;
        int n4 = matrix.cols() - 1;
        int n5 = 0;
        while (!bl) {
            if (d >= matrix.get(0, n2) && d < matrix.get(1, n2)) {
                matrix.increase(2, n2, 1.0);
                bl = true;
            } else if (d < matrix.get(0, n2)) {
                n4 = n2;
                n2 = n3 + (n2 - n3) / 2;
            } else if (d >= matrix.get(1, n2)) {
                n3 = n2;
                n2 += (int)(((double)n4 - (double)n2) / 2.0 + 0.5);
            }
            if (n5 == n) {
                String string = "Fitting bin for value " + d + " not found!\n" + MatrixBasedHistogram.histogram2String(matrix, 2, 8);
                throw new RuntimeException("Fitting bin for value " + d + " not found");
            }
            ++n5;
        }
    }

    public static Matrix getHistogram(Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix);
        matrix2.resize(3, matrix.getColDim());
        return matrix2;
    }

    public static double[] getBordersMostFreqOccBin(Matrix matrix, int n) {
        int n2;
        int n3;
        double[] dArray = new double[2];
        double d = 0.0;
        int n4 = -1;
        for (n3 = n; n3 < matrix.cols() - n; ++n3) {
            n2 = 0;
            for (int i = -n; i < n + 1; ++i) {
                n2 = (int)((double)n2 + matrix.get(2, n3 + i));
            }
            if (!((double)n2 > d)) continue;
            d = n2;
            n4 = n3;
        }
        n3 = Math.max(0, n4 - n);
        n2 = Math.min(matrix.cols() - 1, n4 + n);
        dArray[0] = matrix.get(0, n3);
        dArray[1] = matrix.get(1, n2);
        return dArray;
    }

    public static Matrix getHistogram(float[] fArray, Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix);
        matrix2.resize(3, matrix.getColDim());
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < matrix.getColDim(); ++j) {
                if (!((double)fArray[i] >= matrix2.get(0, j)) || !((double)fArray[i] < matrix2.get(1, j))) continue;
                int n = (int)matrix2.get(2, j);
                matrix2.set(2, j, ++n);
            }
        }
        return matrix2;
    }

    public static Matrix getHistogram(float[][] fArray, int n, Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix);
        matrix2.resize(3, matrix.getColDim());
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < matrix.getColDim(); ++j) {
                if (!((double)fArray[i][n] >= matrix2.get(0, j)) || !((double)fArray[i][n] < matrix2.get(1, j))) continue;
                int n2 = (int)matrix2.get(2, j);
                matrix2.set(2, j, ++n2);
            }
        }
        return matrix2;
    }

    public static Matrix getHistogram(Matrix matrix, int n) {
        double d = matrix.getMin() - matrix.getMin() * 1.0E-6;
        double d2 = matrix.getMax() + matrix.getMax() * 1.0E-6;
        Matrix matrix2 = MatrixBasedHistogram.getHistogramBins(d, d2, n);
        Matrix matrix3 = MatrixBasedHistogram.getHistogram(matrix, matrix2);
        return matrix3;
    }

    public static double getMinOccBin(Matrix matrix) {
        double d = 0.0;
        for (int i = 0; i < matrix.getColDim(); ++i) {
            if (!(matrix.get(2, i) > 0.0)) continue;
            d = matrix.get(0, i);
            break;
        }
        return d;
    }

    public static double getMaxOccBin(Matrix matrix) {
        double d = 0.0;
        for (int i = matrix.getColDim() - 1; i >= 0; --i) {
            if (!(matrix.get(2, i) > 0.0)) continue;
            d = matrix.get(1, i);
            break;
        }
        return d;
    }

    public static Matrix getHistogramBins(double d, double d2, int n) {
        Matrix matrix = new Matrix(2, n);
        double d3 = d2 - d;
        double d4 = d3 / (double)n;
        double d5 = d4 * 1.0E-4;
        double d6 = d;
        int n2 = matrix.getColDim();
        for (int i = 0; i < n2; ++i) {
            matrix.set(0, i, d6);
            double d7 = d6 + d4;
            if (i == n2 - 1) {
                d7 += d5;
            }
            matrix.set(1, i, d7);
            d6 = d7;
        }
        return matrix;
    }

    public static void writeHistogram(String string, Matrix matrix, boolean bl, int n, int n2) throws IOException {
        int n3;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string), bl));
        DecimalFormat decimalFormat = Matrix.format(n);
        String string2 = "";
        for (int i = 0; i < 2; ++i) {
            string2 = "";
            for (n3 = 0; n3 < matrix.getColDim(); ++n3) {
                string2 = string2 + Matrix.format(matrix.get(i, n3), decimalFormat, n2) + Matrix.OUT_SEPARATOR_COL;
            }
            string2 = string2 + Matrix.OUT_SEPARATOR_ROW;
            bufferedWriter.write(string2);
        }
        DecimalFormat decimalFormat2 = new DecimalFormat();
        string2 = "";
        for (n3 = 0; n3 < matrix.getColDim(); ++n3) {
            string2 = string2 + Matrix.format(matrix.get(2, n3), decimalFormat2, n2) + Matrix.OUT_SEPARATOR_COL;
        }
        bufferedWriter.write(string2 + "\n");
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static String histogram2String(Matrix matrix, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        DecimalFormat decimalFormat = Matrix.format(n);
        for (int i = 0; i < 2; ++i) {
            for (n3 = 0; n3 < matrix.getColDim(); ++n3) {
                stringBuilder.append(Matrix.format(matrix.get(i, n3), decimalFormat, n2) + Matrix.OUT_SEPARATOR_COL);
            }
            stringBuilder.append(Matrix.OUT_SEPARATOR_ROW);
        }
        DecimalFormat decimalFormat2 = new DecimalFormat();
        for (n3 = 0; n3 < matrix.getColDim(); ++n3) {
            stringBuilder.append(Matrix.format(matrix.get(2, n3), decimalFormat2, n2) + Matrix.OUT_SEPARATOR_COL);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

