/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.histogram;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.histogram.MatrixBasedHistogram;
import java.text.DecimalFormat;
import java.util.Random;

public class Histogram {
    private double minimumX;
    private double maximumX;
    private float[] arrBins;
    private int[] arrFrequencies;
    private double maximumY;
    private double sumY;
    private double binwidth;
    private double[] arrRaw;
    private int digits;

    public Histogram(double[] dArray, double d, double d2, int n) {
        this.initialize(dArray, d, d2, n);
    }

    public Histogram(double[] dArray, int n) {
        double d = -1.7976931348623157E308;
        double d2 = Double.MAX_VALUE;
        for (double d3 : dArray) {
            if (d3 > d) {
                d = d3;
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        this.initialize(dArray, d2, d, n);
    }

    public void initialize(double[] dArray, double d, double d2, int n) {
        if (n == 0) {
            throw new RuntimeException("Number of bins is 0.");
        }
        this.arrRaw = dArray;
        this.minimumX = d - d * 1.0E-6;
        this.maximumX = d2 + d2 * 1.0E-6;
        this.arrFrequencies = new int[n];
        this.arrBins = new float[n];
        this.digits = -1;
        this.calcBins();
        this.calcHistogram();
    }

    private void calcHistogram() {
        int n = this.arrFrequencies.length;
        this.binwidth = (double)n / (this.maximumX - this.minimumX);
        this.maximumY = 0.0;
        for (int i = 0; i < this.arrRaw.length; ++i) {
            int n2;
            if (!(this.arrRaw[i] >= this.minimumX) || !(this.arrRaw[i] < this.maximumX)) continue;
            int n3 = n2 = (int)((this.arrRaw[i] - this.minimumX) * this.binwidth);
            this.arrFrequencies[n3] = this.arrFrequencies[n3] + 1;
            this.sumY += 1.0;
            if (!((double)this.arrFrequencies[n2] > this.maximumY)) continue;
            this.maximumY = this.arrFrequencies[n2];
        }
    }

    public int getBinIndex(double d) {
        int n = (int)((d - this.minimumX) * this.binwidth);
        return n;
    }

    private void calcBins() {
        double d = (this.maximumX - this.minimumX) / (double)this.arrBins.length;
        this.arrBins[0] = (float)this.minimumX;
        for (int i = 1; i < this.arrBins.length; ++i) {
            this.arrBins[i] = (float)((double)this.arrBins[i - 1] + d);
        }
    }

    public int[] getFrequencies() {
        return this.arrFrequencies;
    }

    public int getFrequency(int n) {
        return this.arrFrequencies[n];
    }

    public float[] getBins() {
        return this.arrBins;
    }

    public float getBin(int n) {
        return this.arrBins[n];
    }

    public int getNumBins() {
        return this.arrBins.length;
    }

    public double getMaximumY() {
        return this.maximumY;
    }

    public double getSumY() {
        return this.sumY;
    }

    public double getSumFromRange(double d, double d2) {
        int n = this.arrFrequencies.length;
        double d3 = (double)n / (this.maximumX - this.minimumX);
        int n2 = (int)Math.max(0.0, (d - this.minimumX) * d3);
        int n3 = (int)Math.min((double)(n - 1), (d2 - this.minimumX) * d3);
        double d4 = 0.0;
        for (int i = n2; i < n3 + 1; ++i) {
            d4 += (double)this.arrFrequencies[i];
        }
        return d4;
    }

    public Matrix getHistogram() {
        Matrix matrix = MatrixBasedHistogram.getHistogramBins(this.minimumX, this.maximumX, this.arrFrequencies.length);
        Matrix matrix2 = MatrixBasedHistogram.getHistogram(this.arrRaw, matrix);
        return matrix2;
    }

    public double getMinimumX() {
        return this.minimumX;
    }

    public double getMaximumX() {
        return this.maximumX;
    }

    public void setDigits(int n) {
        this.digits = n;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        double d = this.maximumX - this.minimumX;
        int n2 = (int)Math.log10(d);
        int n3 = this.arrFrequencies.length;
        int n4 = (int)Math.log10(n3);
        if (this.digits < 0) {
            this.digits = n4 - n2 + 1;
        }
        String string = "";
        for (int i = 0; i < this.digits; ++i) {
            string = string + "0";
        }
        String string2 = "0";
        if (string.length() > 0) {
            string2 = string2 + "." + string;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string2);
        DecimalFormat decimalFormat2 = new DecimalFormat("0");
        DecimalFormat decimalFormat3 = new DecimalFormat("0.00");
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        String[] stringArray3 = new String[n3];
        int n5 = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            String string3 = decimalFormat.format(this.arrBins[n]);
            String string4 = decimalFormat2.format(this.arrFrequencies[n]);
            double d2 = (double)(n5 += this.arrFrequencies[n]) / (double)this.arrRaw.length;
            String string5 = decimalFormat3.format(d2);
            int n6 = string3.length();
            if (string4.length() > n6) {
                n6 = string4.length();
            }
            if (string5.length() > n6) {
                n6 = string5.length();
            }
            while (string3.length() < n6) {
                string3 = " " + string3;
            }
            while (string4.length() < n6) {
                string4 = " " + string4;
            }
            while (string5.length() < n6) {
                string5 = " " + string5;
            }
            stringArray[n] = string3;
            stringArray2[n] = string4;
            stringArray3[n] = string5;
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringBuilder.append(stringArray[n]);
            if (n >= stringArray.length - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuilder.append(stringArray2[n]);
            if (n >= stringArray2.length - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        for (n = 0; n < stringArray3.length; ++n) {
            stringBuilder.append(stringArray3[n]);
            if (n >= stringArray3.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public String toStringWithTabs() {
        String string = this.toString();
        String string2 = string.replaceAll("[ ]{1,}", "\t");
        return string2;
    }

    public double getBinWidth() {
        return this.binwidth;
    }

    public static void main(String[] stringArray) {
        int n = 1000;
        double d = 0.0;
        double d2 = 0.1;
        double d3 = 0.0;
        double d4 = 1.0;
        int n2 = 20;
        double[] dArray = new double[n];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + random.nextDouble();
        }
        Histogram histogram = new Histogram(dArray, d3, d4, n2);
        System.out.println(histogram);
        System.out.println("sum " + histogram.getSumY());
    }
}

