/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.Matrix;
import com.actelion.research.util.ArrayUtils;
import java.text.DecimalFormat;

public class BoxCox {
    private static final double TINY = 1.0E-7;
    private double lambda;
    private boolean zero;

    public BoxCox(double d) {
        this.setLambda(d);
    }

    public void setLambda(double d) {
        this.lambda = d;
        this.zero = d < 1.0E-7;
    }

    public double get(double d) {
        double d2 = 0.0;
        boolean bl = false;
        if (d < 0.0) {
            d *= -1.0;
            bl = true;
        }
        d2 = this.zero ? Math.log(d) : (Math.pow(d, this.lambda) - 1.0) / this.lambda;
        if (bl) {
            d2 *= -1.0;
        }
        return d2;
    }

    public double inverse(double d) {
        boolean bl = false;
        if (d < 0.0) {
            d *= -1.0;
            bl = true;
        }
        double d2 = 0.0;
        if (this.zero) {
            d2 = Math.exp(d2);
        } else {
            d2 = Math.pow(d * this.lambda + 1.0, 1.0 / this.lambda);
            if (bl) {
                d2 *= -1.0;
            }
        }
        return d2;
    }

    public double getLambda() {
        return this.lambda;
    }

    public static Matrix transform(Matrix matrix, BoxCox boxCox) {
        int n = matrix.rows();
        int n2 = matrix.cols();
        Matrix matrix2 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = matrix.get(i, j);
                double d2 = boxCox.get(d);
                matrix2.set(i, j, d2);
            }
        }
        return matrix2;
    }

    public static Matrix reTransform(Matrix matrix, BoxCox boxCox) {
        int n = matrix.rows();
        int n2 = matrix.cols();
        Matrix matrix2 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = matrix.get(i, j);
                double d2 = boxCox.inverse(d);
                matrix2.set(i, j, d2);
            }
        }
        return matrix2;
    }

    public static void main(String[] stringArray) {
        BoxCox.test01();
    }

    public static void test01() {
        double[] dArray = new double[]{-64.0, -32.0, -16.0, -8.0, -4.0, -2.0, -1.0, 0.0, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0};
        double d = -3.0;
        double d2 = 3.0;
        double d3 = 0.1;
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00");
        for (double d4 = d; d4 < d2 + d3; d4 += d3) {
            BoxCox boxCox = new BoxCox(d4);
            double[] dArray2 = new double[dArray.length];
            double[] dArray3 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = boxCox.get(dArray[i]);
                dArray3[i] = boxCox.inverse(dArray2[i]);
            }
            System.out.println(decimalFormat2.format(d4) + "\t" + ArrayUtils.toString(dArray2, decimalFormat));
            System.out.println(decimalFormat2.format(d4) + "\t" + ArrayUtils.toString(dArray3, decimalFormat));
        }
    }
}

