/*
 * Decompiled with CFR 0.152.
 */
package swingjs.jzlib;

import java.io.UnsupportedEncodingException;
import swingjs.jzlib.Adler32;
import swingjs.jzlib.Checksum;
import swingjs.jzlib.Deflate;
import swingjs.jzlib.Inflate;

public abstract class ZStream {
    private static final int Z_STREAM_ERROR = -2;
    byte[] in;
    int in_index;
    public int avail_in;
    protected long total_in;
    byte[] next_out;
    int next_out_index;
    int avail_out;
    long total_out;
    String msg;
    Deflate dstate;
    Inflate istate;
    int data_type;
    Checksum checksum;

    void setAdler32() {
        this.checksum = new Adler32();
    }

    int inflate(int f) {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflate(f);
    }

    public int deflateSetDictionary(byte[] dictionary, int off, int len) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateSetDictionary(dictionary, off, len);
    }

    int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflate(flush);
    }

    void flush_pending() {
        int len = this.dstate.pending;
        if (len > this.avail_out) {
            len = this.avail_out;
        }
        if (len == 0) {
            return;
        }
        System.arraycopy(this.dstate.pending_buf, this.dstate.pending_out, this.next_out, this.next_out_index, len);
        this.next_out_index += len;
        this.dstate.pending_out += len;
        this.total_out += (long)len;
        this.avail_out -= len;
        this.dstate.pending -= len;
        if (this.dstate.pending == 0) {
            this.dstate.pending_out = 0;
        }
    }

    public int read_buf(byte[] out, int start, int size) {
        int len = this.avail_in;
        if (len > size) {
            len = size;
        }
        if (len == 0) {
            return 0;
        }
        this.avail_in -= len;
        if (this.dstate.wrap != 0) {
            this.checksum.update(this.in, this.in_index, len);
        }
        System.arraycopy(this.in, this.in_index, out, start, len);
        this.in_index += len;
        this.total_in += (long)len;
        return len;
    }

    public long getAdlerL() {
        return this.checksum.getValue();
    }

    void free() {
        this.in = null;
        this.next_out = null;
        this.msg = null;
    }

    void setOutput(byte[] buf, int off, int len) {
        this.next_out = buf;
        this.next_out_index = off;
        this.avail_out = len;
    }

    public void setInput(byte[] in, int off, int len, boolean append) {
        if (len <= 0 && append && this.in != null) {
            return;
        }
        if (this.avail_in > 0 && append) {
            byte[] tmp = new byte[this.avail_in + len];
            System.arraycopy(this.in, this.in_index, tmp, 0, this.avail_in);
            System.arraycopy(in, off, tmp, this.avail_in, len);
            this.in = tmp;
            this.in_index = 0;
            this.avail_in += len;
        } else {
            this.in = in;
            this.in_index = off;
            this.avail_in = len;
        }
    }

    public int getAvailIn() {
        return this.avail_in;
    }

    public long getTotalOutL() {
        return this.total_out;
    }

    public long getTotalInL() {
        return this.total_in;
    }

    abstract void end();

    abstract boolean finished();

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

