/*
 * Decompiled with CFR 0.152.
 */
package swingjs.jzlib;

import swingjs.jzlib.Deflate;
import swingjs.jzlib.ZStream;

public class Deflater
extends ZStream {
    private static final int MAX_WBITS = 15;
    private static final int Z_STREAM_END = 1;
    private static final int Z_STREAM_ERROR = -2;
    private boolean finished = false;

    public Deflater init(int level, int bits, boolean nowrap) {
        if (bits == 0) {
            bits = 15;
        }
        this.finished = false;
        this.setAdler32();
        this.dstate = new Deflate(this);
        this.dstate.deflateInit2(level, nowrap ? -bits : bits);
        return this;
    }

    public int deflate(byte[] buf, int off, int len, int flush) {
        super.setOutput(buf, off, len);
        long thisLen = this.getBytesWritten();
        this.deflate(flush);
        long newLen = this.getBytesWritten();
        return (int)(newLen - thisLen);
    }

    @Override
    public int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflate(flush);
        if (ret == 1) {
            this.finished = true;
        }
        return ret;
    }

    @Override
    public void end() {
        this.finished = true;
        if (this.dstate == null) {
            return;
        }
        int ret = this.dstate.deflateEnd();
        this.dstate = null;
        this.free();
    }

    public int params(int level, int strategy) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateParams(level, strategy);
    }

    public int setDictionaryRet(byte[] dictionary, int off, int len) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateSetDictionary(dictionary, off, len);
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    public void finish() {
    }

    public long getBytesRead() {
        return this.dstate.getBytesRead();
    }

    public long getBytesWritten() {
        return this.dstate.getBytesWritten();
    }

    public void reset() {
        this.dstate.deflateReset();
    }

    public boolean needsInput() {
        return this.avail_in <= 0;
    }
}

