/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import java.util.ArrayList;
import java.util.List;
import smile.math.Math;
import smile.stat.distribution.AbstractDistribution;
import smile.stat.distribution.Distribution;

public class Mixture
extends AbstractDistribution {
    private static final long serialVersionUID = 1L;
    List<Component> components = new ArrayList<Component>();

    Mixture() {
    }

    public Mixture(List<Component> list) {
        this.components.addAll(list);
        double d = 0.0;
        for (Component component : list) {
            d += component.priori;
        }
        if (Math.abs(d - 1.0) > 0.001) {
            throw new IllegalArgumentException("The sum of priori is not equal to 1.");
        }
    }

    @Override
    public double mean() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double d = 0.0;
        for (Component component : this.components) {
            d += component.priori * component.distribution.mean();
        }
        return d;
    }

    @Override
    public double var() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double d = 0.0;
        for (Component component : this.components) {
            d += component.priori * component.priori * component.distribution.var();
        }
        return d;
    }

    @Override
    public double sd() {
        return Math.sqrt(this.var());
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Mixture does not support entropy()");
    }

    @Override
    public double p(double d) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double d2 = 0.0;
        for (Component component : this.components) {
            d2 += component.priori * component.distribution.p(d);
        }
        return d2;
    }

    @Override
    public double logp(double d) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        return Math.log(this.p(d));
    }

    @Override
    public double cdf(double d) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double d2 = 0.0;
        for (Component component : this.components) {
            d2 += component.priori * component.distribution.cdf(d);
        }
        return d2;
    }

    @Override
    public double rand() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        double d = Math.random();
        double d2 = 0.0;
        for (Component component : this.components) {
            if (!(d <= (d2 += component.priori))) continue;
            return component.distribution.rand();
        }
        return this.components.get((int)(this.components.size() - 1)).distribution.rand();
    }

    @Override
    public double quantile(double d) {
        double d2;
        double d3;
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + d);
        }
        double d4 = 1.0;
        double d5 = (int)this.mean();
        if (d < this.cdf(d5)) {
            while (d < this.cdf(d5 -= (d4 *= 2.0))) {
            }
            d3 = d5;
            d2 = d5 + d4 / 2.0;
        } else {
            while (d > this.cdf(d5 += (d4 *= 2.0))) {
            }
            d2 = d5;
            d3 = d5 - d4 / 2.0;
        }
        return this.quantile(d, d3, d2);
    }

    @Override
    public int npara() {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        int n = this.components.size() - 1;
        for (int i = 0; i < this.components.size(); ++i) {
            n += this.components.get((int)i).distribution.npara();
        }
        return n;
    }

    public int size() {
        return this.components.size();
    }

    public double bic(double[] dArray) {
        if (this.components.isEmpty()) {
            throw new IllegalStateException("Mixture is empty!");
        }
        int n = dArray.length;
        double d = 0.0;
        for (double d2 : dArray) {
            double d3 = this.p(d2);
            if (!(d3 > 0.0)) continue;
            d += Math.log(d3);
        }
        return d - 0.5 * (double)this.npara() * Math.log(n);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Mixture[");
        stringBuilder.append(this.components.size());
        stringBuilder.append("]:{");
        for (Component component : this.components) {
            stringBuilder.append(" (");
            stringBuilder.append(component.distribution);
            stringBuilder.append(':');
            stringBuilder.append(String.format("%.4f", component.priori));
            stringBuilder.append(')');
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static class Component {
        public Distribution distribution;
        public double priori;

        public Component() {
        }

        public Component(double d, Distribution distribution) {
            this.priori = d;
            this.distribution = distribution;
        }
    }
}

