/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.Math;
import smile.stat.distribution.Distribution;

public abstract class AbstractDistribution
implements Distribution {
    protected double rejection(double d, double d2, double d3) {
        double d4;
        double d5;
        do {
            d5 = d2 + Math.random() * (d3 - d2);
            d4 = Math.random() * d;
        } while (this.p(d5) < d4);
        return d5;
    }

    protected double inverseTransformSampling() {
        double d = Math.random();
        return this.quantile(d);
    }

    protected double quantile(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + d4);
        }
        while (Math.abs(d3 - d2) > d4) {
            double d5 = (d3 + d2) / 2.0;
            if (this.cdf(d5) > d) {
                d3 = d5;
                continue;
            }
            d2 = d5;
        }
        return d2;
    }

    protected double quantile(double d, double d2, double d3) {
        return this.quantile(d, d2, d3, 1.0E-6);
    }

    @Override
    public double likelihood(double[] dArray) {
        return Math.exp(this.logLikelihood(dArray));
    }

    @Override
    public double logLikelihood(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += this.logp(d2);
        }
        return d;
    }
}

