/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

public class SortUtils {
    private SortUtils() {
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    public static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void siftUp(int[] nArray, int n) {
        while (n > 1 && nArray[n / 2] < nArray[n]) {
            SortUtils.swap(nArray, n, n / 2);
            n /= 2;
        }
    }

    public static void siftUp(float[] fArray, int n) {
        while (n > 1 && fArray[n / 2] < fArray[n]) {
            SortUtils.swap(fArray, n, n / 2);
            n /= 2;
        }
    }

    public static void siftUp(double[] dArray, int n) {
        while (n > 1 && dArray[n / 2] < dArray[n]) {
            SortUtils.swap(dArray, n, n / 2);
            n /= 2;
        }
    }

    public static <T extends Comparable<? super T>> void siftUp(T[] TArray, int n) {
        while (n > 1 && TArray[n / 2].compareTo(TArray[n]) < 0) {
            SortUtils.swap(TArray, n, n / 2);
            n /= 2;
        }
    }

    public static void siftDown(int[] nArray, int n, int n2) {
        while (2 * n <= n2) {
            int n3 = 2 * n;
            if (n3 < n2 && nArray[n3] < nArray[n3 + 1]) {
                ++n3;
            }
            if (nArray[n] >= nArray[n3]) break;
            SortUtils.swap(nArray, n, n3);
            n = n3;
        }
    }

    public static void siftDown(float[] fArray, int n, int n2) {
        while (2 * n <= n2) {
            int n3 = 2 * n;
            if (n3 < n2 && fArray[n3] < fArray[n3 + 1]) {
                ++n3;
            }
            if (fArray[n] >= fArray[n3]) break;
            SortUtils.swap(fArray, n, n3);
            n = n3;
        }
    }

    public static void siftDown(double[] dArray, int n, int n2) {
        while (2 * n <= n2) {
            int n3 = 2 * n;
            if (n3 < n2 && dArray[n3] < dArray[n3 + 1]) {
                ++n3;
            }
            if (dArray[n] >= dArray[n3]) break;
            SortUtils.swap(dArray, n, n3);
            n = n3;
        }
    }

    public static <T extends Comparable<? super T>> void siftDown(T[] TArray, int n, int n2) {
        while (2 * n <= n2) {
            int n3 = 2 * n;
            if (n3 < n2 && TArray[n3].compareTo(TArray[n3 + 1]) < 0) {
                ++n3;
            }
            if (TArray[n].compareTo(TArray[n3]) >= 0) break;
            SortUtils.swap(TArray, n, n3);
            n = n3;
        }
    }
}

