/*
 * Decompiled with CFR 0.152.
 */
package smile.math.special;

import smile.math.Math;

public class Erf {
    private static final double[] cof = new double[]{-1.3026537197817094, 0.6419697923564902, 0.019476473204185836, -0.00956151478680863, -9.46595344482036E-4, 3.66839497852761E-4, 4.2523324806907E-5, -2.0278578112534E-5, -1.624290004647E-6, 1.30365583558E-6, 1.5626441722E-8, -8.5238095915E-8, 6.529054439E-9, 5.059343495E-9, -9.91364156E-10, -2.27365122E-10, 9.6467911E-11, 2.394038E-12, -6.886027E-12, 8.94487E-13, 3.13092E-13, -1.12708E-13, 3.81E-16, 7.106E-15, -1.523E-15, -9.4E-17, 1.21E-16, -2.8E-17};

    private Erf() {
    }

    public static double erf(double d) {
        if (d >= 0.0) {
            return 1.0 - Erf.erfccheb(d);
        }
        return Erf.erfccheb(-d) - 1.0;
    }

    public static double erfc(double d) {
        if (d >= 0.0) {
            return Erf.erfccheb(d);
        }
        return 2.0 - Erf.erfccheb(-d);
    }

    public static double erfcc(double d) {
        double d2 = Math.abs(d);
        double d3 = 2.0 / (2.0 + d2);
        double d4 = d3 * Math.exp(-d2 * d2 - 1.26551223 + d3 * (1.00002368 + d3 * (0.37409196 + d3 * (0.09678418 + d3 * (-0.18628806 + d3 * (0.27886807 + d3 * (-1.13520398 + d3 * (1.48851587 + d3 * (-0.82215223 + d3 * 0.17087277)))))))));
        return d >= 0.0 ? d4 : 2.0 - d4;
    }

    private static double erfccheb(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (d < 0.0) {
            throw new IllegalArgumentException("erfccheb requires nonnegative argument");
        }
        double d4 = 2.0 / (2.0 + d);
        double d5 = 4.0 * d4 - 2.0;
        for (int i = cof.length - 1; i > 0; --i) {
            double d6 = d2;
            d2 = d5 * d2 - d3 + cof[i];
            d3 = d6;
        }
        return d4 * Math.exp(-d * d + 0.5 * (cof[0] + d5 * d2) - d3);
    }

    public static double inverfc(double d) {
        if (d >= 2.0) {
            return -100.0;
        }
        if (d <= 0.0) {
            return 100.0;
        }
        double d2 = d < 1.0 ? d : 2.0 - d;
        double d3 = Math.sqrt(-2.0 * Math.log(d2 / 2.0));
        double d4 = -0.70711 * ((2.30753 + d3 * 0.27061) / (1.0 + d3 * (0.99229 + d3 * 0.04481)) - d3);
        for (int i = 0; i < 2; ++i) {
            double d5 = Erf.erfc(d4) - d2;
            d4 += d5 / (1.1283791670955126 * Math.exp(-d4 * d4) - d4 * d5);
        }
        return d < 1.0 ? d4 : -d4;
    }

    public static double inverf(double d) {
        return Erf.inverfc(1.0 - d);
    }
}

