/*
 * Decompiled with CFR 0.152.
 */
package smile.math.rbf;

import java.io.Serializable;
import smile.math.Math;
import smile.math.rbf.RadialBasisFunction;

public class GaussianRadialBasis
implements RadialBasisFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private double r0;

    public GaussianRadialBasis() {
        this(1.0);
    }

    public GaussianRadialBasis(double d) {
        this.r0 = d;
    }

    @Override
    public double f(double d) {
        return Math.exp(-0.5 * (d /= this.r0) * d);
    }

    public String toString() {
        return String.format("Gaussian Radial Basis (r0 = %.4f)", this.r0);
    }
}

