/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.JMatrix;
import smile.math.matrix.Matrix;

public class Lanczos {
    public static EVD eigen(Matrix matrix, int n) {
        return Lanczos.eigen(matrix, n, 1.0E-8, 10 * matrix.nrows());
    }

    public static EVD eigen(Matrix matrix, int n, double d, int n2) {
        Object[] objectArray;
        int n3;
        if (matrix.nrows() != matrix.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", matrix.nrows(), matrix.ncols()));
        }
        if (!matrix.isSymmetric()) {
            throw new IllegalArgumentException("Matrix is not symmetric.");
        }
        if (n < 1 || n > matrix.nrows()) {
            throw new IllegalArgumentException("k is larger than the size of A: " + n + " > " + matrix.nrows());
        }
        if (d <= Math.EPSILON) {
            throw new IllegalArgumentException("Invalid tolerance: kappa = " + d);
        }
        if (n2 <= 0) {
            n2 = 10 * matrix.nrows();
        }
        int n4 = matrix.nrows();
        int n5 = 0;
        double d2 = Math.EPSILON * Math.sqrt(n4);
        double d3 = Math.sqrt(Math.EPSILON);
        double d4 = d3 * Math.sqrt(d3);
        d = Math.max(d, d4);
        double[][] dArray = new double[6][n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n4 + 1];
        double[][] dArrayArray = new double[n4][];
        double[][] dArrayArray2 = new double[2][];
        double[] dArray7 = new double[n4 + 1];
        DenseMatrix denseMatrix = null;
        double d5 = Lanczos.startv(matrix, dArrayArray, dArray, 0);
        double d6 = 1.0 / d5;
        Math.scale(d6, dArray[0], dArray[1]);
        Math.scale(d6, dArray[3]);
        matrix.ax(dArray[3], dArray[0]);
        dArray5[0] = Math.dot(dArray[0], dArray[3]);
        Math.axpy(-dArray5[0], dArray[1], dArray[0]);
        d6 = Math.dot(dArray[0], dArray[3]);
        Math.axpy(-d6, dArray[1], dArray[0]);
        dArray5[0] = dArray5[0] + d6;
        Math.copy(dArray[0], dArray[4]);
        d5 = Math.norm(dArray[0]);
        double d7 = d5 + Math.abs(dArray5[0]);
        double d8 = d3 * d7;
        if (0.0 == d5) {
            throw new IllegalStateException("Lanczos method was unable to find a starting vector within range.");
        }
        dArray2[0] = d2;
        dArray3[0] = d2;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = Math.min(n + Math.max(8, n), n4);
        int n10 = 0;
        boolean bl = false;
        for (n3 = 0; !bl && n3 < n2; ++n3) {
            int n11;
            if (d5 <= d8) {
                d5 = 0.0;
            }
            for (n10 = n8; n10 < n9; ++n10) {
                Math.swap((Object[])dArray, 1, 2);
                Math.swap((Object[])dArray, 3, 4);
                Lanczos.store(dArrayArray, n10 - 1, dArray[2]);
                if (n10 - 1 < 2) {
                    dArrayArray2[n10 - 1] = (double[])dArray[4].clone();
                }
                dArray6[n10] = d5;
                if (0.0 == dArray6[n10]) {
                    d5 = Lanczos.startv(matrix, dArrayArray, dArray, n10);
                    if (d5 < 0.0) {
                        d5 = 0.0;
                        break;
                    }
                    if (d5 == 0.0) {
                        bl = true;
                    }
                }
                if (bl) {
                    Math.swap((Object[])dArray, 1, 2);
                    break;
                }
                d6 = 1.0 / d5;
                Math.scale(d6, dArray[0], dArray[1]);
                Math.scale(d6, dArray[3]);
                matrix.ax(dArray[3], dArray[0]);
                Math.axpy(-d5, dArray[2], dArray[0]);
                dArray5[n10] = Math.dot(dArray[0], dArray[3]);
                Math.axpy(-dArray5[n10], dArray[1], dArray[0]);
                if (n10 <= 2 && Math.abs(dArray5[n10 - 1]) > 4.0 * Math.abs(dArray5[n10])) {
                    n7 = n10;
                }
                for (n11 = 0; n11 < Math.min(n7, n10 - 1); ++n11) {
                    d6 = Math.dot(dArrayArray2[n11], dArray[0]);
                    Math.axpy(-d6, dArrayArray[n11], dArray[0]);
                    dArray2[n11] = d2;
                    dArray3[n11] = d2;
                }
                d6 = Math.dot(dArray[0], dArray[4]);
                Math.axpy(-d6, dArray[2], dArray[0]);
                if (dArray6[n10] > 0.0) {
                    dArray6[n10] = dArray6[n10] + d6;
                }
                d6 = Math.dot(dArray[0], dArray[3]);
                Math.axpy(-d6, dArray[1], dArray[0]);
                dArray5[n10] = dArray5[n10] + d6;
                Math.copy(dArray[0], dArray[4]);
                d5 = Math.norm(dArray[0]);
                d7 = dArray6[n10] + Math.abs(dArray5[n10]) + d5;
                d8 = d3 * d7;
                Lanczos.ortbnd(dArray5, dArray6, dArray2, dArray3, n10, d5, d2);
                d5 = Lanczos.purge(n7, dArrayArray, dArray[0], dArray[1], dArray[4], dArray[3], dArray2, dArray3, n10, d5, d8, d2, d3);
                if (!(d5 <= d8)) continue;
                d5 = 0.0;
            }
            n10 = bl ? --n10 : n9 - 1;
            n8 = n10 + 1;
            dArray6[n10 + 1] = d5;
            System.arraycopy(dArray5, 0, dArray7, 0, n10 + 1);
            System.arraycopy(dArray6, 0, dArray[5], 0, n10 + 1);
            denseMatrix = Matrix.zeros(n10 + 1, n10 + 1);
            for (n11 = 0; n11 <= n10; ++n11) {
                denseMatrix.set(n11, n11, 1.0);
            }
            JMatrix.tql2(denseMatrix, dArray7, dArray[5]);
            for (n11 = 0; n11 <= n10; ++n11) {
                dArray4[n11] = d5 * Math.abs(denseMatrix.get(n10, n11));
            }
            objectArray = new boolean[]{bl};
            n6 = Lanczos.error_bound((boolean[])objectArray, dArray7, dArray4, n10, d8, d4);
            bl = objectArray[0];
            if (n6 < n) {
                if (0 == n6) {
                    n9 = n8 + 9;
                    n5 = n8;
                } else {
                    n9 = n8 + Math.max(3, 1 + (n10 - n5) * (n - n6) / Math.max(3, n6));
                }
                n9 = Math.min(n9, n4);
            } else {
                bl = true;
            }
            bl = bl || n8 >= n4;
        }
        System.out.println("Lanczos: " + n3 + " iterations for Matrix of size " + n4);
        Lanczos.store(dArrayArray, n10, dArray[1]);
        n = Math.min(n, n6);
        objectArray = new double[n];
        DenseMatrix denseMatrix2 = Matrix.zeros(n4, n);
        int n12 = 0;
        for (int i = 0; i <= n10 && n12 < n; ++i) {
            if (!(dArray4[i] <= d * Math.abs(dArray7[i]))) continue;
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k <= n10; ++k) {
                    denseMatrix2.add(j, n12, dArrayArray[k][j] * denseMatrix.get(k, i));
                }
            }
            objectArray[n12++] = dArray7[i];
        }
        return new EVD(denseMatrix2, (double[])objectArray);
    }

    private static double startv(Matrix matrix, double[][] dArray, double[][] dArray2, int n) {
        int n2;
        double d = Math.dot(dArray2[0], dArray2[0]);
        double[] dArray3 = dArray2[0];
        for (n2 = 0; n2 < 3; ++n2) {
            if (n2 > 0 || n > 0 || d == 0.0) {
                for (int i = 0; i < dArray3.length; ++i) {
                    dArray3[i] = Math.random() - 0.5;
                }
            }
            Math.copy(dArray2[0], dArray2[3]);
            matrix.ax(dArray2[3], dArray2[0]);
            Math.copy(dArray2[0], dArray2[3]);
            d = Math.dot(dArray2[0], dArray2[3]);
            if (d > 0.0) break;
        }
        if (d <= 0.0) {
            System.err.println("Lanczos method was unable to find a starting vector within range.");
            return -1.0;
        }
        if (n > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                double d2 = Math.dot(dArray2[3], dArray[n2]);
                Math.axpy(-d2, dArray[n2], dArray2[0]);
            }
            double d3 = Math.dot(dArray2[4], dArray2[0]);
            Math.axpy(-d3, dArray2[2], dArray2[0]);
            Math.copy(dArray2[0], dArray2[3]);
            d3 = Math.dot(dArray2[3], dArray2[0]);
            if (d3 <= Math.EPSILON * d) {
                d3 = 0.0;
            }
            d = d3;
        }
        return Math.sqrt(d);
    }

    private static void ortbnd(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, double d, double d2) {
        int n2;
        if (n < 1) {
            return;
        }
        if (0.0 != d) {
            if (n > 1) {
                dArray4[0] = (dArray2[1] * dArray3[1] + (dArray[0] - dArray[n]) * dArray3[0] - dArray2[n] * dArray4[0]) / d + d2;
            }
            for (n2 = 1; n2 <= n - 2; ++n2) {
                dArray4[n2] = (dArray2[n2 + 1] * dArray3[n2 + 1] + (dArray[n2] - dArray[n]) * dArray3[n2] + dArray2[n2] * dArray3[n2 - 1] - dArray2[n] * dArray4[n2]) / d + d2;
            }
        }
        dArray4[n - 1] = d2;
        for (n2 = 0; n2 < n; ++n2) {
            double d3 = dArray3[n2];
            dArray3[n2] = dArray4[n2];
            dArray4[n2] = d3;
        }
        dArray3[n] = d2;
    }

    private static double purge(int n, double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, int n2, double d, double d2, double d3, double d4) {
        if (n2 < n + 2) {
            return d;
        }
        int n3 = Lanczos.idamax(n2 - (n + 1), dArray6, n, 1) + n;
        if (Math.abs(dArray6[n3]) > d4) {
            int n4;
            double d5 = d3 / d4;
            boolean bl = true;
            for (int i = 0; i < 2 && bl; ++i) {
                double d6;
                if (!(d > d2)) continue;
                double d7 = 0.0;
                double d8 = 0.0;
                for (n4 = n; n4 < n2; ++n4) {
                    d6 = -Math.dot(dArray5, dArray[n4]);
                    d7 += Math.abs(d6);
                    Math.axpy(d6, dArray[n4], dArray3);
                    d6 = -Math.dot(dArray4, dArray[n4]);
                    d8 += Math.abs(d6);
                    Math.axpy(d6, dArray[n4], dArray2);
                }
                Math.copy(dArray3, dArray5);
                d6 = -Math.dot(dArray2, dArray5);
                d8 += Math.abs(d6);
                Math.axpy(d6, dArray3, dArray2);
                Math.copy(dArray2, dArray4);
                d = Math.sqrt(Math.dot(dArray4, dArray2));
                if (!(d7 <= d5) || !(d8 <= d5 * d)) continue;
                bl = false;
            }
            for (n4 = n; n4 <= n2; ++n4) {
                dArray6[n4] = d3;
                dArray7[n4] = d3;
            }
        }
        return d;
    }

    private static int idamax(int n, double[] dArray, int n2, int n3) {
        int n4;
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        if (n3 == 0) {
            return -1;
        }
        int n5 = n4 = n3 < 0 ? n2 + (-n + 1) * n3 : n2;
        double d = Math.abs(dArray[n4]);
        for (int i = 1; i < n; ++i) {
            double d2 = Math.abs(dArray[n4 += n3]);
            if (!(d2 > d)) continue;
            d = d2;
            n5 = n4;
        }
        return n5;
    }

    private static int error_bound(boolean[] blArray, double[] dArray, double[] dArray2, int n, double d, double d2) {
        int n2;
        int n3;
        int n4 = Lanczos.idamax(n + 1, dArray2, 0, 1);
        for (n3 = (n + 1 + (n - 1)) / 2; n3 >= n4 + 1; --n3) {
            if (!(Math.abs(dArray[n3 - 1] - dArray[n3]) < d2 * Math.abs(dArray[n3])) || !(dArray2[n3] > d) || !(dArray2[n3 - 1] > d)) continue;
            dArray2[n3 - 1] = Math.sqrt(dArray2[n3] * dArray2[n3] + dArray2[n3 - 1] * dArray2[n3 - 1]);
            dArray2[n3] = 0.0;
        }
        for (n3 = (n + 1 - (n - 1)) / 2; n3 <= n4 - 1; ++n3) {
            if (!(Math.abs(dArray[n3 + 1] - dArray[n3]) < d2 * Math.abs(dArray[n3])) || !(dArray2[n3] > d) || !(dArray2[n3 + 1] > d)) continue;
            dArray2[n3 + 1] = Math.sqrt(dArray2[n3] * dArray2[n3] + dArray2[n3 + 1] * dArray2[n3 + 1]);
            dArray2[n3] = 0.0;
        }
        n3 = 0;
        double d3 = dArray[n] - dArray[0];
        for (n2 = 0; n2 <= n; ++n2) {
            double d4 = d3;
            if (n2 < n) {
                d3 = dArray[n2 + 1] - dArray[n2];
            }
            if ((d4 = Math.min(d4, d3)) > dArray2[n2]) {
                dArray2[n2] = dArray2[n2] * (dArray2[n2] / d4);
            }
            if (!(dArray2[n2] <= 16.0 * Math.EPSILON * Math.abs(dArray[n2]))) continue;
            ++n3;
            if (blArray[0]) continue;
            blArray[0] = -Math.EPSILON < dArray[n2] && dArray[n2] < Math.EPSILON;
        }
        System.out.println("Lancozs method found " + n3 + " converged eigenvalues of the " + (n + 1) + "-by-" + (n + 1) + " matrix");
        if (n3 != 0) {
            for (n2 = 0; n2 <= n; ++n2) {
                if (!(dArray2[n2] <= 16.0 * Math.EPSILON * Math.abs(dArray[n2]))) continue;
                System.out.println("ritz[" + n2 + "] = " + dArray[n2]);
            }
        }
        return n3;
    }

    private static void store(double[][] dArray, int n, double[] dArray2) {
        if (null == dArray[n]) {
            dArray[n] = (double[])dArray2.clone();
        } else {
            Math.copy(dArray2, dArray[n]);
        }
    }
}

