/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class LU {
    protected DenseMatrix lu;
    protected int pivsign;
    protected int[] piv;
    protected boolean singular;

    public LU(DenseMatrix denseMatrix, int[] nArray, int n, boolean bl) {
        this.lu = denseMatrix;
        this.piv = nArray;
        this.pivsign = n;
        this.singular = bl;
    }

    public LU(DenseMatrix denseMatrix, int[] nArray, boolean bl) {
        this.lu = denseMatrix;
        this.piv = nArray;
        this.singular = bl;
        this.pivsign = 1;
        int n = Math.min(denseMatrix.nrows(), denseMatrix.ncols());
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == i) continue;
            this.pivsign = -this.pivsign;
        }
    }

    public boolean isSingular() {
        return this.singular;
    }

    public double det() {
        int n;
        int n2 = this.lu.nrows();
        if (n2 != (n = this.lu.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", n2, n));
        }
        double d = this.pivsign;
        for (int i = 0; i < n; ++i) {
            d *= this.lu.get(i, i);
        }
        return d;
    }

    public DenseMatrix inverse() {
        int n;
        int n2 = this.lu.nrows();
        if (n2 != (n = this.lu.ncols())) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", n2, n));
        }
        DenseMatrix denseMatrix = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix.set(i, this.piv[i], 1.0);
        }
        this.solve(denseMatrix);
        return denseMatrix;
    }

    public void solve(double[] dArray) {
        DenseMatrix denseMatrix = Matrix.newInstance(dArray);
        this.solve(denseMatrix);
    }

    public void solve(DenseMatrix denseMatrix) {
        int n;
        int n2;
        int n3;
        int n4 = this.lu.nrows();
        int n5 = this.lu.ncols();
        int n6 = denseMatrix.ncols();
        if (denseMatrix.nrows() != n4) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.lu.nrows(), this.lu.ncols(), denseMatrix.nrows(), denseMatrix.ncols()));
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        DenseMatrix denseMatrix2 = Matrix.zeros(denseMatrix.nrows(), denseMatrix.ncols());
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                denseMatrix2.set(n2, n3, denseMatrix.get(this.piv[n2], n3));
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = n3 + 1; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    denseMatrix2.sub(n2, n, denseMatrix2.get(n3, n) * this.lu.get(n2, n3));
                }
            }
        }
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                denseMatrix2.div(n3, n2, this.lu.get(n3, n3));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n6; ++n) {
                    denseMatrix2.sub(n2, n, denseMatrix2.get(n3, n) * this.lu.get(n2, n3));
                }
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                denseMatrix.set(n2, n3, denseMatrix2.get(n2, n3));
            }
        }
    }
}

