/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.lang.reflect.Constructor;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.JMatrix;

class Factory {
    private static Class<?> nlmatrix;
    private static Constructor<?> nlmatrixArray;
    private static Constructor<?> nlmatrixArray2D;
    private static Constructor<?> nlmatrixZeros;
    private static Constructor<?> nlmatrixOnes;

    Factory() {
    }

    public static DenseMatrix matrix(double[][] dArray) {
        if (nlmatrixZeros != null) {
            try {
                return (DenseMatrix)nlmatrixArray2D.newInstance(new Object[]{dArray});
            }
            catch (Exception exception) {
                System.err.println("Failed to call NLMatrix(double[][]): " + exception);
            }
        }
        return new JMatrix(dArray);
    }

    public static DenseMatrix matrix(double[] dArray) {
        if (nlmatrixZeros != null) {
            try {
                return (DenseMatrix)nlmatrixArray.newInstance(new Object[]{dArray});
            }
            catch (Exception exception) {
                System.err.println("Failed to call NLMatrix(double[]): " + exception);
            }
        }
        return new JMatrix(dArray);
    }

    public static DenseMatrix matrix(int n, int n2) {
        if (nlmatrixZeros != null) {
            try {
                return (DenseMatrix)nlmatrixZeros.newInstance(n, n2);
            }
            catch (Exception exception) {
                System.err.println("Failed to call NLMatrix(int, int): " + exception);
            }
        }
        return new JMatrix(n, n2);
    }

    public static DenseMatrix matrix(int n, int n2, double d) {
        if (nlmatrixOnes != null) {
            try {
                return (DenseMatrix)nlmatrixOnes.newInstance(n, n2, d);
            }
            catch (Exception exception) {
                System.err.println("Failed to call NLMatrix(int, int, double): " + exception);
            }
        }
        return new JMatrix(n, n2, d);
    }

    static {
        try {
            nlmatrix = Class.forName("smile.netlib.NLMatrix");
            try {
                nlmatrixArray2D = nlmatrix.getConstructor(double[][].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("NLMatrix(double[][]) does not exist");
            }
            try {
                nlmatrixArray = nlmatrix.getConstructor(double[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("NLMatrix(double[]) does not exist");
            }
            try {
                nlmatrixZeros = nlmatrix.getConstructor(Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("NLMatrix(int, int) does not exist");
            }
            try {
                nlmatrixOnes = nlmatrix.getConstructor(Integer.TYPE, Integer.TYPE, Double.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("NLMatrix(int, int, double) does not exist");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("smile-netlib module is not available in the classpath. Pure Java matrix library will be employed.");
        }
    }
}

