/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class Cholesky {
    protected DenseMatrix L;

    public Cholesky(DenseMatrix denseMatrix) {
        if (denseMatrix.nrows() != denseMatrix.ncols()) {
            throw new UnsupportedOperationException("Cholesky constructor on a non-square matrix");
        }
        this.L = denseMatrix;
    }

    public DenseMatrix getL() {
        return this.L;
    }

    public double det() {
        double d = 1.0;
        for (int i = 0; i < this.L.nrows(); ++i) {
            d *= this.L.get(i, i);
        }
        return d * d;
    }

    public DenseMatrix inverse() {
        int n = this.L.nrows();
        DenseMatrix denseMatrix = Matrix.eye(n);
        this.solve(denseMatrix);
        return denseMatrix;
    }

    public void solve(double[] dArray) {
        DenseMatrix denseMatrix = Matrix.newInstance(dArray);
        this.solve(denseMatrix);
    }

    public void solve(DenseMatrix denseMatrix) {
        int n;
        int n2;
        int n3;
        if (denseMatrix.nrows() != this.L.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.L.nrows(), this.L.ncols(), denseMatrix.nrows(), denseMatrix.ncols()));
        }
        int n4 = denseMatrix.nrows();
        int n5 = denseMatrix.ncols();
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n3; ++n) {
                    denseMatrix.sub(n3, n2, denseMatrix.get(n, n2) * this.L.get(n3, n));
                }
                denseMatrix.div(n3, n2, this.L.get(n3, n3));
            }
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = n3 + 1; n < n4; ++n) {
                    denseMatrix.sub(n3, n2, denseMatrix.get(n, n2) * this.L.get(n, n3));
                }
                denseMatrix.div(n3, n2, this.L.get(n3, n3));
            }
        }
    }
}

