/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SparseArray
implements Iterable<Entry>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Entry> array;

    public SparseArray() {
        this(10);
    }

    private SparseArray(int n) {
        this.array = new ArrayList<Entry>(n);
    }

    public int size() {
        return this.array.size();
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.array.iterator();
    }

    public double get(int n) {
        for (Entry entry : this.array) {
            if (entry.i != n) continue;
            return entry.x;
        }
        return 0.0;
    }

    public boolean set(int n, double d) {
        if (d == 0.0) {
            this.remove(n);
            return false;
        }
        Iterator<Entry> iterator = this.array.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.i == n) {
                entry.x = d;
                return false;
            }
            if (entry.i > n) {
                this.array.add(n2, new Entry(n, d));
                return true;
            }
            ++n2;
        }
        this.array.add(new Entry(n, d));
        return true;
    }

    public void append(int n, double d) {
        if (d != 0.0) {
            this.array.add(new Entry(n, d));
        }
    }

    public void remove(int n) {
        Iterator<Entry> iterator = this.array.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.i != n) continue;
            iterator.remove();
            break;
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int i;
        public double x;

        public Entry(int n, double d) {
            this.i = n;
            this.x = d;
        }
    }
}

