/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.lang.reflect.Array;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import smile.math.DifferentiableFunction;
import smile.math.DifferentiableMultivariateFunction;
import smile.math.Function;
import smile.math.MultivariateFunction;
import smile.math.Random;
import smile.math.SparseArray;
import smile.sort.QuickSelect;
import smile.sort.QuickSort;
import smile.sort.SortUtils;

public class Math {
    public static final double E = java.lang.Math.E;
    public static final double PI = java.lang.Math.PI;
    public static double EPSILON;
    public static int RADIX;
    public static int DIGITS;
    public static int ROUND_STYLE;
    public static int MACHEP;
    public static int NEGEP;
    private static boolean firstRNG;
    private static ThreadLocal<Random> random;
    private static final double LOG2;

    private Math() {
    }

    public static double abs(double d) {
        return java.lang.Math.abs(d);
    }

    public static float abs(float f) {
        return java.lang.Math.abs(f);
    }

    public static int abs(int n) {
        return java.lang.Math.abs(n);
    }

    public static long abs(long l) {
        return java.lang.Math.abs(l);
    }

    public static double acos(double d) {
        return java.lang.Math.acos(d);
    }

    public static double asin(double d) {
        return java.lang.Math.asin(d);
    }

    public static double atan(double d) {
        return java.lang.Math.atan(d);
    }

    public static double atan2(double d, double d2) {
        return java.lang.Math.atan2(d, d2);
    }

    public static double cbrt(double d) {
        return java.lang.Math.cbrt(d);
    }

    public static double ceil(double d) {
        return java.lang.Math.ceil(d);
    }

    public static double copySign(double d, double d2) {
        return java.lang.Math.copySign(d, d2);
    }

    public static float copySign(float f, float f2) {
        return java.lang.Math.copySign(f, f2);
    }

    public static double cos(double d) {
        return java.lang.Math.cos(d);
    }

    public static double cosh(double d) {
        return java.lang.Math.cosh(d);
    }

    public static double exp(double d) {
        return java.lang.Math.exp(d);
    }

    public static double expm1(double d) {
        return java.lang.Math.expm1(d);
    }

    public static double floor(double d) {
        return java.lang.Math.floor(d);
    }

    public static int getExponent(double d) {
        return java.lang.Math.getExponent(d);
    }

    public static int getExponent(float f) {
        return java.lang.Math.getExponent(f);
    }

    public static double hypot(double d, double d2) {
        return java.lang.Math.hypot(d, d2);
    }

    public static double IEEEremainder(double d, double d2) {
        return java.lang.Math.IEEEremainder(d, d2);
    }

    public static double log(double d) {
        return java.lang.Math.log(d);
    }

    public static double log10(double d) {
        return java.lang.Math.log10(d);
    }

    public static double log1p(double d) {
        return java.lang.Math.log1p(d);
    }

    public static double max(double d, double d2) {
        return java.lang.Math.max(d, d2);
    }

    public static float max(float f, float f2) {
        return java.lang.Math.max(f, f2);
    }

    public static int max(int n, int n2) {
        return java.lang.Math.max(n, n2);
    }

    public static long max(long l, long l2) {
        return java.lang.Math.max(l, l2);
    }

    public static double min(double d, double d2) {
        return java.lang.Math.min(d, d2);
    }

    public static float min(float f, float f2) {
        return java.lang.Math.min(f, f2);
    }

    public static int min(int n, int n2) {
        return java.lang.Math.min(n, n2);
    }

    public static long min(long l, long l2) {
        return java.lang.Math.min(l, l2);
    }

    public static double nextAfter(double d, double d2) {
        return java.lang.Math.nextAfter(d, d2);
    }

    public static float nextAfter(float f, double d) {
        return java.lang.Math.nextAfter(f, d);
    }

    public static double nextUp(double d) {
        return java.lang.Math.nextUp(d);
    }

    public static float nextUp(float f) {
        return java.lang.Math.nextUp(f);
    }

    public static double pow(double d, double d2) {
        return java.lang.Math.pow(d, d2);
    }

    public static double rint(double d) {
        return java.lang.Math.rint(d);
    }

    public static long round(double d) {
        return java.lang.Math.round(d);
    }

    public static int round(float f) {
        return java.lang.Math.round(f);
    }

    public static double scalb(double d, int n) {
        return java.lang.Math.scalb(d, n);
    }

    public static float scalb(float f, int n) {
        return java.lang.Math.scalb(f, n);
    }

    public static double signum(double d) {
        return java.lang.Math.signum(d);
    }

    public static float signum(float f) {
        return java.lang.Math.signum(f);
    }

    public static double sin(double d) {
        return java.lang.Math.sin(d);
    }

    public static double sinh(double d) {
        return java.lang.Math.sinh(d);
    }

    public static double sqrt(double d) {
        return java.lang.Math.sqrt(d);
    }

    public static double tan(double d) {
        return java.lang.Math.tan(d);
    }

    public static double tanh(double d) {
        return java.lang.Math.tanh(d);
    }

    public static double toDegrees(double d) {
        return java.lang.Math.toDegrees(d);
    }

    public static double toRadians(double d) {
        return java.lang.Math.toRadians(d);
    }

    public static double ulp(double d) {
        return java.lang.Math.ulp(d);
    }

    public static float ulp(float f) {
        return java.lang.Math.ulp(f);
    }

    public static double log2(double d) {
        return java.lang.Math.log(d) / LOG2;
    }

    public static boolean equals(double d, double d2) {
        if (d == d2) {
            return true;
        }
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        return Math.abs(d - d2) <= Math.min(d3, d4) * 2.220446049250313E-16;
    }

    public static double logistic(double d) {
        double d2 = 0.0;
        d2 = d < -40.0 ? 2.353853E17 : (d > 40.0 ? 1.0 : 1.0 + Math.exp(-d));
        return 1.0 / d2;
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static boolean isPower2(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    public static double round(double d, int n) {
        if (n < 0) {
            return (double)Math.round(d / Math.pow(10.0, (double)(-n))) * Math.pow(10.0, (double)(-n));
        }
        return (double)Math.round(d * Math.pow(10.0, (double)n)) / Math.pow(10.0, (double)n);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n has to be nonnegative.");
        }
        double d = 1.0;
        for (int i = 2; i <= n; ++i) {
            d *= (double)i;
        }
        return d;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("n has to be nonnegative: %d", n));
        }
        double d = 0.0;
        for (int i = 2; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    public static double choose(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(String.format("Invalid n = %d, k = %d", n, n2));
        }
        if (n < n2) {
            return 0.0;
        }
        return Math.floor(0.5 + Math.exp(Math.logChoose(n, n2)));
    }

    public static double logChoose(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 > n) {
            throw new IllegalArgumentException(String.format("Invalid n = %d, k = %d", n, n2));
        }
        return Math.logFactorial(n) - Math.logFactorial(n2) - Math.logFactorial(n - n2);
    }

    public static void setSeed(long l) {
        random.get().setSeed(l);
    }

    public static int random(double[] dArray) {
        int[] nArray = Math.random(dArray, 1);
        return nArray[0];
    }

    public static int[] random(double[] dArray, int n) {
        int n2;
        int n3;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] * (double)dArray.length;
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = i;
        }
        int[] nArray2 = new int[dArray.length];
        int n4 = 0;
        int n5 = dArray.length - 1;
        for (n3 = 0; n3 < dArray.length; ++n3) {
            if (dArray2[n3] >= 1.0) {
                nArray2[n4++] = n3;
                continue;
            }
            nArray2[n5--] = n3;
        }
        while (n4 != 0 && n5 != dArray.length - 1) {
            n3 = nArray2[n5 + 1];
            nArray[n3] = n2 = nArray2[n4 - 1];
            int n6 = n2;
            dArray2[n6] = dArray2[n6] + (dArray2[n3] - 1.0);
            ++n5;
            if (!(dArray2[n2] < 1.0)) continue;
            nArray2[n5--] = n2;
            --n4;
        }
        int[] nArray3 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n7;
            double d = Math.random() * (double)dArray.length;
            nArray3[n2] = (d -= (double)(n7 = (int)d)) < dArray2[n7] ? n7 : nArray[n7];
        }
        return nArray3;
    }

    public static double random() {
        return random.get().nextDouble();
    }

    public static double[] random(int n) {
        double[] dArray = new double[n];
        random.get().nextDoubles(dArray);
        return dArray;
    }

    public static double random(double d, double d2) {
        return random.get().nextDouble(d, d2);
    }

    public static double[] random(double d, double d2, int n) {
        double[] dArray = new double[n];
        random.get().nextDoubles(dArray, d, d2);
        return dArray;
    }

    public static int randomInt(int n) {
        return random.get().nextInt(n);
    }

    public static int randomInt(int n, int n2) {
        int n3 = n2 - n;
        return n + random.get().nextInt(n3);
    }

    public static int[] permutate(int n) {
        return random.get().permutate(n);
    }

    public static void permutate(int[] nArray) {
        random.get().permutate(nArray);
    }

    public static void permutate(float[] fArray) {
        random.get().permutate(fArray);
    }

    public static void permutate(double[] dArray) {
        random.get().permutate(dArray);
    }

    public static void permutate(Object[] objectArray) {
        random.get().permutate(objectArray);
    }

    public static int[] c(int ... nArray) {
        return nArray;
    }

    public static float[] c(float ... fArray) {
        return fArray;
    }

    public static double[] c(double ... dArray) {
        return dArray;
    }

    public static String[] c(String ... stringArray) {
        return stringArray;
    }

    public static int[] c(int[] ... nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray.length;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int n3 : nArray[i]) {
                nArray2[n2++] = n3;
            }
        }
        return nArray2;
    }

    public static float[] c(float[] ... fArray) {
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            n += fArray.length;
        }
        float[] fArray2 = new float[n];
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            for (float f : fArray[i]) {
                fArray2[n2++] = f;
            }
        }
        return fArray2;
    }

    public static double[] c(double[] ... dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            n += dArray.length;
        }
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            for (double d : dArray[i]) {
                dArray2[n2++] = d;
            }
        }
        return dArray2;
    }

    public static String[] c(String[] ... stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray.length;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            for (String string : stringArray[i]) {
                stringArray2[n2++] = string;
            }
        }
        return stringArray2;
    }

    public static int[] cbind(int[] ... nArray) {
        return Math.c(nArray);
    }

    public static float[] cbind(float[] ... fArray) {
        return Math.c(fArray);
    }

    public static double[] cbind(double[] ... dArray) {
        return Math.c(dArray);
    }

    public static String[] cbind(String[] ... stringArray) {
        return Math.c(stringArray);
    }

    public static int[][] rbind(int[] ... nArray) {
        return nArray;
    }

    public static float[][] rbind(float[] ... fArray) {
        return fArray;
    }

    public static double[][] rbind(double[] ... dArray) {
        return dArray;
    }

    public static String[][] rbind(String[] ... stringArray) {
        return stringArray;
    }

    public static <E> E[] slice(E[] EArray, int[] nArray) {
        int n = nArray.length;
        Object[] objectArray = (Object[])Array.newInstance(EArray.getClass().getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = EArray[nArray[i]];
        }
        return objectArray;
    }

    public static int[] slice(int[] nArray, int[] nArray2) {
        int n = nArray2.length;
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    public static float[] slice(float[] fArray, int[] nArray) {
        int n = nArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = fArray[nArray[i]];
        }
        return fArray2;
    }

    public static double[] slice(double[] dArray, int[] nArray) {
        int n = nArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }

    public static boolean contains(double[][] dArray, double[] dArray2) {
        return Math.contains(dArray, dArray2[0], dArray2[1]);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(double[][] var0, double var1_1, double var3_2) {
        if (var0.length <= 2) {
            return false;
        }
        var5_3 = 0;
        var6_4 = var0.length;
        var7_5 = var0[var6_4 - 1][0];
        var9_6 = var0[var6_4 - 1][1];
        for (var15_7 = 0; var15_7 < var6_4; ++var15_7) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                var11_8 = var0[var15_7][0];
                                var13_9 = var0[var15_7][1];
                                if (var13_9 == var9_6) break block8;
                                if (!(var11_8 < var7_5)) break block9;
                                if (var1_1 >= var7_5) break block8;
                                var16_10 = var11_8;
                                break block10;
                            }
                            if (var1_1 >= var11_8) break block8;
                            var16_10 = var7_5;
                        }
                        if (!(var13_9 < var9_6)) break block11;
                        if (var3_2 < var13_9 || var3_2 >= var9_6) break block8;
                        if (!(var1_1 < var16_10)) break block12;
                        ++var5_3;
                        break block8;
                    }
                    var18_11 = var1_1 - var11_8;
                    var20_12 = var3_2 - var13_9;
                    ** GOTO lbl35
                }
                if (var3_2 < var9_6 || var3_2 >= var13_9) break block8;
                if (var1_1 < var16_10) {
                    ++var5_3;
                } else {
                    var18_11 = var1_1 - var7_5;
                    var20_12 = var3_2 - var9_6;
lbl35:
                    // 2 sources

                    if (var18_11 < var20_12 / (var9_6 - var13_9) * (var7_5 - var11_8)) {
                        ++var5_3;
                    }
                }
            }
            var7_5 = var11_8;
            var9_6 = var13_9;
        }
        return (var5_3 & true) != false;
    }

    public static void reverse(int[] nArray) {
        int n = 0;
        int n2 = nArray.length - 1;
        while (n < n2) {
            SortUtils.swap(nArray, n++, n2--);
        }
    }

    public static void reverse(float[] fArray) {
        int n = 0;
        int n2 = fArray.length - 1;
        while (n < n2) {
            SortUtils.swap(fArray, n++, n2--);
        }
    }

    public static void reverse(double[] dArray) {
        int n = 0;
        int n2 = dArray.length - 1;
        while (n < n2) {
            SortUtils.swap(dArray, n++, n2--);
        }
    }

    public static <T> void reverse(T[] TArray) {
        int n = 0;
        int n2 = TArray.length - 1;
        while (n < n2) {
            SortUtils.swap(TArray, n++, n2--);
        }
    }

    public static int min(int n, int n2, int n3) {
        return Math.min(Math.min(n, n2), n3);
    }

    public static double min(float f, float f2, float f3) {
        return Math.min(Math.min(f, f2), f3);
    }

    public static double min(double d, double d2, double d3) {
        return Math.min(Math.min(d, d2), d3);
    }

    public static int max(int n, int n2, int n3) {
        return Math.max(Math.max(n, n2), n3);
    }

    public static float max(float f, float f2, float f3) {
        return Math.max(Math.max(f, f2), f3);
    }

    public static double max(double d, double d2, double d3) {
        return Math.max(Math.max(d, d2), d3);
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static float min(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        for (float f2 : fArray) {
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public static double min(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        for (double d2 : dArray) {
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static int whichMin(int[] nArray) {
        int n = nArray[0];
        int n2 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
            n2 = i;
        }
        return n2;
    }

    public static int whichMin(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
            n = i;
        }
        return n;
    }

    public static int whichMin(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public static int max(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static float max(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        for (float f2 : fArray) {
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public static double max(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static int whichMax(int[] nArray) {
        int n = nArray[0];
        int n2 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
            n2 = i;
        }
        return n2;
    }

    public static int whichMax(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
            n = i;
        }
        return n;
    }

    public static int whichMax(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public static int min(int[][] nArray) {
        int n = nArray[0][0];
        int[][] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3;
            for (int n3 : nArray3 = nArray2[i]) {
                if (n <= n3) continue;
                n = n3;
            }
        }
        return n;
    }

    public static double min(double[][] dArray) {
        double d = Double.POSITIVE_INFINITY;
        double[][] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3;
            for (double d2 : dArray3 = dArray2[i]) {
                if (!(d > d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    public static int max(int[][] nArray) {
        int n = nArray[0][0];
        int[][] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3;
            for (int n3 : nArray3 = nArray2[i]) {
                if (n >= n3) continue;
                n = n3;
            }
        }
        return n;
    }

    public static double max(double[][] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        double[][] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3;
            for (double d2 : dArray3 = dArray2[i]) {
                if (!(d < d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    public static double[][] transpose(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[] rowMin(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = Math.min(dArray[i]);
        }
        return dArray2;
    }

    public static double[] rowMax(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = Math.max(dArray[i]);
        }
        return dArray2;
    }

    public static double[] rowSums(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = Math.sum(dArray[i]);
        }
        return dArray2;
    }

    public static double[] rowMeans(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = Math.mean(dArray[i]);
        }
        return dArray2;
    }

    public static double[] rowSds(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = Math.sd(dArray[i]);
        }
        return dArray2;
    }

    public static double[] colMin(double[][] dArray) {
        int n;
        double[] dArray2 = new double[dArray[0].length];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = Double.POSITIVE_INFINITY;
        }
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray2.length; ++i) {
                if (!(dArray2[i] > dArray[n][i])) continue;
                dArray2[i] = dArray[n][i];
            }
        }
        return dArray2;
    }

    public static double[] colMax(double[][] dArray) {
        int n;
        double[] dArray2 = new double[dArray[0].length];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = Double.NEGATIVE_INFINITY;
        }
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray2.length; ++i) {
                if (!(dArray2[i] < dArray[n][i])) continue;
                dArray2[i] = dArray[n][i];
            }
        }
        return dArray2;
    }

    public static double[] colSums(double[][] dArray) {
        double[] dArray2 = (double[])dArray[0].clone();
        for (int i = 1; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] + dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[] colMeans(double[][] dArray) {
        double[] dArray2 = (double[])dArray[0].clone();
        for (int i = 1; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] + dArray[i][j];
            }
        }
        Math.scale(1.0 / (double)dArray.length, dArray2);
        return dArray2;
    }

    public static double[] colSds(double[][] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        int n = dArray[0].length;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[][] dArray4 = dArray;
        int n2 = dArray4.length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray5 = dArray4[i];
            for (int j = 0; j < n; ++j) {
                int n3 = j;
                dArray2[n3] = dArray2[n3] + dArray5[j];
                int n4 = j;
                dArray3[n4] = dArray3[n4] + dArray5[j] * dArray5[j];
            }
        }
        int n5 = dArray.length - 1;
        for (n2 = 0; n2 < n; ++n2) {
            dArray3[n2] = java.lang.Math.sqrt(dArray3[n2] / (double)n5 - dArray2[n2] / (double)dArray.length * (dArray2[n2] / (double)n5));
        }
        return dArray3;
    }

    public static int sum(int[] nArray) {
        double d = 0.0;
        for (int n : nArray) {
            d += (double)n;
        }
        if (d > 2.147483647E9 || d < -2.147483647E9) {
            throw new ArithmeticException("Sum overflow: " + d);
        }
        return (int)d;
    }

    public static double sum(float[] fArray) {
        double d = 0.0;
        for (float f : fArray) {
            d += (double)f;
        }
        return d;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    public static int median(int[] nArray) {
        return QuickSelect.median(nArray);
    }

    public static float median(float[] fArray) {
        return QuickSelect.median(fArray);
    }

    public static double median(double[] dArray) {
        return QuickSelect.median(dArray);
    }

    public static <T extends Comparable<? super T>> T median(T[] TArray) {
        return (T)QuickSelect.median(TArray);
    }

    public static int q1(int[] nArray) {
        return QuickSelect.q1(nArray);
    }

    public static float q1(float[] fArray) {
        return QuickSelect.q1(fArray);
    }

    public static double q1(double[] dArray) {
        return QuickSelect.q1(dArray);
    }

    public static <T extends Comparable<? super T>> T q1(T[] TArray) {
        return (T)QuickSelect.q1(TArray);
    }

    public static int q3(int[] nArray) {
        return QuickSelect.q3(nArray);
    }

    public static float q3(float[] fArray) {
        return QuickSelect.q3(fArray);
    }

    public static double q3(double[] dArray) {
        return QuickSelect.q3(dArray);
    }

    public static <T extends Comparable<? super T>> T q3(T[] TArray) {
        return (T)QuickSelect.q3(TArray);
    }

    public static double mean(int[] nArray) {
        return (double)Math.sum(nArray) / (double)nArray.length;
    }

    public static double mean(float[] fArray) {
        return Math.sum(fArray) / (double)fArray.length;
    }

    public static double mean(double[] dArray) {
        return Math.sum(dArray) / (double)dArray.length;
    }

    public static double var(int[] nArray) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int n : nArray) {
            d += (double)n;
            d2 += (double)(n * n);
        }
        int n = nArray.length - 1;
        return d2 / (double)n - d / (double)nArray.length * (d / (double)n);
    }

    public static double var(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (float f : fArray) {
            d += (double)f;
            d2 += (double)(f * f);
        }
        int n = fArray.length - 1;
        return d2 / (double)n - d / (double)fArray.length * (d / (double)n);
    }

    public static double var(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (double d3 : dArray) {
            d += d3;
            d2 += d3 * d3;
        }
        int n = dArray.length - 1;
        return d2 / (double)n - d / (double)dArray.length * (d / (double)n);
    }

    public static double sd(int[] nArray) {
        return Math.sqrt(Math.var(nArray));
    }

    public static double sd(float[] fArray) {
        return Math.sqrt(Math.var(fArray));
    }

    public static double sd(double[] dArray) {
        return Math.sqrt(Math.var(dArray));
    }

    public static double mad(int[] nArray) {
        int n = Math.median(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Math.abs(nArray[i] - n);
        }
        return Math.median(nArray);
    }

    public static double mad(float[] fArray) {
        float f = Math.median(fArray);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Math.abs(fArray[i] - f);
        }
        return Math.median(fArray);
    }

    public static double mad(double[] dArray) {
        double d = Math.median(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.abs(dArray[i] - d);
        }
        return Math.median(dArray);
    }

    public static boolean all(boolean[] blArray) {
        for (boolean bl : blArray) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean any(boolean[] blArray) {
        for (boolean bl : blArray) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static double distance(int[] nArray, int[] nArray2) {
        return Math.sqrt(Math.squaredDistance(nArray, nArray2));
    }

    public static double distance(float[] fArray, float[] fArray2) {
        return Math.sqrt(Math.squaredDistance(fArray, fArray2));
    }

    public static double distance(double[] dArray, double[] dArray2) {
        return Math.sqrt(Math.squaredDistance(dArray, dArray2));
    }

    public static double distance(SparseArray sparseArray, SparseArray sparseArray2) {
        return Math.sqrt(Math.squaredDistance(sparseArray, sparseArray2));
    }

    public static double[][] pdist(double[][] dArray) {
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        Math.pdist(dArray, dArray2, false, false);
        return dArray2;
    }

    public static void pdist(double[][] dArray, double[][] dArray2, boolean bl, boolean bl2) {
        int n = dArray.length;
        if (n < 100) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < i; ++j) {
                    double d;
                    dArray2[i][j] = d = Math.distance(dArray[i], dArray[j]);
                    dArray2[j][i] = d;
                }
            }
        } else {
            int n2 = Runtime.getRuntime().availableProcessors();
            ArrayList<PdistTask> arrayList = new ArrayList<PdistTask>();
            for (int i = 0; i < n2; ++i) {
                PdistTask pdistTask = new PdistTask(dArray, dArray2, n2, i, bl, bl2);
                arrayList.add(pdistTask);
            }
            ForkJoinPool.commonPool().invokeAll(arrayList);
        }
    }

    public static double squaredDistance(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += Math.sqr(nArray[i] - nArray2[i]);
        }
        return d;
    }

    public static double squaredDistance(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += Math.sqr(fArray[i] - fArray2[i]);
        }
        return d;
    }

    public static double squaredDistance(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.sqr(dArray[i] - dArray2[i]);
        }
        return d;
    }

    public static double squaredDistance(SparseArray sparseArray, SparseArray sparseArray2) {
        Iterator<SparseArray.Entry> iterator = sparseArray.iterator();
        Iterator<SparseArray.Entry> iterator2 = sparseArray2.iterator();
        SparseArray.Entry entry = iterator.hasNext() ? iterator.next() : null;
        SparseArray.Entry entry2 = iterator2.hasNext() ? iterator2.next() : null;
        double d = 0.0;
        while (entry != null && entry2 != null) {
            if (entry.i == entry2.i) {
                d += Math.sqr(entry.x - entry2.x);
                entry = iterator.hasNext() ? iterator.next() : null;
                entry2 = iterator2.hasNext() ? iterator2.next() : null;
                continue;
            }
            if (entry.i > entry2.i) {
                d += Math.sqr(entry2.x);
                entry2 = iterator2.hasNext() ? iterator2.next() : null;
                continue;
            }
            d += Math.sqr(entry.x);
            entry = iterator.hasNext() ? iterator.next() : null;
        }
        while (iterator.hasNext()) {
            d += Math.sqr(iterator.next().x);
        }
        while (iterator2.hasNext()) {
            d += Math.sqr(iterator2.next().x);
        }
        return d;
    }

    public static double KullbackLeiblerDivergence(double[] dArray, double[] dArray2) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0 || dArray2[i] == 0.0) continue;
            bl = true;
            d += dArray[i] * Math.log(dArray[i] / dArray2[i]);
        }
        if (bl) {
            return d;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double KullbackLeiblerDivergence(SparseArray sparseArray, SparseArray sparseArray2) {
        if (sparseArray.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (sparseArray2.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterator = sparseArray.iterator();
        Iterator<SparseArray.Entry> iterator2 = sparseArray2.iterator();
        SparseArray.Entry entry = iterator.hasNext() ? iterator.next() : null;
        SparseArray.Entry entry2 = iterator2.hasNext() ? iterator2.next() : null;
        boolean bl = false;
        double d = 0.0;
        while (entry != null && entry2 != null) {
            if (entry.i < entry2.i) {
                entry = iterator.hasNext() ? iterator.next() : null;
                continue;
            }
            if (entry.i > entry2.i) {
                entry2 = iterator2.hasNext() ? iterator2.next() : null;
                continue;
            }
            bl = true;
            d += entry.x * Math.log(entry.x / entry2.x);
            entry = iterator.hasNext() ? iterator.next() : null;
            entry2 = iterator2.hasNext() ? iterator2.next() : null;
        }
        if (bl) {
            return d;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double KullbackLeiblerDivergence(double[] dArray, SparseArray sparseArray) {
        return Math.KullbackLeiblerDivergence(sparseArray, dArray);
    }

    public static double KullbackLeiblerDivergence(SparseArray sparseArray, double[] dArray) {
        if (sparseArray.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        Iterator<SparseArray.Entry> iterator = sparseArray.iterator();
        boolean bl = false;
        double d = 0.0;
        while (iterator.hasNext()) {
            SparseArray.Entry entry = iterator.next();
            int n = entry.i;
            if (!(dArray[n] > 0.0)) continue;
            bl = true;
            d += entry.x * Math.log(entry.x / dArray[n]);
        }
        if (bl) {
            return d;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double JensenShannonDivergence(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = (dArray[i] + dArray2[i]) / 2.0;
        }
        return (Math.KullbackLeiblerDivergence(dArray, dArray3) + Math.KullbackLeiblerDivergence(dArray2, dArray3)) / 2.0;
    }

    public static double JensenShannonDivergence(SparseArray sparseArray, SparseArray sparseArray2) {
        if (sparseArray.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (sparseArray2.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterator = sparseArray.iterator();
        Iterator<SparseArray.Entry> iterator2 = sparseArray2.iterator();
        SparseArray.Entry entry = iterator.hasNext() ? iterator.next() : null;
        SparseArray.Entry entry2 = iterator2.hasNext() ? iterator2.next() : null;
        double d = 0.0;
        while (entry != null && entry2 != null) {
            double d2;
            if (entry.i < entry2.i) {
                d2 = entry.x / 2.0;
                d += entry.x * Math.log(entry.x / d2);
                entry = iterator.hasNext() ? iterator.next() : null;
                continue;
            }
            if (entry.i > entry2.i) {
                d2 = entry2.x / 2.0;
                d += entry2.x * Math.log(entry2.x / d2);
                entry2 = iterator2.hasNext() ? iterator2.next() : null;
                continue;
            }
            d2 = (entry.x + entry2.x) / 2.0;
            d += entry.x * Math.log(entry.x / d2) + entry2.x * Math.log(entry2.x / d2);
            entry = iterator.hasNext() ? iterator.next() : null;
            entry2 = iterator2.hasNext() ? iterator2.next() : null;
        }
        return d / 2.0;
    }

    public static double JensenShannonDivergence(double[] dArray, SparseArray sparseArray) {
        return Math.JensenShannonDivergence(sparseArray, dArray);
    }

    public static double JensenShannonDivergence(SparseArray sparseArray, double[] dArray) {
        if (sparseArray.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        Iterator<SparseArray.Entry> iterator = sparseArray.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            SparseArray.Entry entry = iterator.next();
            int n = entry.i;
            double d2 = (entry.x + dArray[n]) / 2.0;
            d += entry.x * Math.log(entry.x / d2);
            if (!(dArray[n] > 0.0)) continue;
            d += dArray[n] * Math.log(dArray[n] / d2);
        }
        return d / 2.0;
    }

    public static double dot(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)(nArray[i] * nArray2[i]);
        }
        return d;
    }

    public static double dot(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += (double)(fArray[i] * fArray2[i]);
        }
        return d;
    }

    public static double dot(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double dot(SparseArray sparseArray, SparseArray sparseArray2) {
        Iterator<SparseArray.Entry> iterator = sparseArray.iterator();
        Iterator<SparseArray.Entry> iterator2 = sparseArray2.iterator();
        SparseArray.Entry entry = iterator.hasNext() ? iterator.next() : null;
        SparseArray.Entry entry2 = iterator2.hasNext() ? iterator2.next() : null;
        double d = 0.0;
        while (entry != null && entry2 != null) {
            if (entry.i == entry2.i) {
                d += entry.x * entry2.x;
                entry = iterator.hasNext() ? iterator.next() : null;
                entry2 = iterator2.hasNext() ? iterator2.next() : null;
                continue;
            }
            if (entry.i > entry2.i) {
                entry2 = iterator2.hasNext() ? iterator2.next() : null;
                continue;
            }
            entry = iterator.hasNext() ? iterator.next() : null;
        }
        return d;
    }

    public static double cov(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (nArray.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double d = Math.mean(nArray);
        double d2 = Math.mean(nArray2);
        double d3 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d4 = (double)nArray[i] - d;
            double d5 = (double)nArray2[i] - d2;
            d3 += d4 * d5;
        }
        return d3 / (double)(nArray.length - 1);
    }

    public static double cov(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (fArray.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double d = Math.mean(fArray);
        double d2 = Math.mean(fArray2);
        double d3 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d4 = (double)fArray[i] - d;
            double d5 = (double)fArray2[i] - d2;
            d3 += d4 * d5;
        }
        return d3 / (double)(fArray.length - 1);
    }

    public static double cov(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (dArray.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double d = Math.mean(dArray);
        double d2 = Math.mean(dArray2);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = dArray[i] - d;
            double d5 = dArray2[i] - d2;
            d3 += d4 * d5;
        }
        return d3 / (double)(dArray.length - 1);
    }

    public static double[][] cov(double[][] dArray) {
        return Math.cov(dArray, Math.colMeans(dArray));
    }

    public static double[][] cov(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        double[][] dArray3 = new double[dArray[0].length][dArray[0].length];
        for (n3 = 0; n3 < dArray.length; ++n3) {
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                for (n = 0; n <= n2; ++n) {
                    double[] dArray4 = dArray3[n2];
                    int n4 = n;
                    dArray4[n4] = dArray4[n4] + (dArray[n3][n2] - dArray2[n2]) * (dArray[n3][n] - dArray2[n]);
                }
            }
        }
        n3 = dArray.length - 1;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n <= n2; ++n) {
                double[] dArray5 = dArray3[n2];
                int n5 = n;
                dArray5[n5] = dArray5[n5] / (double)n3;
                dArray3[n][n2] = dArray3[n2][n];
            }
        }
        return dArray3;
    }

    public static double cor(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (nArray.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double d = Math.cov(nArray, nArray2);
        double d2 = Math.var(nArray);
        double d3 = Math.var(nArray2);
        if (d2 == 0.0 || d3 == 0.0) {
            return Double.NaN;
        }
        return d / java.lang.Math.sqrt(d2 * d3);
    }

    public static double cor(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (fArray.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double d = Math.cov(fArray, fArray2);
        double d2 = Math.var(fArray);
        double d3 = Math.var(fArray2);
        if (d2 == 0.0 || d3 == 0.0) {
            return Double.NaN;
        }
        return d / java.lang.Math.sqrt(d2 * d3);
    }

    public static double cor(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays have different length.");
        }
        if (dArray.length < 3) {
            throw new IllegalArgumentException("array length has to be at least 3.");
        }
        double d = Math.cov(dArray, dArray2);
        double d2 = Math.var(dArray);
        double d3 = Math.var(dArray2);
        if (d2 == 0.0 || d3 == 0.0) {
            return Double.NaN;
        }
        return d / java.lang.Math.sqrt(d2 * d3);
    }

    public static double[][] cor(double[][] dArray) {
        return Math.cor(dArray, Math.colMeans(dArray));
    }

    public static double[][] cor(double[][] dArray, double[] dArray2) {
        int n;
        double[][] dArray3 = Math.cov(dArray, dArray2);
        int n2 = dArray[0].length;
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray4[n] = Math.sqrt(dArray3[n][n]);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i <= n; ++i) {
                double[] dArray5 = dArray3[n];
                int n3 = i;
                dArray5[n3] = dArray5[n3] / (dArray4[n] * dArray4[i]);
                dArray3[i][n] = dArray3[n][i];
            }
        }
        return dArray3;
    }

    private static double crank(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        int n2 = 1;
        while (n2 < n) {
            int n3;
            if (dArray[n2] != dArray[n2 - 1]) {
                dArray[n2 - 1] = n2;
                ++n2;
                continue;
            }
            for (n3 = n2 + 1; n3 <= n && dArray[n3 - 1] == dArray[n2 - 1]; ++n3) {
            }
            double d2 = 0.5 * (double)(n2 + n3 - 1);
            for (int i = n2; i <= n3 - 1; ++i) {
                dArray[i - 1] = d2;
            }
            double d3 = n3 - n2;
            d += d3 * d3 * d3 - d3;
            n2 = n3;
        }
        if (n2 == n) {
            dArray[n - 1] = n;
        }
        return d;
    }

    public static double spearman(int[] nArray, int[] nArray2) {
        int n;
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = nArray[i];
            dArray2[i] = nArray2[i];
        }
        QuickSort.sort(dArray, dArray2);
        double d = Math.crank(dArray);
        QuickSort.sort(dArray2, dArray);
        double d2 = Math.crank(dArray2);
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += Math.sqr(dArray[n] - dArray2[n]);
        }
        n = n2;
        double d4 = n * n * n - n;
        double d5 = (1.0 - d / d4) * (1.0 - d2 / d4);
        double d6 = (1.0 - 6.0 / d4 * (d3 + (d + d2) / 12.0)) / Math.sqrt(d5);
        return d6;
    }

    public static double spearman(float[] fArray, float[] fArray2) {
        int n;
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n2 = fArray.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = fArray[i];
            dArray2[i] = fArray2[i];
        }
        QuickSort.sort(dArray, dArray2);
        double d = Math.crank(dArray);
        QuickSort.sort(dArray2, dArray);
        double d2 = Math.crank(dArray2);
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += Math.sqr(dArray[n] - dArray2[n]);
        }
        n = n2;
        double d4 = n * n * n - n;
        double d5 = (1.0 - d / d4) * (1.0 - d2 / d4);
        double d6 = (1.0 - 6.0 / d4 * (d3 + (d + d2) / 12.0)) / Math.sqrt(d5);
        return d6;
    }

    public static double spearman(double[] dArray, double[] dArray2) {
        int n;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = dArray[i];
            dArray4[i] = dArray2[i];
        }
        QuickSort.sort(dArray3, dArray4);
        double d = Math.crank(dArray3);
        QuickSort.sort(dArray4, dArray3);
        double d2 = Math.crank(dArray4);
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += Math.sqr(dArray3[n] - dArray4[n]);
        }
        n = n2;
        double d4 = n * n * n - n;
        double d5 = (1.0 - d / d4) * (1.0 - d2 / d4);
        double d6 = (1.0 - 6.0 / d4 * (d3 + (d + d2) / 12.0)) / Math.sqrt(d5);
        return d6;
    }

    public static double kendall(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        for (int i = 0; i < n4 - 1; ++i) {
            for (int j = i + 1; j < n4; ++j) {
                double d = nArray[i] - nArray[j];
                double d2 = nArray2[i] - nArray2[j];
                double d3 = d * d2;
                if (d3 != 0.0) {
                    ++n3;
                    ++n2;
                    if (d3 > 0.0) {
                        ++n;
                        continue;
                    }
                    --n;
                    continue;
                }
                if (d != 0.0) {
                    ++n3;
                }
                if (d2 == 0.0) continue;
                ++n2;
            }
        }
        double d = (double)n / (Math.sqrt(n3) * Math.sqrt(n2));
        return d;
    }

    public static double kendall(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = fArray.length;
        for (int i = 0; i < n4 - 1; ++i) {
            for (int j = i + 1; j < n4; ++j) {
                double d = fArray[i] - fArray[j];
                double d2 = fArray2[i] - fArray2[j];
                double d3 = d * d2;
                if (d3 != 0.0) {
                    ++n3;
                    ++n2;
                    if (d3 > 0.0) {
                        ++n;
                        continue;
                    }
                    --n;
                    continue;
                }
                if (d != 0.0) {
                    ++n3;
                }
                if (d2 == 0.0) continue;
                ++n2;
            }
        }
        double d = (double)n / (Math.sqrt(n3) * Math.sqrt(n2));
        return d;
    }

    public static double kendall(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        for (int i = 0; i < n4 - 1; ++i) {
            for (int j = i + 1; j < n4; ++j) {
                double d = dArray[i] - dArray[j];
                double d2 = dArray2[i] - dArray2[j];
                double d3 = d * d2;
                if (d3 != 0.0) {
                    ++n3;
                    ++n2;
                    if (d3 > 0.0) {
                        ++n;
                        continue;
                    }
                    --n;
                    continue;
                }
                if (d != 0.0) {
                    ++n3;
                }
                if (d2 == 0.0) continue;
                ++n2;
            }
        }
        double d = (double)n / (Math.sqrt(n3) * Math.sqrt(n2));
        return d;
    }

    public static double norm1(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += Math.abs(d2);
        }
        return d;
    }

    public static double norm2(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2 * d2;
        }
        d = Math.sqrt(d);
        return d;
    }

    public static double normInf(double[] dArray) {
        int n = dArray.length;
        double d = Math.abs(dArray[0]);
        for (int i = 1; i < n; ++i) {
            d = Math.max(d, Math.abs(dArray[i]));
        }
        return d;
    }

    public static double norm(double[] dArray) {
        return Math.norm2(dArray);
    }

    public static void standardize(double[] dArray) {
        double d = Math.mean(dArray);
        double d2 = Math.sd(dArray);
        if (Math.isZero(d2)) {
            System.out.println("array has variance of 0.");
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (dArray[i] - d) / d2;
        }
    }

    public static void scale(double[][] dArray) {
        Math.scale(dArray, 0.0, 1.0);
    }

    public static void scale(double[][] dArray, double d, double d2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = Math.colMin(dArray);
        double[] dArray3 = Math.colMax(dArray);
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d3 = dArray3[i] - dArray2[i];
            if (!Math.isZero(d3)) {
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[n3][i] = (dArray[n3][i] - dArray2[i]) / d3;
                }
                continue;
            }
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3][i] = 0.5;
            }
        }
    }

    public static void standardize(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = Math.colMeans(dArray);
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                dArray[i][n] = dArray[i][n] - dArray2[n];
            }
        }
        double[] dArray3 = new double[n3];
        for (n = 0; n < n3; ++n) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = n;
                dArray3[n5] = dArray3[n5] + Math.sqr(dArray[n4][n]);
            }
            dArray3[n] = Math.sqrt(dArray3[n] / (double)(n2 - 1));
            if (Math.isZero(dArray3[n])) continue;
            for (n4 = 0; n4 < n2; ++n4) {
                double[] dArray4 = dArray[n4];
                int n6 = n;
                dArray4[n6] = dArray4[n6] / dArray3[n];
            }
        }
    }

    public static void normalize(double[][] dArray) {
        Math.normalize(dArray, false);
    }

    public static void normalize(double[][] dArray, boolean bl) {
        int n;
        int n2;
        double[] dArray2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        if (bl) {
            dArray2 = Math.colMeans(dArray);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    dArray[n2][n] = dArray[n2][n] - dArray2[n];
                }
            }
        }
        dArray2 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n5 = n2;
                dArray2[n5] = dArray2[n5] + Math.sqr(dArray[n][n2]);
            }
            dArray2[n2] = Math.sqrt(dArray2[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (Math.isZero(dArray2[n])) continue;
                double[] dArray3 = dArray[n2];
                int n6 = n;
                dArray3[n6] = dArray3[n6] / dArray2[n];
            }
        }
    }

    public static void unitize(double[] dArray) {
        Math.unitize2(dArray);
    }

    public static void unitize1(double[] dArray) {
        double d = Math.norm1(dArray);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
    }

    public static void unitize2(double[] dArray) {
        double d = Math.norm(dArray);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
    }

    private static double smoothed(int n, double d, double d2) {
        return Math.exp(d2 + d * Math.log(n));
    }

    private static int row(int[] nArray, int n) {
        int n2;
        for (n2 = 0; n2 < nArray.length && nArray[n2] < n; ++n2) {
        }
        return n2 < nArray.length && nArray[n2] == n ? n2 : -1;
    }

    public static double GoodTuring(int[] nArray, int[] nArray2, double[] dArray) {
        int n;
        int n2;
        int n3;
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("The sizes of r and Nr are not same.");
        }
        int n4 = nArray.length;
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n5 += nArray[n3] * nArray2[n3];
        }
        n3 = nArray[0] != 1 ? 0 : nArray2[0];
        double d = (double)n3 / (double)n5;
        for (int i = 0; i < n4; ++i) {
            int n6 = i == 0 ? 0 : nArray[i - 1];
            int n7 = i == n4 - 1 ? 2 * nArray[i] - n6 : nArray[i + 1];
            dArray4[i] = 2.0 * (double)nArray2[i] / (double)(n7 - n6);
            dArray2[i] = Math.log(nArray[i]);
            dArray3[i] = Math.log(dArray4[i]);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = 0; n2 < n4; ++n2) {
            d4 += dArray2[n2];
            d5 += dArray3[n2];
        }
        d4 /= (double)n4;
        d5 /= (double)n4;
        for (n2 = 0; n2 < n4; ++n2) {
            d2 += (dArray2[n2] - d4) * (dArray3[n2] - d5);
            d3 += Math.sqr(dArray2[n2] - d4);
        }
        double d6 = d2 / d3;
        double d7 = d5 - d6 * d4;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            double d8 = (double)(nArray[i] + 1) * Math.smoothed(nArray[i] + 1, d6, d7) / Math.smoothed(nArray[i], d6, d7);
            if (Math.row(nArray, nArray[i] + 1) < 0) {
                bl = true;
            }
            if (!bl) {
                int n8 = nArray2[Math.row(nArray, nArray[i] + 1)];
                double d9 = (double)((nArray[i] + 1) * n8) / (double)nArray2[i];
                if (Math.abs(d9 - d8) <= 1.96 * Math.sqrt(Math.sqr((double)nArray[i] + 1.0) * (double)n8 / Math.sqr(nArray2[i]) * (1.0 + (double)n8 / (double)nArray2[i]))) {
                    bl = true;
                } else {
                    dArray[i] = d9;
                }
            }
            if (!bl) continue;
            dArray[i] = d8;
        }
        double d10 = 0.0;
        for (n = 0; n < n4; ++n) {
            d10 += (double)nArray2[n] * dArray[n];
        }
        for (n = 0; n < n4; ++n) {
            dArray[n] = (1.0 - d) * dArray[n] / d10;
        }
        return d;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", nArray.length, nArray2.length));
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        return Math.equals(fArray, fArray2, 1.0E-7f);
    }

    public static boolean equals(float[] fArray, float[] fArray2, float f) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", fArray.length, fArray2.length));
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (!(Math.abs(fArray[i] - fArray2[i]) > f)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        return Math.equals(dArray, dArray2, 1.0E-10);
    }

    public static boolean equals(double[] dArray, double[] dArray2, double d) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray.length, dArray2.length));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + d);
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > d)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean equals(T[] TArray, T[] TArray2) {
        if (TArray.length != TArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", TArray.length, TArray2.length));
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i].compareTo(TArray2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[][] nArray, int[][] nArray2) {
        if (nArray.length != nArray2.length || nArray[0].length != nArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", nArray.length, nArray[0].length, nArray2.length, nArray2[0].length));
        }
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] == nArray2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(float[][] fArray, float[][] fArray2) {
        return Math.equals(fArray, fArray2, 1.0E-7f);
    }

    public static boolean equals(float[][] fArray, float[][] fArray2, float f) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", fArray.length, fArray[0].length, fArray2.length, fArray2[0].length));
        }
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                if (!(Math.abs(fArray[i][j] - fArray2[i][j]) > f)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(double[][] dArray, double[][] dArray2) {
        return Math.equals(dArray, dArray2, 1.0E-10);
    }

    public static boolean equals(double[][] dArray, double[][] dArray2, double d) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", dArray.length, dArray[0].length, dArray2.length, dArray2[0].length));
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid epsilon: " + d);
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(Math.abs(dArray[i][j] - dArray2[i][j]) > d)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isZero(float f) {
        return Math.isZero((double)f, EPSILON);
    }

    public static boolean isZero(float f, float f2) {
        return Math.abs(f) < f2;
    }

    public static boolean isZero(double d) {
        return Math.isZero(d, EPSILON);
    }

    public static boolean isZero(double d, double d2) {
        return Math.abs(d) < d2;
    }

    public static <T extends Comparable<? super T>> boolean equals(T[][] TArray, T[][] TArray2) {
        if (TArray.length != TArray2.length || TArray[0].length != TArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", TArray.length, TArray[0].length, TArray2.length, TArray2[0].length));
        }
        for (int i = 0; i < TArray.length; ++i) {
            for (int j = 0; j < TArray[i].length; ++j) {
                if (TArray[i][j].compareTo(TArray2[i][j]) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static int[][] clone(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = (int[])nArray[i].clone();
        }
        return nArrayArray;
    }

    public static float[][] clone(float[][] fArray) {
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            fArrayArray[i] = (float[])fArray[i].clone();
        }
        return fArrayArray;
    }

    public static double[][] clone(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = (double[])dArray[i].clone();
        }
        return dArrayArray;
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    public static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void swap(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", nArray.length, nArray2.length));
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            nArray[i] = nArray2[i];
            nArray2[i] = n;
        }
    }

    public static void swap(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", fArray.length, fArray2.length));
        }
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            fArray[i] = fArray2[i];
            fArray2[i] = f;
        }
    }

    public static void swap(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray.length, dArray2.length));
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            dArray[i] = dArray2[i];
            dArray2[i] = d;
        }
    }

    public static <E> void swap(E[] EArray, E[] EArray2) {
        if (EArray.length != EArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", EArray.length, EArray2.length));
        }
        for (int i = 0; i < EArray.length; ++i) {
            E e = EArray[i];
            EArray[i] = EArray2[i];
            EArray2[i] = e;
        }
    }

    public static void copy(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", nArray.length, nArray2.length));
        }
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
    }

    public static void copy(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", fArray.length, fArray2.length));
        }
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
    }

    public static void copy(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray.length, dArray2.length));
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
    }

    public static void copy(int[][] nArray, int[][] nArray2) {
        if (nArray.length != nArray2.length || nArray[0].length != nArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", nArray.length, nArray[0].length, nArray2.length, nArray2[0].length));
        }
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(nArray[i], 0, nArray2[i], 0, nArray[i].length);
        }
    }

    public static void copy(float[][] fArray, float[][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", fArray.length, fArray[0].length, fArray2.length, fArray2[0].length));
        }
        for (int i = 0; i < fArray.length; ++i) {
            System.arraycopy(fArray[i], 0, fArray2[i], 0, fArray[i].length);
        }
    }

    public static void copy(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            throw new IllegalArgumentException(String.format("Matrices have different rows: %d x %d vs %d x %d", dArray.length, dArray[0].length, dArray2.length, dArray2[0].length));
        }
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[i].length);
        }
    }

    public static void plus(double[] dArray, double[] dArray2) {
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray2.length, dArray.length));
        }
        for (int i = 0; i < dArray2.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] + dArray2[i];
        }
    }

    public static void minus(double[] dArray, double[] dArray2) {
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray2.length, dArray.length));
        }
        for (int i = 0; i < dArray2.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] - dArray2[i];
        }
    }

    public static void scale(double d, double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }

    public static void scale(double d, double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d * dArray[i];
        }
    }

    public static double[] axpy(double d, double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", dArray.length, dArray2.length));
        }
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] + d * dArray[i];
        }
        return dArray2;
    }

    public static double[] pow(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.pow(dArray[i], d);
        }
        return dArray2;
    }

    public static int[] unique(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            hashSet.add(nArray[i]);
        }
        int[] nArray2 = new int[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)iterator.next();
        }
        return nArray2;
    }

    public static String[] unique(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        String[] stringArray2 = new String[hashSet.size()];
        Iterator<String> iterator = hashSet.iterator();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = iterator.next();
        }
        return stringArray2;
    }

    public static int[][] sort(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n];
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[j] = dArray[j][i];
            }
            nArrayArray[i] = QuickSort.sort(dArray2);
        }
        return nArrayArray;
    }

    public static double[] solve(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        if (dArray2[0] == 0.0) {
            throw new IllegalArgumentException("Invalid value of b[0] == 0. The equations should be rewritten as a set of order n - 1.");
        }
        int n2 = dArray.length;
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double d = dArray2[0];
        dArray5[0] = dArray4[0] / d;
        for (n = 1; n < n2; ++n) {
            dArray6[n] = dArray3[n - 1] / d;
            d = dArray2[n] - dArray[n] * dArray6[n];
            if (d == 0.0) {
                throw new IllegalArgumentException("The tridagonal matrix is not of diagonal dominance.");
            }
            dArray5[n] = (dArray4[n] - dArray[n] * dArray5[n - 1]) / d;
        }
        for (n = n2 - 2; n >= 0; --n) {
            int n3 = n;
            dArray5[n3] = dArray5[n3] - dArray6[n + 1] * dArray5[n + 1];
        }
        return dArray5;
    }

    public static double root(Function function, double d, double d2, double d3) {
        return Math.root(function, d, d2, d3, 100);
    }

    public static double root(Function function, double d, double d2, double d3, int n) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + d3);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + n);
        }
        double d4 = d;
        double d5 = d2;
        double d6 = d2;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = function.f(d4);
        double d10 = function.f(d5);
        if (d9 > 0.0 && d10 > 0.0 || d9 < 0.0 && d10 < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed.");
        }
        double d11 = d10;
        for (int i = 1; i <= n; ++i) {
            if (d10 > 0.0 && d11 > 0.0 || d10 < 0.0 && d11 < 0.0) {
                d6 = d4;
                d11 = d9;
                d8 = d7 = d5 - d4;
            }
            if (Math.abs(d11) < Math.abs(d10)) {
                d4 = d5;
                d5 = d6;
                d6 = d4;
                d9 = d10;
                d10 = d11;
                d11 = d9;
            }
            d3 = 2.0 * EPSILON * Math.abs(d5) + 0.5 * d3;
            double d12 = 0.5 * (d6 - d5);
            if (i % 10 == 0) {
                System.out.println(String.format("Brent: the root after " + i + " iterations: " + d5 + ", error = " + d12, new Object[0]));
            }
            if (Math.abs(d12) <= d3 || d10 == 0.0) {
                System.out.println(String.format("Brent: the root after " + i + " iterations: " + d5 + ", error = " + d12, new Object[0]));
                return d5;
            }
            if (Math.abs(d8) >= d3 && Math.abs(d9) > Math.abs(d10)) {
                double d13;
                double d14;
                double d15;
                double d16 = d10 / d9;
                if (d4 == d6) {
                    d15 = 2.0 * d12 * d16;
                    d14 = 1.0 - d16;
                } else {
                    d14 = d9 / d11;
                    double d17 = d10 / d11;
                    d15 = d16 * (2.0 * d12 * d14 * (d14 - d17) - (d5 - d4) * (d17 - 1.0));
                    d14 = (d14 - 1.0) * (d17 - 1.0) * (d16 - 1.0);
                }
                if (d15 > 0.0) {
                    d14 = -d14;
                }
                d15 = Math.abs(d15);
                double d18 = 3.0 * d12 * d14 - Math.abs(d3 * d14);
                double d19 = d18 < (d13 = Math.abs(d8 * d14)) ? d18 : d13;
                if (2.0 * d15 < d19) {
                    d8 = d7;
                    d7 = d15 / d14;
                } else {
                    d8 = d7 = d12;
                }
            } else {
                d8 = d7 = d12;
            }
            d4 = d5;
            d9 = d10;
            d5 = Math.abs(d7) > d3 ? (d5 += d7) : (d5 += Math.copySign(d3, d12));
            d10 = function.f(d5);
        }
        System.err.println("Brent's method exceeded the maximum number of iterations.");
        return d5;
    }

    public static double root(DifferentiableFunction differentiableFunction, double d, double d2, double d3) {
        return Math.root(differentiableFunction, d, d2, d3, 100);
    }

    public static double root(DifferentiableFunction differentiableFunction, double d, double d2, double d3, int n) {
        double d4;
        double d5;
        double d6;
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + d3);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + n);
        }
        double d7 = differentiableFunction.f(d);
        double d8 = differentiableFunction.f(d2);
        if (d7 > 0.0 && d8 > 0.0 || d7 < 0.0 && d8 < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed in rtsafe");
        }
        if (d7 == 0.0) {
            return d;
        }
        if (d8 == 0.0) {
            return d2;
        }
        if (d7 < 0.0) {
            d6 = d;
            d5 = d2;
        } else {
            d5 = d;
            d6 = d2;
        }
        double d9 = 0.5 * (d + d2);
        double d10 = d4 = Math.abs(d2 - d);
        double d11 = differentiableFunction.f(d9);
        double d12 = differentiableFunction.df(d9);
        for (int i = 1; i <= n; ++i) {
            if (((d9 - d5) * d12 - d11) * ((d9 - d6) * d12 - d11) > 0.0 || Math.abs(2.0 * d11) > Math.abs(d4 * d12)) {
                d4 = d10;
                d10 = 0.5 * (d5 - d6);
                d9 = d6 + d10;
                if (d6 == d9) {
                    System.out.println(String.format("Newton-Raphson: the root after " + i + " iterations: " + d9 + ", error = " + d10, new Object[0]));
                    return d9;
                }
            } else {
                d4 = d10;
                double d13 = d9;
                d10 = d11 / d12;
                if (d13 == (d9 -= d10)) {
                    System.out.println(String.format("Newton-Raphson: the root after " + i + " iterations: " + d9 + ", error = " + d10, new Object[0]));
                    return d9;
                }
            }
            if (i % 10 == 0) {
                System.out.println(String.format("Newton-Raphson: the root after " + i + " iterations: " + d9 + ", error = " + d10, new Object[0]));
            }
            if (Math.abs(d10) < d3) {
                System.out.println(String.format("Newton-Raphson: the root after " + i + " iterations: " + d9 + ", error = " + d10, new Object[0]));
                return d9;
            }
            d11 = differentiableFunction.f(d9);
            d12 = differentiableFunction.df(d9);
            if (d11 < 0.0) {
                d6 = d9;
                continue;
            }
            d5 = d9;
        }
        System.err.println("Newton-Raphson method exceeded the maximum number of iterations.");
        return d9;
    }

    static double linesearch(MultivariateFunction multivariateFunction, double[] dArray, double d, double[] dArray2, double[] dArray3, double[] dArray4, double d2) {
        int n;
        double d3;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid upper bound of linear search step: " + d2);
        }
        double d4 = EPSILON;
        int n2 = dArray.length;
        double d5 = Math.norm(dArray3);
        if (d5 > d2) {
            d3 = d2 / d5;
            n = 0;
            while (n < n2) {
                int n3 = n++;
                dArray3[n3] = dArray3[n3] * d3;
            }
        }
        d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d3 += dArray2[n] * dArray3[n];
        }
        if (d3 >= 0.0) {
            throw new IllegalArgumentException("Line Search: the search direction is not a descent direction, which may be caused by roundoff problem.");
        }
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d7 = Math.abs(dArray3[i]) / Math.max(dArray[i], 1.0);
            if (!(d7 > d6)) continue;
            d6 = d7;
        }
        double d8 = d4 / d6;
        double d9 = 1.0;
        double d10 = 0.0;
        double d11 = 0.0;
        while (true) {
            double d12;
            for (int i = 0; i < n2; ++i) {
                dArray4[i] = dArray[i] + d9 * dArray3[i];
            }
            double d13 = multivariateFunction.f(dArray4);
            if (d9 < d8) {
                System.arraycopy(dArray, 0, dArray4, 0, n2);
                return d13;
            }
            if (d13 <= d + 1.0E-4 * d9 * d3) {
                return d13;
            }
            if (d9 == 1.0) {
                d12 = -d3 / (2.0 * (d13 - d - d3));
            } else {
                double d14;
                double d15 = d13 - d - d9 * d3;
                double d16 = d11 - d - d10 * d3;
                double d17 = (d15 / (d9 * d9) - d16 / (d10 * d10)) / (d9 - d10);
                double d18 = (-d10 * d15 / (d9 * d9) + d9 * d16 / (d10 * d10)) / (d9 - d10);
                d12 = d17 == 0.0 ? -d3 / (2.0 * d18) : ((d14 = d18 * d18 - 3.0 * d17 * d3) < 0.0 ? 0.5 * d9 : (d18 <= 0.0 ? (-d18 + Math.sqrt(d14)) / (3.0 * d17) : -d3 / (d18 + Math.sqrt(d14))));
                if (d12 > 0.5 * d9) {
                    d12 = 0.5 * d9;
                }
            }
            d10 = d9;
            d11 = d13;
            d9 = Math.max(d12, 0.1 * d9);
        }
    }

    public static double min(DifferentiableMultivariateFunction differentiableMultivariateFunction, int n, double[] dArray, double d) {
        return Math.min(differentiableMultivariateFunction, n, dArray, d, 200);
    }

    public static double min(DifferentiableMultivariateFunction differentiableMultivariateFunction, int n, double[] dArray, double d, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid m: " + n);
        }
        double d2 = 4.0 * EPSILON;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[][] dArray5 = new double[n][n3];
        double[][] dArray6 = new double[n][n3];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double d3 = 1.0;
        double[] dArray9 = new double[n3];
        double d4 = differentiableMultivariateFunction.f(dArray, dArray9);
        System.out.println(String.format("L-BFGS: initial function value: " + d4, new Object[0]));
        double d5 = 0.0;
        for (int i = 0; i < n3; ++i) {
            dArray4[i] = -dArray9[i];
            d5 += dArray[i] * dArray[i];
        }
        double d6 = 100.0 * Math.max(Math.sqrt(d5), (double)n3);
        int n4 = 0;
        for (int i = 1; i <= n2; ++i) {
            int n5;
            int n6;
            Math.linesearch(differentiableMultivariateFunction, dArray, d4, dArray9, dArray4, dArray2, d6);
            d4 = differentiableMultivariateFunction.f(dArray2, dArray3);
            for (int j = 0; j < n3; ++j) {
                dArray5[n4][j] = dArray2[j] - dArray[j];
                dArray6[n4][j] = dArray3[j] - dArray9[j];
                dArray[j] = dArray2[j];
                dArray9[j] = dArray3[j];
            }
            double d7 = 0.0;
            for (int j = 0; j < n3; ++j) {
                double d8 = Math.abs(dArray5[n4][j]) / Math.max(Math.abs(dArray[j]), 1.0);
                if (!(d8 > d7)) continue;
                d7 = d8;
            }
            if (d7 < d2) {
                System.out.println(String.format("L-BFGS: the function value after " + i + " iterations: " + d4, new Object[0]));
                return d4;
            }
            d7 = 0.0;
            double d9 = Math.max(d4, 1.0);
            for (int j = 0; j < n3; ++j) {
                double d10 = Math.abs(dArray9[j]) * Math.max(Math.abs(dArray[j]), 1.0) / d9;
                if (!(d10 > d7)) continue;
                d7 = d10;
            }
            if (d7 < d) {
                System.out.println(String.format("L-BFGS: the function value after " + i + " iterations: " + d4, new Object[0]));
                return d4;
            }
            if (i % 10 == 0) {
                System.out.println(String.format("L-BFGS: the function value after " + i + " iterations: " + d4, new Object[0]));
            }
            double d11 = Math.dot(dArray6[n4], dArray5[n4]);
            double d12 = Math.dot(dArray6[n4], dArray6[n4]);
            d3 = d11 / d12;
            dArray7[n4] = 1.0 / d11;
            for (n6 = 0; n6 < n3; ++n6) {
                dArray4[n6] = -dArray9[n6];
            }
            n6 = n4;
            int n7 = i > n ? n : i;
            for (n5 = 0; n5 < n7; ++n5) {
                dArray8[n6] = dArray7[n6] * Math.dot(dArray5[n6], dArray4);
                Math.axpy(-dArray8[n6], dArray6[n6], dArray4);
                if (--n6 != -1) continue;
                n6 = n - 1;
            }
            n5 = 0;
            while (n5 < n3) {
                int n8 = n5++;
                dArray4[n8] = dArray4[n8] * d3;
            }
            for (n5 = 0; n5 < n7; ++n5) {
                if (++n6 == n) {
                    n6 = 0;
                }
                double d13 = dArray7[n6] * Math.dot(dArray6[n6], dArray4);
                Math.axpy(dArray8[n6] - d13, dArray5[n6], dArray4);
            }
            if (++n4 != n) continue;
            n4 = 0;
        }
        throw new IllegalStateException("L-BFGS: Too many iterations.");
    }

    public static double min(DifferentiableMultivariateFunction differentiableMultivariateFunction, double[] dArray, double d) {
        return Math.min(differentiableMultivariateFunction, dArray, d, 200);
    }

    public static double min(DifferentiableMultivariateFunction differentiableMultivariateFunction, double[] dArray, double d, int n) {
        double d2 = 4.0 * EPSILON;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[][] dArray7 = new double[n2][n2];
        double d3 = differentiableMultivariateFunction.f(dArray, dArray3);
        System.out.println(String.format("BFGS: initial function value: " + d3, new Object[0]));
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            dArray7[i][i] = 1.0;
            dArray6[i] = -dArray3[i];
            d4 += dArray[i] * dArray[i];
        }
        double d5 = 100.0 * Math.max(Math.sqrt(d4), (double)n2);
        for (int i = 1; i <= n; ++i) {
            int n3;
            double d6;
            int n4;
            d3 = Math.linesearch(differentiableMultivariateFunction, dArray, d3, dArray3, dArray6, dArray5, d5);
            if (i % 10 == 0) {
                System.out.println(String.format("BFGS: the function value after " + i + " iterations: " + d3, new Object[0]));
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray6[n4] = dArray5[n4] - dArray[n4];
                dArray[n4] = dArray5[n4];
            }
            double d7 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                d6 = Math.abs(dArray6[n4]) / Math.max(Math.abs(dArray[n4]), 1.0);
                if (!(d6 > d7)) continue;
                d7 = d6;
            }
            if (d7 < d2) {
                System.out.println(String.format("BFGS: the function value after %3d iterations: %.5g", i, d3));
                return d3;
            }
            System.arraycopy(dArray3, 0, dArray2, 0, n2);
            differentiableMultivariateFunction.f(dArray, dArray3);
            double d8 = Math.max(d3, 1.0);
            d7 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                d6 = Math.abs(dArray3[n4]) * Math.max(Math.abs(dArray[n4]), 1.0) / d8;
                if (!(d6 > d7)) continue;
                d7 = d6;
            }
            if (d7 < d) {
                System.out.println(String.format("BFGS: the function value after %3d iterations: %.5g", i, d3));
                return d3;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray2[n4] = dArray3[n4] - dArray2[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray4[n4] = 0.0;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n5 = n4;
                    dArray4[n5] = dArray4[n5] + dArray7[n4][n3] * dArray2[n3];
                }
            }
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                d12 += dArray2[n4] * dArray6[n4];
                d11 += dArray2[n4] * dArray4[n4];
                d10 += dArray2[n4] * dArray2[n4];
                d9 += dArray6[n4] * dArray6[n4];
            }
            if (d12 > Math.sqrt(EPSILON * d10 * d9)) {
                d12 = 1.0 / d12;
                double d13 = 1.0 / d11;
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray2[n4] = d12 * dArray6[n4] - d13 * dArray4[n4];
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    for (n3 = n4; n3 < n2; ++n3) {
                        double[] dArray8 = dArray7[n4];
                        int n6 = n3;
                        dArray8[n6] = dArray8[n6] + (d12 * dArray6[n4] * dArray6[n3] - d13 * dArray4[n4] * dArray4[n3] + d11 * dArray2[n4] * dArray2[n3]);
                        dArray7[n3][n4] = dArray7[n4][n3];
                    }
                }
            }
            Arrays.fill(dArray6, 0.0);
            for (n4 = 0; n4 < n2; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    int n7 = n4;
                    dArray6[n7] = dArray6[n7] - dArray7[n4][n3] * dArray3[n3];
                }
            }
        }
        throw new IllegalStateException("BFGS: Too many iterations.");
    }

    static {
        double d;
        EPSILON = Math.pow(2.0, -52.0);
        RADIX = 2;
        DIGITS = 53;
        ROUND_STYLE = 2;
        MACHEP = -52;
        NEGEP = -53;
        firstRNG = true;
        random = new ThreadLocal<Random>(){

            @Override
            protected synchronized Random initialValue() {
                if (firstRNG) {
                    firstRNG = false;
                    return new Random();
                }
                SecureRandom secureRandom = new SecureRandom();
                byte[] byArray = secureRandom.generateSeed(8);
                long l = 0L;
                for (int i = 0; i < 8; ++i) {
                    l <<= 8;
                    l |= (long)(byArray[i] & 0xFF);
                }
                return new Random(l);
            }
        };
        double d2 = 1.0;
        double d3 = d2 + d2;
        double d4 = d2 - d2;
        double d5 = d2;
        double d6 = d2;
        while (d6 - d2 == d4) {
            d5 += d5;
            d = d5 + d2;
            d6 = d - d5;
        }
        double d7 = d2;
        int n = 0;
        while (n == 0) {
            d7 += d7;
            d = d5 + d7;
            n = (int)(d - d5);
        }
        RADIX = n;
        double d8 = RADIX;
        DIGITS = 0;
        d7 = d2;
        d6 = d2;
        while (d6 - d2 == d4) {
            ++DIGITS;
            d = (d7 *= d8) + d2;
            d6 = d - d7;
        }
        ROUND_STYLE = 0;
        double d9 = d8 / d3;
        d = d5 + d9;
        if (d - d5 != d4) {
            ROUND_STYLE = 1;
        }
        double d10 = d5 + d8;
        d = d10 + d9;
        if (ROUND_STYLE == 0 && d - d10 != d4) {
            ROUND_STYLE = 2;
        }
        NEGEP = DIGITS + 3;
        double d11 = d2 / d8;
        d5 = d2;
        for (int i = 0; i < NEGEP; ++i) {
            d5 *= d11;
        }
        d7 = d5;
        d = d2 - d5;
        while (d - d2 == d4) {
            --NEGEP;
            d = d2 - (d5 *= d8);
        }
        NEGEP = -NEGEP;
        MACHEP = -DIGITS - 3;
        d5 = d7;
        d = d2 + d5;
        while (d - d2 == d4) {
            ++MACHEP;
            d = d2 + (d5 *= d8);
        }
        EPSILON = d5;
        LOG2 = java.lang.Math.log(2.0);
    }

    private static class PdistTask
    implements Callable<Void> {
        double[][] x;
        double[][] dist;
        int nprocs;
        int pid;
        boolean half;
        boolean squared;

        PdistTask(double[][] dArray, double[][] dArray2, int n, int n2, boolean bl, boolean bl2) {
            this.x = dArray;
            this.dist = dArray2;
            this.nprocs = n;
            this.pid = n2;
            this.squared = bl;
            this.half = bl2;
        }

        @Override
        public Void call() {
            int n = this.x.length;
            for (int i = this.pid; i < n; i += this.nprocs) {
                for (int j = 0; j < i; ++j) {
                    double d;
                    this.dist[i][j] = d = this.squared ? Math.squaredDistance(this.x[i], this.x[j]) : Math.distance(this.x[i], this.x[j]);
                    if (this.half) continue;
                    this.dist[j][i] = d;
                }
            }
            return null;
        }
    }
}

