/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import smile.data.Attribute;

public class DateAttribute
extends Attribute {
    private DateFormat format;

    public DateAttribute(String string) {
        this(string, 1.0);
    }

    public DateAttribute(String string, double d) {
        this(string, null, d);
    }

    public DateAttribute(String string, String string2, double d) {
        super(Attribute.Type.DATE, string, string2, d);
        this.format = new SimpleDateFormat();
    }

    public DateAttribute(String string, String string2, String string3) {
        super(Attribute.Type.DATE, string, string2);
        this.format = new SimpleDateFormat(string3);
    }

    public DateAttribute(String string, String string2, double d, String string3) {
        super(Attribute.Type.DATE, string, string2, d);
        this.format = new SimpleDateFormat(string3);
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = new SimpleDateFormat(string);
    }

    public void setFormat(DateFormat dateFormat) {
        this.format = dateFormat;
    }

    public String toString(Date date) {
        return this.format.format(date);
    }

    public Date toDate(double d) {
        if (Double.isNaN(d)) {
            return null;
        }
        return new Date(Double.doubleToRawLongBits(d));
    }

    public double valueOf(Date date) {
        return Double.longBitsToDouble(date.getTime());
    }

    @Override
    public String toString(double d) {
        if (Double.isNaN(d)) {
            return null;
        }
        return this.format.format(Double.doubleToRawLongBits(d));
    }

    @Override
    public double valueOf(String string) throws ParseException {
        Date date = this.format.parse(string);
        return Double.longBitsToDouble(date.getTime());
    }
}

