/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import smile.data.Attribute;
import smile.data.NumericAttribute;
import smile.math.Math;

public class AttributeVector {
    private Attribute attribute;
    private double[] vector;
    private String[] names;

    public AttributeVector(Attribute attribute, double[] dArray) {
        this.attribute = attribute;
        this.vector = dArray;
    }

    public AttributeVector(Attribute attribute, double[] dArray, String[] stringArray) {
        this.attribute = attribute;
        this.vector = dArray;
        this.names = stringArray;
    }

    public Attribute attribute() {
        return this.attribute;
    }

    public double[] vector() {
        return this.vector;
    }

    public String[] names() {
        return this.names;
    }

    public int size() {
        return this.vector.length;
    }

    public String toString() {
        int n = 10;
        String string = this.head(n);
        if (this.vector.length <= n) {
            return string;
        }
        return string + "\n" + (this.vector.length - n) + " more values...";
    }

    public String head(int n) {
        return this.toString(0, n);
    }

    public String tail(int n) {
        return this.toString(this.vector.length - n, this.vector.length);
    }

    public String toString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\t');
        stringBuilder.append(this.attribute.getName());
        int n3 = Math.min(this.vector.length, n2);
        for (int i = n; i < n3; ++i) {
            stringBuilder.append(System.getProperty("line.separator"));
            if (this.names != null) {
                stringBuilder.append(this.names[i]);
            } else {
                stringBuilder.append('[');
                stringBuilder.append(i + 1);
                stringBuilder.append(']');
            }
            stringBuilder.append('\t');
            if (this.attribute.getType() == Attribute.Type.NUMERIC) {
                stringBuilder.append(String.format("%1.4f", this.vector[i]));
                continue;
            }
            stringBuilder.append(this.attribute.toString(this.vector[i]));
        }
        return stringBuilder.toString();
    }

    public AttributeVector summary() {
        NumericAttribute numericAttribute = new NumericAttribute(this.attribute.getName() + " Summary");
        String[] stringArray = new String[]{"min", "q1", "median", "mean", "q3", "max"};
        double[] dArray = new double[]{Math.min(this.vector), Math.q1(this.vector), Math.median(this.vector), Math.mean(this.vector), Math.q3(this.vector), Math.max(this.vector)};
        return new AttributeVector(numericAttribute, dArray, stringArray);
    }
}

