/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.Serializable;
import java.text.ParseException;

public abstract class Attribute
implements Serializable {
    private Type type;
    private double weight;
    private String name;
    private String description;

    public Attribute(Type type, String string) {
        this(type, string, 1.0);
    }

    public Attribute(Type type, String string, double d) {
        this(type, string, null, d);
    }

    public Attribute(Type type, String string, String string2) {
        this(type, string, string2, 1.0);
    }

    public Attribute(Type type, String string, String string2, double d) {
        this.type = type;
        this.name = string;
        this.description = string2;
        this.weight = d;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String string) {
        this.name = string;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute setDescription(String string) {
        this.description = string;
        return this;
    }

    public double getWeight() {
        return this.weight;
    }

    public Attribute setWeight(double d) {
        this.weight = d;
        return this;
    }

    public abstract String toString(double var1);

    public abstract double valueOf(String var1) throws ParseException;

    public boolean equals(Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            if (this.name.equals(attribute.name) && this.type == attribute.type) {
                if (this.description != null && attribute.description != null) {
                    return this.description.equals(attribute.description);
                }
                return this.description == attribute.description;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 37 * n + (this.description != null ? this.description.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.type);
        stringBuilder.append('[');
        stringBuilder.append(this.name);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static enum Type {
        NUMERIC,
        NOMINAL,
        STRING,
        DATE;

    }
}

