/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.Arrays;
import smile.clustering.Clustering;
import smile.clustering.ClusteringDistance;
import smile.math.Math;
import smile.math.distance.Distance;

public abstract class PartitionClustering<T>
implements Clustering<T> {
    protected int k;
    protected int[] y;
    protected int[] size;

    public int getNumClusters() {
        return this.k;
    }

    public int[] getClusterLabel() {
        return this.y;
    }

    public int[] getClusterSize() {
        return this.size;
    }

    static double squaredDistance(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i])) continue;
            ++n2;
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        d = n2 == 0 ? Double.MAX_VALUE : (double)n * d / (double)n2;
        return d;
    }

    public static int[] seed(double[][] dArray, int n, ClusteringDistance clusteringDistance) {
        double d;
        int n2;
        int n3 = dArray.length;
        int[] nArray = new int[n3];
        double[] dArray2 = dArray[Math.randomInt(n3)];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n2] = Double.MAX_VALUE;
        }
        for (n2 = 1; n2 < n; ++n2) {
            int n4;
            for (int i = 0; i < n3; ++i) {
                double d2 = 0.0;
                switch (clusteringDistance) {
                    case EUCLIDEAN: {
                        d2 = Math.squaredDistance(dArray[i], dArray2);
                        break;
                    }
                    case EUCLIDEAN_MISSING_VALUES: {
                        d2 = PartitionClustering.squaredDistance(dArray[i], dArray2);
                        break;
                    }
                    case JENSEN_SHANNON_DIVERGENCE: {
                        d2 = Math.JensenShannonDivergence(dArray[i], dArray2);
                    }
                }
                if (!(d2 < dArray3[i])) continue;
                dArray3[i] = d2;
                nArray[i] = n2 - 1;
            }
            d = Math.random() * Math.sum(dArray3);
            double d3 = 0.0;
            for (n4 = 0; n4 < n3 && !((d3 += dArray3[n4]) >= d); ++n4) {
            }
            dArray2 = dArray[n4];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            d = 0.0;
            switch (clusteringDistance) {
                case EUCLIDEAN: {
                    d = Math.squaredDistance(dArray[n2], dArray2);
                    break;
                }
                case EUCLIDEAN_MISSING_VALUES: {
                    d = PartitionClustering.squaredDistance(dArray[n2], dArray2);
                    break;
                }
                case JENSEN_SHANNON_DIVERGENCE: {
                    d = Math.JensenShannonDivergence(dArray[n2], dArray2);
                }
            }
            if (!(d < dArray3[n2])) continue;
            dArray3[n2] = d;
            nArray[n2] = n - 1;
        }
        return nArray;
    }

    public static <T> double seed(Distance<T> distance, T[] TArray, T[] TArray2, int[] nArray, double[] dArray) {
        double d;
        int n;
        int n2 = TArray.length;
        int n3 = TArray2.length;
        T t = TArray[Math.randomInt(n2)];
        TArray2[0] = t;
        Arrays.fill(dArray, Double.MAX_VALUE);
        for (n = 1; n < n3; ++n) {
            int n4;
            for (int i = 0; i < n2; ++i) {
                double d2 = distance.d(TArray[i], t);
                if (!(d2 < dArray[i])) continue;
                dArray[i] = d2;
                nArray[i] = n - 1;
            }
            d = Math.random() * Math.sum(dArray);
            double d3 = 0.0;
            for (n4 = 0; n4 < n2 && !((d3 += dArray[n4]) >= d); ++n4) {
            }
            t = TArray[n4];
            TArray2[n] = t;
        }
        for (n = 0; n < n2; ++n) {
            d = distance.d(TArray[n], t);
            if (!(d < dArray[n])) continue;
            dArray[n] = d;
            nArray[n] = n3 - 1;
        }
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d4 += dArray[i];
        }
        return d4;
    }
}

