/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import smile.clustering.PartitionClustering;
import smile.math.Math;
import smile.math.distance.Distance;
import smile.util.MulticoreExecutor;

public class CLARANS<T>
extends PartitionClustering<T> {
    private static final long serialVersionUID = 1L;
    double distortion;
    private Distance<T> distance;
    private int numLocal;
    private int maxNeighbor;
    T[] medoids;

    public CLARANS(T[] TArray, Distance<T> distance, int n) {
        this(TArray, distance, n, (int)Math.round(0.0125 * (double)n * (double)(TArray.length - n)));
    }

    public CLARANS(T[] TArray, Distance<T> distance, int n, int n2) {
        this(TArray, distance, n, n2, Math.max(2, MulticoreExecutor.getThreadPoolSize()));
    }

    public CLARANS(T[] TArray, Distance<T> distance, int n, int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid maxNeighbor: " + n2);
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("Invalid numLocal: " + n3);
        }
        int n4 = TArray.length;
        if (n >= n4) {
            throw new IllegalArgumentException("Too large k: " + n);
        }
        if (n2 > n4) {
            throw new IllegalArgumentException("Too large maxNeighbor: " + n2);
        }
        int n5 = 100;
        if (n * (n4 - n) < n5) {
            n5 = n * (n4 - n);
        }
        if (n2 < n5) {
            n2 = n5;
        }
        this.k = n;
        this.distance = distance;
        this.numLocal = n3;
        this.maxNeighbor = n2;
        ArrayList<CLARANSTask> arrayList = new ArrayList<CLARANSTask>();
        for (int i = 0; i < n3; ++i) {
            arrayList.add(new CLARANSTask(TArray));
        }
        try {
            MulticoreExecutor.run(arrayList);
        }
        catch (Exception exception) {
            System.out.println("Failed to run CLARANS on multi-core:" + exception);
            for (CLARANSTask cLARANSTask : arrayList) {
                cLARANSTask.call();
            }
        }
        this.distortion = Double.POSITIVE_INFINITY;
        for (CLARANSTask cLARANSTask : arrayList) {
            if (!(cLARANSTask.distortion < this.distortion)) continue;
            this.distortion = cLARANSTask.distortion;
            this.medoids = cLARANSTask.medoids;
            this.y = cLARANSTask.y;
        }
        this.size = new int[n];
        for (int i = 0; i < n4; ++i) {
            int n6 = this.y[i];
            this.size[n6] = this.size[n6] + 1;
        }
    }

    private double getRandomNeighbor(T[] TArray, T[] TArray2, int[] nArray, double[] dArray) {
        int n;
        boolean bl;
        int n2 = TArray.length;
        int n3 = Math.randomInt(this.k);
        Object t = null;
        block0: do {
            bl = false;
            t = TArray[Math.randomInt(n2)];
            for (n = 0; n < this.k; ++n) {
                if (t != TArray2[n]) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        TArray2[n3] = t;
        for (n = 0; n < n2; ++n) {
            double d = this.distance.d(TArray[n], t);
            if (dArray[n] > d) {
                nArray[n] = n3;
                dArray[n] = d;
                continue;
            }
            if (nArray[n] != n3) continue;
            dArray[n] = d;
            nArray[n] = n3;
            for (int i = 0; i < this.k; ++i) {
                if (i == n3 || !(dArray[n] > (d = this.distance.d(TArray[n], TArray2[i])))) continue;
                nArray[n] = i;
                dArray[n] = d;
            }
        }
        return Math.sum(dArray);
    }

    public int getNumLocalMinima() {
        return this.numLocal;
    }

    public int getMaxNeighbor() {
        return this.maxNeighbor;
    }

    public double distortion() {
        return this.distortion;
    }

    public T[] medoids() {
        return this.medoids;
    }

    @Override
    public int predict(T t) {
        double d = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.k; ++i) {
            double d2 = this.distance.d(t, this.medoids[i]);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("CLARANS distortion: %.5f%n", this.distortion));
        stringBuilder.append(String.format("Clusters of %d data points:%n", this.y.length));
        for (int i = 0; i < this.k; ++i) {
            int n = (int)Math.round(1000.0 * (double)this.size[i] / (double)this.y.length);
            stringBuilder.append(String.format("%3d\t%5d (%2d.%1d%%)%n", i, this.size[i], n / 10, n % 10));
        }
        return stringBuilder.toString();
    }

    class CLARANSTask
    implements Callable<CLARANSTask> {
        final T[] data;
        double distortion;
        T[] medoids;
        int[] y;

        CLARANSTask(T[] TArray) {
            this.data = TArray;
        }

        @Override
        public CLARANSTask call() {
            int n = this.data.length;
            this.medoids = (Object[])Array.newInstance(this.data.getClass().getComponentType(), CLARANS.this.k);
            Object[] objectArray = (Object[])this.medoids.clone();
            this.y = new int[n];
            int[] nArray = new int[n];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            this.distortion = PartitionClustering.seed(CLARANS.this.distance, this.data, this.medoids, this.y, dArray);
            System.arraycopy(this.medoids, 0, objectArray, 0, CLARANS.this.k);
            System.arraycopy(this.y, 0, nArray, 0, n);
            System.arraycopy(dArray, 0, dArray2, 0, n);
            for (int i = 1; i <= CLARANS.this.maxNeighbor; ++i) {
                double d = CLARANS.this.getRandomNeighbor(this.data, objectArray, nArray, dArray2);
                if (d < this.distortion) {
                    i = 0;
                    this.distortion = d;
                    System.arraycopy(objectArray, 0, this.medoids, 0, CLARANS.this.k);
                    System.arraycopy(nArray, 0, this.y, 0, n);
                    System.arraycopy(dArray2, 0, dArray, 0, n);
                    continue;
                }
                System.arraycopy(this.medoids, 0, objectArray, 0, CLARANS.this.k);
                System.arraycopy(this.y, 0, nArray, 0, n);
                System.arraycopy(dArray, 0, dArray2, 0, n);
            }
            return this;
        }
    }
}

