/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.Arrays;
import smile.math.Math;

public class BBDTree {
    private Node root;
    private int[] index;

    public BBDTree(double[][] dArray) {
        int n = dArray.length;
        this.index = new int[n];
        for (int i = 0; i < n; ++i) {
            this.index[i] = i;
        }
        this.root = this.buildNode(dArray, 0, n);
    }

    private Node buildNode(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = dArray[0].length;
        Node node = new Node(n7);
        node.count = n2 - n;
        node.index = n;
        double[] dArray2 = new double[n7];
        double[] dArray3 = new double[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            dArray2[n6] = dArray[this.index[n]][n6];
            dArray3[n6] = dArray[this.index[n]][n6];
        }
        for (n6 = n + 1; n6 < n2; ++n6) {
            for (int i = 0; i < n7; ++i) {
                double d = dArray[this.index[n6]][i];
                if (dArray2[i] > d) {
                    dArray2[i] = d;
                }
                if (!(dArray3[i] < d)) continue;
                dArray3[i] = d;
            }
        }
        double d = -1.0;
        int n8 = -1;
        for (n5 = 0; n5 < n7; ++n5) {
            node.center[n5] = (dArray2[n5] + dArray3[n5]) / 2.0;
            node.radius[n5] = (dArray3[n5] - dArray2[n5]) / 2.0;
            if (!(node.radius[n5] > d)) continue;
            d = node.radius[n5];
            n8 = n5;
        }
        if (d < 1.0E-10) {
            node.upper = null;
            node.lower = null;
            System.arraycopy(dArray[this.index[n]], 0, node.sum, 0, n7);
            if (n2 > n + 1) {
                n5 = n2 - n;
                int n9 = 0;
                while (n9 < n7) {
                    int n10 = n9++;
                    node.sum[n10] = node.sum[n10] * (double)n5;
                }
            }
            node.cost = 0.0;
            return node;
        }
        double d2 = node.center[n8];
        int n11 = n;
        int n12 = n2 - 1;
        int n13 = 0;
        while (n11 <= n12) {
            n4 = dArray[this.index[n11]][n8] < d2 ? 1 : 0;
            int n14 = n3 = dArray[this.index[n12]][n8] >= d2 ? 1 : 0;
            if (n4 == 0 && n3 == 0) {
                int n15 = this.index[n11];
                this.index[n11] = this.index[n12];
                this.index[n12] = n15;
                n3 = 1;
                n4 = 1;
            }
            if (n4 != 0) {
                ++n11;
                ++n13;
            }
            if (n3 == 0) continue;
            --n12;
        }
        node.lower = this.buildNode(dArray, n, n + n13);
        node.upper = this.buildNode(dArray, n + n13, n2);
        for (n4 = 0; n4 < n7; ++n4) {
            node.sum[n4] = node.lower.sum[n4] + node.upper.sum[n4];
        }
        double[] dArray4 = new double[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            dArray4[n3] = node.sum[n3] / (double)node.count;
        }
        node.cost = this.getNodeCost(node.lower, dArray4) + this.getNodeCost(node.upper, dArray4);
        return node;
    }

    private double getNodeCost(Node node, double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = node.sum[i] / (double)node.count - dArray[i];
            d += d2 * d2;
        }
        return node.cost + (double)node.count * d;
    }

    public double clustering(double[][] dArray, double[][] dArray2, int[] nArray, int[] nArray2) {
        int n = dArray.length;
        Arrays.fill(nArray, 0);
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = i;
            Arrays.fill(dArray2[i], 0.0);
        }
        return this.filter(this.root, dArray, nArray3, n, dArray2, nArray, nArray2);
    }

    private double filter(Node node, double[][] dArray, int[] nArray, int n, double[][] dArray2, int[] nArray2, int[] nArray3) {
        int n2;
        int n3 = dArray[0].length;
        double d = Math.squaredDistance(node.center, dArray[nArray[0]]);
        int n4 = nArray[0];
        for (n2 = 1; n2 < n; ++n2) {
            double d2 = Math.squaredDistance(node.center, dArray[nArray[n2]]);
            if (!(d2 < d)) continue;
            d = d2;
            n4 = nArray[n2];
        }
        if (node.lower != null) {
            int[] nArray4 = new int[n];
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                if (this.prune(node.center, node.radius, dArray, n4, nArray[i])) continue;
                nArray4[n5++] = nArray[i];
            }
            if (n5 > 1) {
                double d3 = this.filter(node.lower, dArray, nArray4, n5, dArray2, nArray2, nArray3) + this.filter(node.upper, dArray, nArray4, n5, dArray2, nArray2, nArray3);
                return d3;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double[] dArray3 = dArray2[n4];
            int n6 = n2;
            dArray3[n6] = dArray3[n6] + node.sum[n2];
        }
        int n7 = n4;
        nArray2[n7] = nArray2[n7] + node.count;
        if (nArray3 != null) {
            n2 = node.index + node.count;
            for (int i = node.index; i < n2; ++i) {
                nArray3[this.index[i]] = n4;
            }
        }
        return this.getNodeCost(node, dArray[n4]);
    }

    private boolean prune(double[] dArray, double[] dArray2, double[][] dArray3, int n, int n2) {
        if (n == n2) {
            return false;
        }
        int n3 = dArray3[0].length;
        double[] dArray4 = dArray3[n];
        double[] dArray5 = dArray3[n2];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            double d3 = dArray5[i] - dArray4[i];
            d += d3 * d3;
            if (d3 > 0.0) {
                d2 += (dArray[i] + dArray2[i] - dArray4[i]) * d3;
                continue;
            }
            d2 += (dArray[i] - dArray2[i] - dArray4[i]) * d3;
        }
        return d >= 2.0 * d2;
    }

    class Node {
        int count;
        int index;
        double[] center;
        double[] radius;
        double[] sum;
        double cost;
        Node lower;
        Node upper;

        Node(int n) {
            this.center = new double[n];
            this.radius = new double[n];
            this.sum = new double[n];
        }
    }
}

