/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionDetail;
import com.actelion.research.chem.conf.TorsionPrediction;
import java.util.ArrayList;
import org.openmolecules.chem.conf.so.ConformationRule;
import org.openmolecules.chem.conf.so.SelfOrganizedConformer;

public class TorsionRule
extends ConformationRule {
    static final double COLLIDING_ATOM_STRAIN = 0.1;
    private int mSmallerSubstituentIndex;
    private int[] mAtomToRotate;
    private short[] mTorsion;
    private short[] mFrequency;
    private short[][] mRange;

    public TorsionRule(short[] sArray, short[] sArray2, short[][] sArray3, int[] nArray, int[] nArray2, int n) {
        super(nArray);
        this.mTorsion = sArray;
        this.mFrequency = sArray2;
        this.mRange = sArray3;
        this.mAtomToRotate = nArray2;
        this.mSmallerSubstituentIndex = n;
    }

    @Override
    public int getRuleType() {
        return 3;
    }

    public static void calculateRules(ArrayList<ConformationRule> arrayList, StereoMolecule stereoMolecule) {
        int n;
        TorsionDB.initialize(1);
        boolean[] blArray = new boolean[stereoMolecule.getAllBonds()];
        TorsionDB.findRotatableBonds(stereoMolecule, false, blArray);
        for (n = 0; n < stereoMolecule.getBonds(); ++n) {
            Object object;
            TorsionDetail torsionDetail;
            int[] nArray;
            String string;
            if (!blArray[n] || (string = TorsionDB.getTorsionID(stereoMolecule, n, nArray = new int[4], torsionDetail = new TorsionDetail())) == null || TorsionRule.conflictWithPlaneRules(nArray, arrayList)) continue;
            short[] sArray = TorsionDB.getTorsions(string);
            short[] sArray2 = TorsionDB.getTorsionFrequencies(string);
            short[][] sArray3 = TorsionDB.getTorsionRanges(string);
            if (sArray == null) {
                object = new TorsionPrediction(stereoMolecule, nArray);
                sArray = ((TorsionPrediction)object).getTorsions();
                sArray2 = ((TorsionPrediction)object).getTorsionFrequencies();
                sArray3 = ((TorsionPrediction)object).getTorsionRanges();
            }
            if (sArray == null) continue;
            object = null;
            int n2 = 0;
            if (!stereoMolecule.isRingBond(n)) {
                int n3;
                boolean[][] blArray2 = new boolean[2][stereoMolecule.getAllAtoms()];
                int[] nArray2 = new int[2];
                for (n3 = 0; n3 < 2; ++n3) {
                    nArray2[n3] = stereoMolecule.getSubstituent(torsionDetail.getRearAtom(n3), torsionDetail.getCentralAtom(n3), blArray2[n3], null, null);
                }
                n2 = nArray2[0] < nArray2[1] ? 0 : 1;
                object = new int[nArray2[n2]];
                n3 = 0;
                for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                    if (!blArray2[n2][i]) continue;
                    object[n3++] = i;
                }
            }
            arrayList.add(new TorsionRule(sArray, sArray2, sArray3, nArray, (int[])object, n2));
        }
        block3: for (n = 0; n < stereoMolecule.getBonds(); ++n) {
            if (stereoMolecule.getBondType(n) != 1 || stereoMolecule.isRingBond(n)) continue;
            for (int i = 0; i < 2; ++i) {
                int n4 = stereoMolecule.getBondAtom(i, n);
                int n5 = stereoMolecule.getNonHydrogenNeighbourCount(n4);
                int n6 = stereoMolecule.getAllConnAtoms(n4) - n5;
                if (n5 != 1 || n6 == 0) continue;
                int n7 = stereoMolecule.getBondAtom(1 - i, n);
                int n8 = stereoMolecule.getAtomicNo(n4);
                if (n8 > 6 && stereoMolecule.getAtomPi(n7) == 1) {
                    TorsionRule.addHeteroPiRule(stereoMolecule, n4, n7, n6, arrayList);
                    continue block3;
                }
                if (stereoMolecule.getAtomPi(n7) == 2 || stereoMolecule.getAllConnAtoms(n7) <= 1) continue block3;
                TorsionRule.addDegree60Rule(stereoMolecule, n4, n7, n6, arrayList);
                continue block3;
            }
        }
    }

    private static void addHeteroPiRule(StereoMolecule stereoMolecule, int n, int n2, int n3, ArrayList<ConformationRule> arrayList) {
        int n4;
        int n5 = -1;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n2); ++i) {
            if (stereoMolecule.getConnBondOrder(n2, i) != 2) continue;
            n5 = stereoMolecule.getConnAtom(n2, i);
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[4];
        nArray2[0] = n5;
        nArray2[1] = n2;
        nArray2[2] = n;
        int n6 = 0;
        for (n4 = 0; n4 < stereoMolecule.getAllConnAtoms(n); ++n4) {
            int n7 = stereoMolecule.getConnAtom(n, n4);
            if (stereoMolecule.getAtomicNo(n7) != 1) continue;
            if (n6 == 0) {
                nArray2[3] = n7;
            }
            nArray[n6++] = n7;
        }
        n4 = !stereoMolecule.isAromaticAtom(n2) && n3 == 1 ? 1 : 2;
        short[] sArray = new short[n4];
        short[] sArray2 = new short[n4];
        short[][] sArray3 = new short[n4][2];
        if (!stereoMolecule.isAromaticAtom(n2) && n3 == 1) {
            sArray[0] = 0;
            sArray2[0] = 100;
            sArray3[0][0] = -15;
            sArray3[0][1] = 15;
        } else {
            sArray[0] = 0;
            sArray[1] = 180;
            sArray2[0] = 50;
            sArray2[1] = 50;
            sArray3[0][0] = -15;
            sArray3[0][1] = 15;
            sArray3[1][0] = 165;
            sArray3[1][1] = 195;
        }
        arrayList.add(new TorsionRule(sArray, sArray2, sArray3, nArray2, nArray, 1));
    }

    private static void addDegree60Rule(StereoMolecule stereoMolecule, int n, int n2, int n3, ArrayList<ConformationRule> arrayList) {
        int[] nArray = new int[n3];
        int[] nArray2 = new int[]{stereoMolecule.getConnAtom(n2, stereoMolecule.getConnAtom(n2, 0) == n ? 1 : 0), n2, n, stereoMolecule.getConnAtom(n, stereoMolecule.getConnAtom(n, 0) == n2 ? 1 : 0)};
        int n4 = 0;
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n5 = stereoMolecule.getConnAtom(n, i);
            if (n5 == n2) continue;
            nArray[n4++] = n5;
        }
        short[] sArray = new short[3];
        short[] sArray2 = new short[3];
        short[][] sArray3 = new short[3][2];
        sArray[0] = 60;
        sArray[1] = 180;
        sArray[2] = 300;
        sArray2[0] = 33;
        sArray2[1] = 33;
        sArray2[2] = 33;
        sArray3[0][0] = 45;
        sArray3[0][1] = 75;
        sArray3[1][0] = 165;
        sArray3[1][1] = 195;
        sArray3[2][0] = 285;
        sArray3[2][1] = 315;
        arrayList.add(new TorsionRule(sArray, sArray2, sArray3, nArray2, nArray, 1));
    }

    private static boolean conflictWithPlaneRules(int[] nArray, ArrayList<ConformationRule> arrayList) {
        for (ConformationRule conformationRule : arrayList) {
            if (conformationRule.getRuleType() != 1) continue;
            int[] nArray2 = conformationRule.getAtomList();
            for (int n : nArray) {
                if (n == -1) {
                    return false;
                }
                boolean bl = false;
                for (int n2 : nArray2) {
                    if (n != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(Conformer conformer, double d) {
        int n;
        double d2;
        double d3 = TorsionDB.calculateTorsionExtended(conformer, this.mAtom);
        if (Double.isNaN(d3)) {
            return false;
        }
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d2 = this.getSeverity(d3, n = this.findApplicableTorsionIndex(d3))) == 0.0) {
            return false;
        }
        double d4 = Math.PI * (double)this.mTorsion[n] / 180.0 - d3;
        if (Math.abs(d4) > Math.PI) {
            double d5 = d4 = d4 < 0.0 ? Math.PI * 2 + d4 : d4 - Math.PI * 2;
        }
        if (Math.abs(d4) < 0.0031415926535897933) {
            return false;
        }
        Coordinates coordinates = conformer.getCoordinates(this.mAtom[2]).subC(conformer.getCoordinates(this.mAtom[1]));
        coordinates.unit();
        d4 *= d * d2;
        StereoMolecule stereoMolecule = conformer.getMolecule();
        if (this.mAtomToRotate != null) {
            double d6 = this.mSmallerSubstituentIndex == 0 ? -d4 : d4;
            for (int n2 : this.mAtomToRotate) {
                this.rotateAtom(conformer, n2, this.mAtom[1], coordinates, d6);
            }
        } else {
            int n3 = stereoMolecule.getBond(this.mAtom[1], this.mAtom[2]);
            boolean bl = n3 != -1 && stereoMolecule.getBondRingSize(n3) <= 5;
            for (int i = 1; i <= 2; ++i) {
                double d7 = (i == 1 ? -2.0 : 2.0) * (double)stereoMolecule.getAtomRingBondCount(this.mAtom[i]);
                for (int j = 0; j < stereoMolecule.getAllConnAtoms(this.mAtom[i]); ++j) {
                    int n4 = stereoMolecule.getConnAtom(this.mAtom[i], j);
                    if (n4 == this.mAtom[3 - i]) continue;
                    this.rotateGroup(conformer, n4, this.mAtom[i], coordinates, d4 / d7);
                    if (bl) continue;
                    for (int k = 0; k < stereoMolecule.getConnAtoms(n4); ++k) {
                        int n5 = stereoMolecule.getConnAtom(n4, k);
                        if (n5 == n4 || stereoMolecule.getAllConnAtoms(n5) == 1) continue;
                        this.rotateGroup(conformer, n5, this.mAtom[i], coordinates, d4 / (4.0 * d7));
                    }
                }
            }
        }
        return true;
    }

    private int findApplicableTorsionIndex(double d) {
        int n = -1;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.mTorsion.length; ++i) {
            double d3 = Math.PI * (double)this.mTorsion[i] / 180.0;
            double d4 = Math.abs(d - d3);
            if (d4 > Math.PI) {
                d4 = Math.PI * 2 - d4;
            }
            if (!(d2 > (d4 /= 10.0 + Math.sqrt(this.mFrequency[i])))) continue;
            d2 = d4;
            n = i;
        }
        return n;
    }

    private double getSeverity(double d, int n) {
        double d2 = (double)this.mRange[n][0] * Math.PI / 180.0;
        double d3 = (double)this.mRange[n][1] * Math.PI / 180.0;
        double d4 = (double)this.mTorsion[n] * Math.PI / 180.0;
        if (d < d4 - Math.PI) {
            d += Math.PI * 2;
        } else if (d > d4 + Math.PI) {
            d -= Math.PI * 2;
        }
        double d5 = (d4 - d) / (d4 - (d < d4 ? d2 : d3));
        if (d5 < 1.0) {
            return 0.0;
        }
        if (d5 < 2.0) {
            return (d5 -= 1.0) * d5;
        }
        return 1.0;
    }

    private void rotateGroup(Conformer conformer, int n, int n2, Coordinates coordinates, double d) {
        this.rotateAtom(conformer, n, n2, coordinates, d);
        StereoMolecule stereoMolecule = conformer.getMolecule();
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAllConnAtoms(n3) != 1) continue;
            this.rotateAtom(conformer, n3, n2, coordinates, d);
        }
    }

    @Override
    public double addStrain(Conformer conformer, double[] dArray) {
        int n;
        double d = TorsionDB.calculateTorsionExtended(conformer, this.mAtom);
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        double d2 = 180.0 * d / Math.PI;
        int n2 = this.findApplicableTorsionIndex(d);
        double d3 = this.getSeverity(d, n2);
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = Math.abs(d2 - (double)this.mTorsion[n2]);
        if (d4 > 180.0) {
            d4 = 360.0 - d4;
        }
        if (d4 > 60.0) {
            d4 = 60.0;
        }
        StereoMolecule stereoMolecule = conformer.getMolecule();
        double d5 = d3 * d4 * d4 / 14400.0;
        double d6 = 0.0;
        for (n = 0; n < stereoMolecule.getAllConnAtoms(this.mAtom[1]); ++n) {
            if (stereoMolecule.getConnAtom(this.mAtom[1], n) == this.mAtom[2]) continue;
            int n3 = stereoMolecule.getConnAtom(this.mAtom[1], n);
            dArray[n3] = dArray[n3] + d5;
            d6 += d5;
        }
        for (n = 0; n < stereoMolecule.getAllConnAtoms(this.mAtom[2]); ++n) {
            if (stereoMolecule.getConnAtom(this.mAtom[2], n) == this.mAtom[1]) continue;
            int n4 = stereoMolecule.getConnAtom(this.mAtom[2], n);
            dArray[n4] = dArray[n4] + d5;
            d6 += d5;
        }
        return d6;
    }

    public boolean disableIfColliding(SelfOrganizedConformer selfOrganizedConformer) {
        StereoMolecule stereoMolecule = selfOrganizedConformer.getMolecule();
        double d = 0.0;
        for (int i = 1; i <= 2; ++i) {
            for (int j = 0; j < stereoMolecule.getAllConnAtoms(this.mAtom[i]); ++j) {
                int n = stereoMolecule.getConnAtom(this.mAtom[i], j);
                if (n == this.mAtom[3 - i] || !(selfOrganizedConformer.getAtomStrain(n) > d)) continue;
                d = selfOrganizedConformer.getAtomStrain(n);
            }
        }
        System.out.println((d < 0.1 ? "kept:" : "disabled:") + this.toString());
        if (d < 0.1) {
            return false;
        }
        this.mIsEnabled = false;
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("torsion rule:");
        super.addAtomList(stringBuilder);
        stringBuilder.append(" torsions:");
        for (int i = 0; i < this.mTorsion.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.mTorsion[i] + "(" + this.mFrequency[i] + ")");
        }
        return stringBuilder.toString();
    }
}

