/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import java.util.ArrayList;
import org.openmolecules.chem.conf.so.ConformationRule;

public class TetrahedralStereoRule
extends ConformationRule {
    private int[] mRotatableAtom;
    private Coordinates mAxisOfRotation;

    public TetrahedralStereoRule(StereoMolecule stereoMolecule, int[] nArray) {
        super(nArray);
        this.mRotatableAtom = this.getRotatableAtoms(stereoMolecule, nArray[4]);
    }

    public static void calculateRules(ArrayList<ConformationRule> arrayList, StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n;
            int n2;
            if (stereoMolecule.getAllConnAtoms(i) < 3 || (n2 = stereoMolecule.getAtomParity(i)) != 1 && n2 != 2 || stereoMolecule.isCentralAlleneAtom(i)) continue;
            int[] nArray = new int[5];
            for (n = 0; n < stereoMolecule.getAllConnAtoms(i); ++n) {
                int n3;
                int n4 = stereoMolecule.getConnAtom(i, n);
                for (n3 = 0; n3 < n && n4 > nArray[n3]; ++n3) {
                }
                for (int j = n - 1; j >= n3; --j) {
                    nArray[j + 1] = nArray[j];
                }
                nArray[n3] = n4;
            }
            if (stereoMolecule.getAllConnAtoms(i) == 3) {
                nArray[3] = -1;
            }
            nArray[4] = i;
            if (n2 == 1) {
                n = nArray[2];
                nArray[2] = nArray[1];
                nArray[1] = n;
            }
            arrayList.add(new TetrahedralStereoRule(stereoMolecule, nArray));
        }
    }

    @Override
    public boolean apply(Conformer conformer, double d) {
        boolean bl;
        double[] dArray = this.getPlaneVector(conformer);
        boolean bl2 = bl = this.mAtom[3] == -1 && this.isOnSameSide(conformer, dArray, this.mAtom[0], this.mAtom[4]) || this.mAtom[3] != -1 && this.isOnSameSide(conformer, dArray, this.mAtom[0], this.mAtom[3]);
        if (!bl) {
            return false;
        }
        for (int n : this.mRotatableAtom) {
            this.rotateAtom(conformer, n, this.mAtom[1], this.mAxisOfRotation, Math.PI);
        }
        return true;
    }

    @Override
    public double addStrain(Conformer conformer, double[] dArray) {
        double d = 0.0;
        double[] dArray2 = this.getPlaneVector(conformer);
        if (this.mAtom[3] == -1 && this.isOnSameSide(conformer, dArray2, this.mAtom[0], this.mAtom[4]) || this.mAtom[3] != -1 && this.isOnSameSide(conformer, dArray2, this.mAtom[0], this.mAtom[3])) {
            for (int i = 0; i < this.mAtom.length; ++i) {
                if (this.mAtom[i] == -1) continue;
                double d2 = 0.25;
                int n = this.mAtom[i];
                dArray[n] = dArray[n] + d2;
                d += d2;
            }
        }
        return d;
    }

    private boolean isOnSameSide(Conformer conformer, double[] dArray, int n, int n2) {
        double[] dArray2 = new double[]{conformer.getX(n2) - conformer.getX(n), conformer.getY(n2) - conformer.getY(n), conformer.getZ(n2) - conformer.getZ(n)};
        return dArray2[0] * dArray[0] + dArray2[1] * dArray[1] + dArray2[2] * dArray[2] > 0.0;
    }

    private double[] getPlaneVector(Conformer conformer) {
        double[][] dArray = new double[2][3];
        for (int i = 0; i < 2; ++i) {
            dArray[i][0] = conformer.getX(this.mAtom[i + 1]) - conformer.getX(this.mAtom[0]);
            dArray[i][1] = conformer.getY(this.mAtom[i + 1]) - conformer.getY(this.mAtom[0]);
            dArray[i][2] = conformer.getZ(this.mAtom[i + 1]) - conformer.getZ(this.mAtom[0]);
        }
        double[] dArray2 = new double[]{dArray[0][1] * dArray[1][2] - dArray[0][2] * dArray[1][1], dArray[0][2] * dArray[1][0] - dArray[0][0] * dArray[1][2], dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0]};
        return dArray2;
    }

    private int[] getRotatableAtoms(StereoMolecule stereoMolecule, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = stereoMolecule.getAllConnAtoms(n);
        boolean[][] blArray = new boolean[n7][stereoMolecule.getAllAtoms()];
        int[] nArray = new int[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            if (stereoMolecule.isRingBond(stereoMolecule.getConnBond(n, n6))) continue;
            nArray[n6] = stereoMolecule.getSubstituent(n, stereoMolecule.getConnAtom(n, n6), blArray[n6], null, null);
        }
        n6 = 0;
        boolean[] blArray2 = null;
        block1: for (n5 = 2; n5 < n7; ++n5) {
            int n8 = -1;
            n4 = Integer.MAX_VALUE;
            for (n3 = 0; n3 < n7; ++n3) {
                if (n4 <= nArray[n3] || nArray[n3] == 0) continue;
                n4 = nArray[n3];
                n8 = n3;
            }
            if (n8 != -1) {
                n6 += nArray[n8];
                nArray[n8] = 0;
                if (blArray2 == null) {
                    blArray2 = blArray[n8];
                    continue;
                }
                for (n3 = 0; n3 < stereoMolecule.getAllAtoms(); ++n3) {
                    int n9 = n3;
                    blArray2[n9] = blArray2[n9] | blArray[n8][n3];
                }
                continue;
            }
            if (blArray2 == null) {
                blArray2 = new boolean[stereoMolecule.getAllAtoms()];
            }
            for (n3 = stereoMolecule.getAllConnAtoms(n) - 1; n3 >= 0; --n3) {
                n2 = stereoMolecule.getConnAtom(n, n3);
                if (blArray2[n2]) continue;
                blArray2[n2] = true;
                ++n6;
                continue block1;
            }
        }
        n5 = 0;
        int[] nArray2 = new int[n6];
        for (n4 = 0; n4 < blArray2.length; ++n4) {
            if (blArray2[n4] == false) continue;
            nArray2[n5++] = n4;
        }
        this.mAxisOfRotation = new Coordinates();
        Coordinates coordinates = new Coordinates();
        for (n3 = 0; n3 < stereoMolecule.getAllConnAtoms(n); ++n3) {
            n2 = stereoMolecule.getConnAtom(n, n3);
            if (!blArray2[n2]) {
                this.mAxisOfRotation.add(stereoMolecule.getCoordinates(n2));
                continue;
            }
            if (n7 != 4) continue;
            coordinates.add(stereoMolecule.getCoordinates(n2));
        }
        this.mAxisOfRotation.scale(0.5);
        if (n7 == 4) {
            coordinates.scale(0.5);
        } else {
            coordinates.add(stereoMolecule.getCoordinates(n));
        }
        this.mAxisOfRotation.sub(coordinates).unit();
        return nArray2;
    }

    @Override
    public int getRuleType() {
        return 4;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("stereo rule:");
        super.addAtomList(stringBuilder);
        return stringBuilder.toString();
    }
}

