/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDescriptor;
import com.actelion.research.chem.conf.TorsionDescriptorHelper;
import java.util.ArrayList;
import org.openmolecules.chem.conf.so.ConformationRule;

public class SelfOrganizedConformer
extends Conformer {
    private static final double MAX_ATOM_STRAIN = 0.01;
    private static final double MAX_AVERARAGE_ATOM_STRAIN = 0.001;
    private double mMaxAtomStrain;
    private double mTotalStrain;
    private double[] mAtomStrain;
    private double[] mRuleStrain;
    private boolean mIsUsed;
    private TorsionDescriptor mTorsionDescriptor;

    public SelfOrganizedConformer(StereoMolecule stereoMolecule) {
        super(stereoMolecule);
    }

    public boolean isWorseThan(SelfOrganizedConformer selfOrganizedConformer) {
        return this.mTotalStrain > selfOrganizedConformer.mTotalStrain;
    }

    public void calculateStrain(ArrayList<ConformationRule> arrayList) {
        if (this.mAtomStrain != null) {
            return;
        }
        this.mAtomStrain = new double[this.getMolecule().getAllAtoms()];
        this.mRuleStrain = new double[ConformationRule.RULE_NAME.length];
        for (ConformationRule conformationRule : arrayList) {
            if (!conformationRule.isEnabled()) continue;
            int n = conformationRule.getRuleType();
            this.mRuleStrain[n] = this.mRuleStrain[n] + conformationRule.addStrain(this, this.mAtomStrain);
        }
        this.mMaxAtomStrain = 0.0;
        this.mTotalStrain = 0.0;
        for (int i = 0; i < this.getMolecule().getAllAtoms(); ++i) {
            this.mTotalStrain += this.mAtomStrain[i];
            if (!(this.mMaxAtomStrain < this.mAtomStrain[i])) continue;
            this.mMaxAtomStrain = this.mAtomStrain[i];
        }
    }

    public double getAtomStrain(int n) {
        return this.mAtomStrain[n];
    }

    public double getRuleStrain(int n) {
        return this.mRuleStrain[n];
    }

    public double getHighestAtomStrain() {
        return this.mMaxAtomStrain;
    }

    public double getTotalStrain() {
        return this.mTotalStrain;
    }

    public double getLikelyhood() {
        return Math.pow(100.0, -this.mTotalStrain / (0.001 * (double)this.getMolecule().getAllAtoms()));
    }

    protected boolean isAcceptable(ArrayList<ConformationRule> arrayList) {
        if (arrayList != null) {
            this.calculateStrain(arrayList);
        }
        return this.mMaxAtomStrain < 0.01 && this.mTotalStrain < 0.001 * (double)this.getMolecule().getAllAtoms();
    }

    public void invalidateStrain() {
        this.mAtomStrain = null;
        this.mRuleStrain = null;
    }

    public void calculateDescriptor(int[] nArray) {
        this.mTorsionDescriptor = new TorsionDescriptorHelper(this.getMolecule(), nArray).getTorsionDescriptor(this);
    }

    public boolean equals(SelfOrganizedConformer selfOrganizedConformer) {
        return this.mTorsionDescriptor.equals(selfOrganizedConformer.mTorsionDescriptor);
    }

    public boolean isUsed() {
        return this.mIsUsed;
    }

    public void setUsed(boolean bl) {
        this.mIsUsed = bl;
    }
}

