/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import java.util.Random;
import org.openmolecules.chem.conf.gen.RigidFragment;
import org.openmolecules.chem.conf.gen.RotatableBond;
import org.openmolecules.chem.conf.gen.TorsionSet;
import org.openmolecules.chem.conf.gen.TorsionSetStrategy;

public class TorsionSetStrategyRandom
extends TorsionSetStrategy {
    private static final int MAX_TRIES_FOR_NEW = 64;
    private Random mRandom;
    private boolean mPreferLikelyTorsions;

    public TorsionSetStrategyRandom(RotatableBond[] rotatableBondArray, RigidFragment[] rigidFragmentArray, boolean bl, long l) {
        super(rotatableBondArray, rigidFragmentArray);
        this.mPreferLikelyTorsions = bl;
        this.mRandom = l == 0L ? new Random() : new Random(l);
    }

    public Random getRandom() {
        return this.mRandom;
    }

    @Override
    public TorsionSet createTorsionSet(TorsionSet torsionSet) {
        TorsionSet torsionSet2;
        if (this.getTorsionSetCount() == this.getPermutationCount()) {
            return null;
        }
        int[] nArray = new int[this.mRotatableBond.length];
        int[] nArray2 = new int[this.mRigidFragment.length];
        int n = 0;
        do {
            if (n++ == 64) {
                return null;
            }
            if (this.mPreferLikelyTorsions) {
                int n2;
                double d = (double)n / 64.0;
                for (n2 = 0; n2 < this.mRotatableBond.length; ++n2) {
                    nArray[n2] = this.mRotatableBond[n2].getLikelyRandomTorsionIndex(this.mRandom.nextDouble(), d);
                }
                for (n2 = 0; n2 < this.mRigidFragment.length; ++n2) {
                    nArray2[n2] = this.mRigidFragment[n2].getLikelyRandomConformerIndex(this.mRandom.nextDouble(), d);
                }
            } else {
                int n3;
                for (n3 = 0; n3 < this.mRotatableBond.length; ++n3) {
                    nArray[n3] = this.mRandom.nextInt(this.mRotatableBond[n3].getTorsionCount());
                }
                for (n3 = 0; n3 < this.mRigidFragment.length; ++n3) {
                    nArray2[n3] = this.mRandom.nextInt(this.mRigidFragment[n3].getConformerCount());
                }
            }
        } while (!this.isNewTorsionSet(torsionSet2 = this.createTorsionSet(nArray, nArray2)));
        return torsionSet2;
    }
}

